	SECTION "amiga carpet", HOME

carpet	START_MUSIC_INT

	ld	a, 1
	ldio	[rVBK], a
	ld	hl, _SCRN0
	ld	bc, 1024
	xor	a
	call	vmemset
	xor	a
	ldio	[rVBK], a

	xor	a
	ld	hl, _SCRN0
	ld	bc, 16<<8+8
	call	makemap
	ld	hl, _SCRN0
	ld	c, 8
	call	mirrormap

	ROMBANK	data5

	ld	hl, carpet_tiles
	ld	de, _VRAM
	ld	bc, 178*16
	call	vmemcopy

	ld	hl, boy
	ld	de, oambuf
	ld	b, 160
	call	memcpsh

	ld	hl, snurra_palette
	ld	de, $ca00
	ld	bc, 32*8
	call	vmemcopy
	
	call	initline

	ld	hl, $d000
	call	cp_cls

	ld	hl, gb_pal
	ld	b, 8*2
	call	setobpal
	
	waitVBL

	ld	a, %00001000
	;ld	a, %01000000
	ldio	[rSTAT], a
	ld	de, carpet_irq
	call	setlcdcirq

	ld	a, %10010111
	ldio	[rLCDC], a
		
carpet_main
	waitVBL

	xor	a
	ld	[rLYC], a

	ld	a, 1
	ldio	[rVBK], a
	
	ld	a, $d0
	ldio	[rHDMA1], a
	ld	a, $80
	ldio	[rHDMA3], a
	xor	a
	ldio	[rHDMA2], a
	ldio	[rHDMA4], a
	ld	a, $3f
	ldio	[rHDMA5], a
	
	ld	a, oambuf>>8
	call	oamdma

	MusicUpdate musicb

	xor	a
	ldio	[rVBK], a

	ld	hl, counter
	inc	[hl]
	ld	hl, count2
	inc	[hl]
	inc	[hl]
	ld	hl, count3
	inc	[hl]
	inc	[hl]
	inc	[hl]

	ROMBANK	mathb

	ldh	a, [countl]
	ld	l, a
	ld	h, sintab >> 8
	ld	a, [hl]
	sra	a
	add	a, 40
	ldio	[rSCX], a
			
	call	carpet_render
	
	;ld	hl, $d000
	;call	cp_cls

	ldh	a, [counter]
	add	a, a
	call	carpet_circle
	call	plot
	ldh	a, [counter]
	add	a, a
	add	a, 128
	call	carpet_circle
	call	cplot
	;ldh	a, [counter]
	;add	a, 85
	;call	carpet_circle
	;ldh	a, [counter]
	;add	a, 85*2
	;call	carpet_circle

	ld	a, [counth]
	cp	time+2
	jp	nz, carpet_main

	ld	de, retint
	call	setlcdcirq

	ld	a, 1
	ldio	[rVBK], a
	xor	a
	ld	hl, _SCRN0
	ld	bc, 1024
	call	vmemset
	ldio	[rVBK], a

	call	clearsprites

	ret

carpet_circle
	ld	l, a
	ld	h, sintab>>8
	ld	a, [hl]
	sra	a
	sra	a
	sra	a
	add	a, 16
	ld	d, a
	ld	a, l
	add	a, 64
	ld	l, a
	ld	a, [hl]
	sra	a
	sra	a
	sra	a
	add	a, 14
	ld	e, a
	ret

	;push	de
	;call	plot
	 jp	plot
	pop	de
	inc	e
	push	de
	call	plot
	pop	de
	inc	d
	push	de
	call	plot
	pop	de
	dec	e
	call	plot
	ret

carpet_render
	ld	b, 144
	ld	de, ylist
	ld	h, sintab >> 8
.loop	ldh	a, [count2]
	add	a, b
	ld	l, a
	ld	a, [hl]
	sra	a
	ld	c, a
	ldh	a, [count3]
	sub	b
	ld	l, a
	ld	a, [hl]
	sra	a
	add	a, c
	add	a, 64
	sra	a

	ld	l, a
	sra	a
	add	a, b
	ld	c, a
	ld	a, [countl]
	add	a, c
	ld	c, a
	ld	a, l
	or	%10000000
	bit	4, c
	jr	z, .skip
	and	%01111111
.skip	ld	[de], a
	inc	e
	dec	b
	jr	nz, .loop
	ret

carpet_irq
	push	af
	push	bc
	push	hl

	ldio	a, [rLYC]
	inc	a
	ldio	[rLYC], a
	;dec	a

	cp	144
	jr	nz, .ok
	xor	a	
.ok

	ld	l, a
	ld	h, ylist >> 8

	push	hl

	ld	a, [hl]
	and	%11111110	; %x......0
	rlca			; %......0x
	adc	a, 0		; %......Xx
	add	a, a		; %.....Xx0

	ld	l, a
		
	ld	h, $ca
	ld	a, $80
	ld      [rBCPS], a
	ld	c, rBCPD & 255
	ld	a, [hl+]
	ld	[c], a
	ld	a, [hl+]
	ld	[c], a
	ld	a, [hl+]
	ld	[c], a
	ld	a, [hl+]
	ld	[c], a

	pop	hl
	
	ldio	a, [rLYC]
	dec	a

	res	6, [hl]
	res	7, [hl]
	sub	[hl]
	cpl
	ldio	[rSCY], a

	pop	hl
	pop	bc
	pop	af
	reti

	SECTION	"carpet data", DATA, BANK[data5]

carpet_tiles
	INCBIN	"sqmap.tls"
	INCBIN	"gameboy.bin"

t	set	128
by	set	84
x	set	12
boy
y	set	by+12
	rept	3
	db	y,x,t,0
y	set	y+16
t	set	t+2
	endr
x	set	x+8
y	set	by+8
	rept	4
	db	y,x,t,0
y	set	y+16
t	set	t+2
	endr
x	set	x+8
	db	089,x,142,0
	db	108,x,144,0
	db	124,x,146,0
	db	140,x,148,0
x	set	x+8
	db	087,x,150,0
	db	108,x,152,0
	db	124,x,154,0
	db	140,x,156,0
t	set	158
x	set	x+8
y	set	by+2
	rept	5
	db	y,x,t,0
y	set	y+16
t	set	t+2
	endr
x	set	x+8
y	set	by+2
	rept	4
	db	y,x,t,0
y	set	y+16
t	set	t+2
	endr
	
	db	 95,24,00,9
	db	111,24,02,9
	db	 95,32,16,9
	db	111,32,18,9
	db	 95,40,32,9
	db	111,40,34,9
	db	 95,48,48,9
	db	111,48,50,9
	
	ds	12*4

gb_pal	DW_RGB	 0,  0,  7
	DW_RGB	 0,  0,  0
	DW_RGB  15,  0, 15
	DW_RGB  31,  0, 31

	DW_RGB	 0,  0, 15
	DW_RGB  31, 31, 31
	DW_RGB	31, 31, 31
	DW_RGB   0,  0, 15

snurra_palette
shade	SET	0
	REPT	32
	DW_RGB	shade, 0, 0
	DW_RGB	shade, shade, shade
	DW_RGB	shade, shade, shade
	DW_RGB	shade, 0, 0
shade	SET shade+1
	ENDR
	
time	set	time+2