/* fitxer: Alive.cpp
 *
 *	Aplicaci d'Alive!, la nova demo de tDR per la BCNParty'11,
 *	celebrada a Barcelona els dies 31 d'Octubre i 1 i 2 de Novembre
 *	del 2003.
 *
 *	tDR is back! :D by the DarkRising, 2003
 *	http://thedarkrising.com
 *
 *	Code by Teknik
 *	GFX by SPiTe
 *	Music by ??? (Yero???)
 */

#define STRICT
#define WIN32_LEAN_AND_MEAN

#include <math.h>
#include <d3dx9.h>
#include "resource.h"

//-----------------------------------------------------------------------------
// GLOBALS
//-----------------------------------------------------------------------------
HWND                    g_hWnd          = NULL;
LPCSTR					szWndClass		= TEXT("Alive_tDR_class");

struct tSettings {
	unsigned resx, resy;
	bool windowed;
	bool disable_sound;
} settings;

LPDIRECT3D9             g_pD3D          = NULL;
LPDIRECT3DDEVICE9       g_pd3dDevice    = NULL;
LPDIRECT3DVERTEXBUFFER9 g_pVertexBuffer = NULL;
LPDIRECT3DTEXTURE9      g_pTexture      = NULL;

#define D3DFVF_CUSTOMVERTEX ( D3DFVF_XYZ | D3DFVF_TEX1 )

struct Vertex
{
    float x, y, z;
    float tu, tv;
};

Vertex *g_cubeVertices;
/*Vertex g_cubeVertices[] =
{
	{-1.0f, 1.0f,-1.0f,  0.0f,0.0f },
	{ 1.0f, 1.0f,-1.0f,  1.0f,0.0f },
	{-1.0f,-1.0f,-1.0f,  0.0f,1.0f },
	{ 1.0f,-1.0f,-1.0f,  1.0f,1.0f },
	
	{-1.0f, 1.0f, 1.0f,  1.0f,0.0f },
	{-1.0f,-1.0f, 1.0f,  1.0f,1.0f },
	{ 1.0f, 1.0f, 1.0f,  0.0f,0.0f },
	{ 1.0f,-1.0f, 1.0f,  0.0f,1.0f },
	
	{-1.0f, 1.0f, 1.0f,  0.0f,0.0f },
	{ 1.0f, 1.0f, 1.0f,  1.0f,0.0f },
	{-1.0f, 1.0f,-1.0f,  0.0f,1.0f },
	{ 1.0f, 1.0f,-1.0f,  1.0f,1.0f },
	
	{-1.0f,-1.0f, 1.0f,  0.0f,0.0f },
	{-1.0f,-1.0f,-1.0f,  0.0f,1.0f },
	{ 1.0f,-1.0f, 1.0f,  1.0f,0.0f },
	{ 1.0f,-1.0f,-1.0f,  1.0f,1.0f },
	
	{ 1.0f, 1.0f,-1.0f,  0.0f,0.0f },
	{ 1.0f, 1.0f, 1.0f,  1.0f,0.0f },
	{ 1.0f,-1.0f,-1.0f,  0.0f,1.0f },
	{ 1.0f,-1.0f, 1.0f,  1.0f,1.0f },
	
	{-1.0f, 1.0f,-1.0f,  1.0f,0.0f },
	{-1.0f,-1.0f,-1.0f,  1.0f,1.0f },
	{-1.0f, 1.0f, 1.0f,  0.0f,0.0f },
	{-1.0f,-1.0f, 1.0f,  0.0f,1.0f }
};*/

bool g_bBlending = true;
double fase = 0.0;

//-----------------------------------------------------------------------------
// PROTOTYPES
//-----------------------------------------------------------------------------
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, 
				   LPSTR lpCmdLine, int nCmdShow);
int CALLBACK DialogProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK WindowProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);
void loadTexture(void);
void init(void);
void shutDown(void);
void render(void);

//-----------------------------------------------------------------------------
// Name: WinMain()
// Desc: The application's entry point
//-----------------------------------------------------------------------------
int WINAPI WinMain(	HINSTANCE hInstance,
					HINSTANCE hPrevInstance,
					LPSTR     lpCmdLine,
					int       nCmdShow )
{
	WNDCLASSEX winClass; 
	MSG        uMsg;

	// Setup
	/*
	if (DialogBox(hInstance, MAKEINTRESOURCE(IDD_SETUP), NULL,
					DialogProc) == IDCANCEL)
		return 0;
	*/
	settings.resx = 640;
	settings.resy = 480;
	settings.windowed = false;
	settings.disable_sound = false;

    memset(&uMsg,0,sizeof(uMsg));
    
	winClass.lpszClassName = szWndClass;
	winClass.cbSize        = sizeof(WNDCLASSEX);
	winClass.style         = CS_HREDRAW | CS_VREDRAW;
	winClass.lpfnWndProc   = WindowProc;
	winClass.hInstance     = hInstance;
	winClass.hIcon	       = LoadIcon(hInstance, (LPCTSTR)IDI_DIRECTX_ICON);
    winClass.hIconSm	   = LoadIcon(hInstance, (LPCTSTR)IDI_DIRECTX_ICON);
	winClass.hCursor       = LoadCursor(NULL, IDC_ARROW);
	winClass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	winClass.lpszMenuName  = NULL;
	winClass.cbClsExtra    = 0;
	winClass.cbWndExtra    = 0;

	if(!RegisterClassEx( &winClass) )
		return E_FAIL;

	if (settings.windowed) {
		int x = GetSystemMetrics(SM_CYFIXEDFRAME);
		    x = GetSystemMetrics(SM_CYCAPTION);
		g_hWnd = CreateWindowEx( NULL, szWndClass, TEXT("Alive! by tDR"),
								 WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU |
								 WS_MINIMIZEBOX | WS_VISIBLE,
								 CW_USEDEFAULT, CW_USEDEFAULT,
								 settings.resx + 2 * GetSystemMetrics(SM_CXFIXEDFRAME),
								 settings.resy + 2 * GetSystemMetrics(SM_CYFIXEDFRAME)
									+ GetSystemMetrics(SM_CYCAPTION),
 								 NULL, NULL, hInstance, NULL );
	} else {
		g_hWnd = CreateWindowEx( NULL, szWndClass, TEXT("Alive! by tDR"),
								 WS_POPUP | WS_EX_TOPMOST | WS_VISIBLE,
								 0, 0, settings.resx, settings.resy,
								 NULL, NULL, hInstance, NULL );
	}

	if( g_hWnd == NULL )
		return E_FAIL;

    ShowWindow( g_hWnd, nCmdShow );
    UpdateWindow( g_hWnd );

	init();
	ShowCursor(FALSE);

	while( uMsg.message != WM_QUIT )
	{
		if( PeekMessage( &uMsg, NULL, 0, 0, PM_REMOVE ) )
		{ 
			TranslateMessage( &uMsg );
			DispatchMessage( &uMsg );
		}
        else {
		    render();
			fase += 1.0;
			fase = fmod(fase, 360.0);
		}
	}

	shutDown();

    UnregisterClass( szWndClass, winClass.hInstance );

	return uMsg.wParam;
}

LPCSTR szResolutions[] = {
	TEXT("640x480"), TEXT("800x600"), TEXT("1024x768"), TEXT("1280x1024"),
	NULL };
unsigned uResolutions[][2] = {
	{640, 480}, {800, 600}, {1024, 768}, {1280, 1024} };

int CALLBACK DialogProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	int i, resolution;

	switch (msg) {
	case WM_INITDIALOG:
		for (i = 0; szResolutions[i]; i++)
			SendDlgItemMessage(hwnd, IDC_RESOLUTION, 
                        CB_ADDSTRING, 0, (LPARAM)szResolutions[i]);
		SendDlgItemMessage(hwnd, IDC_RESOLUTION, CB_SETCURSEL, (WPARAM)1, 0);
		return TRUE;

	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		case IDOK:
			resolution = SendDlgItemMessage(hwnd, IDC_RESOLUTION, CB_GETCURSEL,
											0, 0);
			settings.resx = uResolutions[resolution][0];
			settings.resy = uResolutions[resolution][1];
			settings.windowed = (SendDlgItemMessage(hwnd, IDC_WINDOWED,
											BM_GETCHECK, 0, 0) == BST_CHECKED);
			settings.disable_sound = (SendDlgItemMessage(hwnd, IDC_DISABLE_SOUND,
											BM_GETCHECK, 0, 0) == BST_CHECKED);
		case IDCANCEL:
			EndDialog(hwnd, LOWORD(wParam));
			return TRUE;
		}
		break;
	}

	return FALSE;
}

LRESULT CALLBACK WindowProc( HWND   hWnd, 
							 UINT   msg, 
							 WPARAM wParam, 
							 LPARAM lParam )
{
    switch( msg )
	{	
		case WM_ACTIVATE:
			//bActive = LOWORD( wParam ) != WA_INACTIVE;
			break;

        case WM_KEYDOWN:
			if (wParam == VK_ESCAPE)
				PostQuitMessage(0);
			break;

		case WM_CLOSE:
			PostQuitMessage(0);	
			break;
		
        case WM_DESTROY:
            PostQuitMessage(0);
			break;

		default:
			return DefWindowProc( hWnd, msg, wParam, lParam );
	}

	return 0;
}

//-----------------------------------------------------------------------------
// Name: loadTexture()
// Desc: 
//-----------------------------------------------------------------------------
void loadTexture(void)
{
	D3DXCreateTextureFromFile( g_pd3dDevice, "ca-ca-camiseta.bmp", &g_pTexture );

	g_pd3dDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
	g_pd3dDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);
}

void addVertex( Vertex *pV, float x, float y, float z, float u, float v ){
	pV->x = x;
	pV->y = y;
	pV->z = z;
	pV->tu = u;
	pV->tv = v;
}
//-----------------------------------------------------------------------------
// Name: init()
// Desc: 
//-----------------------------------------------------------------------------
void init( void )
{
    g_pD3D = Direct3DCreate9( D3D_SDK_VERSION );

    D3DDISPLAYMODE d3ddm;

    g_pD3D->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &d3ddm );

    D3DPRESENT_PARAMETERS d3dpp;
    ZeroMemory( &d3dpp, sizeof(d3dpp) );

    d3dpp.Windowed               = settings.windowed ? TRUE : FALSE;
	if (!settings.windowed) {
		d3dpp.BackBufferWidth    = settings.resx;
		d3dpp.BackBufferHeight   = settings.resy;
	}
    d3dpp.SwapEffect             = D3DSWAPEFFECT_DISCARD;
    d3dpp.BackBufferFormat       = d3ddm.Format;
    d3dpp.EnableAutoDepthStencil = TRUE;
    d3dpp.AutoDepthStencilFormat = D3DFMT_D16;

    g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, g_hWnd,
                          D3DCREATE_SOFTWARE_VERTEXPROCESSING,
                          &d3dpp, &g_pd3dDevice );

	loadTexture();

	/*
	g_cubeVertices = new Vertex[ 24 ];

	addVertex( &g_cubeVertices[ 0 ], -1.0f, 1.0f,-1.0f,  0.0f,0.0f );
	addVertex( &g_cubeVertices[ 1 ], 1.0f, 1.0f,-1.0f,  1.0f,0.0f );
	addVertex( &g_cubeVertices[ 2 ], -1.0f,-1.0f,-1.0f,  0.0f,1.0f );
	addVertex( &g_cubeVertices[ 3 ], 1.0f,-1.0f,-1.0f,  1.0f,1.0f );

	addVertex( &g_cubeVertices[ 4 ], -1.0f, 1.0f, 1.0f,  0.0f,0.0f );
	addVertex( &g_cubeVertices[ 5 ], -1.0f, -1.0f,1.0f,  1.0f,0.0f );
	addVertex( &g_cubeVertices[ 6 ], 1.0f, 1.0f,1.0f,  0.0f,1.0f );
	addVertex( &g_cubeVertices[ 7 ], 1.0f,-1.0f,1.0f,  1.0f,1.0f );

	addVertex( &g_cubeVertices[ 8 ], -1.0f, 1.0f, 1.0f,  0.0f,0.0f );
	addVertex( &g_cubeVertices[ 9 ], 1.0f, 1.0f,1.0f,  1.0f,0.0f );
	addVertex( &g_cubeVertices[ 10 ], -1.0f, 1.0f,-1.0f,  0.0f,1.0f );
	addVertex( &g_cubeVertices[ 11 ], 1.0f, 1.0f,-1.0f,  1.0f,1.0f );
	
	addVertex( &g_cubeVertices[ 12 ], -1.0f, -1.0f, -1.0f,  0.0f,0.0f );
	addVertex( &g_cubeVertices[ 13 ], -1.0f, -1.0f,1.0f,  1.0f,0.0f );
	addVertex( &g_cubeVertices[ 14 ], 1.0f, -1.0f,-1.0f,  0.0f,1.0f );
	addVertex( &g_cubeVertices[ 15 ], 1.0f, -1.0f,1.0f,  1.0f,1.0f );

	addVertex( &g_cubeVertices[ 16 ], 1.0f, 1.0f, -1.0f,  0.0f,0.0f );
	addVertex( &g_cubeVertices[ 17 ], 1.0f, 1.0f, 1.0f,  1.0f,0.0f );
	addVertex( &g_cubeVertices[ 18 ], 1.0f, -1.0f,-1.0f,  0.0f,1.0f );
	addVertex( &g_cubeVertices[ 19 ], 1.0f, -1.0f,1.0f,  1.0f,1.0f );

	addVertex( &g_cubeVertices[ 20 ], -1.0f, 1.0f, -1.0f,  0.0f,0.0f );
	addVertex( &g_cubeVertices[ 21 ], -1.0f, -1.0f,-1.0f,  1.0f,0.0f );
	addVertex( &g_cubeVertices[ 22 ], -1.0f, 1.0f,1.0f,  0.0f,1.0f );
	addVertex( &g_cubeVertices[ 23 ], -1.0f, -1.0f,1.0f,  1.0f,1.0f );
	*/

	g_cubeVertices = new Vertex[ 600 ];

	for (int i = 0; i < 10; i++)
		for (int j = 0; j < 10; j++) {
			addVertex( &g_cubeVertices[ (i * 10 + j) * 6 + 0 ], i / 10.0f - 0.5f, j / 10.0f - 0.5f, -1.0f,
						i / 10.0f, j / 10.0f );
			addVertex( &g_cubeVertices[ (i * 10 + j) * 6 + 1 ], (i + 1) / 10.0f - 0.5f, j / 10.0f - 0.5f, -1.0f,
						(i + 1) / 10.0f, j / 10.0f );
			addVertex( &g_cubeVertices[ (i * 10 + j) * 6 + 2 ], i / 10.0f - 0.5f, (j + 1) / 10.0f - 0.5f, -1.0f,
						i / 10.0f, (j + 1) / 10.0f );
			addVertex( &g_cubeVertices[ (i * 10 + j) * 6 + 3 ], (i + 1) / 10.0f - 0.5f, j / 10.0f - 0.5f, -1.0f,
						(i + 1) / 10.0f, j / 10.0f );
			addVertex( &g_cubeVertices[ (i * 10 + j) * 6 + 5 ], (i + 1) / 10.0f - 0.5f, (j + 1) / 10.0f - 0.5f, -1.0f,
						(i + 1) / 10.0f, (j + 1) / 10.0f );
			addVertex( &g_cubeVertices[ (i * 10 + j) * 6 + 4 ], i / 10.0f - 0.5f, (j + 1) / 10.0f - 0.5f, -1.0f,
						i / 10.0f, (j + 1) / 10.0f );
		}

	g_pd3dDevice->CreateVertexBuffer( 600 * sizeof(Vertex),0, D3DFVF_CUSTOMVERTEX,
                                      D3DPOOL_DEFAULT, &g_pVertexBuffer, NULL );


	void *pVertices = NULL;
    g_pVertexBuffer->Lock( 0, 600 * sizeof( Vertex ), (void**)&pVertices, 0 );
    memcpy( pVertices, g_cubeVertices, 600 * sizeof( Vertex ) );
    g_pVertexBuffer->Unlock();
	
	g_pd3dDevice->SetRenderState(D3DRS_LIGHTING, FALSE);

	g_pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
	g_pd3dDevice->SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
	g_pd3dDevice->SetRenderState(D3DRS_DESTBLEND, D3DBLEND_ONE);
	g_pd3dDevice->SetRenderState(D3DRS_CULLMODE, D3DCULL_NONE);
	g_pd3dDevice->SetRenderState(D3DRS_ZENABLE, FALSE);

    D3DXMATRIX matProj;	// ***
    D3DXMatrixPerspectiveFovLH( &matProj, 45.0f, 640.0f / 480.0f, 0.1f, 100.0f );
    g_pd3dDevice->SetTransform( D3DTS_PROJECTION, &matProj );
}

//-----------------------------------------------------------------------------
// Name: shutDown()
// Desc: 
//-----------------------------------------------------------------------------
void shutDown( void )
{
    if( g_pTexture != NULL ) 
        g_pTexture->Release();

    if( g_pVertexBuffer != NULL ) 
        g_pVertexBuffer->Release(); 

    if( g_pd3dDevice != NULL )
        g_pd3dDevice->Release();

    if( g_pD3D != NULL )
        g_pD3D->Release();
}

float sinc( float a,  float b) {
	
	float c;
	c = sin(fmod(fase + a * 25.0 + b * 10.0, 360.0) / 360.0f * 3.14159265 * 2.0);
	//c *= 2;
	c -= 4;
	return c; 

}

//-----------------------------------------------------------------------------
// Name: render()
// Desc: 
//-----------------------------------------------------------------------------
void render( void )
{
    g_pd3dDevice->Clear( 0, NULL, D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,
                         D3DCOLOR_COLORVALUE(0.0f,0.0f,0.0f,1.0f), 1.0f, 0 );

    static float fXrot = 0.0f;
	static float fYrot = 0.0f;
	static float fZrot = 0.0f;

	fXrot += 0.1f;
	fYrot += 0.2f;
	fZrot += 0.3f;
	
    D3DXMATRIX matWorld;
    D3DXMATRIX matTrans;
	D3DXMATRIX matRot;

    D3DXMatrixTranslation( &matTrans, 0.0f, 0.0f, 7.0f );

	/*
	D3DXMatrixRotationYawPitchRoll( &matRot, 
		                            D3DXToRadian(fXrot), 
		                            D3DXToRadian(fYrot), 
		                            D3DXToRadian(fZrot) );
	*/
//    matWorld = matRot * matTrans;
//    g_pd3dDevice->SetTransform( D3DTS_WORLD, &matWorld );
    g_pd3dDevice->SetTransform( D3DTS_WORLD, &matTrans );

    g_pd3dDevice->BeginScene();

	if( g_bBlending == true )
	{
		g_pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
		g_pd3dDevice->SetRenderState(D3DRS_ZENABLE, FALSE); 
	}
	else
	{
		g_pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);
		g_pd3dDevice->SetRenderState(D3DRS_ZENABLE, TRUE); 
	}

    g_pd3dDevice->SetTexture( 0, g_pTexture );
    g_pd3dDevice->SetStreamSource( 0, g_pVertexBuffer, 0, sizeof(Vertex) );
    g_pd3dDevice->SetFVF( D3DFVF_CUSTOMVERTEX );	

	// ------------------------------------- SUCKS ------------------------------------

	delete g_cubeVertices;
	g_cubeVertices = new Vertex[ 600 ];

//#define sinc(a, b)  (float) (sin(fmod(fase + a * 5.0 + b * 10.0, 360.0) / 360.0f * 3.14159265 * 2.0) / 5.0 - 1.0f)

	for (int i = 0; i < 10; i++)
		for (int j = 0; j < 10; j++) {
			addVertex( &g_cubeVertices[ (i * 10 + j) * 6 + 0 ], i / 10.0f - 0.5f, j / 10.0f - 0.5f, sinc(i, j),
						i / 10.0f, j / 10.0f );
			addVertex( &g_cubeVertices[ (i * 10 + j) * 6 + 1 ], (i + 1) / 10.0f - 0.5f, j / 10.0f - 0.5f, sinc(i + 1, j),
						(i + 1) / 10.0f, j / 10.0f );
			addVertex( &g_cubeVertices[ (i * 10 + j) * 6 + 2 ], i / 10.0f - 0.5f, (j + 1) / 10.0f - 0.5f, sinc(i, j + 1),
						i / 10.0f, (j + 1) / 10.0f );
			addVertex( &g_cubeVertices[ (i * 10 + j) * 6 + 3 ], (i + 1) / 10.0f - 0.5f, j / 10.0f - 0.5f, sinc(i + 1, j),
						(i + 1) / 10.0f, j / 10.0f );
			addVertex( &g_cubeVertices[ (i * 10 + j) * 6 + 5 ], (i + 1) / 10.0f - 0.5f, (j + 1) / 10.0f - 0.5f, sinc(i + 1, j + 1),
						(i + 1) / 10.0f, (j + 1) / 10.0f );
			addVertex( &g_cubeVertices[ (i * 10 + j) * 6 + 4 ], i / 10.0f - 0.5f, (j + 1) / 10.0f - 0.5f, sinc(i, j + 1),
						i / 10.0f, (j + 1) / 10.0f );
		}

	g_pd3dDevice->CreateVertexBuffer( 600 * sizeof(Vertex),0, D3DFVF_CUSTOMVERTEX,
                                      D3DPOOL_DEFAULT, &g_pVertexBuffer, NULL );

	void *pVertices = NULL;
    g_pVertexBuffer->Lock( 0, 600 * sizeof( Vertex ), (void**)&pVertices, 0 );
    memcpy( pVertices, g_cubeVertices, 600 * sizeof( Vertex ) );
    g_pVertexBuffer->Unlock();
	
	// ------------------------------------- SUCKS ------------------------------------

//	g_pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);
//	g_pd3dDevice->SetRenderState(D3DRS_ZENABLE, TRUE); 

	g_pd3dDevice->SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
	g_pd3dDevice->SetRenderState(D3DRS_ZENABLE, TRUE); 

	g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLELIST,  0, 2 * 100 );
//	g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP,  4, 2 );
//	g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP,  8, 2 );

//	g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 12, 2 );
//	g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 16, 2 );
//	g_pd3dDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 20, 2 );

    g_pd3dDevice->EndScene();
    g_pd3dDevice->Present( NULL, NULL, NULL, NULL );
}
