#include "Demo.inc"

.org demo_exec_ram

morph_counter = $8100
run_counter = $8101
RotWS = $8102


rotated_points = int_end




    xor a
    ld (morph_counter),a
    ld (run_counter),a
    
    call _clrLCD
    call _runindicoff
    
    call BuildTrigTables
    
    call enable_planes
    push hl
    
    
    ld a,0      ;runt z
    ld b,0      ;runt x
    ld c,0      ;runt y
    
loop:
    push af
    push bc    
    
CalcTransformationMatrix:       ;Rotation angles in A, B and C
        ld de,64
        ld h,SinCosTable/256
        ld l,a
        ld a,(hl)
        ld (SinX),a
        add hl,de
        ld a,(hl)
        ld (CosX),a
        ld h,SinCosTable/256
        ld l,b
        ld a,(hl)
        ld (SinY),a
        add hl,de
        ld a,(hl)
        ld (CosY),a
        ld h,SinCosTable/256
        ld l,c
        ld a,(hl)
        ld (SinZ),a
        add hl,de
        ld a,(hl)
        ld (CosZ),a

        ld hl,(SinY-1)
        ld a,(SinX)
        call MultAxH
        ld b,h          ;b=sx.sy
        ld a,(SinZ)
        call MultAxH
        ld c,h          ;c=sx.sy.sz
        ld hl,(CosZ-1)
        ld a,(CosY)
        call MultAxH
        ld a,h
        add a,c         
        ld (RotXX),a    ;xx=sx.sy.sz+cy.cz

        ld a,(CosZ)
        ld h,b
        call MultAxH
        ld c,h          ;c=sx.sy.cz
        ld a,(SinZ)
        ld hl,(CosY-1)
        call MultAxH
        ld a,h
        sub c
        ld (RotXY),a    ;xy=sz.cy-sx.sy.cz

        ld hl,(SinY-1)
        ld a,(CosX)
        call MultAxH
        ld a,h
        ld (RotXZ),a    ;xz=cx.sy

        ld a,(SinZ)
        ld hl,(CosX-1)
        call MultAxH
        xor a
        sub h
        ld (RotYX),a    ;yx=-sz.cx

        ld a,(CosZ)
        ld hl,(CosX-1)
        call MultAxH
        ld a,h
        ld (RotYY),a    ;yy=cz.cx

        ld a,(SinX)
        ld hl,(CosY-1)
        call MultAxH
        ld c,h          ;c=sx.cy
        ld a,(SinZ)
        call MultAxH
        ld b,h          ;b=sx.cy.sz
        ld a,(SinY)
        ld hl,(CosZ-1)
        call MultAxH
        ld a,b
        sub h
        ld (RotZX),a    ;zx=sx.cy.sz-sy.cz

        ld h,c
        ld a,(CosZ)
        call MultAxH
        ld b,h          ;b=sx.cy.cz
        ld a,(SinZ)
        ld hl,(SinY-1)
        call MultAxH
        xor a
        sub b
        sub h
        ld (RotZY),a    ;zy=-sz.sy-sx.cy.cz

        ld a,(CosX)
        ld hl,(CosY-1)
        call MultAxH
        ld a,h
        ld (RotZZ),a    ;zz=cx.cy

    
    ld hl,points
    ld de,rotated_points
    ld b,(hl)
    inc hl
rotate_all_points:
    push bc
    ld b,(hl)
    inc hl
    ld c,(hl)
    inc hl
    ld a,(hl)
    inc hl
    push de        
    push hl    
    call RotatePoint
    

    
    push hl
    push de
    ld hl,128*128
    ld a,b
    sra a
    add a,112
    call _divHLbyA      ;and projected (x'=x/z, y'=y/z)
    ld a,l
    pop de
    push af
    call MultAxDE
    pop af
    ld c,h
    pop de
    call MultAxDE
;    ld e,070h       ;squash in Y (86's pixels aren't square)
    ld e,$70
    call MultExH
    ld a,h

    pop hl    
    pop de


    add a,32
    ld (de),a
    inc de
    ld a,64
    add a,c
    ld (de),a
    inc de

   
    pop bc
    djnz rotate_all_points
    
    ld hl,lines             ;list of points to put together
    ld b,(hl)               ;get length
    ex de,hl    
draw_lines_loop:
    inc de
    push bc
    push de
    call get_coords
    ld c,(hl)
    inc hl
    ld b,(hl)               ;point 1 to bc
    push bc
    call get_coords
    push hl                 ;pointer to point 2 in hl
    push hl
    call get_coords
    ld e,(hl)
    inc hl
    ld d,(hl)               ;point 3 to de
    pop hl
    push de
    ld a,(hl)
    sub c
    ld c,a
    inc hl
    ld a,(hl)
    sub b
    ld b,a                  ;point 2 - point 1 to bc
    
    ld a,d
    sub (hl)
    ld d,a
    
    dec hl
    ld a,e
    sub (hl)
    ld e,a                  ;point 2 - point 3 to de
;at this moment at the stack: point 3, pointer to point 2, point 1, pointer to the triangle, counter
;at this moment in registers: bc = point 2 - point 1, de = point 2 - point 3, hl = pointer to point 1, a = e

    push de
    ld h,b
    call MultExH            ;e*b
    pop de                  ;get coord back
    push hl                 ;save result
    
    ld e,d
    ld h,c
    call MultExH
    pop de                  ;now first result in de and 2nd in hl
    or a
    sbc hl,de
    bit 7,h
    
    pop de
    pop hl
    pop bc
    jp z,dont_draw
    call _ldhlind
;now bc = point 1, hl = point 2 and de = point 3
    pop ix
    ld a,(ix)
    push ix
    push de             ;3
    push hl             ;2
    push bc             ;1
    or a
    
    call z,Line          ;2 - 3
    
    pop de              ;1 
    pop hl              ;2
    push de             ;1
    
    call Line          ;1 - 2
    
    pop de              ;1
    pop hl              ;3
    
    call Line
    
    
dont_draw:
    
    pop de
    ld hl,3
    add hl,de
    ex de,hl
    
    pop bc
    djnz draw_lines_loop

;completet drawing

 
    call draw_screen
    call clear_buffer 
    
    ld hl,morph_counter
    inc (hl)
    ld a,(hl)
    cp 32
    jr nz,dont_morph
    ld (hl),0
    
    ld b,24
    ld hl,morph_coords
    
    ld a,(hl)
to_compare_to = $ + 1
    cp -18
    jr z,morph_sequence_complete
    
move_point_loop:
    bit 7,(hl)
    jr z,positive_coord
    
dec_instr:
    dec (hl)
    jr morph_complete
positive_coord:
inc_instr:
    inc (hl)
    
morph_complete:  
        
    inc hl
    djnz move_point_loop
dont_morph:



    pop bc
    pop af
    
    inc a
    inc b
    inc c
    
    jp loop

morph_sequence_complete:
    ld hl,run_counter
    inc (hl)
    ld a,(hl)
    cp 10
    jr nz,dont_morph
    

    ld a,0
    ld (to_compare_to),a
    
;inc (hl) = $34
;dec (hl) = $35

    ld a,$34
    ld (dec_instr),a
    
    inc a
    ld (inc_instr),a
    
    
    ld a,$c3
    ld (morph_sequence_complete),a
    ld hl,rotate_exit
    ld (morph_sequence_complete + 1),hl
    
    jr dont_morph
    
    
    
rotate_exit:
    pop hl
    pop hl


exit_rotate:
    ret

get_coords:
    inc de
    ld a,(de)
    add a,a
    ld hl,rotated_points
    
    add a,l
    ld l,a
    adc a,h
    sub l
    ld h,a
    ret
    
points3:
    .db 6
    .db 0,0,0          ;0
    .db -34,0,0         ;1
    .db -17,17,0          ;2
    .db -17,-17,0         ;3
    .db -17,0,17          ;4
    .db -17,0,-17         ;5
    
    
lines3:
    .db 8
    
    
    .db 0,5,2,0
    .db 0,0,3,5
    .db 0,3,1,5
    .db 0,1,2,5
    .db 0,0,2,4
    .db 0,3,0,4
    .db 0,1,3,4
    .db 0,2,1,4    



points1:
    .db 4
    
;x,y,z
    
    
morph_coord = $ + 1
    .db 0,22,10
    .db -19,-11,10
    .db 19,-11,10
    .db 0,0,-21
    
    
lines1:

    .db 4

    .db 0,0,1,2
    .db 0,0,2,3
    .db 0,3,1,0
    .db 0,3,2,1
    
points4:
    .db 14

    .db 16,16,16
    .db 16,-16,16
    .db -16,-16,16
    .db -16,16,16
    
    .db 0,0,20
    
    .db 16,16,-16
    .db 16,-16,-16
    
    .db 20,0,0
    
    .db -16,16,-16
    .db -16,-16,-16
    .db 0,0,-20
    
    .db -20,0,0
    
    .db 0,20,0
    .db 0,-20,0
    
lines4:
    .db 24
    
    .db 0,0,4,1
    .db 0,1,4,2
    .db 0,2,4,3
    .db 0,3,4,0
    
    .db 0,0,1,7
    .db 0,1,6,7
    .db 0,5,7,6
    .db 0,0,7,5
    
    .db 0,5,6,10
    .db 0,8,5,10
    .db 0,8,10,9
    .db 0,10,6,9
    
    .db 0,8,9,11
    .db 0,3,8,11
    .db 0,3,11,2
    .db 0,2,11,9
    
    .db 0,8,12,5
    .db 0,12,0,5
    .db 0,3,0,12
    .db 0,3,12,8
    
    .db 0,13,9,6
    .db 0,1,13,6
    .db 0,2,13,1
    .db 0,9,13,2
    
    
    
points2:
    .db 8
    
morph_coords:
    .db -1,1,1
    .db 1,1,1
    .db -1,-1,1
    .db 1,-1,1
    
    .db -1,1,-1
    .db 1,1,-1
    .db -1,-1,-1
    .db 1,-1,-1
    
lines2:
    .db 12
    
    .db 1,0,2,1
    .db 1,3,1,2
    
    .db 1,4,0,5
    .db 1,1,5,0
    
    .db 1,4,5,6
    .db 1,7,6,5

    .db 1,6,7,2
    .db 1,3,2,7
    
    .db 1,1,3,5
    .db 1,7,5,3
    
    .db 1,0,4,2
    .db 1,6,2,4
 

points = points2
lines = lines2






   



;             3D ROTATION AND MISCELLANEOUS 3D MATHS ROUTINES



; This is the 3x3 transformation matrix needed:

; / cos(z)*cos(y)+sin(z)*sin(x)*sin(y)  -sin(z)*cos(x)  -cos(z)*sin(y)+sin(z)*sin(x)*cos(y) \
;|  sin(z)*cos(y)-cos(z)*sin(x)*sin(y)   cos(z)*cos(x)  -sin(z)*sin(y)-cos(z)*sin(x)*cos(y)  |
; \            cos(x)*sin(y)                sin(x)                 cos(x)*cos(y)            /

; So let's get busy!!!




RotatePoint: ;coords in a,b,c
        ld d,3
        ld e,a
        ld ix,RotXX
DoApplyMatrix:
        push de
        push bc
        push bc
        ld a,e
        ld d,(ix)
        ld e,0
        inc ix
        call MultAxDE
        pop af
        push hl
        ld d,(ix)
        ld e,0
        inc ix
        call MultAxDE
        push hl
        ld a,c
        ld d,(ix)
        ld e,0
        inc ix
        call MultAxDE
        pop de
        pop bc
        add hl,de
        add hl,bc
        pop bc
        pop de
        push hl
        dec d
        jr nz,DoApplyMatrix
        pop hl
        pop de
        pop bc
        ret

DoUnApplyMatrix:
        push de
        push bc
        ld h,(ix)
        call MultExH
        ld e,b
        ld b,h
        ld h,(ix+3)
        call MultExH
        ld e,c
        ld c,h
        ld h,(ix+6)
        inc ix
        call MultExH
        ld a,h
        add a,b
        add a,c
        pop bc
        pop de
        push af
        dec d
        jr nz,DoUnApplyMatrix
        pop de
        pop bc
        ld c,d
        pop af
        ret



RotXX =RotWS
RotXY =RotWS+1
RotXZ =RotWS+2
RotYX =RotWS+3
RotYY =RotWS+4
RotYZ =RotWS+5
RotZX =RotWS+6
RotZY =RotWS+7
RotZZ =RotWS+8
SinX =RotYZ
SinY =RotWS+9
SinZ =RotWS+10
CosX =RotWS+11
CosY =RotWS+12
CosZ =RotWS+13



;             FAST EIGHT BIT SIGNED MULTIPLICATION ROUTINES
;                     by Matthew Shepcar  August 1998


; This routine finds the value of (H*E+64)/128 and stores the result in H.
; It is slightly faster if H is positive and minutely faster if E is.
; A, HL, DE are used by the code.   DE will contain the sign extended value
; of E*2.   HL will contain (H*E*2+128).   A will be the same as D.


MultAxH:                
        ld e,a
MultExH:                
        ld l,1          ;initial result (the 1 is for rounding)
        sla h           ;shift sign bit out
        jr nc,NotNegMult
; H is negative but use its positive counterpart and flip E's sign to get
; the same result
        xor a
        sub e           ;negate E
        add a,a         ;double
        ld e,a
        sbc a,a         
        ld d,a          ;sign extend E
        jr nc,$+5
        inc h           
        ld l,-1         ;initial result is different if E is negative
        add hl,hl       ;double result & get next bit of H
        jr c,$+3
        add hl,de       ;add DE to result if bit clear (H's bits have
        add hl,hl       ;the reverse meaning because we are treating it as
        jr c,$+3        ;a positive number)
        add hl,de
        add hl,hl
        jr c,$+3
        add hl,de
        add hl,hl
        jr c,$+3        
        add hl,de       
        add hl,hl       
        jr c,$+3
        add hl,de
        add hl,hl
        jr c,$+3
        add hl,de
        add hl,hl
        jr c,$+3
        add hl,de       ;twos complement = flip bits and add 1
        add hl,de       ;this final addition constitutes the 'add 1'
        ret

NotNegMult:
        sla e
        sbc a,a
        ld d,a
        jr nc,$+5
        inc h
        ld l,-1
        add hl,hl
        jr nc,$+3
        add hl,de
        add hl,hl
        jr nc,$+3
        add hl,de
        add hl,hl
        jr nc,$+3
        add hl,de
        add hl,hl
        jr nc,$+3
        add hl,de
        add hl,hl
        jr nc,$+3
        add hl,de
        add hl,hl
        jr nc,$+3
        add hl,de
        add hl,hl
        ret nc
        add hl,de
        ret

MultAxDE:
        ld b,-1
        add a,a         ;shift sign bit out
        jr nc,NotNegMult16
        push de
        or a
        sbc hl,hl
        sbc hl,de
        add hl,hl
        ex de,hl
        sbc hl,hl
        jr c,$+4
        inc b
        inc l
        adc a,0
        add hl,hl
        rla
        jr c,$+4
        add hl,de
        adc a,b
        add hl,hl
        rla
        jr c,$+4
        add hl,de
        adc a,b
        add hl,hl
        rla
        jr c,$+4
        add hl,de
        adc a,b
        add hl,hl
        rla
        jr c,$+4
        add hl,de
        adc a,b
        add hl,hl
        rla
        jr c,$+4
        add hl,de
        adc a,b
        add hl,hl
        rla
        jr c,$+4
        add hl,de
        adc a,b
        add hl,hl
        rla
        jr c,$+4
        add hl,de
        adc a,b
        add hl,de  
        adc a,b
        ld l,h
        ld h,a
        pop de
        ret

NotNegMult16:
        sla e
        rl d
        sbc hl,hl
        jr c,$+4
        inc b
        inc l
        adc a,0
        add hl,hl
        rla
        jr nc,$+4
        add hl,de
        adc a,b
        add hl,hl
        rla
        jr nc,$+4
        add hl,de
        adc a,b
        add hl,hl
        rla
        jr nc,$+4
        add hl,de
        adc a,b
        add hl,hl
        rla
        jr nc,$+4
        add hl,de
        adc a,b
        add hl,hl
        rla
        jr nc,$+4
        add hl,de
        adc a,b
        add hl,hl
        rla
        jr nc,$+4
        add hl,de
        adc a,b
        add hl,hl
        rla
        jr nc,$+4
        add hl,de
        adc a,b
        ld l,h
        ld h,a
        ret
        
        

BuildTrigTables:
        ld hl,TrigPrecalc
        ld de,SinCosTable
        push de
        ld bc,65
        ldir
        dec hl
        ld b,63
MirrorSineWave:
        dec hl
        ld a,(hl)
        ld (de),a
        inc de
        djnz MirrorSineWave
        pop hl
        ld b,128+64
NegativeSineWave:
        xor a
        sub (hl)
        ld (de),a
        inc hl
        inc de
        djnz NegativeSineWave
        ret
        
TrigPrecalc:
.db     0,    3,    6,    9,   12,   15,   18,   21
.db    24,   27,   30,   33,   36,   39,   42,   45
.db    48,   51,   54,   57,   59,   62,   65,   67
.db    70,   73,   75,   78,   80,   82,   85,   87
.db    89,   91,   94,   96,   98,  100,  102,  103
.db   105,  107,  108,  110,  112,  113,  114,  116
.db   117,  118,  119,  120,  121,  122,  123,  123
.db   124,  125,  125,  126,  126,  126,  126,  126
.db   127







.end
