#include "Demo.inc"

.org demo_exec_ram



    call enable_planes
    
num_points = 1

    ld a,11
    out (2),a


move_points:
    push bc

    ld hl,points
    ld b,(hl)
    inc hl
display_points_loop:
    push bc
    inc hl                          ;coord
    inc hl
    ld b,(hl)
    inc hl                          ;modifyer
    
    inc hl                          ;coord
    inc hl
    ld c,(hl)                       
    inc hl
    
    dec c
    inc c
    call z,reset_point
    
    dec b
    inc b
    call z,reset_point
    
    bit 7,b
    call nz,reset_point
    
    bit 6,c
    call nz,reset_point
    
    push hl
    ld a,b
    cp 64
    jp nz,display
    ld a,c
    cp 32
    jp z,skip_display
display:
    call set_point
skip_display:
    
    pop hl
    pop bc
    djnz display_points_loop
    
    
    call draw_screen
    
    ld hl,points
    ld b,(hl)
    inc hl
move_points_loop:
    call move_coord
    inc hl
    call move_coord
    inc hl
    djnz move_points_loop

;    call reset_int_counter
;    ld a,3
;    call int_pause
;    halt


    
;    call clear_buffer
    ld hl,$fc00
    ld de,$fc01
    ld bc,1023
    ld (hl),$ff
    ldir

    ld hl,add_counter
    inc (hl)
    bit 3,(hl)
    jr z,no_more_points
    ld (hl),0
    ld hl,points
    ld a,(points_end-points_start)/6
    cp (hl)
    jr z,no_more_points
    inc (hl)
    
no_more_points:
    ld hl,(frame_counter)
    inc hl
    ld (frame_counter),hl
    ld de,750
    call _cphlde
    jr z,end_points


    pop bc
    jr move_points
    

end_points:
    pop hl
    call disable_planes
    ld a,15
    out (2),a
    ret
    
move_coord:
    ld a,(hl)
    inc hl
    bit 7,a
    jr z,move_positive
move_negative:
;    neg 
    cpl
    add a,(hl)
    ld (hl),a
    inc hl
    ret nc
    dec (hl)
    ret    
          
             
move_positive:
    add a,(hl)
    ld (hl),a
    inc hl
    ret nc
    inc (hl)
    ret
    
    
set_point:
    call FindPixel
    cpl
    and (hl)
    ld (hl),a
    ret

reset_point:
    push hl
    dec hl
    ld (hl),32
    dec hl
    ld (hl),0
    dec hl
    dec hl
    ld (hl),64
    dec hl
    ld (hl),0
    pop hl
    ld b,64
    ld c,32
    ret
    

add_counter:
    .db 0
    
frame_counter:
    .dw 0
    

    
    
points:
    .db num_points
points_start:

    .db -116,0,0
    .db 55,0,0

    .db 84,0,0
    .db 97,0,0
    .db -121,0,0
    .db -43,0,0
    .db -13,0,0
    .db 127,0,0
    .db -93,0,0
    .db -88,0,0
    .db 119,0,0
    .db -46,0,0
    .db 63,0,0
    .db 111,0,0
    .db -3,0,0
    .db 128,0,0
    .db 121,0,0
    .db 43,0,0
    .db 79,0,0
    .db -101,0,0
    .db 84,0,0
    .db 97,0,0
    .db 128,0,0
    .db 9,0,0
    .db -103,0,0
    .db 76,0,0
    .db 83,0,0
    .db -88,0,0
    .db -71,0,0
    .db -106,0,0
    .db -79,0,0
    .db -101,0,0
    .db 58,0,0
    .db 114,0,0
    .db 13,0,0
    .db 127,0,0
    .db 9,0,0
    .db 128,0,0
    .db -121,0,0
    .db -43,0,0
    .db -122,0,0
    .db -40,0,0
    .db -88,0,0
    .db 93,0,0
    .db 95,0,0
    .db -86,0,0
    .db -113,0,0
    .db -60,0,0
    .db -122,0,0
    .db 37,0,0
    .db -40,0,0
    .db -122,0,0
    .db 110,0,0
    .db -66,0,0
    .db -125,0,0
    .db 28,0,0
    .db -88,0,0
    .db -93,0,0
    .db -88,0,0
    .db 93,0,0
    .db 40,0,0
    .db -122,0,0
    .db 28,0,0
    .db -125,0,0
    .db -117,0,0
    .db 52,0,0
    .db -16,0,0
    .db 127,0,0
    .db 9,0,0
    .db -128,0,0
    .db 74,0,0
    .db -105,0,0
    .db 127,0,0
    .db 19,0,0
    .db -91,0,0
    .db -91,0,0
    .db -86,0,0
    .db -95,0,0
    .db -121,0,0
    .db 43,0,0
    .db -127,0,0
    .db 16,0,0
    .db 31,0,0
    .db -124,0,0
    .db -60,0,0
    .db 113,0,0
    .db -88,0,0
    .db -93,0,0
    .db 111,0,0
    .db -63,0,0
    .db 37,0,0
    .db -122,0,0
    .db -121,0,0
    .db 43,0,0
    .db -95,0,0
    .db 86,0,0
    .db 128,0,0
    .db -3,0,0
    .db -125,0,0
    .db -28,0,0
    .db 28,0,0
    .db -125,0,0
    .db 19,0,0
    .db -127,0,0
    .db 124,0,0
    .db 31,0,0

    
    
    
points_end:

