//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cRocket.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cRocket_hpp
#define cRocket_hpp
//==============================================================================
// Includes
#include "cSprite.hpp"
#include "cCollidable.hpp"
#include "cOwnable.hpp"
#include "cParticleEmitter.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
class cMixer;
class cRocketLauncher;
//==============================================================================
	
//! Rocket
class cRocket : public cCollidable, public cSprite, public cOwnable, public cParticleEmitter
{
	// Constructor & Destructor
	public:
		//! Constructor
		cRocket (void);
		//! Destructor
		virtual ~cRocket (void);
	
	// Public methods
	public:
		virtual void OnMapCollision (	const cVector2f &begin, 
										const cVector2f &end);
		virtual void OnObjectCollision (cCollidable *pOther);
		
		//! Create a smoke particle system
		void CreateSmokeSystem (void);
		void SetChannel(int channel){ mChannel = channel;};
	
		void Explode ();
	
	// Member variables
	private:
		ObjectID mSmokeSystem;
		Uint32 mSound;
		Uint32 mReloadSound;
		int mChannel;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cRocket_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
