//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cFlameSystem.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cFlameSystem.hpp"
#include "cTextureManager.hpp"
#include "cBurnable.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================


//! Constructor
cFlameSystem::cFlameSystem (void):
cParticleSystem (100),
mDeltaTime (0)
{
	// Hard coding sucks
	SetTexture (cTextureManager::GetInstance ().LoadTexture ("tuli2.png"));
	SetAngleVariation (5.0f);
	SetSpeed (0.4f, 0.3f);
	SetBlending ();
	SetSize (6.0f, 128.0f);
	SetEnergy (1000, 0.3f);
	SetEmitDelay (0);
	SetEndColor (1.0f, 0.5f, 0.5f, 0.0f);

	SetCollisionModel (CollisionModel_Particle);
  	SetCollidableParticles (GetParticles (), cParticleSystem::GetNumberOfParticles ());
	SetVelocity (cVector2f (0.0f, 0.0f));
	SetLayer (1);
};

//! Destructor
cFlameSystem::~cFlameSystem (void)
{
	// Empty
};

void 
cFlameSystem::OnObjectCollision (cCollidable *pObject)
{
	cBurnable *pVictim = dynamic_cast<cBurnable*> (pObject);
	if ( pVictim != NULL )
		pVictim->Burn (mDeltaTime, GetOwner ());
}

//==============================================================================
// EOF
//==============================================================================
