//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cPositionable.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cPositionable_hpp
#define cPositionable_hpp
//==============================================================================
// Includes
#include "cObject.hpp"
#include "cVector2f.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//==============================================================================
//! Positionable object
//------------------------------------------------------------------------------
class cPositionable : public cObject
{
	// Constructor & Destructor
	public:
		//! Constructor
		cPositionable (void);
		//! Destructor
		virtual ~cPositionable (void);
	
	// Public methods
	public:
		//! Set position
		void SetPosition (const cVector2f &position) { mPosition = position; };
		//! Return position
		const cVector2f &GetPosition (void) const { return mPosition; };
		
		//! Set rotation
		void SetRotation (float angle) { mRotation = angle; };
		//! Returun rotation
		float GetRotation (void) const { return mRotation; };
		
		//! Set orientation (position & rotation)
		void SetOrientation (const cVector2f &position, float angle)
		{
			SetPosition (position);
			SetRotation (angle);
		};
		//! Get orientation (position & rotation)
		void GetOrientation (cVector2f &position, float &angle) const
		{
			position = GetPosition ();
			angle = GetRotation ();
		};
		
		//! Return direction vector
		cVector2f GetDirection (float angle = 0.0f) const;
		
		//! Move object (no collision detection)
		void Move (const cVector2f &direction) { mPosition += direction; };
		//! Move object (no collision detection)
		void Move (float angle, float speed)
		{
			mPosition += GetDirection (angle) * speed;
		}
		//! Rotate object (no collison detecton)
		void Rotate (float angle) { mRotation += angle; };
	
	// Member variables
	private:
		cVector2f mPosition;	//!< Position of the object
		float mRotation;		//!< Rotation about the Z-axis
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cPositionable_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
