//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cMap.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cMap_hpp
#define cMap_hpp
//==============================================================================
// Includes
#include <string>
#include <vector>
#include "cVector2f.hpp"
#include "Types.hpp"
#include <GL/gl.h>
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
class cWorld;
//==============================================================================
	
struct tMapVertex
{
	cVector2f mPosition;
	float mTexCoord[2];
	float mColor[4];
};

struct tMapTriangle
{
	Uint8 mLayer;
	Uint32 mTextureID;
	Uint32 mFlags;
	Uint16 mVertexIndices[3];
};

struct tMapQuad
{
	Uint8 mLayer;
	Uint32 mFlags;
	Uint32 mTextureID;
	Uint16 mVertexIndices[4];
};

struct tWall
{
	cVector2f begin;
	cVector2f end;
	Uint32 flags;
};

//! Map
class cMap
{
	friend class cWorld;
		
	// Constructor & Destructor
	public:
		//! Constructor
		cMap (void);
		//! Destructor
		~cMap (void);
	
	// Public methods
	public:
		void Free (void);
		void Load (string filename);
		//void Render (void);
	
		vector<tWall> &GetWallList (void) { return mWallList; };
		
		void RenderBelow (void)
		{
			glCallList (mBelowList);
		};
		
		void RenderAbove (void)
		{
			glCallList (mAboveList);
		};
	
		/*//! Test if a circle collides with blocking geometry
		Uint32 CircleCollision (const cVector2f &center, float radius, cVector2f &blocker);
		//! Test if a ray collides with blocking geometry
		Uint32 RayCollision (const cVector2f &start, const cVector2f end, cVector2f &blocker);*/
	
		int GetWidth (void) const { return mWidth; };
		int GetHeight (void) const { return mHeight; };
		
	// Private methods
	private:
		void GenerateWallList (void);
		void GenerateDisplayLists (void);
		void FreeDisplayLists (void);
		void FreeMapGeometry (void);
		
		//! Render layers 0-128
		void RenderBelow2 (void);
		//! Render layers 128-255
		void RenderAbove2 (void);
	// Member variables
	private:
		int mWidth;
		int mHeight;
		
		vector<tWall> mWallList;
	
		Uint32 mBelowList;
		Uint32 mAboveList;
	
		int mNumberOfVertices;
		int mNumberOfTriangles;
		int mNumberOfQuads;
		tMapVertex *mpVertices;
		tMapTriangle *mpTriangles;
		tMapQuad *mpQuads;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cMap_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
