//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cWeaponBox.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cWeaponBox.hpp"
#include "cAnimationManager.hpp"
#include "cPlayer.hpp"
#include "cMixer.hpp"
#include "cPistol.hpp"
#include "cShotgun.hpp"
#include "cRocketLauncher.hpp"
#include "cFlamer.hpp"
#include "cMachineGun.hpp"
#include "cWorld.hpp"
#include "Debug.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================


//! Constructor
cWeaponBox::cWeaponBox (void):
mType (BoxType_Pistol),
mSound (cMixer::GetInstance ().LoadSound ("pickup.wav"))
{
	SetCollisionModel (CollisionModel_Circle);
	SetCollisionRadius (20.0f);
	SetVelocity (cVector2f (0.0f, 0.0f));

	mAnimation.SetAnimation (cAnimationManager::GetInstance ().LoadAnimation ("weaponbox"));
	mAnimation.SetNumberOfFrames (1);
	mAnimation.SetFrameDelay (999999);
	SetLayer (-10);
};

//! Destructor
cWeaponBox::~cWeaponBox (void)
{
	// Empty
};

//! Called when object collides with other object
void 
cWeaponBox::OnObjectCollision (cCollidable *pOther)
{
	cSoldier *pSoldier = dynamic_cast<cPlayer*>(pOther);
	if ( pSoldier != NULL )
	{
		cWeapon *pWeapon = NULL;
		switch ( mType )
		{
			case BoxType_Pistol:
				pWeapon = new cPistol;
				break;
			case BoxType_Shotgun:
				pWeapon = new cShotgun;
				break;
			case BoxType_Flamer:
				pWeapon = new cFlamer;
				break;
			case BoxType_RocketLauncher:
				pWeapon = new cRocketLauncher;
				break;
			case BoxType_MachineGun:
				pWeapon = new cMachineGun;
				break;
			default:
				dbg::sentinel (DBG_HERE);
				break;
		}
		cWorld::GetInstance ().SpawnObject (pWeapon);
		cMixer::GetInstance ().PlaySound (mSound);
		pSoldier->AddWeapon (pWeapon);
		Kill ();
	}
}

//==============================================================================
// EOF
//==============================================================================
