//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cGameMode.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cGameMode_hpp
#define cGameMode_hpp
//==============================================================================
// Includes
#include <string>
#include <vector>
#include <SDL.h>
#include "cPointer.hpp"
#include "cPlayer.hpp"
#include "cHud.hpp"
#include "cTextureFont.hpp"
#include "cActionMapper.hpp"
#include "cComputerSoldier.hpp"
#include "cGameView.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
class cGameCore;
class cTextureManager;
class cAnimationManager;
class cWorld;
class cDisplayManager;
class cMixer;
class cOptions;
//==============================================================================
	
//==============================================================================
//! GameMode
//------------------------------------------------------------------------------
class cGameMode
{
	friend class cGameView;
	
	public:
		enum GameType
		{
			GameType_Single,
			GameType_Split
		};
	// Constructor & Destructor
	public:
		//! Constructor
		cGameMode (cGameCore &core);
		//! Destructor
		~cGameMode (void);
	
	// Public methods
	public:
		void Run (GameType type);
	
	// Private methods
	private:
		void EventHandler (void);
		void ActionHandler (void);
		void UpdateGame (Uint32 deltaTime);
		void RenderGame (Uint32 deltaTime);
	
	  	void InitializeLevel (void);
		void LoadLevel (string map);
		void LoadObjects (string map);
		void LoadLevelList (void);
		void NextLevel (void);
		void RestartLevel (void);
		void GameCompleted (void);
	
	// Member variables
	private:
		cGameCore &mCore;
		bool mRunning;
	
		cGameView mGameView;

		cTextureManager &mTexManager;
		cAnimationManager &mAnimManager;
		cWorld &mWorld;
		cMixer &mMixer;
		cDisplayManager &mDisplayManager;
		cOptions &mOptions;
		cHud mHud;
		cTextureFont mFont;
	
		// Actions
		cActionMapper mActionMapper;
		vector<cAction> mActionList;
	
		// FPS
		float mFPS;
		
		// Rendering
		bool mCameraLock;
		int mMapWidth;
		int mMapHeight;
		float mTextWave;
		
		// Game
		GameType mGameType;	
		bool mGameOver;
		bool mLevelCleared;
		bool mGameCompleted;
		Uint32 mLevelEndDelay;
		vector<string> mLevelList;
		unsigned int mNextLevel;
		
		// Player objects
		cPointer<cPlayer> mPlayer1;
		cPointer<cPlayer> mPlayer2;
		
		// Enemies
		vector<cPointer<cComputerSoldier> > mEnemies;

};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cGameMode_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
