//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cComputerSoldier.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cComputerSoldier_hpp
#define cComputerSoldier_hpp
//==============================================================================
// Includes
#include "cSoldier.hpp"
#include "cPointer.hpp"
#include "cPlayer.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//------------------------------------------------------------------------------
// Constants
const Uint32 REPORT_DELAY = 1000;
//==============================================================================

//==============================================================================
//! Computer controlled soldier
//------------------------------------------------------------------------------
class cComputerSoldier : public cSoldier
{
	typedef cPointer<cPlayer> PlayerRef;
	// Constructor & Destructor
	public:
		//! Constructor
		cComputerSoldier (PlayerRef player1 = NULL, PlayerRef player2 = NULL);
		//! Destructor
		virtual ~cComputerSoldier (void);
	
	// Public methods
	public:
		//! Updating interface
		virtual void Update (Uint32 deltaTime);
	
		//! Called when object is hurt
		virtual void OnHurt (int amount, const cVector2f &direction, ObjectID attacker); 
	// Member variables
	private:
		//! AI state
		enum State
		{
			State_Patrol,
			State_Attack
		};
		State mState;		//!< Current state
		cSoldier *mpTarget;	//!< Target player if any
		bool mTargetLos;
		
		PlayerRef mPlayer1;
		PlayerRef mPlayer2;
		
		// TEMP
		Uint32 mReport;
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cComputerSoldier_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
