//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cBurningEffect.cpp
// Project: Shooting Star
// Author: 
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cBurningEffect.hpp"
#include "cTextureManager.hpp"
#include "cMixer.hpp"
#include "cParticleEmitter.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================


//! Constructor
cBurningEffect::cBurningEffect (cHurtable *pVictim):
cParticleSystem (100),
mTTL (1000),
mCounter (0),
mVictim (pVictim),
mSound (cMixer::GetInstance ().LoadSound ("burning.wav")),
mChannel(-2)
{
	SetEmittingPosition (mVictim->GetPosition ());
	SetAngleVariation (360.0f);
	SetTexture (cTextureManager::GetInstance ().LoadTexture ("tuli2.png"));
	SetSpeed (0.05f, 0.3f);
	SetBlending ();
	SetSize (6.0f, 64.0f);
	SetEnergy (500, 0.3f);
	SetEmitDelay (20);
	SetEndColor (1.0f, 0.7f, 0.7f, 0.0f);
	SetLayer (1);
};

//! Destructor
cBurningEffect::~cBurningEffect (void)
{
	if ( mChannel >= 0 )
	{
		cMixer::GetInstance ().StopSound (mChannel);
		mChannel = -2;
	}
};

void 
cBurningEffect::Update (Uint32 deltaTime)
{
	if ( (!mVictim->IsAlive () || mTTL <= deltaTime) && mTTL != 0 )
	{
		if ( mChannel >= 0 )
		{
			cMixer::GetInstance ().StopSound (mChannel);
			mChannel = -2;
		}
		KillEmptySystem (true);
		SetEmitDelay (0);
		mTTL = 0;
	}
	else if ( mTTL != 0 )
	{
		mTTL -= deltaTime;	
		if ( mTTL == 0 )
			mTTL = 1;
		mCounter += deltaTime;
	
		float power = float (mTTL) / 100.0f;

		if ( mCounter >= 100 )
		{
			if( mChannel < 0 )
				mChannel = cMixer::GetInstance ().PlaySound (mSound,-1);
			
			mVictim->DoDamage (int (power * 0.5f), cVector2f (0.0f, 0.0f));
			mCounter -= 100;
		}

		SetEmittingPosition (mVictim->GetPosition ());
		if ( power > 15 )
			power = 15;
		SetEmitDelay (50 - int (power * 2));
	}	
	
	// Call base
	cParticleSystem::Update (deltaTime);
}

//==============================================================================
// EOF
//==============================================================================
