//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cHarmful.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cHarmful_hpp
#define cHarmful_hpp
//==============================================================================
// Includes
#include "cCollidable.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
class cHurtable;
//==============================================================================
	
//==============================================================================
//! Object that can do damage to hurtable objects
//------------------------------------------------------------------------------
class cHarmful : public cCollidable
{
	// Constructor & Destructor
	public:
		//! Constructor
		cHarmful (void);
		//! Destructor
		virtual ~cHarmful (void);
	
	// Public methods
	public:
		//! Set the amount of damage this object will do on collision
		void SetDamage (int damage) { mDamage = damage; };
		//! Return the amount of damage this object will do on collision
		int GetDamage (void) const { return mDamage; };
		
		//! Called when object collides with other object
		virtual void OnObjectCollision (cCollidable *pOther);
		//! Called when object deals damage to hurtable object
		virtual void OnDamage (cHurtable *pObject) {};
	
	// Member variables
	private:
		int mSound;
		int mDamage;	//!< The amount of damage this object will do
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cHarmful_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
