//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cCollidable.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cCollidable_hpp
#define cCollidable_hpp
//==============================================================================
// Includes
#include "Types.hpp"
#include "cPositionable.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
class cObject;
struct tParticle;
struct tWall;
//==============================================================================

//==============================================================================
//! Object that collides with other collidable objects and the map
//------------------------------------------------------------------------------
class cCollidable : virtual public cPositionable
{
	// Constructor & Destructor
	public:
		//! Constructor
		cCollidable (void);
		//! Destructor
		virtual ~cCollidable (void);
	
	// Public methods
	public:
		// --- Collision detection
		/*//! Object collision test
		void RayCollision (cCollidable *pOther, Uint32 deltaTime);	
		//! Object collision test
		void CircleCollision (cCollidable *pOther, Uint32 deltaTime);*/
	
		// --- Collision model ---
		//! Set collision model for this object
		void SetCollisionModel (CollisionModel model) 
		{ 
			mCollisionModel = model;
		};
		//! Return collision model
		CollisionModel GetCollisionModel (void) const { return mCollisionModel; };
		// --- Contact model
		//! Set contact model for this object
		void SetContactModel (ContactModel model) { mContactModel = model; };
		//! Return contact model
		ContactModel GetContactModel (void) const { return mContactModel; };
		
		// --- CollisionModel_Circle
		//! Set collision radius (CollisionModel_Circle)
		void SetCollisionRadius (float radius) { mCollisionRadius = radius; };
		//! Return collision radius (CollisionModel_Circle)
		float GetCollisionRadius (void) const { return mCollisionRadius; };
		
		// --- CollisionModel_Particle
		//! Set collidable particles (CollisionModel_Particle)
		void SetCollidableParticles (tParticle *pParticles, int numberOfParticles) 
		{ 
			mpParticles = pParticles; 
			mNumberOfParticles = numberOfParticles;
		};
		//! Return colliding particles (CollisionModel_Particle)
		tParticle *GetCollidableParticles (void) { return mpParticles; };
		//! Return number of particles
		int GetNumberOfParticles (void) { return mNumberOfParticles; };
		
		// --- Velocity ---
		void SetVelocity (const cVector2f &velocity) { mVelocity = velocity; };
		const cVector2f &GetVelocity (void) const { return mVelocity; };
				
		//! Called when object collides with the map
		virtual void OnMapCollision (	const cVector2f &begin, 
										const cVector2f &end) {};
		//! Called when object collides with other object
		virtual void OnObjectCollision (cCollidable *pOther) {};
	
	// Member variables
	private:
		CollisionModel mCollisionModel;	//!< Collision model
		ContactModel mContactModel;	//!< Contact model
		float mCollisionRadius;		//!< CollisionModel = CollisionModel_Circle
		cVector2f mVelocity;		//!< Velocity of the object
		tParticle *mpParticles;		//!< CollisionModell = CollisionModel_Particle
		int mNumberOfParticles;
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cCollidable_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
