
string RENDERPASS = "solid";

texture Tex0 < string name = "t2.jpg"; int mipmaps=7; int quality=1;>;
texture Tex1 < string name = "b3.jpg"; int normalmap=1; float normalmapamplitude=20; int mipmaps=7; int quality=1;>;


float4x3 WorldView  : WORLDVIEW; 
float4x4 Projection : PROJECTION;

float4 Ambience = float4(0.03,0,0.08,1);

float TheTime : TIME;

struct VS_OUTPUT
{
    float4 Position : POSITION;
    float4 Diffuse  : COLOR0;
    float4 Specular : COLOR1;
    float2 TexCoord : TEXCOORD0;
    float2 NormalMap: TEXCOORD1;
  
};

struct PS_OUTPUT
{
    float4 vColor           : COLOR0;
};


VS_OUTPUT VS
    (
    float4 Position : POSITION, 
    float4 Colour   : COLOR0,
    float3 Tangent  : TANGENT,
    float4 Spec     : COLOR1,
    float3 Normal   : NORMAL,
    float2 TexCoord : TEXCOORD0,
    float2 BumpCoord : TEXCOORD1
    )
{
    VS_OUTPUT Out = (VS_OUTPUT)0;

	float3 LightPos;

	LightPos.x = sin(1+TheTime*1)*3;
	LightPos.y = sin(TheTime*1.2)*4+5;
	LightPos.z = 1;


	float3 P = mul(Position, WorldView);                    // position (view space)

	
	float3 N = Normal;
	N = mul(N,WorldView);

	float3 T = Tangent;


	float3 lpos = normalize(LightPos - P);
	float3 camvertvec = normalize(P);

	float3 halfvec = normalize(lpos + camvertvec);
	

	    
	float3 Binormal = cross(N, T);        

	float3x3 mLight = float3x3(T.x, Binormal.x, N.x,
	                 T.y, Binormal.y, N.y, 
        	         T.z, Binormal.z, N.z);
	

	
	Out.Diffuse = float4(mul(lpos, mLight) * 0.5 + 0.5,1);
	//Out.Diffuse.x -= Position.z * 0.3;
	//Out.Diffuse.y -= Position.z * 0.3;
	//Out.Diffuse.z -= Position.z * 0.3;
	Out.Diffuse.w = 1.0;
	Out.Specular = float4(mul(halfvec, mLight) * 0.5 + 0.5,1);
	
	Out.TexCoord.xy = TexCoord.xy;
	Out.NormalMap.xy = BumpCoord.xy  + float2(0,TheTime);
	//Out.NormalMap.xy = N.xy * 0.5 + 0.5;
	Out.Position = mul(float4(P, 1), Projection);   // projected position

	   
	return Out;    
}




sampler DiffuseMap = sampler_state
{
Texture   = <Tex0>;
MinFilter = LINEAR;
MagFilter = LINEAR;
MipFilter = LINEAR;
};

sampler NormalMapa = sampler_state
{
Texture   = <Tex1>;
MinFilter = LINEAR;
MagFilter = LINEAR;
MipFilter = LINEAR;
};


float4 PS11(VS_OUTPUT In) : COLOR
{   
	float4 col= (tex2D(NormalMapa,In.NormalMap) - 0.5f) * 2.0f;
	float4 texcol= tex2D(DiffuseMap,In.TexCoord);
	float4 dif = (In.Diffuse - 0.5f) * 1.0f;
	float4 spec = (In.Specular - 0.5f) * 1.0f;
	float4 difbump = dot(dif, col);
	float4 speccol = dot(spec, col);


	
	speccol = speccol * speccol;
	//speccol = speccol * speccol;
	//speccol = speccol * speccol;
	//speccol = speccol * speccol;

	return Ambience + (difbump  * texcol) + speccol;
}  


technique TSpecularBumpmap
{
    pass P0
    {   
        VertexShader = compile vs_1_1 VS();

       PixelShader  = compile ps_1_1 PS11();

        Sampler[0] = (DiffuseMap);
       Sampler[1] = (NormalMapa);

	TexCoordIndex[0] =0;
	TexCoordIndex[1] =1;

	AlphaBlendEnable = false;
	SrcBlend = One;
	DestBlend = One;

	AlphaOp[0] = SelectArg1;
	AlphaArg1[0] = Diffuse;
	ZEnable = true;
	ZWriteEnable = true;

	CullMode = CCw;

	
	

        
    }

}