#ifndef __BLOB_H
#define __BLOB_H

/* class definition is at the bottom */

enum axis {
        xaxis = 0,
	yaxis = 1,
	zaxis = 2
};

#define GP_X 36
#define GP_Y 36
#define GP_Z 36
#define GP_DISTX 4.0
#define GP_DISTY 4.0
#define GP_DISTZ 4.0
#define GP_MINX (0.0 + -((float)GP_X)/2 * (float)GP_DISTX)
#define GP_MINY (0.0 + -((float)GP_Y)/2 * (float)GP_DISTY)
#define GP_MINZ (0.0 + -((float)GP_Z)/2 * (float)GP_DISTZ)
#define GP_MAXX (0.0 + ((float)GP_X)/2 * (float)GP_DISTX)
#define GP_MAXY (0.0 + ((float)GP_Y)/2 * (float)GP_DISTY)
#define GP_MAXZ (0.0 + ((float)GP_Z)/2 * (float)GP_DISTZ)
#define GP_STEPX (((float)GP_MAXX - (float)GP_MINX) / (float)(GP_X-1))
#define GP_STEPY (((float)GP_MAXY - (float)GP_MINY) / (float)(GP_Y-1))
#define GP_STEPZ (((float)GP_MAXZ - (float)GP_MINZ) / (float)(GP_Z-1))

#define MAX_VERTEX 3*(GP_X-1)*(GP_Y-1)*(GP_Z-1)

#define TP_MULA ((GP_X-1)*(GP_Y-1)*(GP_Z-1)*3)
#define TP_MULX ((GP_Y-1)*(GP_Z-1)*3)
#define TP_MULY ((GP_Z-1)*3)
#define TP_MULZ (1*3)

typedef struct MovingPoint {
        float x;
        float y;
        float z;
        float value;
} MovingPoint;

typedef struct Vertex3D {
        float nx, ny, nz;
        float x, y, z;
} Vertex3D;
typedef struct Vertex3D ThresholdPoint;

typedef struct GridPoint
{
        float value;
        float nx, ny, nz;
        int inside;
        int valid;
} GridPoint;

#ifndef APIENTRY
#define APIENTRY
#endif

typedef void (APIENTRY *PFNGLDRAWRANGEELEMENTSEXTPROC)(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);
typedef void (APIENTRY *PFNGLLOCKARRAYSEXTPROC)(GLint first, GLsizei count);
typedef void (APIENTRY *PFNGLUNLOCKARRAYSEXTPROC)(void);

class Blob {
public:
        Blob(int num_mps);
        ~Blob();

        void draw_object();
	void draw_object(bool draw_halo, float halo_length, int stencil_mask);
        void set_moving_point(int point, float x,float y,float z, float value);

private:
        int num_mps;
        
        void ResetThresholdPoints();
        void ResetGrid();
        int calcPoint(int index, float x, float y, float z);
        void move_from_point(int index, int i, int j, int k, float x, float y, float z);
        void CalcGrid();
        inline void CalcThresholdPoint(GridPoint *gp1, GridPoint *gp2, Vertex3D *tp,float gx,float gy,float gz,enum axis ax);
        void CalcThresholdPoints();
        void MakePolys(bool draw_halo, float halo_length, int stencil_mask);
        void CreateVertex3DList();
        
        GridPoint *GridPoints;
        Vertex3D *Vertex3DList;
        MovingPoint *MovingPoints;

	int max_vert;
	
	bool has_draw_range_elements, has_compiled_vertex_array;
	PFNGLDRAWRANGEELEMENTSEXTPROC glDrawRangeElementsEXT;
	PFNGLLOCKARRAYSEXTPROC glLockArraysEXT;
	PFNGLUNLOCKARRAYSEXTPROC glUnlockArraysEXT;
};

#endif
