/*
 * This "effect" is almost totally untimed (ie. it counts frames, not
 * seconds).  Rationale: A faster machine will play the fades faster,
 * but it will also _load_ faster, so it's reasonable that it also
 * loads faster ;-) * (If you want, do a s/rationale/excuse for being
 * lazy/ ;-) )
 */

#include "main/piprecalc.h"
#include <stdio.h>
#include <unistd.h>

#define PI_STRING "3.14159265358979323846264338327950288"

/* ahem ;-) */
#ifndef __linux__
#define usleep(x) Sleep(x)
#endif

PiPrecalc::PiPrecalc(GLWindow *win)
{
	this->win = win;
	this->font = texture::load("loaderfont.png");

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
        glOrtho(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
        glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	glDisable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	this->font->bind();

	/* "slide" the letters */
	for (int i = 0; i < 200; i++) {
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

		for (int j = 0; j < 10; j++) {
			int t = (j > 7) ? 7 : j;
			
			glColor4f(1.0f, 1.0f, 1.0f, (float)(i - j * 10 - 15) / 20.0f);
			glBegin(GL_QUADS);
			glTexCoord2f((float)(t) / 32.0f, 0.0f);
			glVertex2f((float)(j) / 35.0f + 0.35f, 0.22f);
			
			glTexCoord2f((float)(t+1) / 32.0f, 0.0f);
			glVertex2f((float)(j+1) / 35.0f + 0.35f, 0.22f);
			
			glTexCoord2f((float)(t+1) / 32.0f, 1.0f);
			glVertex2f((float)(j+1) / 35.0f + 0.35f, 0.32f);
			
			glTexCoord2f((float)(t) / 32.0f, 1.0f);
			glVertex2f((float)(j) / 35.0f + 0.35f, 0.32f);
			glEnd();
		}
		this->win->flip();
		usleep(1);
	}
	
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);

	this->last_status = 0;
}

PiPrecalc::~PiPrecalc()
{
	this->update(1.0f);

	/* simple fade to zero, fading quicker and quicker :-) */
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
        glOrtho(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
        glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
	
	for (int i = 0; i < 50; i++) {
		glColor4f(0.0f, 0.0f, 0.0f, (float)(i*i) / 2500.0f);
		
		glBegin(GL_QUADS);
		glVertex2f(0.0f, 0.0f);
		glVertex2f(1.0f, 0.0f);
		glVertex2f(1.0f, 1.0f);
		glVertex2f(0.0f, 1.0f);
		glEnd();

		this->win->flip();
		usleep(1);
	}
	
	delete this->font;
	this->font = NULL;
}
	
void PiPrecalc::update(float p)
{
	int target = (int)(p * 37.0f);

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
        glOrtho(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f);
        glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE);
	glDisable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	this->font->bind();

	for (int i = this->last_status; i < target; i++) {
		for (int fno = 0; fno < 10; fno++) {
			/* first rewrite the text :-) */
			glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
			glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
			
			int j;
			for (j = 0; j < 10; j++) {
				int t = (j > 7) ? 7 : j;
			
				glBegin(GL_QUADS);
				glTexCoord2f((float)(t) / 32.0f, 0.0f);
				glVertex2f((float)(j) / 35.0f + 0.35f, 0.22f);
			
				glTexCoord2f((float)(t+1) / 32.0f, 0.0f);
				glVertex2f((float)(j+1) / 35.0f + 0.35f, 0.22f);
			
				glTexCoord2f((float)(t+1) / 32.0f, 1.0f);
				glVertex2f((float)(j+1) / 35.0f + 0.35f, 0.32f);
			
				glTexCoord2f((float)(t) / 32.0f, 1.0f);
				glVertex2f((float)(j) / 35.0f + 0.35f, 0.32f);
				glEnd();
			}

			/*
			 * then write every letter that we already wrote,
			 * and last the new letter
			 */
			for (j = 0; j <= i; j++) {
				char ch = PI_STRING[36 - j];
				int t = (ch == '.') ? 7 : (8 + (ch - '0'));

				if (j == i) {
					glColor4f(1.0f, 1.0f, 1.0f, (float)(fno) / 10.0f);
				}
				
				glBegin(GL_QUADS);
				glTexCoord2f((float)(t) / 32.0f, 0.0f);
				glVertex2f((float)(38-j) / 41.0f, 0.7f);
			
				glTexCoord2f((float)(t+1) / 32.0f, 0.0f);
				glVertex2f((float)(38-j+1) / 41.0f, 0.7f);
			
				glTexCoord2f((float)(t+1) / 32.0f, 0.9f);
				glVertex2f((float)(38-j+1) / 41.0f, 0.8f);
			
				glTexCoord2f((float)(t) / 32.0f, 0.9f);
				glVertex2f((float)(38-j) / 41.0f, 0.8f);
				glEnd();
			}
			this->win->flip();
			usleep(1);
		}
	}
	
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);

	this->last_status = target;
}
