#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>

#ifdef WIN32
#include <windows.h>
#endif
#include <GL/gl.h>

#ifndef M_PI
#define M_PI 3.14159265358979323846264
#endif

#include "main/heightmaptunnelhandler.h"
#include "math/vector.h"
#include "exception.h"
#include "demolib_prefs.h"

#if DEMOLIB_MAINLOOP

HeightmapTunnelHandler::HeightmapTunnelHandler(MainLoop *ml, const char *title, const char *elem, Hashtable *attr) :
	Object(ml, title, elem, attr)
{
	this->xlod = attr->get_int("xlod");
	this->ylod = attr->get_int("ylod");
	this->speedlin = attr->get_float("speedlin");
	this->freqlinx = attr->get_float("freqlinx");
	this->freqliny = attr->get_float("freqliny");
	this->ampllin = attr->get_float("ampllin");
	
	this->speedcirc = attr->get_float("speedcirc");
	this->freqcirc = attr->get_float("freqcirc");
	this->amplcirc = attr->get_float("amplcirc");
	
	this->pure_indices = true;

	this->vertices_per_face = 4;

	float xscale = 2.0f * M_PI / (float)xlod;
	float yscale = 1.0f / (float)ylod;
	
	int x, y;
	float xf, yf;
	for (y = 0, yf = -0.5f; y < ylod; y++, yf += yscale) {
		for (x = 0, xf = 0.0f; x < xlod; x++, xf += xscale) {
			struct vertex v = { cos(xf) * 10.0f, sin(xf) * 10.0f, yf * 100.0f };
			struct texcoord t = { xf + 0.5f, yf + 0.5f };
			struct normal n = { 0.0f, 1.0f, 0.0f };
			this->vertices.add_end(v);
			this->texcoords.add_end(t);
			this->normals.add_end(n);
		}
	}
	
	for (y = 0; y < ylod-1; y++) {
		for (x = 0; x < xlod-1; x++) {
			this->faces.add_end(y*ylod + x);
			this->faces.add_end((y+1)*ylod + x);
			this->faces.add_end((y+1)*ylod + x+1);
			this->faces.add_end(y*ylod + x+1);
		}
	}
}

HeightmapTunnelHandler::~HeightmapTunnelHandler()
{
}

void HeightmapTunnelHandler::start_effect()
{
	Object::start_effect();
}
void HeightmapTunnelHandler::draw_scene(float progress)
{
	this->unlock_object();
	float u1 = this->get_val("user1", progress);
	float u2 = this->get_val("user2", progress);
	float u3 = this->get_val("user3", progress);
	float u4 = this->get_val("user4", progress);
	float xscale = 1.0f / (float)(xlod-1);
	float yscale = 1.0f / (float)ylod;
	float yf = 0.0f;
	for (int y = 0; y < ylod; y++, yf += yscale) {
		float xf = 0.0f;
		for (int x = 0; x < xlod; x++, xf += xscale) {
			const float z = hfunc(xf, yf, u1, u2, u3, u4, progress);
			const float xxf = xf * 2.0f * M_PI;
			Vector p(cos(xxf) * (10.0f - z * 2.0f),
				 sin(xxf) * (10.0f - z * 2.0f),
				 yf * 100.0f);
			float z1 = hfunc(xf + 0.0001f, yf, u1, u2, u3, u4, progress);
			Vector p1(cos(xxf + 0.000628f) * (10.0f - z1 * 2.0f),
				  sin(xxf + 0.000628f) * (10.0f - z1 * 2.0f),
				  yf * 100.0f);
			float z2 = hfunc(xf, yf + 0.0001f, u1, u2, u3, u4, progress);
			Vector p2(cos(xxf) * (10.0f - z2 * 2.0f),
				  sin(xxf) * (10.0f - z2 * 2.0f),
				  (yf + 0.0001f) * 100.0f);

			p1 -= p;
//			p1.z *= 0.2f;
			p2 -= p;
//			p2.z *= 0.2f;

			Vector normal = p2.cross_product(p1).normalize();
//			vertices[y * xlod + x].z = z;
			vertices[y * xlod + x].x = p.x;
			vertices[y * xlod + x].y = p.y;

			normals[y * xlod + x].nx = normal.x;
			normals[y * xlod + x].ny = normal.y;
			normals[y * xlod + x].nz = normal.z;
		}
	}
	Object::draw_scene(progress);
}
void HeightmapTunnelHandler::end_effect()
{
	Object::end_effect();
}

inline float HeightmapTunnelHandler::hfunc(float xf, float yf, float u1, float u2, float u3, float u4, float progress)
{
	float dist = hypot(sin(xf*2.0f*M_PI) - u3, yf - u4);
	return sin(dist*freqcirc + progress * speedcirc) * amplcirc +
	       (sin(sin(xf*2.0f*M_PI+yf)*freqlinx + progress * speedlin + u1) +
	        sin(yf*freqliny + progress * speedlin + u2)) * ampllin;
}

#endif /* DEMOLIB_MAINLOOP */

