//coded by eL 2002 (eL@email.cz)
//simple hardcoding

{$mode delphi}
{$macro on}

unit texture;

interface

uses gl;

procedure loadTexture (s: string; var tex: gluint);
procedure draw_texture (tex: gluint);

implementation









procedure Load_PCX (path: string; var p: array of byte); {512x512 pcx}
var count, i, j, id: word;
    f: file;
    buf: array[0..511] of byte;
    q: longint;
    c: byte;

   function GetByte: byte;
   begin
      GetByte:=buf[id];
      inc(id);
      if id=512 then begin
         BlockRead(f,buf,512,count);
         id:=0;
      end;
   end;

begin
   	assign(f,path);
   	reset(f,1);
   	seek(f,128);
   	BlockRead(f,buf,512,count);
   	id:=0;
   	q:=0;
   	repeat
      	j:=GetByte;
      	if j<$c0 then begin
         	p[q]:=j;
         	inc(q);
      end else begin
         j:=j and 63;
         c:=getByte;
         for i:=0 to j-1 do begin
            p[q]:=c;
            inc(q);
         end;
      end;
   until q>512*512-1;
   close(f);
end;

procedure loadTexture (s: string; var tex: gluint);
var t: array [0..512*512-1] of glubyte;
begin
	load_pcx(s,t);
    glGenTextures(1, tex);                            // Create One Textures
    glBindTexture(GL_TEXTURE_2D, tex);
    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_NEAREST);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_NEAREST);
    glTexImage2D(GL_TEXTURE_2D, 0, GL_ALPHA, 512, 512, 0, GL_ALPHA, GL_UNSIGNED_BYTE, t);
end;


procedure draw_texture (tex: gluint);
begin
	glEnable(GL_TEXTURE_2D);
	glBindTexture(GL_TEXTURE_2D, tex);
	glBegin(GL_QUADS);
	glTexCoord2f(0,0); glVertex2f(0,0);
	glTexCoord2f(1,0); glVertex2f(1,0);
	glTexCoord2f(1,1); glVertex2f(1,1);
	glTexCoord2f(0,1); glVertex2f(0,1);
	glEnd();
	glDisable(GL_TEXTURE_2D);
end;
	
end.