// coded by eL 2002 (eL@email.cz)
// windows dialog routine

{$mode delphi}
{$macro on}
{$apptype console}

unit setup;

interface

uses windows,sysutils;


const //global vars
	width: integer = 800;
	height: integer = 600;
	run_demo: boolean = false;
	no_sound: boolean = false;
	windowed: boolean = false;
	
procedure run_setup;
	
implementation












	
const square = 300;

var 
	menu_hWnd: HWND;
	menu_hdc: HDC;
	menu_ps: paintstruct;
	menu_active: boolean;
	mr: rect;
  	menu_class : WNDCLASSEX;		// Windows Class of the Saver
  	message: msg;
	button_hwnd: hwnd;

PROCEDURE NewButton (Button_Number : Longint; Button_Title : pChar; Button_Type : DWord; x, y, mx, my : longint);
var menu_menu: hMenu;
begin
	menu_menu := Button_Number;
	button_hwnd := CreateWindowEx(	0,
		'button',
		Button_Title,
		WS_CHILD or WS_VISIBLE or Button_Type,
		x,y,
		mx,my,
		menu_hwnd,
		menu_menu,
		hInstance,
		Nil);
end;

procedure draw_buttons;
const s: array [0..5] of pchar = 
	('reflection mapping',
	 'polygon multitexture',
	 'compressed textures',
	 'smooth patch subdivision',
	 'software vertex processing',
	 'D24S8 z-buffer');
var i,cx,cy: integer;
begin
			menu_hdc := BeginPaint(menu_hwnd,@menu_ps);
			
			getClientRect(menu_hwnd, mr);
			//FillRect(menu_hdc, mr, getStockObject(WHITE_BRUSH));
	 	
	 		SetBKMode(menu_hdc, TRANSPARENT);
	 		SetTextColor(menu_hdc, RGB(0,0,0));
			selectObject(menu_hdc, GetStockObject(ANSI_VAR_FONT));
	 		//TextOut(menu_hdc, 50,10, 'resolution',10);
	 		cx:=120;
	 		cy:=10;
	 		NewButton(1,'Resolution',BS_GROUPBOX,cx,cy,150,18*4+5);
	 		NewButton(2,'640x480',BS_AUTORADIOBUTTON,cx+10,cy+18,90,20);
	 		NewButton(3,'800x600',BS_AUTORADIOBUTTON,cx+10,cy+18*2,90,20);
 			SendMessage(button_hwnd,BM_SETCHECK,BST_CHECKED,0);
	 		NewButton(4,'1024x768',BS_AUTORADIOBUTTON,cx+10,cy+18*3,90,20);
	 		
	 		NewButton(5,'no sound',BS_AUTOCHECKBOX,10,28,90,20);
	 		NewButton(6,'windowed',BS_AUTOCHECKBOX,10,46,90,20);
	 		
			NewButton(301, 'play', BS_DEFPUSHBUTTON, 10+50,245,80,25);
			NewButton(302, 'cancel', BS_PUSHBUTTON, 100+50,245,80,25);
	 		//mr.left:=square div 4; mr.top:=10; mr.right:=square-5; mr.bottom:=30;
	 		//drawText(menu_hdc,'resolution  ',-1,@mr,0);
	 		for i:=0 to 5 do begin
	 			NewButton(500+i,s[i],BS_AUTOCHECKBOX, 10,82+18+i*23, 180,23);
	 			if random(2)=1 then SendMessage(button_hwnd,BM_SETCHECK,BST_CHECKED,0);
	 		end;
	 		
			EndPaint(menu_hwnd,menu_ps);
end;

FUNCTION MenuWndProc(menu_hwnd : HWND; message : DWORD; wParam : WPARAM; lParam : LPARAM) : LRESULT; stdcall;
begin
  	case (message) of
    	WM_CREATE: begin
    		menu_active:=true;
    		result:=0;
    	end;
    	WM_CLOSE: begin
    		menu_active:=false;
        	Result := 0;
    	end;
    	WM_PAINT: begin
			menu_hdc := BeginPaint(menu_hwnd,@menu_ps);
			selectObject(menu_hdc, GetStockObject(ANSI_VAR_FONT));
			getClientRect(menu_hwnd, mr);
			EndPaint(menu_hwnd,menu_ps);
			result:=0;
       	end;
       	WM_COMMAND: begin
       		result:=0;
       		case loword(wparam) of
       			5: no_sound:=not(no_sound);
       			6: windowed:=not(windowed);
       			2: begin
       				width:=640; height:=480;
       			end;
       			3: begin
       				width:=800; height:=600;
       			end;
       			4: begin
       				width:=1024; height:=768;
       			end;       				
       			301: begin
       				run_demo:=true;
       				menu_active:=false;
       			end;
       			302: begin
       				run_demo:=false;
       				menu_active:=false;
       			end;
       		end;       		
       	end;
    	else
    		MenuWndProc := DefWindowProc(menu_hwnd, message, wParam, lParam);
    end;
end;

PROCEDURE Menu_Create;
begin
  	menu_hWnd := CreateWindowEx(WS_EX_TOPMOST,
				'forwardMenu',
				'setup',
				WS_CAPTION OR WS_POPUPWINDOW OR WS_VISIBLE,
				(GetSystemMetrics(SM_CXSCREEN) div 2)-square shr 1,
				(GetSystemMetrics(SM_CYSCREEN) div 2)-square shr 1,
				square,
				square,
				0, 0, 
				hInstance, 
				nil );
end;

PROCEDURE Menu_Register;
begin
	menu_class.cbSize		:= sizeof(menu_class);
  	menu_class.style		:= CS_OWNDC;
  	menu_class.lpfnWndProc	:= WndProc(@menuWndProc);
  	menu_class.cbClsExtra		:= 0;
  	menu_class.cbWndExtra		:= 0;
  	menu_class.hInstance		:= hInstance;
  	menu_class.hIcon		:= LoadIcon( 0, IDI_APPLICATION );
  	menu_class.hCursor		:= LoadCursor( 0, IDC_ARROW );
  	menu_class.hbrBackground	:= GetStockObject(LTGray_BRUSH);;
  	menu_class.lpszMenuName	:= nil;
  	menu_class.lpszClassName	:= 'forwardMenu';
  	menu_class.hIconSm		:= LoadIcon(0, IDI_APPLICATION);
	RegisterClassEx( menu_class );
end;
 
procedure run_setup;
begin
	menu_register;
	menu_create;
	menu_ps.hdc := menu_hdc;
	menu_ps.fErase := false;
	menu_ps.rcPaint := mr;
	draw_buttons;

	repeat
		if PeekMessage(@message,0,0,0,0) = true then begin
    		GetMessage(@message, 0, 0, 0);
    		TranslateMessage(message);
    		DispatchMessage(message);
  		end;
	until menu_active = false;
	DestroyWindow(menu_hWnd);
end;

begin
end.
