//simply code by eL (2002) http://eL.zde.cz

{define debug}
{define fps}
{define stop}

{$ifdef debug}
	{$apptype console}
{$else}
	{$apptype gui}
{$endif}
{$mode delphi}
{$macro on}

uses windows,gl,opengl32,bass,efx1,efx2,efx7,efx15,efx3,setup,texture,efx14;

{$r myres.res}

const
	music_file : pchar = 'pure_me_zverimex.it';
	finished: boolean = false;
	{$ifdef fps}
  	FPS_TIMER = 1;                     // Timer to calculate FPS
  	FPS_INTERVAL = 1000;               // Calculate FPS every 1000 ms
  	fpscount: longint = 0;
  	{$endif}
	{$ifdef stop}
	stop: boolean = false;
	{$endif}
	credits: boolean = false;
	credits_start: glfloat = -1;
	
var music: hmusic;
	music_sync: hsync;
	h_wnd: HWND;
	h_DC: HDC;
	h_RC: HGLRC;
	{$ifdef fps}
	demostart,lasttime, elapsedtime: longint; 
	{$endif fps}
	tex: array [0..2] of gluint;


procedure display_credits;
const 
	c = 300;
	s: array [0..2] of glfloat = (0,3000,6000);
	cols: array [0..2,0..2] of glfloat = 
		((132/c,18/c,18/c),
		 (18/c,32/c,132/c),
		 (12/c,94/c,22/c));
	len = 5000;
	fade = 2400;
var t: glfloat;
	i: integer;
begin
	glLoadIdentity();
	glDisable(GL_BLEND);
	glColor4f(1,1,1,0);
	glRectf(0,0,1,1);
	glEnable(GL_BLEND);
	
	t:=getTickCount-credits_start;
	if t>12000 then finished:=true;
	
	for i:=0 to 2 do begin
		if (t>=s[i]) and (t<s[i]+len) then begin
			if t<s[i]+fade then glColor4f(cols[i,0],cols[i,1],cols[i,2],(t-s[i])/fade)
			else if t>s[i]+len-fade then glColor4f(cols[i,0],cols[i,1],cols[i,2],(s[i]+len-t)/fade)
			else glColor4f(cols[i,0],cols[i,1],cols[i,2],1);
			draw_texture(tex[i]);
		end;
	end;
	swapBuffers(h_DC);
end;

procedure display;
begin
	glLoadIdentity();
	glDisable(GL_BLEND);
	glColor4f(1,1,1,0);
	glRectf(0,0,1,1);	
	glEnable(GL_BLEND);
	//glClearColor(1,1,1,0);
	//glClear(GL_COLOR_BUFFER_BIT);
	
	efx1_draw;
	efx2_draw;
	efx7_draw;
	efx15_draw;
	efx3_draw;
	efx14_draw;
	
	{$ifdef debug}
	//writeln('ord: ',bass_channelgetPosition(music) and 65535);
	{$endif}
	
	//glutSwapBuffers();
	swapBuffers(h_DC);
end;

procedure reshape (w,h: longint);
begin
	width:=w;
	height:=h;
	glViewPort(0,0,w,h);
	glLoadIdentity();
	glClearColor(0,0,0,0);
	glClear(GL_COLOR_BUFFER_BIT);
	
	glViewPort((w-h) div 2,0,h,h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glOrtho(0,1,0,1,-1,1);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
end;

procedure error (s: pchar);
begin
	{$ifdef debug}
    writeln(s);
    {$else}
    MessageBox(0,s,'',MB_OK or MB_ICONERROR);
    {$endif}
	halt(1);
end;


procedure sync_instrument (handle: HSYNC; channel, data, user: dword); stdcall;
var note,vol: word;
begin
	note:=data and 65535;
	vol:=data shr 16;
	if user=8 then efx2_init_new(note,vol);	//shaking circle
	if user=7 then efx1_init_new(note,vol);	//variation on square, A-4(54?)(yellow flash)
	if user=9 then efx7_init_new(note,vol); //moving arrow
	if user=15 then efx15_init_new(note,vol);	//sine waves
	
	if user=14 then efx14_init_new(note,vol);
	//if user=3 then efx3_init_new(note,vol);	//yellow flash
end;

{$include glwin.inc}

var i: integer;
	msg: MSG;

begin
	randomize;
	run_setup;
	if not run_demo then halt(0);
	
	if not initGL then error('opengl is not supported on this system.');
	if not glCreateWnd(width,height,not(windowed),24) then error('couldn''t create gl window');
	
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_LINE_SMOOTH);
	glEnable(GL_POINT_SMOOTH);
	glEnable(GL_POLYGON_SMOOTH);
	glHint(GL_POLYGON_SMOOTH_HINT, GL_DONT_CARE);
	glDisable(GL_DEPTH_TEST);
	
	loadTexture('el.pcx',tex[0]);
	loadTexture('kakan.pcx',tex[1]);
	loadTexture('prook.pcx',tex[2]);

	if no_sound then begin
		if not(BASS_init(-2,44100,0,0)) then error('no sound card?');
	end
	else if not(BASS_init(0,44100,0,0)) then error('no sound card?');
	
	if not BASS_Start then error('error sound');
	
	music:=BASS_MusicLoad(false,music_file,0,0,0);
	if music=0 then error('no sound module');
	
	for i:=1 to 16 do begin
		music_sync:=BASS_ChannelSetSync(music,BASS_SYNC_MUSICINST,i+(-1 shl 16),sync_instrument,i);
		if music_sync=0 then error('sync handler error');
	end;
	BASS_MusicPlay(music);
	{$ifdef debug}
	//BASS_ChannelSetPosition(music,makelong(60,0));
	{$endif}
	//BASS_ChannelSetPosition(music,makelong(49,0));
	{$ifdef fps}demostart:=gettickCount;{$endif}
  	//glutMainLoop();
  	while not finished do begin
    	if (PeekMessage(msg, 0, 0, 0, PM_REMOVE)) then begin
      		if (msg.message = WM_QUIT) then finished:=true
      		else begin
      			translateMessage(msg);
      			dispatchMessage(msg);
      		end;
    	end
    	else begin
    		{$ifdef fps}
    		inc(fpscount);
      		LastTime :=ElapsedTime;
      		ElapsedTime :=GetTickCount() - DemoStart;     // Calculate Elapsed Time
      		ElapsedTime :=(LastTime + ElapsedTime) DIV 2; // Average it out for smoother movement
      		{$endif}
      		
     		{$ifdef stop} if not(stop) then {$endif} 
     			if credits then display_credits()
     			else display();
     		if (BASS_ChannelIsActive(music)=0) and (not credits) then begin
     			credits:=true;
     			credits_start:=getTickCount+2000;
     		end;
    	end;
  	end;
   	BASS_Stop;
   	BASS_Free;
  	glKillWnd(not(windowed));
end.