{$mode delphi}
unit efx3;

interface

uses windows,gl;

function efx3_init_new (note, volume: word): boolean;
procedure efx3_draw;

implementation

const 
	max = 3;
	tt = 150;

var 
	p: array [0..max-1] of record
		playing: boolean;
		startTime: dword;
		r,g,b: single;
	end;
	
function efx3_init_new (note, volume: word): boolean;
var i,j: integer;
	v: single;
begin
	j:=-1;
	for i:=0 to max-1 do if not p[i].playing then j:=i;
	if j=-1 then begin
		result:=false;
		exit;
	end;
	with p[j] do begin
		playing:=true;
		startTime:=getTickCount;
		r:=random; g:=random; b:=random;
	end;
end;
	
procedure efx3_draw;
var t: longint;
	i,j: integer;
	xx: single;
	//old1,old2: array [0..1] of single;
begin
	for i:=0 to max-1 do with p[i] do if playing then begin
		t:=getTickCount-startTime;
		if t>tt then playing:=false;
		glColor4f(0,0,0,0.2-(t/tt)*0.23);
		glRectf(0,0,1,1);
	end;
end;

var i: integer;

begin
	for i:=0 to max-1 do p[i].playing:=false;
end.