//===================================================================================
//FILE : AttenPass.vsh
//DESC : per-pixel lighting attenuation setup
//PROJ : Inercia 2k2 demo
//CODER: Tiago Sousa
//==================================================================================

// Registers

//  c4-7   		 = WorldViewProj matrix
//  c8-11   		 = WorldTransposed matrix
//  c12  		 = LightPosition 
//  c13  		 = 1.0f/LightSize

//  c16                  = LightPosition in object space
//  c17                  = CamPosition in object space

//  v0	 		 = vertex position
//  v7 	 	         = texture coordinates (2d)
//  v8 	 		 = normal vector
//  v9 	 		 = tangent vector

vs.1.1     

def c18, 0.5, 0.5, 0.5, 0.0

// projected vertex position
m4x4 oPos, v0, c4

// compute color attenuation
add r1.xyz, v0.xyz, -c12.xyz        
mul r1.xyz, r1.xyz, c13.xyz

// clamp values to [0..1]
mad oT0.xy, c18.xy, c18.xy, r1.xy
mad oT1.x, c18.x, c18.x, r1.z

/////////////////////////////////////////////////////////////////////////////