#include <SDL/SDL.h>
#include <unistd.h> 
#include <sys/mman.h> 
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <math.h>


#define XRES 640
#define YRES 480

#define RGB(r,g,b) ((r<<16)|(g<<8)|b)

void init_sdl();
void end_sdl();

void rect(int xi, int yi, int tx, int ty, long int color);

SDL_Surface *screen;
long int *logo;
long int *song;
long int *notas[7];
long int *plasma;

char melody[128][4];
int Time=0;

void putSprite(long int *p, int x, int y, int tx, int ty){
  int i,j;
  unsigned int *buff=(unsigned int*)screen->pixels;
  
  for(i=0;i<ty;i++)
    for(j=0;j<tx;j++)
      buff[(y+i)*XRES+x+j]=p[i*tx+j]+RGB(rand()&127,0,0);

}

void tracker(){
  unsigned int i;
  unsigned int *buff=(unsigned int*)screen->pixels;
  rect(0,0,XRES,YRES, RGB(0,0,100));
  
  rect(2,2,XRES-4, YRES/2, RGB(0,60,150));

  putSprite(logo, 3,3, 256,64);
  putSprite(song, 3,70, 256,128);

  for (i=0;i<5;i++){
    putSprite(notas[melody[(Time+i)&127][0]%7], 10, YRES/2+10+i*40, 64,32);
    putSprite(notas[melody[(Time+i)&127][1]%7], 10+100, YRES/2+10+i*40, 64,32);
    putSprite(notas[melody[(Time+i)&127][2]%7], 10+200, YRES/2+10+i*40, 64,32);
    putSprite(notas[melody[(Time+i)&127][3]%7], 10+300, YRES/2+10+i*40, 64,32);
  }
  rect(380, 250, 240,200, RGB(10,50,50));
  for (i=380;i<380+240;i++){
    int y=350+ sin((Time+i)/fmod(Time,15.0))*cos((Time-i)/100.0)*100;
    buff[y*XRES+i]=RGB(250,250,250);
  }

  Time++;
  putPlasma();
}

void putPlasma(void){
  int i,j;
  unsigned int *buff=(unsigned int*)screen->pixels;
  for (i=0;i<310;i++)
    for (j=0;j<220;j++){
      int Y1=(j+100+sin(Time/10.0)*100);
      int Y2=(j+100+cos(Time/10.0)*100);
      int X3=(j+100+cos((Time+100)/10.0)*100);
      buff[(10+j)*XRES + i+290]=plasma[Y1*XRES+i]+plasma[Y2*XRES+i]+plasma[Y2*XRES+i+X3];
    }

}

void iniPlasma(void){
  int i,j;
  plasma=malloc(640*480*4);
  for(i=0;i<XRES;i++)
    for(j=0;j<YRES;j++){
      int r=((int)128*((cos(sqrt((j-320)*(j-320)+(i-240)*(i-240))/10.0))+1));
      plasma[j*XRES + i]=RGB(r,0,0);
    }
}

long int *loadImg(char *name, long int size){
  int fd;
  long int *ret;

  fd=open(name,O_RDONLY);
  ret=malloc(size*4);
  read(fd, ret,size*4);
  close(fd);

  return ret;
}

void init_melody(){
  int i,j;
  for (i=0;i<128;i++){
    melody[i][0]=((i&4)==0);
    melody[i][1]=(i&3);
    melody[i][2]=(i&6);
    melody[i][3]=(i&123);
  }
}

int main(int argc, char **argv){
  int done=0;
  SDL_Event event;

  init_sdl();
  iniPlasma();
  logo=loadImg("logo.rgba", 256*64);
  song=loadImg("song.rgba", 256*128);
  notas[0]=loadImg("0.rgba", 64*32);
  notas[1]=loadImg("1.rgba", 64*32);
  notas[2]=loadImg("2.rgba", 64*32);
  notas[3]=loadImg("3.rgba", 64*32);
  notas[4]=loadImg("4.rgba", 64*32);
  notas[5]=loadImg("5.rgba", 64*32);
  notas[6]=loadImg("6.rgba", 64*32);
  
  init_melody();

  while(!done){
  if ( SDL_MUSTLOCK(screen) ) {
        if ( SDL_LockSurface(screen) < 0 ) {
            fprintf(stderr, "Can't lock screen: %s\n", SDL_GetError());
            return;
        }
    }


  tracker();
  //  usleep(500);


  //  putpixel(screen, 100,100, 0x0FFFFFFFF);
    if ( SDL_MUSTLOCK(screen) ) {
        SDL_UnlockSurface(screen);
    }
    SDL_UpdateRect(screen, 0, 0, XRES, YRES);
    while ( SDL_PollEvent(&event) ) {
      if ( event.type == SDL_QUIT ||
	   event.type == SDL_KEYDOWN ) {
        done = 1;
      }
    }
  }
  end_sdl();
}

void rect(int xi, int yi, int tx, int ty, long int color){
  int x,y;
  unsigned int *buff=(unsigned int*)screen->pixels;
  int mod;

  for (x=xi;x<xi+tx;x++){
    mod=RGB(rand()&127,0,0);
    for (y=yi;y<yi+ty;y++)
      buff[y*XRES + x]=color+mod;//+RGB(rand()&127,0,0);;
  }
}


void init_sdl(){
  /* Initialize the SDL library */
  if( SDL_Init(SDL_INIT_VIDEO) < 0 ) {
    fprintf(stderr,
	    "Couldn't initialize SDL: %s\n", SDL_GetError());
    exit(1);
  }
  
  /* Clean up on exit */
  atexit(SDL_Quit);  
  screen = SDL_SetVideoMode(XRES, YRES , 32, SDL_SWSURFACE);
  if ( screen == NULL ) {
    fprintf(stderr, "Couldn't set 640x480x8 video mode: %s\n",
	    SDL_GetError());
    exit(1);
  }
}

void end_sdl(){
  SDL_Quit();
}


