/*
    dd7.cpp

    base para los fast_code.

    soporta modos de cualquier bpp. soporta tambin modos de paleta
    (emulado sobre 32bpp).


    iq + una-i
*/

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>          // sprintf()
#include <string.h>         // memset()

#include "ddraw.h"


#define DD_ON   1
#define DD_OFF  0


// fps
static BOOL                 DDFPS = FALSE;
static DWORD                startTickCount;
static int                  frame=0;
static float                nFramesPerSec;


static LPDIRECTDRAWSURFACE7 lpDDSBack;
static LPDIRECTDRAWSURFACE7 lpDDSPrimary;
static LPDIRECTDRAW7        lpDD;

//----------------------------------------------------------------------------



void DDRAW_SetFPS( long status )
{
    DDFPS = status;
}


void DDRAW_TogleFPS( void )
{
    if( !DDFPS )
        DDFPS=1;
    else
        DDFPS=0;
}


int DDRAW_Init( int xres, int yres, int bpp, HWND hwnd )
{
    DDSURFACEDESC2   ddsd;
    DDSCAPS2         ddscaps;
    HRESULT          ddrval;


    ddrval = DirectDrawCreateEx(NULL, (VOID**)&lpDD, IID_IDirectDraw7, NULL);;
    if( ddrval != DD_OK )
        {
        MessageBox( hwnd, "Could not create Direct Draw Instance\n", "Error", MB_OK );
        return( 0 );
        }

    ddrval = lpDD->SetCooperativeLevel( hwnd, DDSCL_ALLOWMODEX|DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN);
    if( ddrval != DD_OK )
        {
        MessageBox( hwnd, "Could not take control of the screen\n", "Error", MB_OK );
        return( 0 );
        }

    ddrval = lpDD->SetDisplayMode( xres,yres, bpp, NULL, NULL);
    if(ddrval != DD_OK)
        {
        MessageBox( hwnd, "Video mode not found\n", "Error", MB_OK );
        return( 0 );
        }



    // Create the primary surface with 1 back buffer

    ZeroMemory(&ddsd, sizeof(ddsd));
    ddsd.dwSize = sizeof(ddsd);
    ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
    ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE | DDSCAPS_FLIP |
                          DDSCAPS_COMPLEX;
    ddsd.dwBackBufferCount = 1;
    ddrval = lpDD->CreateSurface(&ddsd, &lpDDSPrimary, NULL);
    if( ddrval != DD_OK )
        {
        MessageBox( hwnd, "Could not create the primary surface\n", "Error", MB_OK );
        return( 0 );
        }


    // Get a pointer to the back buffer
    ZeroMemory(&ddscaps, sizeof(ddscaps));
    ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
    ddrval = lpDDSPrimary->GetAttachedSurface( &ddscaps, &lpDDSBack );
    if( ddrval != DD_OK )
        {
        MessageBox( hwnd, "Could not get the back surface\n", "Error", MB_OK );
        return( 0 );
        }


    startTickCount = GetTickCount();
    frame = 0;


    return( 1 );
}


void DDRAW_Flip( void )
{
    HRESULT     ddrval;
    HDC         hdc;
    char        buffer[32];



    // -------------------

	frame++;

    if( (DDFPS == DD_ON) )
        {
        if( GetTickCount()>startTickCount+1000 )
            {
            nFramesPerSec = 1000.0f*(float)frame/(float)(GetTickCount()-startTickCount);
    
            frame = 0;
            startTickCount =  GetTickCount();
            }

        if( lpDDSBack->GetDC(&hdc) == DD_OK ) 
            { 
            SetBkMode( hdc, TRANSPARENT );
            SetTextColor( hdc, 0xffffffff );
            sprintf( buffer, "%3.1f fps", nFramesPerSec );
            TextOut( hdc, 0, 0, buffer, strlen(buffer) );
            lpDDSBack->ReleaseDC(hdc); 
            }
        }

    // -------------------


    while( 1 )
        {
        ddrval = lpDDSPrimary->Flip( NULL, 0 );

        if( ddrval == DD_OK ) break;
        if( ddrval != DDERR_WASSTILLDRAWING ) break;
        }
}


long DDRAW_GetPitch( void )
{
    HRESULT             ddrval;
    DDSURFACEDESC2      DDSDesc;
    long                pitch;

    DDSDesc.dwSize=sizeof( DDSDesc );
    ddrval=lpDDSBack->Lock( NULL, &DDSDesc, 0, NULL );

    if( ddrval!=DD_OK )
        {
        pitch = 0;
        }
    else
        {
        pitch = DDSDesc.lPitch;
        lpDDSBack->Unlock( NULL );
        }


    return( pitch );
}

long *DDRAW_GetPtr( void )
{
    HRESULT             ddrval;
    DDSURFACEDESC2      DDSDesc;


    DDSDesc.dwSize=sizeof( DDSDesc );
    ddrval=lpDDSBack->Lock( NULL, &DDSDesc, 0, NULL );

    if( ddrval!=DD_OK )
        {
        return( 0L );
        }


    return( (long *)DDSDesc.lpSurface );

}

void DDRAW_EndFrame( void )
{
    lpDDSBack->Unlock(NULL);
}
