/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;

class Sample {
    private byte[] name;
    private int sample_length;
    private int fine_tune;
    private int volume;
    private int loop_start;
    private int loop_length;
    public byte[] sample_data = null;
    private boolean looped;

    public void LoadSampleHeader(DataInputStream dataInputStream) {
        try {
            if (this.name == null) {
                this.name = new byte[22];
            }
            dataInputStream.read(this.name, 0, this.name.length);
            this.sample_length = dataInputStream.readUnsignedShort() << 1;
            int n = dataInputStream.readUnsignedByte();
            this.fine_tune = n > 7 ? n - 16 : n;
            this.volume = dataInputStream.readUnsignedByte();
            this.loop_start = dataInputStream.readUnsignedShort() << 1;
            this.loop_length = dataInputStream.readUnsignedShort() << 1;
            this.looped = this.loop_start != 0 || this.loop_length != 2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void LoadSampleData(DataInputStream dataInputStream) {
        try {
            this.sample_data = new byte[this.sample_length];
            int n = 0;
            while (n < this.sample_length) {
                this.sample_data[n] = dataInputStream.readByte();
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String GetName() {
        return new String(this.name);
    }

    public int GetLength() {
        return this.sample_length;
    }

    public int GetFineTune() {
        return this.fine_tune;
    }

    public int GetVolume() {
        return this.volume;
    }

    public int GetLoopStart() {
        return this.loop_start;
    }

    public int GetLoopLength() {
        return this.loop_length;
    }

    public int GetLoopEnd() {
        return this.loop_start + this.loop_length;
    }

    public boolean IsLooped() {
        return this.looped;
    }

    public byte[] GetSampleData() {
        return this.sample_data;
    }
}

