/*
 * Decompiled with CFR 0.152.
 */
class Note {
    static int[] frequency_table = new int[]{907, 900, 894, 887, 881, 875, 868, 862, 856, 850, 844, 838, 832, 826, 820, 814, 808, 802, 796, 791, 785, 779, 774, 768, 762, 757, 752, 746, 741, 736, 730, 725, 720, 715, 709, 704, 699, 694, 689, 684, 678, 674, 670, 665, 660, 655, 651, 646, 640, 637, 632, 628, 623, 619, 614, 610, 604, 601, 597, 592, 588, 584, 580, 575, 570, 567, 563, 559, 555, 551, 547, 543, 538, 535, 532, 528, 524, 520, 516, 513, 508, 505, 502, 498, 495, 491, 487, 484, 480, 477, 474, 470, 467, 463, 460, 457, 453, 450, 447, 444, 441, 437, 434, 431, 428, 425, 422, 419, 416, 413, 410, 407, 404, 401, 398, 395, 392, 390, 387, 384, 381, 379, 376, 373, 370, 368, 365, 363, 360, 357, 355, 352, 350, 347, 345, 342, 339, 337, 335, 332, 330, 328, 325, 323, 320, 318, 316, 314, 312, 309, 307, 305, 302, 300, 298, 296, 294, 292, 290, 288, 285, 284, 282, 280, 278, 276, 274, 272, 269, 268, 266, 264, 262, 260, 258, 256, 254, 253, 251, 249, 247, 245, 244, 242, 240, 239, 237, 235, 233, 232, 230, 228, 226, 225, 224, 222, 220, 219, 217, 216, 214, 213, 211, 209, 208, 206, 205, 204, 202, 201, 199, 198, 196, 195, 193, 192, 190, 189, 188, 187, 185, 184, 183, 181, 180, 179, 177, 176, 175, 174, 172, 171, 170, 169, 167, 166, 165, 164, 163, 161, 160, 159, 158, 157, 156, 155, 154, 152, 151, 150, 149, 148, 147, 146, 145, 144, 143, 142, 141, 140, 139, 138, 137, 136, 135, 134, 133, 132, 131, 130, 129, 128, 127, 126, 125, 125, 124, 123, 122, 121, 120, 119, 118, 118, 117, 116, 115, 114, 113, 113, 112, 111, 110, 109, 109, 108};
    public int sample_number = 0;
    public int period_frequency = 0;
    public int note_number = -1;
    public int effect_number = 0;
    public int effect_param = 0;

    public void assign_note_number(int n) {
        int n2 = 1;
        while (n2 <= 36) {
            if (n >= frequency_table[n2 << 3] - 1 && n <= frequency_table[n2 << 3] + 1) {
                this.note_number = n2 << 3;
            }
            ++n2;
        }
    }

    public int get_frequency() {
        return frequency_table[this.note_number];
    }

    public int get_frequency(int n) {
        return frequency_table[this.note_number + n];
    }

    public int get_frequency(int n, int n2) {
        int n3 = this.note_number + (n << 3) + n2;
        if (n3 < frequency_table.length) {
            return frequency_table[this.note_number + (n << 3) + n2];
        }
        return frequency_table[frequency_table.length - 1];
    }

    public String GetNoteSymbol() {
        String string;
        int n = (this.note_number >> 38) - 1;
        int n2 = n / 12 + 1;
        int n3 = n % 12;
        switch (n3) {
            case 0: {
                string = new String("C-");
                break;
            }
            case 1: {
                string = new String("C#");
                break;
            }
            case 2: {
                string = new String("D-");
                break;
            }
            case 3: {
                string = new String("D#");
                break;
            }
            case 4: {
                string = new String("E-");
                break;
            }
            case 5: {
                string = new String("F-");
                break;
            }
            case 6: {
                string = new String("F#");
                break;
            }
            case 7: {
                string = new String("G-");
                break;
            }
            case 8: {
                string = new String("G#");
                break;
            }
            case 9: {
                string = new String("A-");
                break;
            }
            case 10: {
                string = new String("A#");
                break;
            }
            case 11: {
                string = new String("B-");
                break;
            }
            default: {
                String string2 = new String("---");
                return string2;
            }
        }
        string = string + Integer.toString(n2);
        return string;
    }

    public String GetEffectSymbol() {
        String string = this.effect_number == 0 && this.effect_param == 0 ? new String("---") : (this.effect_param < 16 ? new String(Integer.toString(this.effect_number, 16).toUpperCase() + "0" + Integer.toString(this.effect_param, 16)) : new String(Integer.toString(this.effect_number, 16).toUpperCase() + Integer.toString(this.effect_param, 16)));
        return string;
    }
}

