/*
* ============================================================================
*  Name     : CYksinContainer from YksinContainer.h
*  Part of  : yksin
*  Created  : 03.08.2002 by 
*  Implementation notes:
*     Initial content was generated by Series 60 AppWizard.
*  Version  :
*  Copyright: 
* ============================================================================
*/

// INCLUDE FILES
#include "YksinContainer.h"
#include <eikenv.h>	 


#include <e32base.h>
#include <eiklabel.h>  // for example label control
#include <coemain.h>
#include <e32math.h>
// ================= MEMBER FUNCTIONS =======================

// ---------------------------------------------------------
// CYksinContainer::ConstructL(const TRect& aRect)
// EPOC two phased constructor
// ---------------------------------------------------------
//
void CYksinContainer::ConstructL(const TRect& aRect)
    {
    CreateWindowL();

//    iLabel = new (ELeave) CEikLabel;
//    iLabel->SetContainerWindowL( *this );
//    iLabel->SetTextL( _L("Example View") );

//    iToDoLabel = new (ELeave) CEikLabel;
//    iToDoLabel->SetContainerWindowL( *this );
//    iToDoLabel->SetTextL( _L("Add Your controls here") );

	iPeriodic = CPeriodic::NewL(0);

    SetRect(aRect);
    ActivateL();
	iPeriodic->Start(4000000,4000000,TCallBack(StaticPeriodicCallback, this));
    iState=EInit;
	iTick = 0;
}

void CYksinContainer::PeriodicTick()
{
	switch (iState)
	{
	case EInit:
		iState=EStart;
		DrawNow();
		break;
	
	case EStart:
		iState=EStory;
		DrawNow();
		break;

	case EStory:
		iState = EGameProgress;
		DrawNow();
		break;
	case EGameProgress:
		iState = EPolkuEntered;
		DrawNow();
		break;
	case EPolkuEntered:
		iState = ECorrectAnswer;
		DrawNow();
		break;
	case ECorrectAnswer:
		iState = ELevel2;
		DrawNow();
		break;
	case ELevel2:
		iState = ELevel2Answer;
		DrawNow();
		break;
	case ELevel2Answer:
		iState = EL2CorrectAnswer;
		DrawNow();
		break;
	case EL2CorrectAnswer:
		iState = EDemoVersion;
		DrawNow();
		break;
	case EDemoVersion:
		iState = EFinal1;
		DrawNow();
		//		iState=EScrollerInit;
		break;
	case EFinal1:
		iState = EGreets;
		DrawNow();
		break;
						
	}
}

TInt CYksinContainer::StaticPeriodicCallback(TAny* aObject)
{
	((CYksinContainer*)aObject)->PeriodicTick();
	return 1;
}

// Destructor
CYksinContainer::~CYksinContainer()
    {
	if(iPeriodic->IsActive())
		iPeriodic->Cancel();
	delete iPeriodic;
    //delete iLabel;
    //delete iToDoLabel;
    }

// ---------------------------------------------------------
// CYksinContainer::SizeChanged()
// Called by framework when the view size is changed
// ---------------------------------------------------------
//
void CYksinContainer::SizeChanged()
    {
    // TODO: Add here control resize code etc.
    //->SetExtent( TPoint(10,10), iLabel->MinimumSize() );
    //iToDoLabel->SetExtent( TPoint(10,100), iToDoLabel->MinimumSize() );
    }

// ---------------------------------------------------------
// CYksinContainer::CountComponentControls() const
// ---------------------------------------------------------
//
TInt CYksinContainer::CountComponentControls() const
    {
    return 0; // return nbr of controls inside this container
    }

// ---------------------------------------------------------
// CYksinContainer::ComponentControl(TInt aIndex) const
// ---------------------------------------------------------
//
CCoeControl* CYksinContainer::ComponentControl(TInt aIndex) const
    {
    switch ( aIndex )
        {
        case 0:
            //return iLabel;
        case 1:
            //return iToDoLabel;
        default:
            return NULL;
        }
    }

// ---------------------------------------------------------
// CYksinContainer::Draw(const TRect& aRect) const
// ---------------------------------------------------------
//
void CYksinContainer::Draw(const TRect& aRect) const
    {

	// tss tervetuloilmo
    CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
    gc.SetPenStyle(CGraphicsContext::ENullPen);
    gc.SetBrushColor(KRgbWhite);
    gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
    gc.DrawRect(aRect);

	switch (iState)
	{
		case EStart:
		{
			CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
			gc.UseFont(CEikonEnv::Static()->AnnotationFont());

			gc.SetPenColor(KRgbBlack);

			gc.SetBrushColor(KRgbWhite);
			gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
			gc.DrawText(_L("Forum Nokia 24h"),TPoint(10,40));
			gc.DrawText(_L("compo AT ASSEMBLY '02'"),TPoint(10,60));
			break;
		}
		case EStory:
		{	
			CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
			gc.UseFont(CEikonEnv::Static()->AnnotationFont());

			gc.SetPenColor(KRgbBlack);

			gc.SetBrushColor(KRgbWhite);
			gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
			gc.DrawText(_L("5v. Simo on eksynyt"),TPoint(10,40));
			gc.DrawText(_L("pelottavaan metsn"),TPoint(10,60));
			gc.DrawText(_L("Tehtvsi on auttaa"),TPoint(10,80));
			gc.DrawText(_L("Simo pois metsst."),TPoint(10,100));
			break;
		}
		case EGameProgress:
		{
				CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
			gc.UseFont(CEikonEnv::Static()->AnnotationFont());

			gc.SetPenColor(KRgbBlack);

			gc.SetBrushColor(KRgbWhite);
			gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
			gc.DrawText(_L("TASO 1"),TPoint(10,20));
			gc.DrawText(_L("Simo nkee edessn"),TPoint(10,40));
			gc.DrawText(_L("viisi polkua. Mille"),TPoint(10,60));
			gc.DrawText(_L("polulle simo menee (1-5)?"),TPoint(10,80));
			gc.DrawText(_L("___"),TPoint(20,120));
			break;
		}
		case EPolkuEntered:
		{
				CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
			gc.UseFont(CEikonEnv::Static()->AnnotationFont());

			gc.SetPenColor(KRgbBlack);

			gc.SetBrushColor(KRgbWhite);
			gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
			gc.DrawText(_L("TASO 1"),TPoint(10,20));
			gc.DrawText(_L("Simo nkee edessn"),TPoint(10,40));
			gc.DrawText(_L("viisi polkua. Mille"),TPoint(10,60));
			gc.DrawText(_L("polulle simo menee (1-5)?"),TPoint(10,80));
			gc.DrawText(_L("3"),TPoint(20,120));
			break;
		}
		case ECorrectAnswer:
		{
			CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
			gc.UseFont(CEikonEnv::Static()->AnnotationFont());

			gc.SetPenColor(KRgbBlack);

			gc.SetBrushColor(KRgbWhite);
			gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
			
			gc.DrawText(_L("Onnittelut!"),TPoint(10,20));
			gc.DrawText(_L("Vastasit oikein"),TPoint(10,60));
			gc.DrawText(_L("Simoa pelottaa"),TPoint(10,80));
			gc.DrawText(_L("vhemmn!"),TPoint(10,100));
			break;
		}
		case ELevel2:
		{
			CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
			gc.UseFont(CEikonEnv::Static()->AnnotationFont());

			gc.SetPenColor(KRgbBlack);

			gc.SetBrushColor(KRgbWhite);
			gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
			gc.DrawText(_L("TASO 2"),TPoint(10,20));
			gc.DrawText(_L("Simo nkee edessn"),TPoint(10,40));
			gc.DrawText(_L("kymmenen polkua. Mille"),TPoint(10,60));
			gc.DrawText(_L("polulle simo menee (1-10)?"),TPoint(10,80));
			gc.DrawText(_L("___"),TPoint(20,120));
			break;
		}
		case ELevel2Answer:
		{
			CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
			gc.UseFont(CEikonEnv::Static()->AnnotationFont());

			gc.SetPenColor(KRgbBlack);

			gc.SetBrushColor(KRgbWhite);
			gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
			gc.DrawText(_L("TASO 2"),TPoint(10,20));
			gc.DrawText(_L("Simo nkee edessn"),TPoint(10,40));
			gc.DrawText(_L("viisi polkua. Mille"),TPoint(10,60));
			gc.DrawText(_L("polulle simo menee (1-10)?"),TPoint(10,80));
			gc.DrawText(_L("8"),TPoint(20,120));
			break;
		}
		case EL2CorrectAnswer:
		{
			CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
			gc.UseFont(CEikonEnv::Static()->AnnotationFont());

			gc.SetPenColor(KRgbBlack);

			gc.SetBrushColor(KRgbWhite);
			gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
			
			gc.DrawText(_L("Onnittelut!"),TPoint(10,20));
			gc.DrawText(_L("Vastasit oikein"),TPoint(10,60));
			gc.DrawText(_L("Simoa pelottaa"),TPoint(10,80));
			gc.DrawText(_L("entistkin vhemmn!"),TPoint(10,100));
			break;
		}
		case EDemoVersion:
		{
			CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
			gc.UseFont(CEikonEnv::Static()->AnnotationFont());

			gc.SetPenColor(KRgbBlack);

			gc.SetBrushColor(KRgbWhite);
			gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
			
			gc.DrawText(_L("Tm oli demoversio"),TPoint(10,20));
			gc.DrawText(_L("yksin metsss pelist"),TPoint(10,40));
			gc.DrawText(_L("Voit ladata seuraavan"),TPoint(10,60));
			gc.DrawText(_L("tason osoitteesta:"),TPoint(10,80));
			gc.DrawText(_L("wap.clubnokia.com/simo.sis"),TPoint(10,100));
			gc.DrawText(_L("Hinta 3euroa / taso"),TPoint(10,120));

			

			break;
		}

			case EFinal1:
		{
			CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
			gc.UseFont(CEikonEnv::Static()->AnnotationFont());

			gc.SetPenColor(KRgbBlack);

			gc.SetBrushColor(KRgbWhite);
			gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
			
			gc.DrawText(_L("Ethn jt Simoa"),TPoint(10,20));
			gc.DrawText(_L("pulaan?"),TPoint(10,40));

			break;
		}

		case EGreets:
		{
			CWindowGc& gc = SystemGc();
    // TODO: Add your drawing code here
    // example code...
			gc.UseFont(CEikonEnv::Static()->AnnotationFont());

			gc.SetPenColor(KRgbBlack);

			gc.SetBrushColor(KRgbWhite);
			gc.SetBrushStyle(CGraphicsContext::ESolidBrush);
			
			gc.DrawText(_L("Greets:"),TPoint(10,20));
			gc.DrawText(_L("Jaska,Miikka,Mikko"),TPoint(10,40));
			
			gc.DrawText(_L("Hane,Ervasti"),TPoint(10,60));

			gc.DrawText(_L("LOPPU!"),TPoint(10,100));
			break;
		}

    }
}
// ---------------------------------------------------------
// CYksinContainer::HandleControlEventL(
//     CCoeControl* aControl,TCoeEvent aEventType)
// ---------------------------------------------------------
//
void CYksinContainer::HandleControlEventL(
    CCoeControl* /*aControl*/,TCoeEvent /*aEventType*/)
    {
    // TODO: Add your control event handler code here
    }

// End of File  
