/* assembly2002demo25.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Technology is a possibility etc */
#include "assembly2002demo.h"

static void params_25_horizontalblur(void *d, long time) {
  horizontalblur_data *data=(horizontalblur_data *)d;
  int major, minor;
  time-=PART_25_START;
  if(time<0)
    time=0;

  major=time/SONGPOSTOTIME(1, 16);
  if(time%SONGPOSTOTIME(1, 2)<SONGPOSTOTIME(1, 1))
    minor=0;
  else
    minor=1;
  data->source=pictures[FUEL1+major+minor];

  data->amount=pow((20-(double)time/400), 2)*fabs(sin((double)time*M_PI*8/SONGPOSTOTIME(3, 0)));
}

static void params_25_add(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_25_START;
  if(time<0)
    time=0;

  while(time>=SONGPOSTOTIME(2, 0))
    time-=SONGPOSTOTIME(2, 0);

  if(time>511)
    data->color=0;
  else 
    data->color=((255-time/2)<<24|0xffffff);
}

static void params_25_copy_fuel(void *d, long time) {
  copy_data *data=(copy_data *)d;
  int x;

  time-=PART_25_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 20))
    x=0;
  else if(time<SONGPOSTOTIME(1, 36))
    x=66-66*cos((time-SONGPOSTOTIME(1, 20))*M_PI/SONGPOSTOTIME(1, 16));
  else if(time<SONGPOSTOTIME(1, 52))
    x=133;
  else if(time<SONGPOSTOTIME(2, 4))
    x=200-66*cos((time-SONGPOSTOTIME(1, 52))*M_PI/SONGPOSTOTIME(1, 16));
  else if(time<SONGPOSTOTIME(2, 20))
    x=267;
  else if(time<SONGPOSTOTIME(2, 36))
    x=200+66*cos((time-SONGPOSTOTIME(2, 20))*M_PI/SONGPOSTOTIME(1, 16));
  else if(time<SONGPOSTOTIME(2, 52))
    x=133;
  else
    x=66+66*cos((time-SONGPOSTOTIME(2, 52))*M_PI/SONGPOSTOTIME(1, 16));

  data->sourcex=x;
  data->destx=x;
}

static void params_25_stripes(void *d, long time) {
  verticalstripes_data *data=(verticalstripes_data *)d;
  int i, x;

  time-=PART_25_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 20))
    x=0;
  else if(time<SONGPOSTOTIME(1, 36))
    x=66-66*cos((time-SONGPOSTOTIME(1, 20))*M_PI/SONGPOSTOTIME(1, 16));
  else if(time<SONGPOSTOTIME(1, 52))
    x=133;
  else if(time<SONGPOSTOTIME(2, 4))
    x=200-66*cos((time-SONGPOSTOTIME(1, 52))*M_PI/SONGPOSTOTIME(1, 16));
  else if(time<SONGPOSTOTIME(2, 20))
    x=267;
  else if(time<SONGPOSTOTIME(2, 36))
    x=200+66*cos((time-SONGPOSTOTIME(2, 20))*M_PI/SONGPOSTOTIME(1, 16));
  else if(time<SONGPOSTOTIME(2, 52))
    x=133;
  else
    x=66+66*cos((time-SONGPOSTOTIME(2, 52))*M_PI/SONGPOSTOTIME(1, 16));
  
  for(i=0; i<x; i++)
    data->alphas[i]=160;
  for(i=x; i<x+133; i++)
    data->alphas[i]=0;
  for(i=x+133; i<data->width; i++)
    data->alphas[i]=160;
}

static void params_25_addleft(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_25_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 20))
    data->x=0;
  else if(time<SONGPOSTOTIME(1, 36))
    data->x=66-66*cos((time-SONGPOSTOTIME(1, 20))*M_PI/SONGPOSTOTIME(1, 16));
  else if(time<SONGPOSTOTIME(1, 52))
    data->x=133;
  else if(time<SONGPOSTOTIME(2, 4))
    data->x=200-66*cos((time-SONGPOSTOTIME(1, 52))*M_PI/SONGPOSTOTIME(1, 16));
  else if(time<SONGPOSTOTIME(2, 20))
    data->x=267;
  else if(time<SONGPOSTOTIME(2, 36))
    data->x=200+66*cos((time-SONGPOSTOTIME(2, 20))*M_PI/SONGPOSTOTIME(1, 16));
  else if(time<SONGPOSTOTIME(2, 52))
    data->x=133;
  else
    data->x=66+66*cos((time-SONGPOSTOTIME(2, 52))*M_PI/SONGPOSTOTIME(1, 16));
}

static void params_25_addright(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_25_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 20))
    data->x=133;
  else if(time<SONGPOSTOTIME(1, 36))
    data->x=200-66*cos((time-SONGPOSTOTIME(1, 20))*M_PI/SONGPOSTOTIME(1, 16));
  else if(time<SONGPOSTOTIME(1, 52))
    data->x=267;
  else if(time<SONGPOSTOTIME(2, 4))
    data->x=333-66*cos((time-SONGPOSTOTIME(1, 52))*M_PI/SONGPOSTOTIME(1, 16));
  else if(time<SONGPOSTOTIME(2, 20))
    data->x=399;
  else if(time<SONGPOSTOTIME(2, 36))
    data->x=333+66*cos((time-SONGPOSTOTIME(2, 20))*M_PI/SONGPOSTOTIME(1, 16));
  else if(time<SONGPOSTOTIME(2, 52))
    data->x=267;
  else
    data->x=200+66*cos((time-SONGPOSTOTIME(2, 52))*M_PI/SONGPOSTOTIME(1, 16));
}

static void params_25_copy_text1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  int x, m;
  time-=PART_25_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->source=pictures[TECHNOLOGY2];
    data->desty=70;
    x=120;
    m=-100;
  } else {
    data->source=pictures[ANSWER];
    data->desty=190;
    x=40;
    m=130;
  }
  data->sourcewidth=data->source->width;
  data->sourceheight=data->source->height;
  data->destwidth=data->sourcewidth;
  data->destheight=data->sourceheight;

  time%=SONGPOSTOTIME(2, 0);
  if(time<SONGPOSTOTIME(1, 32))
    data->alpha=0;
  else {
    data->alpha=127*sin((time-SONGPOSTOTIME(1, 32))*M_PI/SONGPOSTOTIME(1, 32));
    data->destx=x+m*sin((time-SONGPOSTOTIME(1, 32))*M_PI/2/SONGPOSTOTIME(1, 32));
  }
}

static void params_25_copy_text2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  int x, m;
  time-=PART_25_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->source=pictures[TECHNOLOGY2];
    data->desty=70;
    x=130;
    m=-110;
  } else {
    data->source=pictures[ANSWER];
    data->desty=190;
    x=20;
    m=150;
  }
  data->sourcewidth=data->source->width;
  data->sourceheight=data->source->height;
  data->destwidth=data->sourcewidth;
  data->destheight=data->sourceheight;

  time%=SONGPOSTOTIME(2, 0);
  if(time<SONGPOSTOTIME(1, 24))
    data->alpha=0;
  else if(time<SONGPOSTOTIME(1, 56)) {
    data->alpha=127*sin((time-SONGPOSTOTIME(1, 24))*M_PI/SONGPOSTOTIME(1, 32));
    data->destx=x+m*sin((time-SONGPOSTOTIME(1, 24))*M_PI/2/SONGPOSTOTIME(1, 32));
  } else
    data->alpha=0;
}

static void params_25_copy_text3(void *d, long time) {
  copy_data *data=(copy_data *)d;
  int x, m;
  time-=PART_25_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->source=pictures[POSSIBILITY];
    data->desty=93;
    x=120;
    m=-80;
  } else {
    data->source=pictures[PROBLEMS];
    data->desty=210;
    x=80;
    m=70;
  }
  data->sourcewidth=data->source->width;
  data->sourceheight=data->source->height;
  data->destwidth=data->sourcewidth;
  data->destheight=data->sourceheight;

  time%=SONGPOSTOTIME(2, 0);
  if(time<SONGPOSTOTIME(1, 32))
    data->alpha=0;
  else {
    data->alpha=127*sin((time-SONGPOSTOTIME(1, 32))*M_PI/SONGPOSTOTIME(1, 32));
    data->destx=x+m*sin((time-SONGPOSTOTIME(1, 32))*M_PI/2/SONGPOSTOTIME(1, 32));
  }
}

static void params_25_copy_text4(void *d, long time) {
  copy_data *data=(copy_data *)d;
  int x, m;
  time-=PART_25_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->source=pictures[POSSIBILITY];
    data->desty=93;
    x=130;
    m=-90;
  } else {
    data->source=pictures[PROBLEMS];
    data->desty=210;
    x=70;
    m=80;
  }
  data->sourcewidth=data->source->width;
  data->sourceheight=data->source->height;
  data->destwidth=data->sourcewidth;
  data->destheight=data->sourceheight;

  time%=SONGPOSTOTIME(2, 0);
  if(time<SONGPOSTOTIME(1, 24))
    data->alpha=0;
  else if(time<SONGPOSTOTIME(1, 56)) {
    data->alpha=127*sin((time-SONGPOSTOTIME(1, 24))*M_PI/SONGPOSTOTIME(1, 32));
    data->destx=x+m*sin((time-SONGPOSTOTIME(1, 24))*M_PI/2/SONGPOSTOTIME(1, 32));
  } else
    data->alpha=0;
}

static void params_25_copy_binary1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_25_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->destx=7;
    data->desty=217;
  } else {
    data->destx=275;
    data->desty=7;
  }
  data->sourcey=((time*2/125)%7)*11;
  data->sourceheight=pictures[BINARY]->height-data->sourcey;
  data->destheight=data->sourceheight;
}

static void params_25_copy_binary2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_25_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->destx=7;
    data->desty=221;
  } else {
    data->destx=275;
    data->desty=11;
  }
  data->sourceheight=((time*2/125)%7)*11;
  data->destheight=data->sourceheight;
  data->desty+=pictures[BINARY]->height-data->sourceheight;
}

void part_25() {
  copy_data *copydata;
  horizontalblur_data *hbdata;
  verticalstripes_data *vstripesdata;
  add_data *adddata;
  int i;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 12. Fade from white */
  effectlist=effectlistentry_new(effect_new(add_new, params_25_add),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0xffffffff;
  adddata->x=0;
  adddata->y=0;
  adddata->width=screenbuffer.width;
  adddata->height=screenbuffer.height;

  /* 11. Add white border */
  effectlist=effectlistentry_new(effect_new(add_new, params_25_addleft),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0x80ffffff;
  adddata->x=0;
  adddata->y=0;
  adddata->width=1;
  adddata->height=screenbuffer.height;

  /* 10. Add white border */
  effectlist=effectlistentry_new(effect_new(add_new, params_25_addright),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0x80ffffff;
  adddata->x=399;
  adddata->y=0;
  adddata->width=1;
  adddata->height=screenbuffer.height;

  /* 9. Add binary, lower */
  effectlist=effectlistentry_new(effect_new(copy_new, params_25_copy_binary2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[BINARY];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=7;
  copydata->desty=217;
  copydata->sourcewidth=pictures[BINARY]->width;
  copydata->sourceheight=pictures[BINARY]->height;
  copydata->destwidth=pictures[BINARY]->width;
  copydata->destheight=pictures[BINARY]->height;
  copydata->alpha=127;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 8. Add binary, upper */
  effectlist=effectlistentry_new(effect_new(copy_new, params_25_copy_binary1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[BINARY];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=7;
  copydata->desty=217;
  copydata->sourcewidth=pictures[BINARY]->width;
  copydata->sourceheight=pictures[BINARY]->height;
  copydata->destwidth=pictures[BINARY]->width;
  copydata->destheight=pictures[BINARY]->height;
  copydata->alpha=127;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 7. Add some text */
  effectlist=effectlistentry_new(effect_new(copy_new, params_25_copy_text4),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[POSSIBILITY];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=40;
  copydata->sourcewidth=pictures[POSSIBILITY]->width;
  copydata->sourceheight=pictures[POSSIBILITY]->height;
  copydata->destwidth=pictures[POSSIBILITY]->width;
  copydata->destheight=pictures[POSSIBILITY]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 6. Add some text */
  effectlist=effectlistentry_new(effect_new(copy_new, params_25_copy_text3),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[POSSIBILITY];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=40;
  copydata->sourcewidth=pictures[POSSIBILITY]->width;
  copydata->sourceheight=pictures[POSSIBILITY]->height;
  copydata->destwidth=pictures[POSSIBILITY]->width;
  copydata->destheight=pictures[POSSIBILITY]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 5. Add some text */
  effectlist=effectlistentry_new(effect_new(copy_new, params_25_copy_text2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TECHNOLOGY2];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=20;
  copydata->sourcewidth=pictures[TECHNOLOGY2]->width;
  copydata->sourceheight=pictures[TECHNOLOGY2]->height;
  copydata->destwidth=pictures[TECHNOLOGY2]->width;
  copydata->destheight=pictures[TECHNOLOGY2]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 4. Add some text */
  effectlist=effectlistentry_new(effect_new(copy_new, params_25_copy_text1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TECHNOLOGY2];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=20;
  copydata->sourcewidth=pictures[TECHNOLOGY2]->width;
  copydata->sourceheight=pictures[TECHNOLOGY2]->height;
  copydata->destwidth=pictures[TECHNOLOGY2]->width;
  copydata->destheight=pictures[TECHNOLOGY2]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 3. Copy final image */
  effectlist=effectlistentry_new(effect_new(copy_new, params_25_copy_fuel),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[FUEL8];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=133;
  copydata->sourceheight=screenbuffer.height;
  copydata->destwidth=133;
  copydata->destheight=screenbuffer.height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;

  /* 2. Stripe it */
  effectlist=effectlistentry_new(effect_new(verticalstripes_new,
					    params_25_stripes), effectlist);
  vstripesdata=(verticalstripes_data *)effectlist->effect->data;
  vstripesdata->dest=&screenbuffer;
  vstripesdata->x=0;
  vstripesdata->y=0;
  vstripesdata->width=screenbuffer.width;
  vstripesdata->height=screenbuffer.height;
  vstripesdata->alphas=(unsigned char *)calloc(vstripesdata->width,
					       sizeof(unsigned char));
  for(i=0; i<133; i++)
    vstripesdata->alphas[i]=0;
  for(i=133; i<vstripesdata->width; i++)
    vstripesdata->alphas[i]=160;

  /* 1. Blur the background */
  effectlist=effectlistentry_new(effect_new(horizontalblur_new,
					    params_25_horizontalblur),
				 effectlist);
  hbdata=(horizontalblur_data *)effectlist->effect->data;
  hbdata->source=pictures[FUEL1];
  hbdata->dest=&screenbuffer;
  hbdata->amount=10;
}
