/* assembly2002demo19.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Phone */
#include "assembly2002demo.h"

static void params_19_add_left(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_19_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 16) && (time%500)<400) {
    data->width=110*sin(time*M_PI/4000);
    data->height=data->dest->height;
  } else if(time<SONGPOSTOTIME(2, 48))
    data->height=0;
  else if(time<SONGPOSTOTIME(3, 0)) {
    data->width=data->dest->width;
    data->height=data->dest->height;
    data->color=(((time-SONGPOSTOTIME(2, 48))*255/SONGPOSTOTIME(1, 16))<<24)|
      0xffffff;
  }
}
  
static void params_19_add_right(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_19_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 16) && (time%500)<400) {
    data->width=110*sin(time*M_PI/4000);
    data->x=data->dest->width-data->width;
    data->height=data->dest->height;
  } else
    data->height=0;
}

static void params_19_stripes(void *d, long time) {
  verticalstripes_data *data=(verticalstripes_data *)d;
  time-=PART_19_START;
  if(time<0)
    time=0;
  
  if(time<SONGPOSTOTIME(1, 16)) {
  } else if(time<SONGPOSTOTIME(1, 32)) {
    int i;

    for(i=0; i<110*sin(time*M_PI/4000); i++) {
      data->alphas[i]=192;
      data->alphas[data->width-1-i]=192;
    }    
    data->alphas[i+1]=255;
    data->alphas[i+2]=192;
    data->alphas[i+3]=192;
    data->alphas[data->width-2-i]=255;
    data->alphas[data->width-3-i]=192;
    data->alphas[data->width-4-i]=192;
  }
}

static void params_19_verticalstretch(void *d, long time) {
  verticalstretch_data *data=(verticalstretch_data *)d;
  time-=PART_19_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 32)) {
    data->position=0;
    data->length=0;
  } else if(time<SONGPOSTOTIME(3, 0)) {
    data->position=(time-SONGPOSTOTIME(2, 32))*data->dest->height/SONGPOSTOTIME(1, 32);
    data->length=-data->position;
  }
}
  
static void params_19_verticalblur(void *d, long time) {
  verticalblur_data *data=(verticalblur_data *)d;
  time-=PART_19_START;
  if(time<0)
    time=0;

  if(time>SONGPOSTOTIME(2, 0))
    data->amount=1;
  else
    data->amount=rand()%((SONGPOSTOTIME(2, 0)-time)/16+1)+1;
}

static void params_19_copy(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_19_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 16))
    data->alpha=0;
  else {
    if(time<SONGPOSTOTIME(1, 32)) {
      data->alpha=(time-SONGPOSTOTIME(1, 16))*255/SONGPOSTOTIME(1, 16);
      data->desty=data->dest->height*(1-sin((time-SONGPOSTOTIME(1, 16))*M_PI/2/SONGPOSTOTIME(1, 16)));
    } else {
      data->alpha=255;
      data->desty=0;
    }
  }
 
}

static void params_19_copy_box(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_19_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 48))
    data->alpha=0;
  else if(time<SONGPOSTOTIME(3, 0)) {
    double s=sin(pow((double)(time-SONGPOSTOTIME(1, 48))/400, 2));
    if(s<0)
      data->alpha=0;
    else
      data->alpha=128;
  } else data->alpha=192;
}

void part_19() {
  copy_data *copydata;
  add_data *adddata;
  verticalstripes_data *vstripesdata;
  verticalstretch_data *vstretchdata;
  verticalblur_data *vbdata;
  int i;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 8. Right add */
  effectlist=effectlistentry_new(effect_new(add_new, params_19_add_right),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0xffcccccc;
  adddata->x=0;
  adddata->y=0;
  adddata->width=100;
  adddata->height=screenbuffer.height;
  
  /* 7. Left add */
  effectlist=effectlistentry_new(effect_new(add_new, params_19_add_left),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0xffcccccc;
  adddata->x=0;
  adddata->y=0;
  adddata->width=100;
  adddata->height=screenbuffer.height;
  
  /* 6. Stripe it */
  effectlist=effectlistentry_new(effect_new(verticalstripes_new,
					    params_19_stripes), effectlist);
  vstripesdata=(verticalstripes_data *)effectlist->effect->data;
  vstripesdata->dest=&screenbuffer;
  vstripesdata->x=0;
  vstripesdata->y=0;
  vstripesdata->width=pictures[TEMP]->width;
  vstripesdata->height=pictures[TEMP]->height;
  vstripesdata->alphas=(unsigned char *)calloc(vstripesdata->width,
					 sizeof(unsigned char));
  for(i=0; i<vstripesdata->width; i++)
    vstripesdata->alphas[i]=255;

  /* 5. Copy box */
  effectlist=effectlistentry_new(effect_new(copy_new, params_19_copy_box),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PHONEBOX];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=133;
  copydata->desty=5;
  copydata->sourcewidth=pictures[PHONEBOX]->width;
  copydata->sourceheight=pictures[PHONEBOX]->height;
  copydata->destwidth=pictures[PHONEBOX]->width;
  copydata->destheight=pictures[PHONEBOX]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 4. Copy on top */
  effectlist=effectlistentry_new(effect_new(copy_new, params_19_copy),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[TEMP];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TEMP]->width;
  copydata->sourceheight=pictures[TEMP]->height;
  copydata->destwidth=screenbuffer.width;
  copydata->destheight=screenbuffer.height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 3. Strech it */
  effectlist=effectlistentry_new(effect_new(verticalstretch_new,
					    params_19_verticalstretch),
				 effectlist);
  vstretchdata=(verticalstretch_data *)effectlist->effect->data;
  vstretchdata->dest=pictures[TEMP];
  vstretchdata->position=0;
  vstretchdata->length=0;

  /* 2. Blur text */
  effectlist=effectlistentry_new(effect_new(verticalblur_new,
					    params_19_verticalblur),
				 effectlist);
  vbdata=(verticalblur_data *)effectlist->effect->data;
  vbdata->source=pictures[GLOBALCOVERAGE];
  vbdata->dest=pictures[TEMP];
  vbdata->amount=1;

  /* 1. Copy phone background */
  effectlist=effectlistentry_new(effect_new(copy_new, NULL),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[PHONE];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[PHONE]->width;
  copydata->sourceheight=pictures[PHONE]->height;
  copydata->destwidth=screenbuffer.width;
  copydata->destheight=screenbuffer.height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;
}
