/* assembly2002demo17.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Laptop */
#include "assembly2002demo.h"

static void params_17_add(void *d, long time) {
  add_data *data=(add_data *)d;
  time-=PART_17_START;
  if(time<0)
    time=0;

  while(time>=SONGPOSTOTIME(2, 0))
    time-=SONGPOSTOTIME(2, 0);

  if(time>255)
    data->color=0;
  else 
    data->color=((255-time)<<24|0xffffff);
}

static void params_17_copy_laptop1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  double laptop;
  time-=PART_17_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 24)) {
    data->source=pictures[LAPTOP1];
    data->alpha=255;
  } else if(time<SONGPOSTOTIME(1, 32)) {
    time-=SONGPOSTOTIME(1, 24);
    laptop=(double)time*(double)7/(double)SONGPOSTOTIME(1, 8);
    data->source=pictures[LAPTOP1+(int)laptop];
    data->alpha=255-(int)(256*fmod(laptop, 1));
  } else if(time<SONGPOSTOTIME(1, 56)) {
    data->source=pictures[LAPTOP9];
    data->alpha=255;
  } else if(time<SONGPOSTOTIME(2, 0)) {
    time-=SONGPOSTOTIME(1, 56);
    laptop=(double)time*(double)7/(double)SONGPOSTOTIME(1, 8);
    data->source=pictures[LAPTOP9+(int)laptop];
    data->alpha=255-(int)(256*fmod(laptop, 1));
  } else if(time<SONGPOSTOTIME(2, 24)) {
    data->source=pictures[LAPTOP16];
    data->alpha=255;
  } else if(time<SONGPOSTOTIME(2, 32)) {
    time-=SONGPOSTOTIME(2, 24);
    laptop=(double)time*(double)7/(double)SONGPOSTOTIME(1, 8);
    data->source=pictures[LAPTOP16-(int)laptop];
    data->alpha=255-(int)(256*fmod(laptop, 1));
  } else {
    data->source=pictures[LAPTOP8];
    data->alpha=255;
  }
}

static void params_17_copy_laptop2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  double laptop;
  time-=PART_17_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 24)) {
    data->source=pictures[LAPTOP2];
    data->alpha=0;
  } else if(time<SONGPOSTOTIME(1, 32)) {
    time-=SONGPOSTOTIME(1, 24);
    laptop=(double)time*(double)7/(double)SONGPOSTOTIME(1, 8);
    data->source=pictures[LAPTOP2+(int)laptop];
    data->alpha=(int)(256*fmod(laptop, 1));
  } else if(time<SONGPOSTOTIME(1, 56)) {
    data->source=pictures[LAPTOP10];
    data->alpha=0;
  } else if(time<SONGPOSTOTIME(2, 0)) {
    time-=SONGPOSTOTIME(1, 56);
    laptop=(double)time*(double)7/(double)SONGPOSTOTIME(1, 8);
    data->source=pictures[LAPTOP10+(int)laptop];
    data->alpha=(int)(256*fmod(laptop, 1));
  } else if(time<SONGPOSTOTIME(2, 24)) {
    data->source=pictures[LAPTOP15];
    data->alpha=0;
  } else if(time<SONGPOSTOTIME(2, 32)) {
    time-=SONGPOSTOTIME(2, 24);
    laptop=(double)time*(double)7/(double)SONGPOSTOTIME(1, 8);
    data->source=pictures[LAPTOP15-(int)laptop];
    data->alpha=(int)(256*fmod(laptop, 1));
  } else {
    data->source=pictures[LAPTOP7];
    data->alpha=0;
  }
}

static void params_17_copy_text1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_17_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->source=pictures[MOBILE];
    data->sourcewidth=pictures[MOBILE]->width;
    data->sourceheight=pictures[MOBILE]->height;
    data->destwidth=pictures[MOBILE]->width;
    data->destheight=pictures[MOBILE]->height;
    data->destx=200;
    data->desty=167+(int)pow((double)(SONGPOSTOTIME(2, 0)-time)/1000, 3);
    data->alpha=224*sin((double)time*M_PI/SONGPOSTOTIME(2, 0));
  } else {
    data->source=pictures[WHENEVER];
    data->sourcewidth=pictures[WHENEVER]->width;
    data->sourceheight=pictures[WHENEVER]->height;
    data->destwidth=pictures[WHENEVER]->width;
    data->destheight=pictures[WHENEVER]->height;
    data->destx=30;
    data->desty=127+(int)pow((double)(SONGPOSTOTIME(3, 0)-time)/1200, 3);
    data->alpha=-224*sin((double)time*M_PI/SONGPOSTOTIME(2, 0));
  }
}

static void params_17_copy_text2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_17_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->source=pictures[COMPUTING];
    data->sourcewidth=pictures[COMPUTING]->width;
    data->sourceheight=pictures[COMPUTING]->height;
    data->destwidth=pictures[COMPUTING]->width;
    data->destheight=pictures[COMPUTING]->height;
    data->destx=225;
    data->desty=195-(int)pow((double)(SONGPOSTOTIME(2, 0)-time)/800, 3);
    data->alpha=192*sin((double)time*M_PI/SONGPOSTOTIME(2, 0));
  } else {
    data->source=pictures[WHEREEVER];
    data->sourcewidth=pictures[WHEREEVER]->width;
    data->sourceheight=pictures[WHEREEVER]->height;
    data->destwidth=pictures[WHEREEVER]->width;
    data->destheight=pictures[WHEREEVER]->height;
    data->destx=5;
    data->desty=155-(int)pow((double)(SONGPOSTOTIME(3, 0)-time)/800, 3);
    data->alpha=-192*sin((double)time*M_PI/SONGPOSTOTIME(2, 0));
  }
}

static void params_17_copy_bullshit(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_17_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->destx=25;
    data->desty=175+(int)pow((double)(SONGPOSTOTIME(2, 0)-time)/1600, 4);
    data->alpha=192*sin((double)time*M_PI/SONGPOSTOTIME(2, 0));
  } else {
    data->destx=235;
    data->desty=175-(int)pow((double)(SONGPOSTOTIME(3, 0)-time)/1800, 4);
    data->alpha=-192*sin((double)time*M_PI/SONGPOSTOTIME(2, 0));
  }
}

static void params_17_copy_binary1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_17_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->destx=7;
    data->desty=228;
    data->alpha=time*191/SONGPOSTOTIME(2, 0);
  } else {
    data->destx=275;
    data->desty=7;
    data->alpha=191;
  }
  data->sourcey=((time*2/125)%6)*11;
  data->sourceheight=pictures[BINARY]->height-11-data->sourcey;
  data->destheight=data->sourceheight;
}

static void params_17_copy_binary2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_17_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0)) {
    data->destx=7;
    data->desty=232;
    data->alpha=time*191/SONGPOSTOTIME(2, 0);
  } else {
    data->destx=275;
    data->desty=11;
    data->alpha=191;
  }
  data->sourceheight=((time*2/125)%6)*11;
  data->destheight=data->sourceheight;
  data->desty+=pictures[BINARY]->height-11-data->sourceheight;
}

static void params_17_horizontalstripes(void *d, long time) {
  horizontalstripes_data *data=(horizontalstripes_data *)d;
  int i;
  time-=PART_17_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 32))
    for(i=0; i<time/25; i++) {
      data->alphas[i]=127;
      data->alphas[data->height-1-i]=127;
    }
}

void part_17() {
  copy_data *copydata;
  add_data *adddata;
  horizontalstripes_data *horizontalstripesdata;
  int i;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 9. Flash */
  effectlist=effectlistentry_new(effect_new(add_new, params_17_add),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0xffffffff;
  adddata->x=0;
  adddata->y=0;
  adddata->width=screenbuffer.width;
  adddata->height=screenbuffer.height;

  /* 8. Stripe it */
  effectlist=effectlistentry_new(effect_new(horizontalstripes_new, params_17_horizontalstripes),
				 effectlist);
  horizontalstripesdata=(horizontalstripes_data *)effectlist->effect->data;
  horizontalstripesdata->dest=&screenbuffer;
  horizontalstripesdata->x=0;
  horizontalstripesdata->y=0;
  horizontalstripesdata->width=pictures[TEMP]->width;
  horizontalstripesdata->height=pictures[TEMP]->height;
  horizontalstripesdata->alphas=(unsigned char *)calloc(horizontalstripesdata->height,
					      sizeof(unsigned char));
  for(i=0; i<horizontalstripesdata->height; i++)
    horizontalstripesdata->alphas[i]=255;

  /* 7. Add binary, lower */
  effectlist=effectlistentry_new(effect_new(copy_new, params_17_copy_binary2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[BINARY];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=7;
  copydata->desty=217;
  copydata->sourcewidth=pictures[BINARY]->width;
  copydata->sourceheight=pictures[BINARY]->height;
  copydata->destwidth=pictures[BINARY]->width;
  copydata->destheight=pictures[BINARY]->height;
  copydata->alpha=127;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 6. Add binary, upper */
  effectlist=effectlistentry_new(effect_new(copy_new, params_17_copy_binary1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[BINARY];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=7;
  copydata->desty=217;
  copydata->sourcewidth=pictures[BINARY]->width;
  copydata->sourceheight=pictures[BINARY]->height;
  copydata->destwidth=pictures[BINARY]->width;
  copydata->destheight=pictures[BINARY]->height;
  copydata->alpha=127;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 5. Copy bullshit */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_17_copy_bullshit),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[BULLSHITWHITE];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=225;
  copydata->desty=195;
  copydata->sourcewidth=pictures[BULLSHITWHITE]->width;
  copydata->sourceheight=pictures[BULLSHITWHITE]->height;
  copydata->destwidth=pictures[BULLSHITWHITE]->width;
  copydata->destheight=pictures[BULLSHITWHITE]->height;
  copydata->alpha=192;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 4. Copy text 2 */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_17_copy_text2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[COMPUTING];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=225;
  copydata->desty=195;
  copydata->sourcewidth=pictures[COMPUTING]->width;
  copydata->sourceheight=pictures[COMPUTING]->height;
  copydata->destwidth=pictures[COMPUTING]->width;
  copydata->destheight=pictures[COMPUTING]->height;
  copydata->alpha=192;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 3. Copy text 1 */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_17_copy_text1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[MOBILE];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=200;
  copydata->desty=170;
  copydata->sourcewidth=pictures[MOBILE]->width;
  copydata->sourceheight=pictures[MOBILE]->height;
  copydata->destwidth=pictures[MOBILE]->width;
  copydata->destheight=pictures[MOBILE]->height;
  copydata->alpha=224;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 2. Copy laptop 2 */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_17_copy_laptop2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[LAPTOP1];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[LAPTOP1]->width;
  copydata->sourceheight=pictures[LAPTOP1]->height;
  copydata->destwidth=screenbuffer.width;
  copydata->destheight=screenbuffer.height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_ADD;
  copydata->interpolate=0;

  /* 1. Copy laptop */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_17_copy_laptop1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[LAPTOP1];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[LAPTOP1]->width;
  copydata->sourceheight=pictures[LAPTOP1]->height;
  copydata->destwidth=screenbuffer.width;
  copydata->destheight=screenbuffer.height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_ADD;
  copydata->interpolate=0;

  /* 1. Copy laptop */
  effectlist=effectlistentry_new(effect_new(copy_new, NULL),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[MOTHERBOARD];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[MOTHERBOARD]->width;
  copydata->sourceheight=pictures[MOTHERBOARD]->height;
  copydata->destwidth=screenbuffer.width;
  copydata->destheight=screenbuffer.height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;
}
