/* assembly2002demo14.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02141-1407  USA
 */

/* Crane 1 (machinery) */
#include "assembly2002demo.h"

static void params_14_add(void *d, long time) {
  add_data *data=(add_data *)d;

  time-=PART_14_START;
  if(time<0)
    time=0;

  if(time/12>191)
    data->color=0;
  else 
    data->color=((191-(time/12))<<24|0xffffff);
}

static void params_14_horizontalblur(void *d, long time) {
  verticalblur_data *data=(verticalblur_data *)d;
  time-=PART_14_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0))
    data->amount=rand()%((SONGPOSTOTIME(2, 0)-time)/64+1)+(SONGPOSTOTIME(2, 0)-time)/128+1;
  else
    data->amount=1;
}

static void params_14_verticalstretch(void *d, long time) {
  verticalstretch_data *data=(verticalstretch_data *)d;
  time-=PART_14_START;
  if(time<0)
    time=0;

  /* Golden section vertically: 185 115 */
  if(time<SONGPOSTOTIME(1, 28)) {
    data->position=115;
    data->length=-data->position;
  } else if(time<SONGPOSTOTIME(1, 32)) {
    data->position=115-(int)pow((double)(time-SONGPOSTOTIME(1, 28))/(double)52,
				3);
    data->length=-data->position;
  } else {
    data->position=0;
    data->length=0;
  }
}

static void params_14_copy_machinery1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_14_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 36)) {
    data->alpha=(SONGPOSTOTIME(1, 36)-time)*255/SONGPOSTOTIME(1, 36);
    data->desty=165-(int)pow((double)(SONGPOSTOTIME(1, 36)-time)/(double)550, 3);
  } else
    data->alpha=0;
}

static void params_14_copy_machinery2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_14_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 8)) {
  } else if(time<SONGPOSTOTIME(1, 44)) {
    data->alpha=(time-SONGPOSTOTIME(1, 8))*255/SONGPOSTOTIME(1, 36);
    data->desty=160-(int)pow((double)(SONGPOSTOTIME(1, 44)-time)/(double)550, 3);
  } else
    data->alpha=255;
}

static void params_14_copy_crane1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_14_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 32))
    data->sourcex=0;
  else
    data->sourcex=data->source->width-data->dest->width;;
}

static void params_14_copy_bullshitblack1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_14_START;
  if(time<0)
    time=0;

  data->desty=170+time/128;
  data->alpha=time/32;
}

static void params_14_copy_bullshitblack2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_14_START;
  if(time<0)
    time=0;

  data->desty=250-time/128;
  data->alpha=time/32;
}

static void params_14_copy_small1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_14_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 52))
    data->alpha=0;
  else
    data->alpha=255;
}

static void params_14_copy_small2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_14_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 56))
    data->alpha=0;
  else
    data->alpha=255;
}

static void params_14_copy_small3(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_14_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(1, 60))
    data->alpha=0;
  else
    data->alpha=255;
}

void part_14() {
  copy_data *copydata;
  horizontalblur_data *hbdata;
  verticalstretch_data *vsdata;
  add_data *adddata;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 11. Fade from white */
  effectlist=effectlistentry_new(effect_new(add_new, params_14_add),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0xffffffff;
  adddata->x=0;
  adddata->y=0;
  adddata->width=screenbuffer.width;
  adddata->height=screenbuffer.height;

  /* 10. Strech them */
  effectlist=effectlistentry_new(effect_new(verticalstretch_new,
					    params_14_verticalstretch),
				 effectlist);
  vsdata=(verticalstretch_data *)effectlist->effect->data;
  vsdata->dest=&screenbuffer;
  vsdata->position=0;
  vsdata->length=0;

  /* 9. Copy factory 2 small 3 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_14_copy_small3),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[CRANE1SMALL3];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=87;
  copydata->desty=5;
  copydata->sourcewidth=pictures[CRANE1SMALL3]->width;
  copydata->sourceheight=pictures[CRANE1SMALL3]->height;
  copydata->destwidth=pictures[CRANE1SMALL3]->width;
  copydata->destheight=pictures[CRANE1SMALL3]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 8. Copy factory 2 small 2 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_14_copy_small2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[CRANE1SMALL2];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=46;
  copydata->desty=5;
  copydata->sourcewidth=pictures[CRANE1SMALL2]->width;
  copydata->sourceheight=pictures[CRANE1SMALL2]->height;
  copydata->destwidth=pictures[CRANE1SMALL2]->width;
  copydata->destheight=pictures[CRANE1SMALL2]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 7. Copy factory 2 small 1 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_14_copy_small1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[CRANE1SMALL1];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=5;
  copydata->desty=5;
  copydata->sourcewidth=pictures[CRANE1SMALL1]->width;
  copydata->sourceheight=pictures[CRANE1SMALL1]->height;
  copydata->destwidth=pictures[CRANE1SMALL1]->width;
  copydata->destheight=pictures[CRANE1SMALL1]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 6. Copy machinery 2 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_14_copy_machinery2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[MACHINERY];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=screenbuffer.width-pictures[MACHINERY]->width;
  copydata->desty=104;
  copydata->sourcewidth=pictures[MACHINERY]->width;
  copydata->sourceheight=pictures[MACHINERY]->height;
  copydata->destwidth=pictures[MACHINERY]->width;
  copydata->destheight=pictures[MACHINERY]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 5. Copy machinery */
  effectlist=effectlistentry_new(effect_new(copy_new, params_14_copy_machinery1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[MACHINERY];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=screenbuffer.width-pictures[MACHINERY]->width;
  copydata->desty=104;
  copydata->sourcewidth=pictures[MACHINERY]->width;
  copydata->sourceheight=pictures[MACHINERY]->height;
  copydata->destwidth=pictures[MACHINERY]->width;
  copydata->destheight=pictures[MACHINERY]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 4. Copy bullshitblack 2 */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_14_copy_bullshitblack2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[BULLSHITBLACK];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=95;
  copydata->desty=250;
  copydata->sourcewidth=pictures[BULLSHITBLACK]->width;
  copydata->sourceheight=pictures[BULLSHITBLACK]->height;
  copydata->destwidth=pictures[BULLSHITBLACK]->width;
  copydata->destheight=pictures[BULLSHITBLACK]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 3. Copy bullshitblack 1 */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_14_copy_bullshitblack1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[BULLSHITBLACK];
  copydata->dest=&screenbuffer;
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=245;
  copydata->desty=165;
  copydata->sourcewidth=pictures[BULLSHITBLACK]->width;
  copydata->sourceheight=pictures[BULLSHITBLACK]->height;
  copydata->destwidth=pictures[BULLSHITBLACK]->width;
  copydata->destheight=pictures[BULLSHITBLACK]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 2. Blur the background */
  effectlist=effectlistentry_new(effect_new(horizontalblur_new,
					    params_14_horizontalblur),
				 effectlist);
  hbdata=(horizontalblur_data *)effectlist->effect->data;
  hbdata->source=pictures[TEMP];
  hbdata->dest=&screenbuffer;
  hbdata->amount=1;

  /* 1. Copy background */
  effectlist=effectlistentry_new(effect_new(copy_new, params_14_copy_crane1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[CRANE1];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TEMP]->width;
  copydata->sourceheight=pictures[TEMP]->height;
  copydata->destwidth=pictures[TEMP]->width;
  copydata->destheight=pictures[TEMP]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;
}
