/* assembly2002demo05.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Factory 1 (a cross platform demo) */
#include "assembly2002demo.h"

static void params_05_verticalblur(void *d, long time) {
  verticalblur_data *data=(verticalblur_data *)d;
  time-=PART_05_START;
  if(time<0)
    time=0;

  if(time<=SONGPOSTOTIME(2, 48))
    data->amount=1;
  else
    data->amount=rand()%((time-SONGPOSTOTIME(2, 48))/4+1)+1;
}

static void params_05_copy_factory(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_05_START;
  if(time<0)
    time=0;

  if(time>SONGPOSTOTIME(2, 48))
    data->alpha=255-(time-SONGPOSTOTIME(2, 48))/2;

  if(time/90>79)
    data->sourcex=79;
  else
    data->sourcex=time/90;
}

static void params_05_copy_factoryoverlay(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_05_START;
  if(time<0)
    time=0;

  if(time<=SONGPOSTOTIME(2, 48))
    data->alpha=0;
  else {
    data->alpha=16;
    data->desty=rand()%50;
  }

  if(time/90>79)
    data->sourcex=79;
  else
    data->sourcex=time/90;
}

static void params_05_copy_design1(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_05_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0))
    data->desty=data->dest->height-125*sin((double)time*M_PI/2/SONGPOSTOTIME(2, 0));
  else
    data->desty=175;
}

static void params_05_copy_design2(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_05_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0))
    data->desty=45*sin((double)time*M_PI/2/SONGPOSTOTIME(2, 0));
  else
    data->desty=45;
}

static void params_05_copy_crossplatform(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_05_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0))
    data->destx=400-215*sin((double)time*M_PI/2/SONGPOSTOTIME(2, 0));
  else
    data->destx=185;
}

static void params_05_copy_demo(void *d, long time) {
  copy_data *data=(copy_data *)d;
  time-=PART_05_START;
  if(time<0)
    time=0;

  if(time<SONGPOSTOTIME(2, 0))
    data->destx=400-60*sin((double)time*M_PI/2/SONGPOSTOTIME(2, 0));
  else
    data->destx=340;
}

static void params_05_add(void *d, long time) {
  add_data *data=(add_data *)d;

  time-=PART_05_START;
  if(time<0)
    time=0;

  if(time/24>255)
    data->color=0;
  else 
    data->color=((255-(time/24))<<24|0xffffff);
}

void part_05() {
  copy_data *copydata;
  verticalblur_data *vbdata;
  add_data *adddata;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  /* 8. Fade from white */
  effectlist=effectlistentry_new(effect_new(add_new, params_05_add),
				 effectlist);
  adddata=(add_data *)effectlist->effect->data;
  adddata->dest=&screenbuffer;
  adddata->color=0xffffffff;
  adddata->x=0;
  adddata->y=0;
  adddata->width=screenbuffer.width;
  adddata->height=screenbuffer.height;

  /* 7. Blur it */
  effectlist=effectlistentry_new(effect_new(verticalblur_new, 
					    params_05_verticalblur),
				 effectlist);
  vbdata=(verticalblur_data *)effectlist->effect->data;
  vbdata->source=pictures[TEMP];
  vbdata->dest=&screenbuffer;
  vbdata->amount=1;

  /* 6. Copy factory overlay */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_05_copy_factoryoverlay),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[FACTORY1];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TEMP]->width;
  copydata->sourceheight=pictures[TEMP]->height;
  copydata->destwidth=pictures[TEMP]->width;
  copydata->destheight=pictures[TEMP]->height;
  copydata->alpha=0;
  copydata->mode=COPY_MODE_ADD;
  copydata->interpolate=0;

  /* 5. Copy demo */
  effectlist=effectlistentry_new(effect_new(copy_new, params_05_copy_demo),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[DEMO];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=285;
  copydata->desty=183;
  copydata->sourcewidth=pictures[DEMO]->width;
  copydata->sourceheight=pictures[DEMO]->height;
  copydata->destwidth=pictures[DEMO]->width;
  copydata->destheight=pictures[DEMO]->height;
  copydata->alpha=160;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 4. Copy crossplatform */
  effectlist=effectlistentry_new(effect_new(copy_new,
					    params_05_copy_crossplatform),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[CROSSPLATFORM];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=205;
  copydata->desty=145;
  copydata->sourcewidth=pictures[CROSSPLATFORM]->width;
  copydata->sourceheight=pictures[CROSSPLATFORM]->height;
  copydata->destwidth=pictures[CROSSPLATFORM]->width;
  copydata->destheight=pictures[CROSSPLATFORM]->height;
  copydata->alpha=128;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 3. Copy DESIGN2 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_05_copy_design2),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[DESIGN2];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=78;
  copydata->sourcewidth=pictures[DESIGN2]->width;
  copydata->sourceheight=pictures[DESIGN2]->height;
  copydata->destwidth=pictures[DESIGN2]->width;
  copydata->destheight=pictures[DESIGN2]->height;
  copydata->alpha=32;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 2. Copy DESIGN1 */
  effectlist=effectlistentry_new(effect_new(copy_new, params_05_copy_design1),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[DESIGN1];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=28;
  copydata->sourcewidth=pictures[DESIGN1]->width;
  copydata->sourceheight=pictures[DESIGN1]->height;
  copydata->destwidth=pictures[DESIGN1]->width;
  copydata->destheight=pictures[DESIGN1]->height;
  copydata->alpha=32;
  copydata->mode=COPY_MODE_NORMAL;
  copydata->interpolate=0;

  /* 1. Copy factory */
  effectlist=effectlistentry_new(effect_new(copy_new, params_05_copy_factory),
				 effectlist);
  copydata=(copy_data *)effectlist->effect->data;
  copydata->source=pictures[FACTORY1];
  copydata->dest=pictures[TEMP];
  copydata->sourcex=0;
  copydata->sourcey=0;
  copydata->destx=0;
  copydata->desty=0;
  copydata->sourcewidth=pictures[TEMP]->width;
  copydata->sourceheight=pictures[TEMP]->height;
  copydata->destwidth=pictures[TEMP]->width;
  copydata->destheight=pictures[TEMP]->height;
  copydata->alpha=255;
  copydata->mode=COPY_MODE_OVERWRITE;
  copydata->interpolate=0;
}
