/* assembly2002demo.c
 *
 * Copyright 2001-2002 Vesa Halttunen (Vesuri/dA JoRMaS)
 *
 * This file is part of JRm-core.
 *
 * JRm-core is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * JRm-core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JRm-core; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "assembly2002demo.h"

buffer **pictures;
int renderwidth=400, renderheight=300, screenwidth=400, screenheight=300;
int npictures;
char *production_window_title="dA JoRMaS: Ht";
char *production_mp3_filename="data/raunio.mp3";
char *picture_filenames[]={
  "data/assembly.png",
  "data/colon.png",
  "data/2002.png",
  "data/helsinki.png",
  "data/shipyard1.jpg",
  "data/da.png",
  "data/jormas.png",
  "data/present.png",
  "data/factory1.jpg",
  "data/factory1.png",
  "data/design1.png",
  "data/design2.png",
  "data/crossplatform.png",
  "data/demo.png",
  "data/hata.png",
  "data/traffic1.jpg",
  "data/traffic2.jpg",
  "data/traffic3.jpg",
  "data/traffic4.jpg",
  "data/traffic5.jpg",
  "data/traffic6.jpg",
  "data/traffic7.jpg",
  "data/traffic8.jpg",
  "data/traffic.png",
  "data/jam.png",
  "data/instant.png",
  "data/mobility.png",
  "data/trafficbullshit1.png",
  "data/trafficbullshit2.png",
  "data/bullshitwhite.png",
  "data/bullshitblack.png",
  "data/train.jpg",
  "data/train.png",
  "data/straightelectric.png",
  "data/locomotives.png",
  "data/take.png",
  "data/you.png",
  "data/there.png",
  "data/but.png",
  "data/where.png",
  "data/factory2.jpg",
  "data/factory2small1.png",
  "data/factory2small2.png",
  "data/factory2small3.png",
  "data/energy.png",
  "data/crane1.jpg",
  "data/crane1small1.png",
  "data/crane1small2.png",
  "data/crane1small3.png",
  "data/machinery.png",
  "data/factory3.jpg",
  "data/factory3small1.png",
  "data/factory3small2.png",
  "data/factory3small3.png",
  "data/electricity.png",
  "data/traffic9.jpg",
  "data/traffic9small1.png",
  "data/traffic9small2.png",
  "data/traffic9small3.png",
  "data/technology.png",
  "data/laptop1.jpg",
  "data/laptop2.jpg",
  "data/laptop3.jpg",
  "data/laptop4.jpg",
  "data/laptop5.jpg",
  "data/laptop6.jpg",
  "data/laptop7.jpg",
  "data/laptop8.jpg",
  "data/laptop9.jpg",
  "data/laptop10.jpg",
  "data/laptop11.jpg",
  "data/laptop12.jpg",
  "data/laptop13.jpg",
  "data/laptop14.jpg",
  "data/laptop15.jpg",
  "data/laptop16.jpg",
  "data/motherboard.jpg",
  "data/mobile.png",
  "data/computing.png",
  "data/whenever.png",
  "data/whereever.png",
  "data/phone.jpg",
  "data/phonebox.png",
  "data/globalcoverage.png",
  "data/factory4.jpg",
  "data/factory4small1.png",
  "data/factory4small2.png",
  "data/factory4small3.png",
  "data/crane2.jpg",
  "data/crane2small1.png",
  "data/crane2small2.png",
  "data/crane2small3.png",
  "data/powerstation.jpg",
  "data/powerstationsmall1.png",
  "data/powerstationsmall2.png",
  "data/powerstationsmall3.png",
  "data/traffic10.jpg",
  "data/traffic10small1.png",
  "data/traffic10small2.png",
  "data/traffic10small3.png",
  "data/fuel1.jpg",
  "data/fuel2.jpg",
  "data/fuel3.jpg",
  "data/fuel4.jpg",
  "data/fuel5.jpg",
  "data/fuel6.jpg",
  "data/fuel7.jpg",
  "data/fuel8.jpg",
  "data/fuel9.jpg",
  "data/technology2.png",
  "data/possibility.png",
  "data/answer.png",
  "data/problems.png",
  "data/binary.png",
  "data/eye.jpg",
  "data/what.png",
  "data/about.png",
  "data/the.png",
  "data/problems2.png",
  "data/ofthe.png",
  "data/mind.png",
  "data/stairs1.jpg",
  "data/stairs2.jpg",
  "data/stairs3.jpg",
  "data/stairs4.jpg",
  "data/stairs5.jpg",
  "data/stairs6.jpg",
  "data/stairs7.jpg",
  "data/stairs8.jpg",
  "data/stairs9.jpg",
  "data/stairs10.jpg",
  "data/stairs11.jpg",
  "data/stairs12.jpg",
  "data/stairs13.jpg",
  "data/stairs14.jpg",
  "data/stairs15.jpg",
  "data/fear.png",
  "data/insecurity.png",
  "data/loneliness.png",
  "data/insanity.png",
  "data/basement1.jpg",
  "data/basement2.jpg",
  "data/basement3.jpg",
  "data/basement4.jpg",
  "data/basement5.jpg",
  "data/basement6.jpg",
  "data/basement7.jpg",
  "data/basement8.jpg",
  "data/basement9.jpg",
  "data/basement10.jpg",
  "data/basement11.jpg",
  "data/basement12.jpg",
  "data/basement13.jpg",
  "data/basement14.jpg",
  "data/basement15.jpg",
  "data/elevator1.jpg",
  "data/elevator2.jpg",
  "data/elevator3.jpg",
  "data/elevator4.jpg",
  "data/elevator5.jpg",
  "data/elevator6.jpg",
  "data/elevator7.jpg",
  "data/elevator8.jpg",
  "data/elevator9.jpg",
  "data/vesuri1.jpg",
  "data/vesuri2.jpg",
  "data/vesuri3.jpg",
  "data/vesuri4.jpg",
  "data/vesuri5.jpg",
  "data/vesuri6.jpg",
  "data/vesuri7.jpg",
  "data/vesuri8.jpg",
  "data/lapinkulta.jpg",
  "data/lapinkultasmall1.png",
  "data/lapinkultasmall2.png",
  "data/lapinkultasmall3.png",
  "data/lapinkultasmall4.png",
  "data/lapinkultasmall5.png",
  "data/lapinkultasmall6.png",
  "data/lapinkultasmall7.png",
  "data/lapinkultasmall8.png",
  "data/lapinkultasmall9.png",
  "data/lapinkultasmall10.png",
  "data/lapinkultasmall11.png",
  "data/lapinkultasmall12.png",
  "data/beer.jpg",
  "data/water1.jpg",
  "data/water2.jpg",
  "data/water3.jpg",
  "data/water4.jpg",
  "data/peaceofmind.png",
  "data/escapingreality.png",
  "data/help1.jpg",
  "data/help2.jpg",
  "data/help3.jpg",
  "data/help4.jpg",
  "data/credits.png",
  "data/kode.png",
  "data/gfx.png",
  "data/musik.png",
  "data/design.png",
  "data/vesuri.png",
  "data/thanks.png",
  "data/inspiration.png",
  "data/gmunk.png",
  "data/lievonen.png",
  "data/support.png",
  "data/virnes.png",
  "data/jrm.png",
  "data/design3.png",
  "data/design4.png",
  "data/design5.jpg",
  "data/design6.jpg",
  "data/design7.jpg",
  "data/design8.jpg",
  "data/symbol.png",
  "data/mixer1.jpg",
  "data/mixer2.jpg",
  "data/mixer3.jpg",
  "data/mixer4.jpg",
  "data/eps.jpg",
  "data/x51.jpg",
  "data/x52.jpg",
  "data/endscreen.png",
  NULL
};

/* Allocate a temporary buffer and load pictures */
void production_startup() {
  int i=0;

  while(picture_filenames[i]!=NULL)
    i++;
  
  npictures=i+1;
  pictures=(struct buffer **)calloc(npictures, sizeof(struct buffer *));

  i=0;
  while(picture_filenames[i]!=NULL) {
    if(!(pictures[i]=buffer_load(picture_filenames[i]))) {
      fprintf(stderr, "Couldn't load %s\n", picture_filenames[i]);
      exit(1);
    }
    i++;
  }
  pictures[i]=buffer_new(renderwidth, renderheight);
}

void production_shutdown() {
  int i;

  if(effectlist)
    effectlist_free(effectlist);
  effectlist=NULL;

  for(i=0; i<npictures; i++)
    buffer_free(pictures[i]);
  free(pictures);
}

timelineentry timeline[] = {
  { PART_01_START, part_01 },
  /* Pattern 02 is handled in part 01 */
  { PART_03_START, part_03 },
  /* Pattern 04 is handled in part 03 */
  { PART_05_START, part_05 },
  /* Pattern 06 is handled in part 05 */
  { PART_07_START, part_07 },
  /* Pattern 08 is handled in part 07 */
  { PART_09_START, part_09 },
  /* Pattern 10 is handled in part 09 */
  { PART_11_START, part_11 },
  /* Pattern 12 is handled in part 11 */
  { PART_13_START, part_13 },
  { PART_14_START, part_14 },
  { PART_15_START, part_15 },
  { PART_16_START, part_16 },
  { PART_17_START, part_17 },
  /* Pattern 18 is handled in part 17 */
  { PART_19_START, part_19 },
  /* Pattern 20 is handled in part 19 */
  { PART_21_START, part_21 },
  { PART_22_START, part_22 },
  { PART_23_START, part_23 },
  { PART_24_START, part_24 },
  { PART_25_START, part_25 },
  /* Pattern 26 is handled in part 25 */
  { PART_27_START, part_27 },
  /* Pattern 28 is handled in part 27 */
  { PART_29_START, part_29 },
  /* Pattern 30 is handled in part 29 */
  { PART_31_START, part_31 },
  /* Pattern 32 is handled in part 31 */
  { PART_33_START, part_33 },
  /* Pattern 34 is handled in part 33 */
  { PART_35_START, part_35 },
  /* Pattern 36 is handled in part 35 */
  { PART_37_START, part_37 },
  /* Patterns 38-40 are handled in part 37 */
  { PART_41_START, part_41 },
  /* Patterns 42-44 are handled in part 41 */
  { PART_45_START, part_45 },
  /* Pattern 46 is handled in part 45 */
  { PART_END, production_quit },
  { NULL, NULL }
};
