/*
**
**	FX Skeutuveu . Sir-One
**
*/

#include <windows.h>
#include <GL/gl.h>
#include <stdlib.h>
#include <math.h>


#include "fxSkeutuveu.hpp"


#define deuxpi 6.28f


fxSkeutuveu::fxSkeutuveu()
{
	r=1.0f;
	g=1.0f;
	b=1.0f;
	res=0.01f;
	temp1=0.0f;
	temp2=0.0f;
}

bool fxSkeutuveu::Init(const Loader* l)
{
	return true;
}

void fxSkeutuveu::Render(float time, const Demo *env)
{
	glDisable( GL_LIGHTING );
	glDisable( GL_BLEND );
	glDisable( GL_TEXTURE_2D );
	glDisable( GL_DEPTH_TEST );
	glLoadIdentity();
	glTranslatef( cos((res+time)*200), sin((res+time)*200), sin((res+time)*200)*3-10.0f );
	gluLookAt( 2.0f , 2.0f , 2.0f , 0.0f , 0.0f , 0.0f , 0.0f , 1.0f , 0.0f );
	glRotatef(sin(time * deuxpi+2*res)*360,cos(time * deuxpi+2*res),sin(time * deuxpi+1.0+2*res),tan(time * deuxpi/10));

	time += 0.1f;
	time *= 5.0f;

	r = 0.5f + sin( time * deuxpi+0.8)/2  ;
	g = 0.5f + cos( time * deuxpi+0.8)/2  ;
	b = 0.5f + sin(time * deuxpi+1.8f)/2  ;

	for(k=1;k<=99;k++)
	{
		for(i=1;i<=99;i++)
		{
			
			temp1=((float)(i-50)/(50.0*((sin(time * deuxpi)+1.8+res)/3)));
			temp2=((float)(k-50)/(50.0*((sin(time * deuxpi)+1.8+res)/3)));
			temp1=sqrt(temp1*temp1+temp2*temp2);
			if (noise)
				array[k][i] = 1.5 * sin(temp1+5*sin(time * deuxpi))/(temp1+1)+rand()/65536.0f;
			else
				array[k][i]=sin(temp1+5*sin(time * deuxpi))/(temp1+1);
			
			//array[k][i]=cos((float)(i-50)/(50.0*((sin(res)+1.1)/3)))*sin((float)(k-50)/(50.0*((sin(res)+1.1)/3)));
		}
	}

	glColor3f(r,g,b);
	
	for(k=2;k<=99;k++)
	{
	glBegin(GL_LINE_STRIP);
	
		for(i=2;i<=99;i++)
		{
	
			glVertex3f(((float)k/50-1)*3,array[i][k]*3,((float)i/50-1)*3);
	
		}
	glEnd();
	
	}
	
	for(i=2;i<=99;i++)
	{
	glBegin(GL_LINE_STRIP);
	
		for(k=2;k<=99;k++)
		{
	
			glVertex3f(((float)k/50-1)*3,array[i][k]*3,((float)i/50-1)*3);
	
		}
	glEnd();
	
	}

}

void fxSkeutuveu::Push(ud type, float value)
{
	if (type == PUSH_PERC)
		res += 0.01;
	if (type == PUSH_BASS){
		noise=true;
	}else{
		noise=false;
	}

}

void fxSkeutuveu::DeInit()
{
}


fxSkeutuveu::~fxSkeutuveu()
{
}



