/*
**
**	Conceptual metaballs by FirEdge / Ethereal
**
*/


#include <windows.h>
#include <gl/gl.h>
#include <math.h>

#include "ijl.h"

#include "fxMetaballs.hpp"


fxMetaballs::fxMetaballs()
{
	scale = 10.0f;
	hscale = 20.0f;

	localtime = 0.0f;
}


bool fxMetaballs::Init(const Loader* loader)
{
	// thank you pcween for the sample code that loads a JPEG ;-)
	// too lazy to recode it by myself :o)

	JPEG_CORE_PROPERTIES jcprops;
	BYTE pixel_buffer [128*128*3]; // Metatex is 128*128*3

	ijlInit (&jcprops);

	jcprops.JPGFile = "data/metatexture.jpg";

	jcprops.DIBWidth = 128;
	jcprops.DIBHeight = 128;
	jcprops.DIBChannels = 3;
	jcprops.DIBColor = IJL_RGB;
	jcprops.DIBPadBytes = 0;
	jcprops.DIBBytes = pixel_buffer;

    ijlRead (&jcprops, IJL_JFILE_READWHOLEIMAGE);
	ijlFree (&jcprops);	
	
	glGenTextures(2, &metatex);					
	glBindTexture(GL_TEXTURE_2D, metatex);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, 128, 128, 0, GL_RGB, GL_UNSIGNED_BYTE, pixel_buffer);

	return true;
}


void fxMetaballs::Render(float time, const Demo *env)
{
	unsigned int i,j,k,l;
	float posx,posz,sc;

	float posy = 0.0f;
	float oposx = 0.0f;
	float oposz = 0.0f;
	float ltime = time + localtime;


	// Move the balls !

	balls[0].x = sin( ltime * deuxpi * 2.0f + 1.0f ) * cos( ltime * deuxpi * 3.0f + 2 ) + 1.0f; 
	balls[1].x = sin( ltime * deuxpi * 3.0f - 1.0f ) * cos( ltime * deuxpi * 2.0f - 2 ) + 1.0f; 
	balls[2].x = sin( ltime * deuxpi * 5.0f + 2.0f ) * cos( ltime * deuxpi * 3.0f + 2 ) + 1.0f; 
//	balls[3].x = sin( ltime * deuxpi * 7.0f - 2.0f ) * cos( ltime * deuxpi * 2.0f - 2 ) + 1.0f; 

	balls[0].y = ( sin( ltime * deuxpi * 2.0f + 2.0f ) * cos( ltime * deuxpi * 4.0f - 1.0f ) / 3.0f ) + 0.5f; 
	balls[1].y = ( sin( ltime * deuxpi * 3.0f - 1.0f ) * cos( ltime * deuxpi * 2.0f - 2.0f ) / 3.0f ) + 0.5f; 
	balls[2].y = ( sin( ltime * deuxpi * 4.0f + 7.0f ) * cos( ltime * deuxpi * 4.0f - 1.0f ) / 3.0f ) + 0.5f; 
//	balls[3].y = ( sin( ltime * deuxpi * 3.0f + 1.0f ) * cos( ltime * deuxpi * 2.0f - 2.0f ) / 3.0f ) + 0.5f; 

	balls[0].z = sin( ltime * deuxpi + 1.5f ) + 1.0f; 
	balls[1].z = sin( ltime * deuxpi * 4.0f - 1.0f ) + 1.0f; 
	balls[2].z = sin( ltime * deuxpi - 1.5f ) + 1.0f; 
//	balls[3].z = sin( ltime * deuxpi * 6.0f - 5.0f ) + 1.0f; 

	scale -= (scale - 1.0f) / 2.0f;

	// Setup viewport & opengl

	glLoadIdentity();
	glTranslatef( -0.5f, -0.5f, -5.0f * time );
	glRotatef( -time*30.0f , 0.0f, 1.0f, 0.0f);

	glColor4ub( 128, 128, 128 , 128);
	glEnable( GL_TEXTURE_2D );
	glBindTexture( GL_TEXTURE_2D , metatex );

	glEnable( GL_BLEND );
	glBlendFunc( GL_ONE, GL_ONE );


	// Calculate and render the stuff !

	glBegin( GL_QUADS );

	for ( j=0; j<sy; j++ )
	{
		posz = oposz;

		for ( k=0; k<sz; k++ )
		{
			posx = oposx;

			for ( i=0; i<sx; i++ )
			{
				for (l=0; l<MAX_BALLS; l++)
				{
					if ( l == 0 )
					{
						s[i][j][k] = 1.0f /  ( (posx-balls[0].x)*(posx-balls[0].x) +
											   (posy-balls[0].y)*(posy-balls[0].y) +
											   (posz-balls[0].z)*(posz-balls[0].z) );
					}
					else
					{
						if ( l < MAX_BALLS-1 )
						{
							s[i][j][k] += 1.0f / ((float) (posx-balls[l].x)*(posx-balls[l].x) +
												 		  (posy-balls[l].y)*(posy-balls[l].y) +
														  (posz-balls[l].z)*(posz-balls[l].z) );
						}
						else
						{
							if ( ( ( s[i][j][k] += 1.0f /  ((float)  (posx-balls[l].x)*(posx-balls[l].x) +
														 		  (posy-balls[l].y)*(posy-balls[l].y) +
																  (posz-balls[l].z)*(posz-balls[l].z) ) ) ) >= 6.0f )
							{

								if ( s[i][j][k] >= 16.0f )
								{
									sc = dx;
								}
								else
								{
									sc = (s[i][j][k] - 6.0f) / 100.0f;
								}

									glTexCoord2f( 0.0f , 0.0f );
									glVertex3f( posx , posy + sc , posz );
									glTexCoord2f( 1.0f , 0.0f );
									glVertex3f( posx + sc , posy + sc , posz );
									glTexCoord2f( 1.0f , 1.0f );
									glVertex3f( posx + sc , posy , posz );
									glTexCoord2f( 0.0f , 1.0f );
									glVertex3f( posx , posy , posz );
							
							}  // if ( s[i][j][k] >= 6.0f )


						}  // if ( l<MAX_BALLS-1 )

				
					}  // if ( l == 0 )


				}  // for (l=0; l<MAX_BALLS; l++)

				posx += dx;
			
			}  // for ( i=0; i<sx; i++ )

			posz += dz;

		}  // for ( k=0; k<sz; k++ )
		
		posy += dy;

	}  // for ( j=0; j<sy; j++ )

	glEnd();

}

/*
** PUSH_BASS 
** PUSH_PERC 
** PUSH_CYMB 
** PUSH_MELO  
*/

void fxMetaballs::Push(ud type, float value)
{
	if (type == PUSH_PERC)
		localtime += 0.01;
}


void fxMetaballs::DeInit()
{
	glDeleteTextures( 2, &metatex ); // Actually important if you don't want
							         // the textures to remain in video memory.
}



