/* TETRAHEDRA */
/* SoopaDoopa 2001 */

#include "eks7.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"
#include "vu.h"
#include "matrix.h"

static float posy;

extern unsigned int eks7_vucodebegin  __attribute__((section(".vudata")));
extern unsigned int eks7_vucodeend  __attribute__((section(".vudata")));
extern unsigned int eks7_vudatabegin  __attribute__((section(".vudata")));
extern unsigned int eks7_vudataend  __attribute__((section(".vudata")));

extern int128 eks7_e_start,eks7_e_delta,eks7_e_giftag,eks7_e_matrix,eks7_e_light   __attribute__((section(".vudata")));
extern int128 eks7_e_stack   __attribute__((section(".vudata")));
extern fvec eks7_e_sinedata,eks7_e_sinetable[16]  __attribute__((section(".vudata")));
extern fvec eks7_e_sinevec1,eks7_e_sinevec2,eks7_e_sinemul  __attribute__((section(".vudata")));
extern ivec eks7_e_maxkicks  __attribute__((section(".vudata")));
extern fvec eks7_e_col1[8]  __attribute__((section(".vudata")));
extern ivec eks7_e_dep  __attribute__((section(".vudata")));

static fvec ver(float x, float y, float z)
{
	fvec v;

	v.x=x;
	v.y=y;
	v.z=z;
	v.w=1.0;

	v.x=0;
	v.y=0;
	v.z=0;
	v.w=0;

	return v;
}

static ivec fac(int x, int y, int z)
{
	ivec v;

	v.x=x;
	v.y=y;
	v.z=z;
	v.w=0;

	v.x=0;
	v.y=0;
	v.z=0;
	v.w=0;

	return v;
}

static float angle;

static void vutest(float frames)
{
	int x,y;
	float s;
	fmatrix M;
	gif_env;
	fvec norlist[4];
	fvec nordestlist[4];

	norlist[0]=new_fvec(1,1,0);
	norlist[1]=new_fvec(-1,0,-1);
	norlist[2]=new_fvec(-1,0,1);
	norlist[3]=new_fvec(1,-1,0);

	angle=0.005*2*frames;

	vu1_wait();

	vu1_uploadcode(&eks7_vucodebegin,&eks7_vucodeend);

	vu1_cleardata();

	{
		ivec *f;
		float a=0.5;
		float b=0.87;
		float c=0.25;
		fvec *v;
		int t;

		v=((fvec*)vu1_mem)+20;

		v[0]=ver(1.0,0,c);
		v[1]=ver(a,b,c);
		v[2]=ver(-a,b,c);
		v[3]=ver(-1.0,0,c);
		v[4]=ver(-a,-b,c);
		v[5]=ver(a,-b,c);
		v[6]=ver(1.0,0,-c);
		v[7]=ver(a,b,-c);
		v[8]=ver(-a,b,-c);
		v[9]=ver(-1.0,0,-c);
		v[10]=ver(-a,-b,-c);
		v[11]=ver(a,-b,-c);

		v[12]=ver(0,0,1);
		v[13]=ver(b,a,0);
		v[14]=ver(0,1,0);
		v[15]=ver(-b,a,0);
		v[16]=ver(-b,-a,0);
		v[17]=ver(0,-1,0);
		v[18]=ver(b,-a,0);
		v[19]=ver(0,0,-1);
//		v[20]=ver(0,0,1);


		f=((ivec*)vu1_mem)+50;

		f[0]=fac(3,4,12);
		f[1]=fac(2,5,12);
		f[2]=fac(1,0,12);
		f[3]=fac(0,6,13);
		f[4]=fac(1,7,13);
		f[5]=fac(2,8,14);
		f[6]=fac(3,9,15);
		f[7]=fac(4,10,16);
		f[8]=fac(5,11,17);
		f[9]=fac(0,6,18);
		f[10]=fac(6,7,19);
		f[11]=fac(11,8,19);
		f[12]=fac(10,9,19);


		eks7_e_giftag.hi=0x551;
		eks7_e_giftag.lo=0x2102400000008000;
//		eks7_e_giftag.lo=0x2002400000008000;
//		eks7_e_giftag.lo=0x2022400000008000;

		for(t=0;t<MATH_N;t++)
		{
			eks7_e_sinetable[t].x=math_sinetable[t][3];
			eks7_e_sinetable[t].y=math_sinetable[t][2];
			eks7_e_sinetable[t].z=math_sinetable[t][1];
			eks7_e_sinetable[t].w=math_sinetable[t][0];
		}
		
		eks7_e_sinedata.x=MATH_N/(2*3.1415926536);
		eks7_e_sinedata.y=4000;
		eks7_e_sinedata.z=(2*3.1415926536)/MATH_N;
		eks7_e_sinedata.w=angle*2;


		eks7_e_sinevec1.x=0;
		eks7_e_sinevec1.y=cos(angle*0.9)*16*cos(angle*0.005);
		eks7_e_sinevec1.z=sin(angle*0.9)*9;
		eks7_e_sinevec1.w=0.8*angle;

		eks7_e_sinevec2.x=sin(angle)*8;
		eks7_e_sinevec2.y=cos(angle)*7;
		eks7_e_sinevec2.z=0;
		eks7_e_sinevec2.w=0.9*angle;

		eks7_e_sinemul.x=0.2;
		eks7_e_sinemul.y=0.5;
		eks7_e_sinemul.z=0;
		eks7_e_sinemul.w=1.5;

		{
			static int i;
			i++;
			eks7_e_maxkicks.x=-i*i/40.0;
			eks7_e_maxkicks.x=-1024;
//			eks7_e_maxkicks.x=-1;
		}

		vu1_uploaddata(&eks7_vudatabegin,&eks7_vudataend);
	}


	s=1.8-0.7*cos(frames*0.02);

	{
		resetmatrixf(&M);
		scalematrixf(&M,s,s,s);
		scalematrixf(&M,170,170,170);
		scalematrixf(&M,1,320.0/256,1);
		movematrixf(&M,0,0,2000);
		movematrixf(&M,0,20*posy,0);

		M.xu+=0.5*M.zu;
		M.xv+=0.5*M.zv;
		M.xw+=0.5*M.zw;
		M.xx+=0.5*M.zz;
		M.yu+=0.5*M.zu;
		M.yv+=0.5*M.zv;
		M.yw+=0.5*M.zw;
		M.yy+=0.5*M.zz;

		scalematrixf(&M,640*16,256*16,1);

		M.xu+=32000*M.zu;
		M.xv+=32000*M.zv;
		M.xw+=32000*M.zw;
		M.xx+=32000*M.zz;
		M.yu+=32000*M.zu;
		M.yv+=32000*M.zv;
		M.yw+=32000*M.zw;
		M.yy+=32000*M.zz;
	}

	for(x=35;x<36;x+=2)
	for(y=20;y<21;y+=1)
	{
		fmatrix m,m2;
		fvec light;
		m=M;
		vu1_wait();

		resetmatrixf(&m2);
		frotatematrixyf(&m2,(angle*0.4+x*0.1));
		frotatematrixxf(&m2,(angle+y*0.2));

		transformf(&m2,norlist,nordestlist,4);
		{
			int t;
			for(t=0;t<4;t++)
			{
				float d=max(nordestlist[t].z*155,0);
				eks7_e_col1[t+3].x=d*d/255;
				eks7_e_col1[t+3].y=d*d/255;
				eks7_e_col1[t+3].z=d*d/255;
			}
		}


		fmovematrixf(&m,x-34.5,y-19.5,0);
		fscalematrixf(&m,5,5,5);
		fscalematrixf(&m,0.5,0.5,0.5);
		frotatematrixyf(&m,angle*0.4+x*0.1);
		frotatematrixxf(&m,angle+y*0.2);
		vu1_wait();

		vu1_wait();
		*((fmatrix*)&eks7_e_matrix)=m;
		*((fvec*)&eks7_e_light)=light;

		vu1_uploaddata2(&eks7_vudatabegin,&eks7_e_stack,&eks7_e_stack+5);
		vu1_uploaddata2(&eks7_vudatabegin,&eks7_e_matrix,&eks7_e_matrix+4);
		vu1_uploaddata2(&eks7_vudatabegin,&eks7_e_light,&eks7_e_light+1);
		vu1_uploaddata2(&eks7_vudatabegin,&eks7_e_col1,&eks7_e_col1+8);

		vu1_start();
		vu1_wait();

	}
}


void eks7_init()
{
}

void eks7_init2()
{
}

extern int PAL;

void eks7_frame(float frames)
{
	posy=160*(1-cos(0.04*min(-30+frames,0)));
	posy+=160*(1-cos(0.03*max(frames-550,0)));

	if(PAL)
		eks7_e_dep.x=min(3+frames/40,7);
	else
		eks7_e_dep.x=min(3+frames/40,6);
	vutest(frames);
}

void eks7_deinit()
{
}
