/* Logo and bars and credits */
/* SoopaDoopa 2001 */

#include "eks1.h"
#include "gif.h"
#include "dma.h"
#include "texture.h"
#include "math.h"

extern char binary_dot_start[];
extern char binary_logo_start[];
extern char binary_logo_alpha_start[];
extern char binary_fslogo_start[];

extern char binary_mainbg1_start[];
extern char binary_mainbg1_alpha_start[];
extern char binary_mainbg2_start[];
extern char binary_mainbg2_alpha_start[];

extern char binary_druckluft_start[];
extern char binary_druckluft_a_start[];

extern char binary_gibson_start[];
extern char binary_gibson_a_start[];

static int128	list[40];

static texture tex1;
static texture fslogo;
static texture druckluft,gibson;
static texture bar1,bar2;

static void puttexture(texture *tex, float posx, float posy, float width, float height)
{
	int x1=32000+(posx-width*0.5)*16;
	int y1=32000+(posy-height*0.5)*16;
	int x2=32000+(posx+width*0.5)*16;
	int y2=32000+(posy+height*0.5)*16;
	
	gif_env;
	
	dma_begingp();
	gif_tag(0xe,1,0,0,0);

	gPRMODECONT(1);				// refer to prim attributes
	gCOLCLAMP(1);
	gCLAMP_1(0x1000010005);
	gALPHA_1(0x4000000044);
	gDTHE(0);				// Dither off
	gTEX0_1(texture_TEX0(tex));
	gTEX1_1(1<<5);				//bilinear
	gTEST_1(0x30000);
	gPRIM(0x116+0x40);
	gPABE(0);
	gRGBAQ(0x3F80000080808080);		// Background RGBA
	gUV(hhw(0,0));
	gXYZ2(hhw(x1,y1));
	gUV(hhw((tex->width)*16,(tex->height)*16));
	gXYZ2(hhw(x2,y2));
	gif_endfinal();

	dma_endgp();
}

static void puttexture2(texture *tex, float posx, float posy, float width, float height, int alpha)
{
	int x1=32000+(posx-width*0.5)*16;
	int y1=32000+(posy-height*0.5)*16;
	int x2=32000+(posx+width*0.5)*16;
	int y2=32000+(posy+height*0.5)*16;
	
	gif_env;

	dma_begingp();
	gif_tag(0xe,1,0,0,0);

	gPRMODECONT(1);				// refer to prim attributes
	gCOLCLAMP(1);
	gCLAMP_1(0x1000010005);
	gALPHA_1(0x4000000048);
	gDTHE(0);				// Dither off

	gTEX0_1(texture_TEX0(tex));
	gTEX1_1(1<<5);				//bilinear

	gTEST_1(0x30000);
	gPRIM(0x116+0x40);
	gPABE(0);
	gRGBAQ(0x3F80000000808080+(alpha<<24));		// Background RGBA
	gUV(hhw(0,0));
	gXYZ2(hhw(x1,y1));
	gUV(hhw((tex->width)*16,(tex->height)*16));
	gXYZ2(hhw(x2,y2));
	gif_endfinal();

	dma_endgp();
}


void eks1_init()
{
	texture_init(&tex1);
	texture_load(&tex1,binary_logo_start);
	texture_init(&fslogo);
	texture_load(&fslogo,binary_fslogo_start);
	texture_loadalpha(&tex1,binary_logo_alpha_start);
	texture_init(&bar1);
	texture_load(&bar1,binary_mainbg1_start);
	texture_loadalpha(&bar1,binary_mainbg1_alpha_start);
	texture_init(&bar2);
	texture_load(&bar2,binary_mainbg2_start);
	texture_loadalpha(&bar2,binary_mainbg2_alpha_start);

	texture_init(&gibson);
	texture_load(&gibson,binary_gibson_start);
	texture_loadalpha(&gibson,binary_gibson_a_start);
	texture_init(&druckluft);
	texture_load(&druckluft,binary_druckluft_start);
	texture_loadalpha(&druckluft,binary_druckluft_a_start);


	// nu fikser vi farverne i logoet, s der ikke er forskel i styrke mellem at motion blure og ikke motion blure

	{
		int x,y;
		for(y=0;y<tex1.height;y++)
		for(x=0;x<tex1.width;x++)
		{
			tex1.image[y*tex1.width+x]&=0xfff0f0f0;
			tex1.image[y*tex1.width+x]+=0x01000000;
		}
	}
}

extern int PAL;
static float tex1height;
static float yoffset;
static float yoffset2;

void eks1_init2()
{
	texture_allocupload(&tex1);
	texture_allocupload(&fslogo);
	texture_allocupload(&bar1);
	texture_allocupload(&bar2);
	texture_allocupload(&gibson);
	texture_allocupload(&druckluft);

	if(PAL)
	{
		tex1height=tex1.height;
		yoffset=0;
		yoffset2=0;
	}
	else
	{
		tex1height=tex1.height;
//		yoffset=+14;
		yoffset=+28;
		yoffset2=-10;
	}
}

static void pos(float frames, float *x, float *y, float *sx, float *sy)
{
	float x_=320;
	float y_=32+2+yoffset;
	float sx_=tex1.width;
	float sy_=tex1height/2;

	if(frames<3000)
	{
		*x=320-(240+max(0,140-frames*0.5)*max(0,140-frames*0.5))*cos((frames)*0.03);
		*y=128+50*sin((frames)*0.03),1500+600*sin((frames)*0.03);
		*sx=1500+min(2*frames,500)*sin((frames)*0.04);
		*sy=167;
	}
	else if(frames<400)
	{
		*x=320+max(10090-10*frames,350)*sin((frames)*0.02);
		*y=128+50*sin((frames)*0.03),1500+600*sin((frames)*0.03);
		*sx=1500+600*sin((frames)*0.03);
		*sy=167;
	}

	{
		float mix=0.5+0.5*cos(min(3.1415,max(0,0.03*(frames-400))));
		float mix_=1-mix;
		
		*x=*x*mix+x_*mix_;
		*y=*y*mix+y_*mix_;
		*sx=*sx*mix+sx_*mix_;
		*sy=*sy*mix+sy_*mix_;
	}

	if(*x<-800)*x=-800;
	if(*x>1260)*x=1260;
	if(*y<-1000)*y=-1000;
	if(*y>1000)*y=1000;
}

void eks1_frame(float frames)
{
	// draw logo and bars or
	// animated and motionblured logo
	float thorsten=0.007*2;

	int t;

	if(frames>550)
	{
		float pos=min(70,frames-550);
		
		puttexture(&bar1,320,pos-35,bar1.width*10,bar1.height/2);
		puttexture(&bar2,320,256-(pos-(70-16))+yoffset2,bar2.width*10,bar2.height/2);
		puttexture(&tex1,320,yoffset+32+2,tex1.width,tex1height/2);
	}
	else
	for(t=0;t<16;t++)
	{
		float x,y;
		float sx,sy;
			
		pos(frames+t*thorsten*20,&x,&y,&sx,&sy);
		puttexture2(&tex1,x,y,sx,sy,8);

	}
}

void eks1_frame2(float frames)
{
	//funslower logo falling down
	puttexture2(&fslogo,320,min(max(0,frames-00)*12-146,146),fslogo.width,fslogo.height/2,128);
}


void eks1_frame3(float frames)
{
	// the credits
	float x1,y1,z1;
	float x2,y2,z2;
	
	float angle=21*cos2(frames*0.006);

	float radius=160+10*max(0,frames-1070);
	
	x1=320-radius*sin2(angle);
	x2=320+radius*sin2(angle);
	z1=400-160*cos2(angle);
	z2=400+160*cos2(angle);

	z1=400/z1;
	z2=400/z2;

	if(z1<z2)
	{
		puttexture(&gibson,x1,min(max(0,frames-00)*12-146,146),gibson.width*z1,gibson.height/2*z1);
		puttexture(&druckluft,x2,min(max(0,frames-00)*12-146,146),druckluft.width*z2,druckluft.height/2*z2);
	}
	else
	{
		puttexture(&druckluft,x2,min(max(0,frames-00)*12-146,146),druckluft.width*z2,druckluft.height/2*z2);
		puttexture(&gibson,x1,min(max(0,frames-00)*12-146,146),gibson.width*z1,gibson.height/2*z1);
	}
}

void eks1_deinit()
{
}

void eks1_drawlogo(float a, int d)
{
	//draw the soopadoopa logo and bars (animated)
// 0 ind
// 50 ud

	static float b;
	float c;
	
	if(a<b)b--;
	if(a>b)b++;
	
	c=b*b/30;
	
	puttexture(&bar1,320,35-c,bar1.width*10,bar1.height/2);
	puttexture(&bar2,320,256-16+c+yoffset2,bar2.width*10,bar2.height/2);
	puttexture(&tex1,320,yoffset+32+2-c*d*2,tex1.width,tex1height/2);
}