// sergio jimenez
// elfhood / rgba, for durango party 2

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <math.h>


#define PI      3.141592653589
#define GRD     PI/180


unsigned char* vga = ( unsigned char* ) 0xa0000;
unsigned char* buffer;
unsigned char* blur;
unsigned char* sprite;
unsigned char* pallette;




void SetMode ( unsigned short mode );
    #pragma aux SetMode =\
    "int 0x10"\
    parm[ax];


void VSync ( void )
{

		while ( inp(0x3DA)&8 );
		while ( !(inp(0x3DA)&8) );

    //de nada iq... ;)


}


void SetPal ( unsigned char* pal )
{

    unsigned short int i;

		outp ( 0x3C8, 0 );
    
		for ( i = 0; i<768; i++ )
            outp ( 0x3C9, *(pal+i) );

}

void GenerarPaleta ( unsigned char* pal )
{
    unsigned short int cont, aux;
		
		
		
		for ( cont = 0; cont<256; cont++ )
		{
			
            *( pal + (cont*3)+0 ) = 32 + ( 31*sin( (cont+50)*PI/150) );
            *( pal + (cont*3)+1 ) = 32 + ( 31*sin( (cont+30)*PI/120) );
			*( pal + (cont*3)+2 ) = 42 + ( 21*sin( (cont+30)*PI/380) );
		}

}


void DoPlasma ( short int cx, short int cy, short int c2x, short int c2y )
{

    short int j, i, x, y, dx, dy, dx2, dy2;

    float aux_x, aux_y;

    float dist, dist2;
    float ang;

        ang = 0;

        for ( j = -100; j<100; j++ )
        {
            for ( i = -160; i<160; i++ )
            {
                //ang++;

                //aux_x = ang - i;
                //aux_y = ang - j;


                dx = cx - i;
                dy = cy - j;

                dist = sqrt( (dx*dx) + (dy*dy) );


                dx2 = c2x - dx;
                dy2 = c2y - dy;

                dist2 = sqrt ( (dx2*dx2) + (dy2*dy2) );



                x = i + 160;
                y = j + 100;

                buffer[x+(y*320)] = 128 + (64*sin(dist*GRD)*cos(dist2*GRD))+ (64*cos(dist2*GRD)*sin(dist*GRD));


            }
        }


}

void DoRotoZ ( float angle, float k )
{

    short int i, j, xscr, yscr, xspr, yspr;
    float rotx, roty;


        for ( j = -100; j<100; j++ )
            for ( i = -160; i<160; i++ )
            {

                rotx = k*(cos(angle)*i - sin(angle)*j);
                roty = k*(sin(angle)*i + cos(angle)*j);

                if ( k )
                {
                    xspr = rotx + 160;
                    yspr = roty + 100;
                }

                if ( xspr<0 )
                    xspr = 320 + xspr%320;

                if ( yspr<0 )
                    yspr = 200 + yspr%200;

                if ( xspr>=320 )
                    xspr = xspr%320;

                if ( yspr>=200 )
                    yspr = yspr%200;

                xscr = i + 160;
                yscr = j + 100;


                buffer[xscr+(yscr*320)] = sprite[xspr+(yspr*320)];

            }



}



void main ( void )
{

    float angle, angle2, acel;
    short int cx, cy, c2x, c2y;
    unsigned short int cont;
    float k;

        system( "cls" );


        buffer = ( unsigned char* ) malloc(64000);
        if ( buffer == NULL )
        {
            SetMode( 0x0003);
            printf( "\nError al asignar mem, buffer" );
            exit( -1 );
        }

        blur = ( unsigned char* ) malloc(64000);
        if ( blur == NULL )
        {
            SetMode( 0x0003);
            printf( "\nError al asignar mem, blur" );
            exit( -1 );
        }


        sprite = ( unsigned char* ) malloc(64000);
        if ( sprite == NULL )
        {
            SetMode( 0x0003);
            printf( "\nError al asignar mem, sprite" );
            exit( -1 );
        }

        pallette = ( unsigned char* ) malloc(768);
        if ( pallette == NULL )
        {
            SetMode( 0x0003);
            printf( "\nError al asignar mem, pallette" );
            exit( -1 );
        }



        GenerarPaleta( pallette );


        SetMode( 0x0013 );
        SetPal( pallette );


        angle = 0;
        angle2 = 0;
        acel = 0;

        do
        {
            acel += GRD*4;
            angle = PI + (PI*sin(acel));
            angle2 = angle + (sin(angle)*cos(acel));

            k = 2. + (1.5*sin(angle));

            cx = 160 + (20*cos(angle)*sin(angle2));
            cy = 100 + (20*sin(angle));

            c2x = cx + (60*cos(angle2));
            c2y = cy + (90*sin(angle)*cos(angle));

            DoPlasma( cx, cy, c2x, c2y );

            memcpy( sprite, buffer, 64000 );

            DoRotoZ( angle, k );

            for ( cont = 0; cont<64000; cont++ )
                blur[cont] = (blur[cont] + buffer[cont])>>1;


            VSync();
            memcpy( vga, blur, 64000 );
            memset( buffer, 0, 64000 );

        }while( !kbhit() );



        free( buffer );
        free( blur );
        free( sprite );
        free( pallette );

        SetMode( 0x0003 );

        printf ( "\nanother pieze of lame code...\nby:...\nelfhood / rgba\n\ndurango party 2\n\n\n" );

}
