; <true mapper>

segment code32 use32

%define TRUEMAP

%include "truemap.inc"

;----------------------------------------------------------------------------
align 32
;----------------------------------------------------------------------------
Clip
    .XR  dw 320 ; X right
    .XL  dw 0   ; X left
    .YU  dw 0   ; Y up
    .YD  dw 200 ; Y down
;----------------------------------------------------------------------------
align 32
;----------------------------------------------------------------------------
; structure of a Perspective Corrected Texture Mapper (Gouraud shaded + Arbitrary-Tiled)
mapper
        .Xreso        dw 320 ; screen X resolution

        .map          dd 0   ; address of texture
        .screen       dd 0   ; address of screen
        .shadetable   dd 0   ; address of shade table

         .setup        dd 0   ; linear address of texture + shadetable setup (call this for setup)
        .drawpoly     dd 0   ; linear address of polygon drawer routine (call this to put the polygon)
;----------------------------------------------------------------------------
align 32
;----------------------------------------------------------------------------
vertex1
        .Y  dw 0
        .X  dw 0
        .Z  dw 0
        .S  dw 0
        .Xtile  db 0
        .Ytile  db 0

        .perZ  dd 0
        .UperZ dd 0
        .VperZ dd 0
vertex2
        .Y  dw 0
        .X  dw 0
        .Z  dw 0
        .S  dw 0
        .Xtile  db 0
        .Ytile  db 0

        .perZ  dd 0
        .UperZ dd 0
        .VperZ dd 0
vertex3
        .Y  dw 0
        .X  dw 0
        .Z  dw 0
        .S  dw 0
        .Xtile  db 0
        .Ytile  db 0

        .perZ  dd 0
        .UperZ dd 0
        .VperZ dd 0
;----------------------------------------------------------------------------
align 32
;----------------------------------------------------------------------------
a
  .X.XF     dd 0
  .X.WD     dd 0
  .perZ     dd 0
  .perZ.D   dd 0
  .perZ.F   dd 0
  .perZ.W   dd 0
  .UperZ    dd 0
  .UperZ.D  dd 0
  .UperZ.F  dd 0
  .UperZ.W  dd 0
  .VperZ    dd 0
  .VperZ.D  dd 0
  .VperZ.F  dd 0
  .VperZ.W  dd 0
  .S.SF     dd 0
  .S.WD     dd 0
b
  .X.XF     dd 0
  .X.WD     dd 0
  .perZ     dd 0
  .perZ.D   dd 0
  .perZ.F   dd 0
  .perZ.W   dd 0
  .UperZ    dd 0
  .UperZ.D  dd 0
  .UperZ.F  dd 0
  .UperZ.W  dd 0
  .VperZ    dd 0
  .VperZ.D  dd 0
  .VperZ.F  dd 0
  .VperZ.W  dd 0
  .S.SF     dd 0
  .S.WD     dd 0
c
  .X.XF     dd 0
  .X.WD     dd 0
  .perZ     dd 0
  .perZ.D   dd 0
  .perZ.F   dd 0
  .perZ.W   dd 0
  .UperZ    dd 0
  .UperZ.D  dd 0
  .UperZ.F  dd 0
  .UperZ.W  dd 0
  .VperZ    dd 0
  .VperZ.D  dd 0
  .VperZ.F  dd 0
  .VperZ.W  dd 0
  .S.SF     dd 0
  .S.WD     dd 0
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
align 32
;----------------------------------------------------------------------------
; set up main datas for mapper (texture + shade table)
texture_shadetable_setup:
                     mov   ax,[mapper.Xreso]
                     mov   [put_scanline_LEFTtoRIGHT_first.SM_xreso+2],ax
                     mov   [put_scanline_LEFTtoRIGHT_second.SM_xreso+2],ax
                     mov   [put_scanline_RIGHTtoLEFT_first.SM_xreso+2],ax
                     mov   [put_scanline_RIGHTtoLEFT_second.SM_xreso+2],ax

                     mov   eax,[mapper.map]
                     mov   ebx,[mapper.shadetable]

                     mov   [put_scanline_LEFTtoRIGHT_first.SM_mem1+2],eax
                     mov   [put_scanline_LEFTtoRIGHT_first.SM_mem3+2],eax
                     mov   [put_scanline_LEFTtoRIGHT_second.SM_mem1+2],eax
                     mov   [put_scanline_LEFTtoRIGHT_second.SM_mem3+2],eax

                     mov   [put_scanline_RIGHTtoLEFT_first.SM_mem1+2],eax
                     mov   [put_scanline_RIGHTtoLEFT_first.SM_mem3+2],eax
                     mov   [put_scanline_RIGHTtoLEFT_second.SM_mem1+2],eax
                     mov   [put_scanline_RIGHTtoLEFT_second.SM_mem3+2],eax

                     mov   [put_scanline_LEFTtoRIGHT_first.SM_mem2+2],ebx
                     mov   [put_scanline_LEFTtoRIGHT_first.SM_mem4+2],ebx
                     mov   [put_scanline_LEFTtoRIGHT_second.SM_mem2+2],ebx
                     mov   [put_scanline_LEFTtoRIGHT_second.SM_mem4+2],ebx

                     mov   [put_scanline_RIGHTtoLEFT_first.SM_mem2+2],ebx
                     mov   [put_scanline_RIGHTtoLEFT_first.SM_mem4+2],ebx
                     mov   [put_scanline_RIGHTtoLEFT_second.SM_mem2+2],ebx
                     mov   [put_scanline_RIGHTtoLEFT_second.SM_mem4+2],ebx
                     ret
;----------------------------------------------------------------------------
align 32
;----------------------------------------------------------------------------
; perspective corrected texture mapper (gouraud shaded + arbitrary-tiled)
; only the structure is needed
put_true_gshaded_arbitrary_tiled_tmap:
;----------------------------------------------------------------------------
; exchange coordinates (SORT routine) by Y
                     mov   eax,[vertex1.Y] ; XXYY
                     mov   ebx,[vertex1.Z] ; -SZZ
                     mov   ecx,[vertex2.Y]
                     mov   edx,[vertex2.Z]
                     mov   esi,[vertex3.Y]
                     mov   edi,[vertex3.Z]

                     cmp   cx,si  ; 2-3
                     jle   .sort.noXCHG1
                     xchg  ecx,esi
                     xchg  edx,edi
                     push  word [vertex2.Xtile]
                     mov   ebp,[vertex3.Xtile]
                     pop   word [vertex3.Xtile]
                     mov   [vertex2.Xtile],ebp
.sort.noXCHG1:
                     cmp   ax,si  ; 1-3
                     jle   .sort.noXCHG2
                     xchg  eax,esi
                     xchg  ebx,edi
                     push  word [vertex1.Xtile]
                     mov   ebp,[vertex3.Xtile]
                     pop   word [vertex3.Xtile]
                     mov   [vertex1.Xtile],ebp
.sort.noXCHG2:
                     cmp   ax,cx  ; 1-2
                     jle   .sort.noXCHG3
                     xchg  eax,ecx
                     xchg  ebx,edx
                     push  word [vertex1.Xtile]
                     mov   ebp,[vertex2.Xtile]
                     pop   word [vertex2.Xtile]
                     mov   [vertex1.Xtile],ebp
.sort.noXCHG3:
                     mov   [vertex1.Y],eax ; XXYY
                     mov   [vertex1.Z],ebx ; -SZZ
                     mov   [vertex2.Y],ecx
                     mov   [vertex2.Z],edx
                     mov   [vertex3.Y],esi
                     mov   [vertex3.Z],edi
;----------------------------------------------------------------------------
; (1/Z, U/Z, V/Z calculation)
; calculation for vertex 1
                     xor   ebx,ebx
                     xor   edx,edx
                     mov   bx,word [vertex1.Z]
                     or    eax,-1
                     div   ebx     ; 1/Z * 2^32                   (1/Z)
                     mov   [vertex1.perZ],eax

                     xor   ebx,ebx
                     mov   bl,[vertex1.Xtile]
                     inc   bx
                     imul  ebx,eax
                     mov   [vertex1.UperZ],ebx ; 1/Z * 2^32 * U   (U/Z)

                     xor   ebx,ebx
                     mov   bl,[vertex1.Ytile]
                     inc   bx
                     imul  ebx,eax
                     mov   [vertex1.VperZ],ebx ; 1/Z * 2^32 * V   (V/Z)
; calculation for vertex 2
                     xor   ebx,ebx
                     xor   edx,edx
                     mov   bx,word [vertex2.Z]
                     or    eax,-1
                     div   ebx     ; 1/Z * 2^32                   (1/Z)
                     mov   [vertex2.perZ],eax

                     xor   ebx,ebx
                     mov   bl,[vertex2.Xtile]
                     inc   bx
                     imul  ebx,eax
                     mov   [vertex2.UperZ],ebx ; 1/Z * 2^32 * U   (U/Z)

                     xor   ebx,ebx
                     mov   bl,[vertex2.Ytile]
                     inc   bx
                     imul  ebx,eax
                     mov   [vertex2.VperZ],ebx ; 1/Z * 2^32 * V   (V/Z)
; calculation for vertex 3
                     xor   ebx,ebx
                     xor   edx,edx
                     mov   bx,word [vertex3.Z]
                     or    eax,-1
                     div   ebx     ; 1/Z * 2^32                   (1/Z)
                     mov   [vertex3.perZ],eax

                     xor   ebx,ebx
                     mov   bl,[vertex3.Xtile]
                     inc   bx
                     imul  ebx,eax
                     mov   [vertex3.UperZ],ebx ; 1/Z * 2^32 * U   (U/Z)

                     xor   ebx,ebx
                     mov   bl,[vertex3.Ytile]
                     inc   bx
                     imul  ebx,eax
                     mov   [vertex3.VperZ],ebx ; 1/Z * 2^32 * V   (V/Z)
;----------------------------------------------------------------------------
; (perZ.W.D.F, UperZ.W.D.F, VperZ.W.D.F, X.WD.XF, S.WD.XF calculation)
; interpolation for side a
                     xor   ebp,ebp
                     mov   bp,[vertex3.Y]
                     sub   bp,[vertex1.Y]
                     jz    near .skipIPforside.a
; 1/Z
                     xor   edx,edx
                     mov   eax,[vertex3.perZ]
                     sub   eax,[vertex1.perZ]
                     jnc   .noperZca
                     not   edx
.noperZca:
                     idiv  ebp
                     mov   [a.perZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [a.perZ.D],eax
                     mov   eax,[vertex1.perZ]
                     mov   dword [a.perZ.F],0
                     mov   [a.perZ],eax
; U/Z
                     xor   edx,edx
                     mov   eax,[vertex3.UperZ]
                     sub   eax,[vertex1.UperZ]
                     jnc   .noUperZca
                     not   edx
.noUperZca:
                     idiv  ebp
                     mov   [a.UperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [a.UperZ.D],eax
                     mov   eax,[vertex1.UperZ]
                     mov   dword [a.UperZ.F],0
                     mov   [a.UperZ],eax
; V/Z
                     xor   edx,edx
                     mov   eax,[vertex3.VperZ]
                     sub   eax,[vertex1.VperZ]
                     jnc   .noVperZca
                     not   edx
.noVperZca:
                     idiv  ebp
                     mov   [a.VperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [a.VperZ.D],eax
                     mov   eax,[vertex1.VperZ]
                     mov   dword [a.VperZ.F],0
                     mov   [a.VperZ],eax
; X
                     mov   ax,[vertex3.X]
                     sub   ax,[vertex1.X]
                     shl   eax,16
                     cdq
                     idiv  ebp
                     mov   [a.X.WD],eax
                     mov   ax,[vertex1.X]
                     shl   eax,16
                     mov   [a.X.XF],eax
; S
                     mov   al,[vertex3.S]
                     sub   al,[vertex1.S]
                     cbw
                     shl   eax,16
                     cdq
                     idiv  ebp
                     mov   [a.S.WD],eax
                     mov   ax,[vertex1.S]
                     shl   eax,16
                     mov   [a.S.SF],eax
.skipIPforside.a:
; interpolation for side b
                     xor   ebp,ebp
                     mov   bp,[vertex2.Y]
                     sub   bp,[vertex1.Y]
                     jz    near .skipIPforside.b
; 1/Z
                     xor   edx,edx
                     mov   eax,[vertex2.perZ]
                     sub   eax,[vertex1.perZ]
                     jnc   .noperZcb
                     not   edx
.noperZcb:
                     idiv  ebp
                     mov   [b.perZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [b.perZ.D],eax
                     mov   eax,[vertex1.perZ]
                     mov   dword [b.perZ.F],0
                     mov   [b.perZ],eax
; U/Z
                     xor   edx,edx
                     mov   eax,[vertex2.UperZ]
                     sub   eax,[vertex1.UperZ]
                     jnc   .noUperZcb
                     not   edx
.noUperZcb:
                     idiv  ebp
                     mov   [b.UperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [b.UperZ.D],eax
                     mov   eax,[vertex1.UperZ]
                     mov   dword [b.UperZ.F],0
                     mov   [b.UperZ],eax
; V/Z
                     xor   edx,edx
                     mov   eax,[vertex2.VperZ]
                     sub   eax,[vertex1.VperZ]
                     jnc   .noVperZcb
                     not   edx
.noVperZcb:
                     idiv  ebp
                     mov   [b.VperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [b.VperZ.D],eax
                     mov   eax,[vertex1.VperZ]
                     mov   dword [b.VperZ.F],0
                     mov   [b.VperZ],eax
; X
                     mov   ax,[vertex2.X]
                     sub   ax,[vertex1.X]
                     shl   eax,16
                     cdq
                     idiv  ebp
                     mov   [b.X.WD],eax
                     mov   ax,[vertex1.X]
                     shl   eax,16
                     mov   [b.X.XF],eax
; S
                     mov   al,[vertex2.S]
                     sub   al,[vertex1.S]
                     cbw
                     shl   eax,16
                     cdq
                     idiv  ebp
                     mov   [b.S.WD],eax
                     mov   ax,[vertex1.S]
                     shl   eax,16
                     mov   [b.S.SF],eax
.skipIPforside.b:
; interpolation for side c
                     xor   ebp,ebp
                     mov   bp,[vertex3.Y]
                     sub   bp,[vertex2.Y]
                     jz    near .skipIPforside.c
; 1/Z
                     xor   edx,edx
                     mov   eax,[vertex3.perZ]
                     sub   eax,[vertex2.perZ]
                     jnc   .noperZcc
                     not   edx
.noperZcc:
                     idiv  ebp
                     mov   [c.perZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [c.perZ.D],eax
                     mov   eax,[vertex2.perZ]
                     mov   dword [c.perZ.F],0
                     mov   [c.perZ],eax
; U/Z
                     xor   edx,edx
                     mov   eax,[vertex3.UperZ]
                     sub   eax,[vertex2.UperZ]
                     jnc   .noUperZcc
                     not   edx
.noUperZcc:
                     idiv  ebp
                     mov   [c.UperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [c.UperZ.D],eax
                     mov   eax,[vertex2.UperZ]
                     mov   dword [c.UperZ.F],0
                     mov   [c.UperZ],eax
; V/Z
                     xor   edx,edx
                     mov   eax,[vertex3.VperZ]
                     sub   eax,[vertex2.VperZ]
                     jnc   .noVperZcc
                     not   edx
.noVperZcc:
                     idiv  ebp
                     mov   [c.VperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [c.VperZ.D],eax
                     mov   eax,[vertex2.VperZ]
                     mov   dword [c.VperZ.F],0
                     mov   [c.VperZ],eax
; X
                     mov   ax,[vertex3.X]
                     sub   ax,[vertex2.X]
                     shl   eax,16
                     cdq
                     idiv  ebp
                     mov   [c.X.WD],eax
                     mov   ax,[vertex2.X]
                     shl   eax,16
                     mov   [c.X.XF],eax
; S
                     mov   al,[vertex3.S]
                     sub   al,[vertex2.S]
                     cbw
                     shl   eax,16
                     cdq
                     idiv  ebp
                     mov   [c.S.WD],eax
                     mov   ax,[vertex2.S]
                     shl   eax,16
                     mov   [c.S.SF],eax
.skipIPforside.c:
;----------------------------------------------------------------------------
; calculate direction (LEFTtoRIGHT or RIGHTtoLEFT)
; x1 - ((x1-x3)*(y2-y1)) / (y3-y1)
                     mov   ax,[vertex1.X]
                     sub   ax,[vertex3.X]
                     cwde
                     xor   ebx,ebx
                     mov   bx,[vertex2.Y]
                     sub   bx,[vertex1.Y]
                     xor   ecx,ecx
                     mov   cx,[vertex3.Y]
                     sub   cx,[vertex1.Y]
                     jnz   .noLtR_RtLnull
                     xor   ax,ax
                     jmp   short .LtR_RtLnull
.noLtR_RtLnull:
                     imul  eax,ebx

                     cdq
                     idiv  ecx
.LtR_RtLnull:
                     mov   bx,[vertex1.X]
                     sub   bx,ax

                     mov   byte [direction],0
                     cmp   bx,[vertex2.X]
                     jge   .noRIGHTtoLEFTdirection
                     inc   byte [direction]
.noRIGHTtoLEFTdirection:
;----------------------------------------------------------------------------
; put the FIRST piece of polygon
                     mov   ax,[vertex2.Y]
                     sub   ax,[vertex1.Y]
                     jz    near .noFIRSTpolygon
                     mov   [FIRSTpolygon.LGT],ax
                     mov   ax,[vertex1.Y]
                     mov   [FIRSTpolygon.curY],ax
;----------------------------------------------------------------------------
; Y clip
                     mov   ax,[FIRSTpolygon.curY]
                     cmp   ax,[Clip.YD]
                     jge   near .noSECONDpolygon
                     cmp   ax,[Clip.YU]
                     jge   near .noUPclip1

                     xor   ebp,ebp
                     mov   bp,[Clip.YU]
                     sub   bp,[FIRSTpolygon.curY]
                     mov   ax,[vertex2.Y]
                     cmp   ax,[Clip.YU]
                     jge   .noUPclip2
                     add   bp,ax
.noUPclip2:
; clip linear X
                     mov   eax,[a.X.WD]
                     imul  eax,ebp
                     add   [a.X.XF],eax

                     mov   eax,[b.X.WD]
                     imul  eax,ebp
                     add   [b.X.XF],eax
; clip linear S
                     mov   eax,[a.S.WD]
                     imul  eax,ebp
                     add   [a.S.SF],eax

                     mov   eax,[b.S.WD]
                     imul  eax,ebp
                     add   [b.S.SF],eax
; clip 1/Z
                     mov   eax,[a.perZ.D]
                     mul   ebp
                     mov   [a.perZ.F],eax
                     add   [a.perZ],edx
                     mov   eax,[a.perZ.W]
                     imul  eax,ebp
                     add   [a.perZ],eax

                     mov   eax,[b.perZ.D]
                     mul   ebp
                     mov   [b.perZ.F],eax
                     add   [b.perZ],edx
                     mov   eax,[b.perZ.W]
                     imul  eax,ebp
                     add   [b.perZ],eax
; clip U/Z
                     mov   eax,[a.UperZ.D]
                     mul   ebp
                     mov   [a.UperZ.F],eax
                     add   [a.UperZ],edx
                     mov   eax,[a.UperZ.W]
                     imul  eax,ebp
                     add   [a.UperZ],eax

                     mov   eax,[b.UperZ.D]
                     mul   ebp
                     mov   [b.UperZ.F],eax
                     add   [b.UperZ],edx
                     mov   eax,[b.UperZ.W]
                     imul  eax,ebp
                     add   [b.UperZ],eax
; clip V/Z
                     mov   eax,[a.VperZ.D]
                     mul   ebp
                     mov   [a.VperZ.F],eax
                     add   [a.VperZ],edx
                     mov   eax,[a.VperZ.W]
                     imul  eax,ebp
                     add   [a.VperZ],eax

                     mov   eax,[b.VperZ.D]
                     mul   ebp
                     mov   [b.VperZ.F],eax
                     add   [b.VperZ],edx
                     mov   eax,[b.VperZ.W]
                     imul  eax,ebp
                     add   [b.VperZ],eax

                     mov   ax,[FIRSTpolygon.curY]
                     add   ax,[FIRSTpolygon.LGT]
                     cmp   ax,[Clip.YU]
                     jle   near .noFIRSTpolygon

                     mov   ax,[Clip.YU]
                     mov   [FIRSTpolygon.curY],ax
                     sub   [FIRSTpolygon.LGT],bp
.noUPclip1:
;----------------------------------------------------------------------------
.FIRSTpolygon.loop:
                     cmp   byte [direction],0
                     jnz   .FIRSTpolygon.dirRtL
                     call  put_scanline_LEFTtoRIGHT_first
                     jmp   short .FIRSTpolygon.dirLtR
.FIRSTpolygon.dirRtL:
                     call  put_scanline_RIGHTtoLEFT_first
.FIRSTpolygon.dirLtR:
; interpolate datas for side a
                     mov   eax,[a.perZ.D]
                     mov   ebx,[a.perZ.W]
                     add   [a.perZ.F],eax
                     adc   [a.perZ],ebx
                     mov   eax,[a.UperZ.D]
                     mov   ebx,[a.UperZ.W]
                     add   [a.UperZ.F],eax
                     adc   [a.UperZ],ebx
                     mov   eax,[a.VperZ.D]
                     mov   ebx,[a.VperZ.W]
                     add   [a.VperZ.F],eax
                     adc   [a.VperZ],ebx
                     mov   eax,[a.S.WD]
                     add   [a.S.SF],eax
                     mov   eax,[a.X.WD]
                     add   [a.X.XF],eax
; interpolate datas for side b
                     mov   eax,[b.perZ.D]
                     mov   ebx,[b.perZ.W]
                     add   [b.perZ.F],eax
                     adc   [b.perZ],ebx
                     mov   eax,[b.UperZ.D]
                     mov   ebx,[b.UperZ.W]
                     add   [b.UperZ.F],eax
                     adc   [b.UperZ],ebx
                     mov   eax,[b.VperZ.D]
                     mov   ebx,[b.VperZ.W]
                     add   [b.VperZ.F],eax
                     adc   [b.VperZ],ebx
                     mov   eax,[b.S.WD]
                     add   [b.S.SF],eax
                     mov   eax,[b.X.WD]
                     add   [b.X.XF],eax
; FIRST polygon end side
                     inc   word [FIRSTpolygon.curY]
                     mov   ax,[FIRSTpolygon.curY]
                     cmp   ax,[Clip.YD]
                     jge   near .noSECONDpolygon
                     dec   word [FIRSTpolygon.LGT]
                     jnz   near .FIRSTpolygon.loop
.noFIRSTpolygon:
;----------------------------------------------------------------------------
; put the SECOND piece of polygon
                     mov   ax,[vertex3.Y]
                     sub   ax,[vertex2.Y]
                     jz    near .noSECONDpolygon
                     mov   [SECONDpolygon.LGT],ax
                     mov   ax,[vertex2.Y]
                     mov   [SECONDpolygon.curY],ax
;----------------------------------------------------------------------------
; Y clip
                     mov   ax,[SECONDpolygon.curY]
                     cmp   ax,[Clip.YD]
                     jge   near .noSECONDpolygon
                     cmp   ax,[Clip.YU]
                     jge   near .noUPclip4

                     xor   ebp,ebp
                     mov   bp,[Clip.YU]
                     sub   bp,[SECONDpolygon.curY]
                     mov   ax,[vertex3.Y]
                     cmp   ax,[Clip.YU]
                     jge   .noUPclip3
                     add   bp,ax
.noUPclip3:
; clip linear X
                     mov   eax,[a.X.WD]
                     imul  eax,ebp
                     add   [a.X.XF],eax

                     mov   eax,[c.X.WD]
                     imul  eax,ebp
                     add   [c.X.XF],eax
; clip linear S
                     mov   eax,[a.S.WD]
                     imul  eax,ebp
                     add   [a.S.SF],eax

                     mov   eax,[c.S.WD]
                     imul  eax,ebp
                     add   [c.S.SF],eax
; clip 1/Z
                     mov   eax,[a.perZ.D]
                     mul   ebp
                     mov   [a.perZ.F],eax
                     add   [a.perZ],edx
                     mov   eax,[a.perZ.W]
                     imul  eax,ebp
                     add   [a.perZ],eax

                     mov   eax,[c.perZ.D]
                     mul   ebp
                     mov   [c.perZ.F],eax
                     add   [c.perZ],edx
                     mov   eax,[c.perZ.W]
                     imul  eax,ebp
                     add   [c.perZ],eax
; clip U/Z
                     mov   eax,[a.UperZ.D]
                     mul   ebp
                     mov   [a.UperZ.F],eax
                     add   [a.UperZ],edx
                     mov   eax,[a.UperZ.W]
                     imul  eax,ebp
                     add   [a.UperZ],eax

                     mov   eax,[c.UperZ.D]
                     mul   ebp
                     mov   [c.UperZ.F],eax
                     add   [c.UperZ],edx
                     mov   eax,[c.UperZ.W]
                     imul  eax,ebp
                     add   [c.UperZ],eax
; clip V/Z
                     mov   eax,[a.VperZ.D]
                     mul   ebp
                     mov   [a.VperZ.F],eax
                     add   [a.VperZ],edx
                     mov   eax,[a.VperZ.W]
                     imul  eax,ebp
                     add   [a.VperZ],eax

                     mov   eax,[c.VperZ.D]
                     mul   ebp
                     mov   [c.VperZ.F],eax
                     add   [c.VperZ],edx
                     mov   eax,[c.VperZ.W]
                     imul  eax,ebp
                     add   [c.VperZ],eax

                     mov   ax,[SECONDpolygon.curY]
                     add   ax,[SECONDpolygon.LGT]
                     cmp   ax,[Clip.YU]
                     jle   near .noSECONDpolygon

                     mov   ax,[Clip.YU]
                     mov   [SECONDpolygon.curY],ax
                     sub   [SECONDpolygon.LGT],bp
.noUPclip4:
;----------------------------------------------------------------------------
.SECONDpolygon.loop:
                     cmp   byte [direction],0
                     jnz   .SECONDpolygon.dirRtL
                     call  put_scanline_LEFTtoRIGHT_second
                     jmp   short .SECONDpolygon.dirLtR
.SECONDpolygon.dirRtL:
                     call  put_scanline_RIGHTtoLEFT_second
.SECONDpolygon.dirLtR:
; interpolate datas for side a
                     mov   eax,[a.perZ.D]
                     mov   ebx,[a.perZ.W]
                     add   [a.perZ.F],eax
                     adc   [a.perZ],ebx
                     mov   eax,[a.UperZ.D]
                     mov   ebx,[a.UperZ.W]
                     add   [a.UperZ.F],eax
                     adc   [a.UperZ],ebx
                     mov   eax,[a.VperZ.D]
                     mov   ebx,[a.VperZ.W]
                     add   [a.VperZ.F],eax
                     adc   [a.VperZ],ebx
                     mov   eax,[a.S.WD]
                     add   [a.S.SF],eax
                     mov   eax,[a.X.WD]
                     add   [a.X.XF],eax
; interpolate datas for side c
                     mov   eax,[c.perZ.D]
                     mov   ebx,[c.perZ.W]
                     add   [c.perZ.F],eax
                     adc   [c.perZ],ebx
                     mov   eax,[c.UperZ.D]
                     mov   ebx,[c.UperZ.W]
                     add   [c.UperZ.F],eax
                     adc   [c.UperZ],ebx
                     mov   eax,[c.VperZ.D]
                     mov   ebx,[c.VperZ.W]
                     add   [c.VperZ.F],eax
                     adc   [c.VperZ],ebx
                     mov   eax,[c.S.WD]
                     add   [c.S.SF],eax
                     mov   eax,[c.X.WD]
                     add   [c.X.XF],eax
; FIRST polygon end side
                     inc   word [SECONDpolygon.curY]
                     mov   ax,[SECONDpolygon.curY]
                     cmp   ax,[Clip.YD]
                     jge   .noSECONDpolygon
                     dec   word [SECONDpolygon.LGT]
                     jnz   near .SECONDpolygon.loop
;----------------------------------------------------------------------------
.noSECONDpolygon:
                     ret
;----------------------------------------------------------------------------
FIRSTpolygon.curY  dw 0
FIRSTpolygon.LGT   dw 0
SECONDpolygon.curY dw 0
SECONDpolygon.LGT  dw 0
;----------------------------------------------------------------------------
direction          db 0
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
CYCL.LGT dw 0
;----------------------------------------------------------------------------
S        db 0 ; S struc
 .W      db 0
 .D      dw 0
 .F      dw 0
;----------------------------------------------------------------------------
perZ     dd 0 ; 1/Z struc
    .F   dd 0
    .W   dd 0
    .D   dd 0
UperZ    dd 0 ; U/Z struc
     .F  dd 0
     .W  dd 0
     .D  dd 0
VperZ    dd 0 ; V/Z struc
     .F  dd 0
     .W  dd 0
     .D  dd 0
;----------------------------------------------------------------------------








;----------------------------------------------------------------------------
; put scanline from LEFT to RIGHT - for the FIRST polygon
put_scanline_LEFTtoRIGHT_first:
;----------------------------------------------------------------------------
; check for endline + calculate XLGT
                     mov   ax,[b.X.XF+2]
                     mov   bx,[a.X.XF+2]
                     cmp   ax,[Clip.XR]
                     jge   near .endline
                     mov   bp,bx
                     cmp   bx,[Clip.XL]
                     jle   near .endline

                     sub   bp,ax          ; ebp = XLGT
                     jz    near .endline
                     js    near .endline
                     movsx ebp,bp
;----------------------------------------------------------------------------
; calculate starting address
                     xor   ebx,ebx
                     xor   eax,eax
                     mov   bx,[b.X.XF+2]
                     mov   ax,[FIRSTpolygon.curY]
.SM_xreso:           imul  edi,eax,320

                     cmp   bx,[Clip.XL]
                     jge   .noLEFTclip1
                     mov   bx,[Clip.XL]
.noLEFTclip1:
                     add   edi,ebx
                     add   edi,[mapper.screen]
;----------------------------------------------------------------------------
; calculate linear S interpolation
                     mov   ax,[a.S.SF+2]
                     mov   bx,[b.S.SF+2]
                     sub   ax,bx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     mov   [S.D],ax
                     shr   eax,8
                     mov   [S.W],ah
                     mov   ax,[b.S.SF+2]
                     mov   word [S.F],0
                     mov   [S],al
;----------------------------------------------------------------------------
; calculate 1/Z, U/Z, V/Z interpolations
; 1/Z interpolation
                     xor   edx,edx
                     mov   eax,[a.perZ]
                     sub   eax,[b.perZ]
                     jnc   .noperZc
                     not   edx
.noperZc:
                     idiv  ebp
                     mov   [perZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [perZ.D],eax
                     mov   eax,[b.perZ]
                     mov   dword [perZ.F],0
                     mov   [perZ],eax
; U/Z interpolation
                     xor   edx,edx
                     mov   eax,[a.UperZ]
                     sub   eax,[b.UperZ]
                     jnc   .noUperZc
                     not   edx
.noUperZc:
                     idiv  ebp
                     mov   [UperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [UperZ.D],eax
                     mov   eax,[b.UperZ]
                     mov   dword [UperZ.F],0
                     mov   [UperZ],eax
; V/Z interpolation
                     xor   edx,edx
                     mov   eax,[a.VperZ]
                     sub   eax,[b.VperZ]
                     jnc   .noVperZc
                     not   edx
.noVperZc:
                     idiv  ebp
                     mov   [VperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [VperZ.D],eax
                     mov   eax,[b.VperZ]
                     mov   dword [VperZ.F],0
                     mov   [VperZ],eax
;----------------------------------------------------------------------------
; LEFT clipping
                     xor   ebp,ebp
                     mov   bp,[b.X.XF+2]
                     cmp   bp,[Clip.XL]
                     jge   near .noLEFTclip2
                     mov   bp,[Clip.XL]
                     sub   bp,[b.X.XF+2]
; clip linear S
                     xor   ah,ah
                     mov   al,[S.W]
                     shl   eax,16
                     mov   ax,[S.D]
                     imul  eax,ebp
                     mov   [S.F],ax
                     shr   eax,8
                     add   [S],ah
; clip 1/Z
                     mov   eax,[perZ.D]
                     mul   ebp
                     mov   [perZ.F],eax
                     add   [perZ],edx
                     mov   eax,[perZ.W]
                     imul  eax,ebp
                     add   [perZ],eax
; clip U/Z
                     mov   eax,[UperZ.D]
                     mul   ebp
                     mov   [UperZ.F],eax
                     add   [UperZ],edx
                     mov   eax,[UperZ.W]
                     imul  eax,ebp
                     add   [UperZ],eax
; clip V/Z
                     mov   eax,[VperZ.D]
                     mul   ebp
                     mov   [VperZ.F],eax
                     add   [VperZ],edx
                     mov   eax,[VperZ.W]
                     imul  eax,ebp
                     add   [VperZ],eax
.noLEFTclip2:
;----------------------------------------------------------------------------
; calculate length of CYCL
                     mov   ax,[b.X.XF+2]
                     mov   bx,[a.X.XF+2]
                     cmp   ax,[Clip.XL]
                     jge   .noLEFTclip3
                     mov   ax,[Clip.XL]
.noLEFTclip3:
                     cmp   bx,[Clip.XR]
                     jle   .noRIGHTclip
                     mov   bx,[Clip.XR]
.noRIGHTclip:
                     sub   bx,ax
                     jz    near .endline
                     mov   [CYCL.LGT],bx
;----------------------------------------------------------------------------
; put the first pixel before the CYCL
                     mov   ebx,[perZ]
                     mov   ecx,[UperZ]
                     mov   esi,[VperZ]

                     xor   edx,edx
                     or    eax,-1
                     div   ebx
                     mov   ebp,eax  ; Z

                     xor   ebx,ebx

                     mov   eax,ecx
                     mul   ebp
                     mov   bl,dl    ; U
                     mov   eax,esi
                     mul   ebp
                     mov   bh,dl    ; V

                     mov   ax,[S.D]
.SM_mem1:            mov   bl,[12345678h+ebx]
                     add   [S.F],ax
                     mov   bh,[S]
.SM_mem2:            mov   al,[12345678h+ebx]
                     adc   bh,[S.W]
                     dec   word [CYCL.LGT]
                     mov   [edi],al
                     jz    near .endline
                     mov   [S],bh
;----------------------------------------------------------------------------
; CYCL
;----------------------------------------------------------------------------
.CYCL.loop:
;----------------------------------------------------------------------------
; interpolate 1/Z, U/Z, V/Z
                     mov   eax,[perZ.D]
                     mov   ebx,[perZ]
                     add   [perZ.F],eax
                     adc   ebx,[perZ.W]

                     mov   eax,[UperZ.D]
                     mov   ecx,[UperZ]
                     add   [UperZ.F],eax
                     adc   ecx,[UperZ.W]

                     mov   eax,[VperZ.D]
                     mov   esi,[VperZ]
                     add   [VperZ.F],eax
                     adc   esi,[VperZ.W]

                     mov   [perZ],ebx
                     mov   [UperZ],ecx
                     mov   [VperZ],esi
;----------------------------------------------------------------------------
; calculate U,V from Z
                     xor   edx,edx
                     or    eax,-1
                     div   ebx
                     mov   ebp,eax  ; Z

                     xor   ebx,ebx

                     mov   eax,ecx
                     mul   ebp
                     mov   bl,dl    ; U
                     mov   eax,esi
                     mul   ebp
                     mov   bh,dl    ; V
;----------------------------------------------------------------------------
                     mov   ax,[S.D]
.SM_mem3:            mov   bl,[12345678h+ebx]
                     add   [S.F],ax
                     mov   bh,[S]
                     inc   edi
.SM_mem4:            mov   al,[12345678h+ebx]
                     adc   bh,[S.W]
                     dec   word [CYCL.LGT]
                     mov   [edi],al

                     mov   [S],bh
                     jnz   near .CYCL.loop
;----------------------------------------------------------------------------
.endline:
                     ret
;----------------------------------------------------------------------------








;----------------------------------------------------------------------------
; put scanline from RIGHT to LEFT - for the FIRST polygon
put_scanline_RIGHTtoLEFT_first:
;----------------------------------------------------------------------------
; check for endline + calculate XLGT
                     mov   ax,[a.X.XF+2]
                     mov   bx,[b.X.XF+2]
                     cmp   ax,[Clip.XR]
                     jge   near .endline
                     mov   bp,bx
                     cmp   bx,[Clip.XL]
                     jle   near .endline

                     sub   bp,ax          ; ebp = XLGT
                     jz    near .endline
                     js    near .endline
                     movsx ebp,bp
;----------------------------------------------------------------------------
; calculate starting address
                     xor   ebx,ebx
                     xor   eax,eax
                     mov   bx,[b.X.XF+2]
                     mov   ax,[FIRSTpolygon.curY]
.SM_xreso:           imul  edi,eax,320

                     cmp   bx,[Clip.XR]
                     jle   .noRIGHTclip1
                     mov   bx,[Clip.XR]
.noRIGHTclip1:
                     add   edi,ebx
                     add   edi,[mapper.screen]
;----------------------------------------------------------------------------
; calculate linear S interpolation
                     mov   ax,[a.S.SF+2]
                     mov   bx,[b.S.SF+2]
                     sub   ax,bx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     mov   [S.D],ax
                     shr   eax,8
                     mov   [S.W],ah
                     mov   ax,[b.S.SF+2]
                     mov   word [S.F],0
                     mov   [S],al
;----------------------------------------------------------------------------
; calculate 1/Z, U/Z, V/Z interpolations
; 1/Z interpolation
                     xor   edx,edx
                     mov   eax,[a.perZ]
                     sub   eax,[b.perZ]
                     jnc   .noperZc
                     not   edx
.noperZc:
                     idiv  ebp
                     mov   [perZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [perZ.D],eax
                     mov   eax,[b.perZ]
                     mov   dword [perZ.F],0
                     mov   [perZ],eax
; U/Z interpolation
                     xor   edx,edx
                     mov   eax,[a.UperZ]
                     sub   eax,[b.UperZ]
                     jnc   .noUperZc
                     not   edx
.noUperZc:
                     idiv  ebp
                     mov   [UperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [UperZ.D],eax
                     mov   eax,[b.UperZ]
                     mov   dword [UperZ.F],0
                     mov   [UperZ],eax
; V/Z interpolation
                     xor   edx,edx
                     mov   eax,[a.VperZ]
                     sub   eax,[b.VperZ]
                     jnc   .noVperZc
                     not   edx
.noVperZc:
                     idiv  ebp
                     mov   [VperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [VperZ.D],eax
                     mov   eax,[b.VperZ]
                     mov   dword [VperZ.F],0
                     mov   [VperZ],eax
;----------------------------------------------------------------------------
; RIGHT clipping
                     xor   ebp,ebp
                     mov   bp,[b.X.XF+2]
                     cmp   bp,[Clip.XR]
                     jle   near .noRIGHTclip2
                     sub   bp,[Clip.XR]
; clip linear S
                     xor   ah,ah
                     mov   al,[S.W]
                     shl   eax,16
                     mov   ax,[S.D]
                     imul  eax,ebp
                     mov   [S.F],ax
                     shr   eax,8
                     add   [S],ah
; clip 1/Z
                     mov   eax,[perZ.D]
                     mul   ebp
                     mov   [perZ.F],eax
                     add   [perZ],edx
                     mov   eax,[perZ.W]
                     imul  eax,ebp
                     add   [perZ],eax
; clip U/Z
                     mov   eax,[UperZ.D]
                     mul   ebp
                     mov   [UperZ.F],eax
                     add   [UperZ],edx
                     mov   eax,[UperZ.W]
                     imul  eax,ebp
                     add   [UperZ],eax
; clip V/Z
                     mov   eax,[VperZ.D]
                     mul   ebp
                     mov   [VperZ.F],eax
                     add   [VperZ],edx
                     mov   eax,[VperZ.W]
                     imul  eax,ebp
                     add   [VperZ],eax
.noRIGHTclip2:
;----------------------------------------------------------------------------
; calculate length of CYCL
                     mov   ax,[a.X.XF+2]
                     mov   bx,[b.X.XF+2]
                     cmp   ax,[Clip.XL]
                     jge   .noRIGHTclip3
                     mov   ax,[Clip.XL]
.noRIGHTclip3:
                     cmp   bx,[Clip.XR]
                     jle   .noLEFTclip
                     mov   bx,[Clip.XR]
.noLEFTclip:
                     sub   bx,ax
                     jz    near .endline
                     mov   [CYCL.LGT],bx
;----------------------------------------------------------------------------
; put the first pixel before the CYCL
                     mov   ebx,[perZ]
                     mov   ecx,[UperZ]
                     mov   esi,[VperZ]

                     xor   edx,edx
                     or    eax,-1
                     div   ebx
                     mov   ebp,eax  ; Z

                     xor   ebx,ebx

                     mov   eax,ecx
                     mul   ebp
                     mov   bl,dl    ; U
                     mov   eax,esi
                     mul   ebp
                     mov   bh,dl    ; V

                     mov   ax,[S.D]
.SM_mem1:            mov   bl,[12345678h+ebx]
                     add   [S.F],ax
                     mov   bh,[S]
                     dec   edi
.SM_mem2:            mov   al,[12345678h+ebx]
                     adc   bh,[S.W]
                     dec   word [CYCL.LGT]
                     mov   [edi],al
                     jz    near .endline
                     mov   [S],bh
;----------------------------------------------------------------------------
; CYCL
;----------------------------------------------------------------------------
.CYCL.loop:
;----------------------------------------------------------------------------
; interpolate 1/Z, U/Z, V/Z
                     mov   eax,[perZ.D]
                     mov   ebx,[perZ]
                     add   [perZ.F],eax
                     adc   ebx,[perZ.W]

                     mov   eax,[UperZ.D]
                     mov   ecx,[UperZ]
                     add   [UperZ.F],eax
                     adc   ecx,[UperZ.W]

                     mov   eax,[VperZ.D]
                     mov   esi,[VperZ]
                     add   [VperZ.F],eax
                     adc   esi,[VperZ.W]

                     mov   [perZ],ebx
                     mov   [UperZ],ecx
                     mov   [VperZ],esi
;----------------------------------------------------------------------------
; calculate U,V from Z
                     xor   edx,edx
                     or    eax,-1
                     div   ebx
                     mov   ebp,eax  ; Z

                     xor   ebx,ebx

                     mov   eax,ecx
                     mul   ebp
                     mov   bl,dl    ; U
                     mov   eax,esi
                     mul   ebp
                     mov   bh,dl    ; V
;----------------------------------------------------------------------------
                     mov   ax,[S.D]
.SM_mem3:            mov   bl,[12345678h+ebx]
                     add   [S.F],ax
                     mov   bh,[S]
                     dec   edi
.SM_mem4:            mov   al,[12345678h+ebx]
                     adc   bh,[S.W]
                     dec   word [CYCL.LGT]
                     mov   [edi],al

                     mov   [S],bh
                     jnz   near .CYCL.loop
;----------------------------------------------------------------------------
.endline:
                     ret
;----------------------------------------------------------------------------








;----------------------------------------------------------------------------
; put scanline from LEFT to RIGHT - for the second polygon
put_scanline_LEFTtoRIGHT_second:
;----------------------------------------------------------------------------
; check for endline + calculate XLGT
                     mov   ax,[c.X.XF+2]
                     mov   bx,[a.X.XF+2]
                     cmp   ax,[Clip.XR]
                     jge   near .endline
                     mov   bp,bx
                     cmp   bx,[Clip.XL]
                     jle   near .endline

                     sub   bp,ax          ; ebp = XLGT
                     jz    near .endline
                     js    near .endline
                     movsx ebp,bp
;----------------------------------------------------------------------------
; calculate starting address
                     xor   ebx,ebx
                     xor   eax,eax
                     mov   bx,[c.X.XF+2]
                     mov   ax,[SECONDpolygon.curY]
.SM_xreso:           imul  edi,eax,320

                     cmp   bx,[Clip.XL]
                     jge   .noLEFTclip1
                     mov   bx,[Clip.XL]
.noLEFTclip1:
                     add   edi,ebx
                     add   edi,[mapper.screen]
;----------------------------------------------------------------------------
; calculate linear S interpolation
                     mov   ax,[a.S.SF+2]
                     mov   bx,[c.S.SF+2]
                     sub   ax,bx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     mov   [S.D],ax
                     shr   eax,8
                     mov   [S.W],ah
                     mov   ax,[c.S.SF+2]
                     mov   word [S.F],0
                     mov   [S],al
;----------------------------------------------------------------------------
; calculate 1/Z, U/Z, V/Z interpolations
; 1/Z interpolation
                     xor   edx,edx
                     mov   eax,[a.perZ]
                     sub   eax,[c.perZ]
                     jnc   .noperZc
                     not   edx
.noperZc:
                     idiv  ebp
                     mov   [perZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [perZ.D],eax
                     mov   eax,[c.perZ]
                     mov   dword [perZ.F],0
                     mov   [perZ],eax
; U/Z interpolation
                     xor   edx,edx
                     mov   eax,[a.UperZ]
                     sub   eax,[c.UperZ]
                     jnc   .noUperZc
                     not   edx
.noUperZc:
                     idiv  ebp
                     mov   [UperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [UperZ.D],eax
                     mov   eax,[c.UperZ]
                     mov   dword [UperZ.F],0
                     mov   [UperZ],eax
; V/Z interpolation
                     xor   edx,edx
                     mov   eax,[a.VperZ]
                     sub   eax,[c.VperZ]
                     jnc   .noVperZc
                     not   edx
.noVperZc:
                     idiv  ebp
                     mov   [VperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [VperZ.D],eax
                     mov   eax,[c.VperZ]
                     mov   dword [VperZ.F],0
                     mov   [VperZ],eax
;----------------------------------------------------------------------------
; LEFT clipping
                     xor   ebp,ebp
                     mov   bp,[c.X.XF+2]
                     cmp   bp,[Clip.XL]
                     jge   near .noLEFTclip2
                     mov   bp,[Clip.XL]
                     sub   bp,[c.X.XF+2]
; clip linear S
                     xor   ah,ah
                     mov   al,[S.W]
                     shl   eax,16
                     mov   ax,[S.D]
                     imul  eax,ebp
                     mov   [S.F],ax
                     shr   eax,8
                     add   [S],ah
; clip 1/Z
                     mov   eax,[perZ.D]
                     mul   ebp
                     mov   [perZ.F],eax
                     add   [perZ],edx
                     mov   eax,[perZ.W]
                     imul  eax,ebp
                     add   [perZ],eax
; clip U/Z
                     mov   eax,[UperZ.D]
                     mul   ebp
                     mov   [UperZ.F],eax
                     add   [UperZ],edx
                     mov   eax,[UperZ.W]
                     imul  eax,ebp
                     add   [UperZ],eax
; clip V/Z
                     mov   eax,[VperZ.D]
                     mul   ebp
                     mov   [VperZ.F],eax
                     add   [VperZ],edx
                     mov   eax,[VperZ.W]
                     imul  eax,ebp
                     add   [VperZ],eax
.noLEFTclip2:
;----------------------------------------------------------------------------
; calculate length of CYCL
                     mov   ax,[c.X.XF+2]
                     mov   bx,[a.X.XF+2]
                     cmp   ax,[Clip.XL]
                     jge   .noLEFTclip3
                     mov   ax,[Clip.XL]
.noLEFTclip3:
                     cmp   bx,[Clip.XR]
                     jle   .noRIGHTclip
                     mov   bx,[Clip.XR]
.noRIGHTclip:
                     sub   bx,ax
                     jz    near .endline
                     mov   [CYCL.LGT],bx
;----------------------------------------------------------------------------
; put the first pixel before the CYCL
                     mov   ebx,[perZ]
                     mov   ecx,[UperZ]
                     mov   esi,[VperZ]

                     xor   edx,edx
                     or    eax,-1
                     div   ebx
                     mov   ebp,eax  ; Z

                     xor   ebx,ebx

                     mov   eax,ecx
                     mul   ebp
                     mov   bl,dl    ; U
                     mov   eax,esi
                     mul   ebp
                     mov   bh,dl    ; V

                     mov   ax,[S.D]
.SM_mem1:            mov   bl,[12345678h+ebx]
                     add   [S.F],ax
                     mov   bh,[S]
.SM_mem2:            mov   al,[12345678h+ebx]
                     adc   bh,[S.W]
                     dec   word [CYCL.LGT]
                     mov   [edi],al
                     jz    near .endline
                     mov   [S],bh
;----------------------------------------------------------------------------
; CYCL
;----------------------------------------------------------------------------
.CYCL.loop:
;----------------------------------------------------------------------------
; interpolate 1/Z, U/Z, V/Z
                     mov   eax,[perZ.D]
                     mov   ebx,[perZ]
                     add   [perZ.F],eax
                     adc   ebx,[perZ.W]

                     mov   eax,[UperZ.D]
                     mov   ecx,[UperZ]
                     add   [UperZ.F],eax
                     adc   ecx,[UperZ.W]

                     mov   eax,[VperZ.D]
                     mov   esi,[VperZ]
                     add   [VperZ.F],eax
                     adc   esi,[VperZ.W]

                     mov   [perZ],ebx
                     mov   [UperZ],ecx
                     mov   [VperZ],esi
;----------------------------------------------------------------------------
; calculate U,V from Z
                     xor   edx,edx
                     or    eax,-1
                     div   ebx
                     mov   ebp,eax  ; Z

                     xor   ebx,ebx

                     mov   eax,ecx
                     mul   ebp
                     mov   bl,dl    ; U
                     mov   eax,esi
                     mul   ebp
                     mov   bh,dl    ; V
;----------------------------------------------------------------------------
                     mov   ax,[S.D]
.SM_mem3:            mov   bl,[12345678h+ebx]
                     add   [S.F],ax
                     mov   bh,[S]
                     inc   edi
.SM_mem4:            mov   al,[12345678h+ebx]
                     adc   bh,[S.W]
                     dec   word [CYCL.LGT]
                     mov   [edi],al

                     mov   [S],bh
                     jnz   near .CYCL.loop
;----------------------------------------------------------------------------
.endline:
                     ret
;----------------------------------------------------------------------------








;----------------------------------------------------------------------------
; put scanline from RIGHT to LEFT - for the SECOND polygon
put_scanline_RIGHTtoLEFT_second:
;----------------------------------------------------------------------------
; check for endline + calculate XLGT
                     mov   ax,[a.X.XF+2]
                     mov   bx,[c.X.XF+2]
                     cmp   ax,[Clip.XR]
                     jge   near .endline
                     mov   bp,bx
                     cmp   bx,[Clip.XL]
                     jle   near .endline

                     sub   bp,ax          ; ebp = XLGT
                     jz    near .endline
                     js    near .endline
                     movsx ebp,bp
;----------------------------------------------------------------------------
; calculate starting address
                     xor   ebx,ebx
                     xor   eax,eax
                     mov   bx,[c.X.XF+2]
                     mov   ax,[SECONDpolygon.curY]
.SM_xreso:           imul  edi,eax,320

                     cmp   bx,[Clip.XR]
                     jle   .noRIGHTclip1
                     mov   bx,[Clip.XR]
.noRIGHTclip1:
                     add   edi,ebx
                     add   edi,[mapper.screen]
;----------------------------------------------------------------------------
; calculate linear S interpolation
                     mov   ax,[a.S.SF+2]
                     mov   bx,[c.S.SF+2]
                     sub   ax,bx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     mov   [S.D],ax
                     shr   eax,8
                     mov   [S.W],ah
                     mov   ax,[c.S.SF+2]
                     mov   word [S.F],0
                     mov   [S],al
;----------------------------------------------------------------------------
; calculate 1/Z, U/Z, V/Z interpolations
; 1/Z interpolation
                     xor   edx,edx
                     mov   eax,[a.perZ]
                     sub   eax,[c.perZ]
                     jnc   .noperZc
                     not   edx
.noperZc:
                     idiv  ebp
                     mov   [perZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [perZ.D],eax
                     mov   eax,[c.perZ]
                     mov   dword [perZ.F],0
                     mov   [perZ],eax
; U/Z interpolation
                     xor   edx,edx
                     mov   eax,[a.UperZ]
                     sub   eax,[c.UperZ]
                     jnc   .noUperZc
                     not   edx
.noUperZc:
                     idiv  ebp
                     mov   [UperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [UperZ.D],eax
                     mov   eax,[c.UperZ]
                     mov   dword [UperZ.F],0
                     mov   [UperZ],eax
; V/Z interpolation
                     xor   edx,edx
                     mov   eax,[a.VperZ]
                     sub   eax,[c.VperZ]
                     jnc   .noVperZc
                     not   edx
.noVperZc:
                     idiv  ebp
                     mov   [VperZ.W],eax
                     mov   eax,edx
                     shl   eax,16
                     cdq
                     idiv  ebp
                     shl   eax,16
                     mov   [VperZ.D],eax
                     mov   eax,[c.VperZ]
                     mov   dword [VperZ.F],0
                     mov   [VperZ],eax
;----------------------------------------------------------------------------
; RIGHT clipping
                     xor   ebp,ebp
                     mov   bp,[c.X.XF+2]
                     cmp   bp,[Clip.XR]
                     jle   near .noRIGHTclip2
                     sub   bp,[Clip.XR]
; clip linear S
                     xor   ah,ah
                     mov   al,[S.W]
                     shl   eax,16
                     mov   ax,[S.D]
                     imul  eax,ebp
                     mov   [S.F],ax
                     shr   eax,8
                     add   [S],ah
; clip 1/Z
                     mov   eax,[perZ.D]
                     mul   ebp
                     mov   [perZ.F],eax
                     add   [perZ],edx
                     mov   eax,[perZ.W]
                     imul  eax,ebp
                     add   [perZ],eax
; clip U/Z
                     mov   eax,[UperZ.D]
                     mul   ebp
                     mov   [UperZ.F],eax
                     add   [UperZ],edx
                     mov   eax,[UperZ.W]
                     imul  eax,ebp
                     add   [UperZ],eax
; clip V/Z
                     mov   eax,[VperZ.D]
                     mul   ebp
                     mov   [VperZ.F],eax
                     add   [VperZ],edx
                     mov   eax,[VperZ.W]
                     imul  eax,ebp
                     add   [VperZ],eax
.noRIGHTclip2:
;----------------------------------------------------------------------------
; calculate length of CYCL
                     mov   ax,[a.X.XF+2]
                     mov   bx,[c.X.XF+2]
                     cmp   ax,[Clip.XL]
                     jge   .noRIGHTclip3
                     mov   ax,[Clip.XL]
.noRIGHTclip3:
                     cmp   bx,[Clip.XR]
                     jle   .noLEFTclip
                     mov   bx,[Clip.XR]
.noLEFTclip:
                     sub   bx,ax
                     jz    near .endline
                     mov   [CYCL.LGT],bx
;----------------------------------------------------------------------------
; put the first pixel before the CYCL
                     mov   ebx,[perZ]
                     mov   ecx,[UperZ]
                     mov   esi,[VperZ]

                     xor   edx,edx
                     or    eax,-1
                     div   ebx
                     mov   ebp,eax  ; Z

                     xor   ebx,ebx

                     mov   eax,ecx
                     mul   ebp
                     mov   bl,dl    ; U
                     mov   eax,esi
                     mul   ebp
                     mov   bh,dl    ; V

                     mov   ax,[S.D]
.SM_mem1:            mov   bl,[12345678h+ebx]
                     add   [S.F],ax
                     mov   bh,[S]
                     dec   edi
.SM_mem2:            mov   al,[12345678h+ebx]
                     adc   bh,[S.W]
                     dec   word [CYCL.LGT]
                     mov   [edi],al
                     jz    near .endline
                     mov   [S],bh
;----------------------------------------------------------------------------
; CYCL
;----------------------------------------------------------------------------
.CYCL.loop:
;----------------------------------------------------------------------------
; interpolate 1/Z, U/Z, V/Z
                     mov   eax,[perZ.D]
                     mov   ebx,[perZ]
                     add   [perZ.F],eax
                     adc   ebx,[perZ.W]

                     mov   eax,[UperZ.D]
                     mov   ecx,[UperZ]
                     add   [UperZ.F],eax
                     adc   ecx,[UperZ.W]

                     mov   eax,[VperZ.D]
                     mov   esi,[VperZ]
                     add   [VperZ.F],eax
                     adc   esi,[VperZ.W]

                     mov   [perZ],ebx
                     mov   [UperZ],ecx
                     mov   [VperZ],esi
;----------------------------------------------------------------------------
; calculate U,V from Z
                     xor   edx,edx
                     or    eax,-1
                     div   ebx
                     mov   ebp,eax  ; Z

                     xor   ebx,ebx

                     mov   eax,ecx
                     mul   ebp
                     mov   bl,dl    ; U
                     mov   eax,esi
                     mul   ebp
                     mov   bh,dl    ; V
;----------------------------------------------------------------------------
                     mov   ax,[S.D]
.SM_mem3:            mov   bl,[12345678h+ebx]
                     add   [S.F],ax
                     mov   bh,[S]
                     dec   edi
.SM_mem4:            mov   al,[12345678h+ebx]
                     adc   bh,[S.W]
                     dec   word [CYCL.LGT]
                     mov   [edi],al

                     mov   [S],bh
                     jnz   near .CYCL.loop
;----------------------------------------------------------------------------
.endline:
                     ret
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
; END of all polygon (drawer) routine
;----------------------------------------------------------------------------

