%define RMCALL_VECT     32h     ; vector of RM int caller routine ( >=32h )
%define N_DSC           8       ; number of free descriptors
%define N_INT           8       ; number of free interrupt gates

%macro  seg_descriptor 0-6 0,0,0,0,0,0
  .limit0_15    dw      %1      ; g=granularity bit; x=default bit for a code
  .base0_15     dw      %2      ;  seg, x=big bit for a data seg: if data seg
  .base16_23    db      %3      ;  expands down: b=0 -> upper bound is 64K-1
  .access       db      %4      ;  b=1 -> upper bound is 4G-1, x=big bit for
  .gx00limit16_19 db    %5      ;  a stack seg too -> determines stack
  .base24_31    db      %6      ;  address-size attribute (sp <-> esp)
%endmacro

%macro  TSS 0-25 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
.backlink       dd      %1              ; selector of the outgoing task's TSS
.esp0           dd      %2              ; privilege level 0 stack pointers
.ss0            dd      %3
.esp1           dd      %4              ; privilege level 1 stack pointers
.ss1            dd      %5
.esp2           dd      %6              ; privilege level 2 stack pointers
.ss2            dd      %7
.@cr3           dd      %8
.eip            dd      %9
.eflags         dd      %10
.@eax           dd      %11
.@ecx           dd      %12
.@edx           dd      %13
.@ebx           dd      %14
.@esp           dd      %15
.@ebp           dd      %16
.@esi           dd      %17
.@edi           dd      %18
.@es            dd      %19
.@cs            dd      %20
.@ss            dd      %21
.@ds            dd      %22
.@fs            dd      %23
.@gs            dd      %24
.ldtr           dd      %25
.io_map_base    dd      104 << 16       ; offset I/O map from the start of
%endmacro                               ;  the Task State Segment

%ifndef NO_EXTERN
extern  v86r_al, v86r_ah, v86r_bl, v86r_bh
extern  v86r_cl, v86r_ch, v86r_dl, v86r_dh
extern  v86r_ax, v86r_bx, v86r_cx, v86r_dx
extern  v86r_si, v86r_di, v86r_bp, v86r_sp
extern  v86r_flags
extern  v86r_eax, v86r_ebx, v86r_ecx, v86r_edx
extern  v86r_esi, v86r_edi, v86r_ebp
extern  v86r_ds, v86r_es, v86r_fs, v86r_gs, v86r_ss
extern  totalextmem, systemtype, code16a, code32a
extern  lomembase, lomemtop, himembase, himemtop
extern  code32sel, data32sel, zerosel
extern  code16sel, data16sel, pspsel, envsel
extern  IRQ0_vect, IRQ1_vect, IRQ2_vect, IRQ3_vect
extern  IRQ4_vect, IRQ5_vect, IRQ6_vect, IRQ7_vect
extern  IRQ8_vect, IRQ9_vect, IRQ10_vect, IRQ11_vect
extern  IRQ12_vect, IRQ13_vect, IRQ14_vect, IRQ15_vect
extern  hextbl, windows, returncode

extern  exit, getmem, getlomem, gethimem
extern  lomemsize, himemsize
extern  getdsc, setdsc, getvect, setvect
extern  map_phys_addr, dosshell, dosprint, putstr

%else

global  v86r_al, v86r_ah, v86r_bl, v86r_bh, v86r_cl, v86r_ch, v86r_dl, v86r_dh
global  v86r_ax, v86r_bx, v86r_cx, v86r_dx, v86r_si, v86r_di, v86r_bp, v86r_sp
global  v86r_flags
global  v86r_eax, v86r_ebx, v86r_ecx, v86r_edx, v86r_esi, v86r_edi, v86r_ebp
global  v86r_ds, v86r_es, v86r_fs, v86r_gs, v86r_ss
global  code16a, code32a, lomembase, lomemtop, himembase, himemtop
global  totalextmem, systemtype
global  code32sel, data32sel, zerosel, code16sel, data16sel, pspsel, envsel
global  IRQ0_vect, IRQ1_vect, IRQ2_vect, IRQ3_vect
global  IRQ4_vect, IRQ5_vect, IRQ6_vect, IRQ7_vect
global  IRQ8_vect, IRQ9_vect, IRQ10_vect, IRQ11_vect
global  IRQ12_vect, IRQ13_vect, IRQ14_vect, IRQ15_vect
global  hextbl, windows, returncode

global  exit, getmem, getlomem, gethimem, lomemsize, himemsize
global  getdsc, setdsc, getvect, setvect, map_phys_addr
global  dosshell, dosprint, putstr

%endif

; Move relatively adjusted pointer to register
%macro  @rlp 2
        mov %1,%2
        sub %1,[code32a]
%endmacro
