; macros for raw32/nasm by mogyi
;----------------------------------------------------------------------------
%define B byte
%define W word
%define D dword
%define Q qword
%define T tword
;----------------------------------------------------------------------------
%macro dosprint 1
                   mov edx,%1
                   call dosprint
%endmacro
;----------------------------------------------------------------------------



;----------------------------------------------------------------------------
; MACROS for FILE/DISK operations
;----------------------------------------------------------------------------
%macro Fopen 4
 %ifnum %4
                   mov edx,%1  ; name
                   mov al,%2   ; mode
                   mov cl,%3   ; attrib
                   call Fopen
 %else
                   mov edx,%1
                   mov al,%2
                   mov cl,%3
                   call Fopen
                   mov %4,ax
 %endif
%endmacro
;----------------------------------------------------------------------------
%macro Fclose 1
                   mov bx,%1   ; handle
                   call Fclose
%endmacro
;----------------------------------------------------------------------------
%macro Fread 3
                   mov bx,%1   ; handle
                   mov cx,%2   ; length
                   mov edx,%3  ; memory
                   call Fread
%endmacro
;----------------------------------------------------------------------------
%macro Fwrite 3
                   mov bx,%1    ; handle
                   mov cx,%2    ; length
                   mov edx,%3   ; memory
                   call Fwrite
%endmacro
;----------------------------------------------------------------------------
%macro Fcreate 3
 %ifnum %3
                   mov edx,%1    ; name
                   mov cx,%2     ; attrib
                   call Fcreate
 %else
                   mov edx,%1    ; name
                   mov cx,%2     ; attrib
                   call Fcreate
                   mov %3,ax
 %endif
%endmacro
;----------------------------------------------------------------------------
%macro Flongread 3-4
 %if %1 = 0
                   mov al,%1      ; mode (0)
                   mov bx,%2      ; handle
                   mov ecx,%3     ; length
                   mov edx,%4     ; memory
                   call Flongread
 %else
                   mov al,%1      ; mode (1)
                   mov bx,%2      ; handle
                   mov edx,%3     ; memory
                   call Flongread
 %endif
%endmacro
;----------------------------------------------------------------------------
%macro Flongwrite 3
                   mov bx,%1       ; handle
                   mov ecx,%2      ; length
                   mov edx,%3      ; memory
                   call Flongwrite
%endmacro
;----------------------------------------------------------------------------
%macro Fseek 3
                   mov al,%1    ; mode
                   mov bx,%2    ; handle
                   mov ecx,%3   ; length
                   call Fseek
%endmacro
;----------------------------------------------------------------------------
%macro Fmkdir 1
                   mov edx,%1  ; name
                   call Fmkdir
%endmacro
;----------------------------------------------------------------------------
%macro Frmdir 1
                   mov edx,%1  ; name
                   call Frmdir
%endmacro
;----------------------------------------------------------------------------
%macro Fchdir 1
                   mov edx,%1  ; name
                   call Fchdir
%endmacro
;----------------------------------------------------------------------------
%macro Fdel 2
                   mov cl,%1   ; attrib
                   mov edx,%2  ; name
                   call Fdel
%endmacro
;----------------------------------------------------------------------------
%macro Fget_attrib 1
                   mov edx,%1  ; name
                   call Fget_attrib
%endmacro
;----------------------------------------------------------------------------
%macro Fchmod 2
                   mov cx,%1    ; attrib
                   mov edx,%2   ; name
                   call Fchmod
%endmacro
;----------------------------------------------------------------------------
%macro Fget_size 1
                   mov bx,%1    ; handle
                   call Fget_size
%endmacro
;----------------------------------------------------------------------------
%macro Fcopy 3
                   mov si,%1    ; source handle
                   mov di,%2    ; destination handle
                   mov ecx,%3   ; length (0 if full copy)
                   call Fcopy
%endmacro
;----------------------------------------------------------------------------
%macro Ffind 4
                   mov ah,%1    ; mode - 4E or 4F
                   mov al,%2    ; flag for use by apped
                   mov cx,%3    ; attrib
                   mov edx,%4   ; name
                   call Find
%endmacro
;----------------------------------------------------------------------------
%macro Fget_diskspace 1
                   mov dl,%1    ; drive number (0=actual 1=A)
                   call Fget_diskspace
%endmacro
;----------------------------------------------------------------------------
%macro Fselect_drive 1
                   mov dl,%1    ; drive number (0=actual 1=A)
                   call Fselect_drive
%endmacro
;----------------------------------------------------------------------------
%macro Fset_date 3
                   mov cx,%1    ; year
                   mov dh,%2    ; month
                   mov dl,%3    ; day
                   call Fset_date
%endmacro
;----------------------------------------------------------------------------
%macro Fset_time 4
                   mov ch,%1    ; hour
                   mov cl,%2    ; minute
                   mov dh,%3    ; second
                   mov dl,%4    ; 1/100 seconds
                   call Fset_date
%endmacro
;----------------------------------------------------------------------------
%macro Fget_cwd 2
                   mov al,%1    ; drive number (0=actual 1=A)
                   mov edx,%2   ; name
                   call Fget_cwd
%endmacro
;----------------------------------------------------------------------------
%macro Frename 3
                   mov edx,%1   ; oldname
                   mov edi,%2   ; newname
                   mov cl,%3    ; attrib
                   call Frename
%endmacro
;----------------------------------------------------------------------------
%macro Fget_lastwdt 1
                   mov bx,%1    ; handle
                   call Fget_lastwdt
%endmacro
;----------------------------------------------------------------------------
%macro Fset_lastwdt 3
                   mov bx,%1    ; handle
                   mov cx,%2    ; new time
                   mov dx,%3    ; new date
                   call Fset_lastwdt
%endmacro
;----------------------------------------------------------------------------
%macro Fdisk_serialnmb 4
                   mov al,%1    ; mode - 0:get 1:set
                   mov bl,%2    ; drive (0=actual 1=A)
                   mov bh,%3    ; info level 00 for DOS , ?
                   mov edx,%4   ; disk info
                   call Fdisk_serialnmb
%endmacro
;----------------------------------------------------------------------------
; END OF MACROS for FILE/DISK operations
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
; MACROS for PROCS
;----------------------------------------------------------------------------
%macro hex16write 1
                   mov ax,%1
                   call hex16write
%endmacro
;----------------------------------------------------------------------------
%macro hex32write 1
                   mov eax,%1
                   call hex32write
%endmacro
;----------------------------------------------------------------------------
%macro decwrite 1
                   mov eax,%1
                   call decwrite
%endmacro
;----------------------------------------------------------------------------
; END OF MACROS for PROCS
;----------------------------------------------------------------------------







