; MAIN program

segment code32 use32

%include "raw32.inc"
%include "files.inc"
%include "procs.inc"
%include "nasmmacr.inc"

%include "3Dengine.inc"
%include "3Drotate.inc"
%include "truemap.inc"

%include "ITengine.inc"
%include "ITplayer.inc"

global main
;----------------------------------------------------------------------------
main:
                     push  ds
                     pop   es
;----------------------------------------------------------------------------
; prepare then play IT module
                     call  SC.detect
                     jc    .skipITplay

                     call  get.DMA_buffer
                     call  get.MIX_buffer
                     call  IT.load
                     call  IT.prepare
                     call  IT.play
                     inc   B [ITisOK]
.skipITplay:
;----------------------------------------------------------------------------
; init screen+3D engine
                     call  videomode.set
                     call  V.videomem.get
                     call  init_3D_engine
;----------------------------------------------------------------------------
; MAIN routines
                     call  IRQ_init
                     mov   bl,[IRQ0_vect]
                     mov   al,0
                     call  _setirqmask
.mainloop:
                     cmp   B [kilepflag],0
                     jnz   .kilep
                     in    al,60h
                     dec   al
                     jnz   .mainloop
.kilep:
                     call  IRQ_deinit
;----------------------------------------------------------------------------
                     cmp   B [ITisOK],0
                     jz    .skipITstop
                     call  IT.stop
.skipITstop:
;----------------------------------------------------------------------------
; END of all
                     mov   W [screen.mode],3
                     call  videomode.set

                     jmp   exit
;----------------------------------------------------------------------------
ITisOK db 0
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
IRQ_init:
                     mov   bl,[IRQ0_vect]
                     call  getvect
                     mov   [old_IRQ.cx],cx
                     mov   [old_IRQ.edx],edx
; Install own handler
                     cli
                     mov   cx,cs
                     mov   edx,own_IRQ
                     call  setvect

                     call  save_PIT
                     call  init_PIT
                     ret
;----------------------------------------------------------------------------
save_PIT:
;  Save PIT counter mode
                     mov   al,0E2h               ;  Read back command; bit 5!=0 -> Don't
                     out   43h,al                ;  latch counter; bit 4=0 -> Latch
                     in    al,40h                ;  status; bit 1=1 -> Select cntr 0
                     and   al,0eh                ;  bits 3 to 1 contain counter mode
                     shr   al,1
                     mov   [counter_mode],al
                     ret
;----------------------------------------------------------------------------
init_PIT:
; Initialize PIT
                     mov   eax,[generated.IRQ]
                     xor   ebx,ebx
                     xor   edx,edx
                     mov   bx,[IRQ_onherz]
                     div   ebx
                     mov   bx,ax

                     mov   al,30h                ; bits 7-6=0 -> Select cntr 0; bits
                     mov   ah,[counter_mode]     ;  5-4=3 -> Read/Write LSB followed
                     shl   ah,1                  ;  by MSB; bits 3-1=counter mode;
                     add   al,ah                 ;  bit 0=0 -> 16 binary counter
                     out   43h,al
                     mov   al,bl                 ; LSB of tick counter
                     out   40h,al
                     mov   al,bh                 ; MSB of tick counter
                     out   40h,al
                     sti
                     ret
;----------------------------------------------------------------------------
restore_PIT:
; Restore default PIT counter value
                     cli
                     mov   al,30h
                     mov   ah,[counter_mode]
                     shl   ah,1
                     add   al,ah
                     out   43h,al
                     mov   al,0
                     out   40h,al
                     out   40h,al
                     ret
;----------------------------------------------------------------------------
IRQ_deinit:
; Restore original timer handler
                     call  restore_PIT

                     mov   bl,[IRQ0_vect]
                     mov   cx,[old_IRQ.cx]
                     mov   edx,[old_IRQ.edx]
                     call  setvect
                     sti
                     ret
;----------------------------------------------------------------------------
generated.IRQ  dd 1193181
IRQ_onherz     dw 50
counter_mode   db 0
;----------------------------------------------------------------------------
old_IRQ.cx   dw 0
old_IRQ.edx  dd 0
;----------------------------------------------------------------------------
own_IRQ:
                     pushad
                     pushf
                     push  ds
                     push  es
                     push  fs

                     call  calc_3D.eff1
                     ;call  calc.eff1
                     call  calc.eff2

                     mov   al,20h   ; 20h=non-specific EOI cmd for IC reg
                     out   20h,al   ; Send EOI to master PIC

                     pop   fs
                     pop   es
                     pop   ds
                     popf
                     popad
                     iret
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
calc_3D.eff1:
                     call  V.videomem.fill

                     call  rotate.area
                     call  calc.zgouraud
                     call  area.putpoly_1

                     call  vert.retr
                     call  V.videomem.copy

                     add   W [alpha],1
                     and   W [alpha],511
                     add   W [beta],3
                     and   W [beta],511
                     add   W [gamma],2
                     and   W [gamma],511
                     ret
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
calc.eff1:
                     inc   W [.cntr1]
                     cmp   W [.cntr1],11
                     jnz   .nocntr1_null
                     mov   W [.cntr1],0

                     add   D [videomem.filldata],1F1F1F1Fh
                     cmp   D [videomem.filldata],3E3E3E3Eh
                     jnz   .novm.fd_null
                     mov   D [videomem.filldata],0
.novm.fd_null:

.nocntr1_null:
                     ret
.cntr1 dw 0
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
calc.eff2:
                     mov   di,3
                     mov   al,[CHN_sample_vol+di]
                     cmp   al,64
                     jnz   .nokilep
                     inc   B [kilepflag]
.nokilep:
                     mov   ah,al
                     mov   bx,ax
                     shl   eax,16
                     mov   ax,bx

                     mov   D [videomem.filldata],eax
                     ret
;----------------------------------------------------------------------------
kilepflag  db 0



; thx to tran
;
; Set status of IRQ mask bit
; In:
;   BL - IRQ num (0-15)
;   AL - status: 0=enabled, 1=disabled
;
_setirqmask:
                push    ax
                push    bx
                push    cx
                push    dx
                mov     cl,bl
                mov     bx,0FFFEh
                movzx   dx,al
                rol     bx,cl
                shl     dx,cl
                in      al,0A1h
                mov     ah,al
                in      al,21h
                and     ax,bx
                or      ax,dx
                out     21h,al
                mov     al,ah
                out     0A1h,al
                pop     dx
                pop     cx
                pop     bx
                pop     ax
                ret
;




