; software mixing IT player was done by mogyi/MCL
; code & effects has been tested.
;   - in volume D0x & Dx0 effect, at x=15 value, effect is processed when tempo is 1. (for S3M compatibility)
;
; (plays only uncompressed modules!)

ALIGNsize_1 equ 32 ; alignment for pent cacheline (32 byte)

segment code32 use32 align ALIGNsize_1,db 0

%define ITPLAYER 0
%include "raw32.inc"
%include "ITplayer.inc"

;----------------------------------------------------------------------------
; MIXING MODES:
; - stereo 8bit/16bit non-interpolated mixing
;   (sample loop, sustain loop and directions are totally supported)
;----------------------------------------------------------------------------
; EFFECTS WHICH ARE SUPPORTED:
;
; volume:         sample volume, sample global volume, channel volume + global volume (mixing volume is supported too)
;                 Vxx - set global volume
;                 Mxx - set channel volume
;                 D0x - volume slide down
;                 Dx0 - volume slide up
;                 DFx - fine volume slide down
;                 DxF - fine volume slide up
;
; panning:        sample panning, channel panning
;                 Xxx - set panning
;
; others:         Axx - speed
;                 Txx - tempo
;                 Oxx - offset (no overflow supported)
;                 SAy - "
;                 Cxx - break to row (only C00 supported)
;                 Jxy - arpeggio
;
; pitch effects:  Exx - pitch slide down
;                 EEx - fine pitch slide down
;                 EFx - extra fine pitch slide down
;
;                 Fxx - pitch slide up
;                 FFx - fine pitch slide up
;                 FEx - extra fine pitch slide up
;
;                 Gxx - portamento to note
;
;----------------------------------------------------------------------------



;----------------------------------------------------------------------------
; PROCEDURES: ( "->" are the procs, which can see other programs)
;
; ->prepare_IT_module            - ok
;   process_patterndatas         - ok
;   process_BPM                  - ok
;   init_bufferLGT               - ok
;   get_channel_marker           - ok
;   rowprocess_newnote           - ok
;   rowprocess_newinstr          - ok
;   rowprocess_newboth_noteinstr - ok
;   rowprocess_newsmallCMD       - not yet
;   rowprocess_newCMD_value      - not yet
;   mixing_procedure             - not yet
; ->MAIN_procedure               - ok
;----------------------------------------------------------------------------
;HERE is the ITplayer CODE
;----------------------------------------------------------------------------
CHN_nmb equ 64 ; number of channels
;----------------------------------------------------------------------------
; the MAIN procedure, includes mixing, getting channel marker, etc..
; DESTROYS: ?

MAIN_procedure:
                     mov eax,[final_buffer_LGT]      ; restore final buffer counter
                     shr eax,2                       ; (16bit + stereo)
                     mov [final_buffer_CNTR],eax
                     mov eax,[mixing_buffer_ADDR]    ; restore mixing buffer current address
                     mov [mixing_buffer_curADDR],eax

                     mov edi,[mixing_buffer_ADDR]    ; clear mixing buffer
                     mov ecx,[mixing_buffer_LGT]
                     shr ecx,2                       ; stosd
                     xor eax,eax
                     repz stosd

                     cmp dword [buffer_LGT_cntr],0
                     jz .getchnmrk                   ; mixbuff isn't empty
.loop:
                     call mixing_procedure           ; we mix the remainder
                     cmp dword [final_buffer_CNTR],0
                     jz .end                         ; end of Mp
.getchnmrk:
                     cmp byte [tempo_counter],0
                     jnz .tc_isnot_null
                     mov al,[tempo]
                     mov [tempo_counter],al
                     call reset_general_effects   ; reset general effects
                     call get_channel_marker      ; get channel marker
.tc_isnot_null:
                     dec byte [tempo_counter]
                     call process_general_effects ; process general effects
                     call init_bufferLGT          ; init buffer LENGTH
                     jmp short .loop
.end:

; now moving data from MIXING buffer to the FINAL buffer
; 16-bit/MONO or STEREO -> 16-bit/STEREO writing

                     mov edi,[final_buffer_ADDR]  ; to final buffer
                     inc byte [HALF_counter]      ; HALF counter
                     cmp byte [HALF_counter],2
                     jnz .Hc_nonull
                     mov byte [HALF_counter],0
                     mov eax,[final_buffer_LGT]   ; length of final buffer
                     add edi,eax
.Hc_nonull:
                     mov ecx,[final_buffer_LGT]   ; length is HALF!
                     mov esi,[mixing_buffer_ADDR] ; from mixing buffer
                     shr ecx,1
                     movzx ebx,byte [MV]          ; mixing volume
.mov2final_loop:
                     mov eax,[esi]                ; check for over/underflow
                     cmp eax,32768
                     jl .mov2final_skip1
                     mov eax,32767                ; overflow
.mov2final_skip1:
                     cmp eax,-32768
                     jge .mov2final_skip2
                     mov eax,-32768               ; underflow
.mov2final_skip2:
                     imul eax,ebx                 ; calc. mixing volume
                     add esi,4                    ; (16bit + stereo) skip
                     sar eax,7
                     mov [edi],ax
                     add edi,2
                     dec ecx
                     jnz .mov2final_loop

                     ret
;----------------------------------------------------------------------------
; prepare an IT module
;
; note that EBX,ECX must be an INTEGER number and DIVISIBLE with 4!
;
; IN: ESI = mixing buffer address   (usually HIGH memory location)
;     EBX = mixing buffer length    (usually 64kb)
;     EDI = final  buffer address   (usually the start address of DMA)
;     ECX = final  buffer length    (usually 32kb) - it is doubled for the DMA
;     module_OFS = offset of IT module
;
; DESTROYS: ESI,EAX,EBX,ECX,EDI

prepare_IT_module:
                     mov [mixing_buffer_ADDR],esi    ; ADDR    mixbuff
                     mov [mixing_buffer_curADDR],esi ; curADDR "
                     mov [mixing_buffer_LGT],ebx     ; LGT     "

                     mov [final_buffer_ADDR],edi     ; ADDR    finalbuff
                     mov [final_buffer_LGT],ecx      ; total LENGTH (no shift)
                     shr ecx,2                       ; (16bit + stereo)
                     mov [final_buffer_CNTR],ecx     ; counter (twice shifted)

                     mov esi,[module_OFS]
                     mov ax,[esi+32h] ; tempo,BPM
                     mov [tempo],al
                     mov byte [tempo_counter],0
                     mov [BPM],ah

                     movzx eax,word [esi+20h] ; ORDnum
                     add ax,0C0h
                     add eax,esi
                     mov [instr_OFS],eax ; offset of instruments

                     movzx eax,word [esi+22h] ; INSnum
                     shl eax,2
                     add eax,[instr_OFS]
                     mov [sample_OFS],eax ; offset of samples

                     movzx eax,word [esi+24h] ; SMPnum
                     shl eax,2
                     add eax,[sample_OFS]
                     mov [pattern_OFS],eax ; offset of patterns

                     mov ax,[esi+30h] ; GV,MV
                     mov [GV],al
                     mov [MV],ah

                     mov ebx,esi ; move CHANNEL VOL from table to MEM
                     xor di,di
.lp0:
                     mov al,[ebx+80h]
                     mov [CHN_sample_CHNvol+di],al
                     inc di
                     cmp di,64
                     jnz .lp0

                     mov ebx,esi ; calculate the numbers of inactive channel
                     xor di,di
.lp1:
                     test byte [ebx+40h],128 ; CHN pan table
                     jnz .inactive_chn       ; if bit7 set, CHN is disabled
                     inc byte [active_channels]
                     or dword [CHN_sampling_flags+di],2 ; set active flag
.inactive_chn:
                     inc ebx
                     add di,4
                     cmp di,256
                     jnz .lp1

                     mov byte [ordpos],0 ; current position in order
                     call process_patterndatas

                     call process_BPM    ; buffer LGT from BPM

                     ret
;----------------------------------------------------------------------------
; process pattern datas (from ordpos)
; DESTROYS: ESI,AX

process_patterndatas:
                     movzx esi,byte [ordpos] ; offset of orders + ordpos
                     add esi,00C0h
                     add esi,[module_OFS]

                     movzx esi,byte [esi]    ; offset of current pattern
                     shl si,2
                     add esi,[pattern_OFS]
                     mov esi,[esi]
                     add esi,[module_OFS]

                     mov ax,[esi]            ; length of pattern
                     mov [pattern_LGT],ax
                     mov ax,[esi+2]          ; number of rows
                     mov [row_number],ax
                     mov [row_counter],ax

                     add esi,8
                     mov [patternpos],esi    ; current position in pattern + OFS
                     ret
;----------------------------------------------------------------------------
; process FRACTIONAL step for BUFFER (from BPM)
; DESTROYS: AX

process_BPM:
                     movzx ax,byte [BPM] ; BPM*2 / 5
                     shl ax,1
                     mov [tmp1],ax

                     fild word [tmp1]            ; BPM*2
                     fidiv word [tmp2]           ; 5
                     fidivr dword [mixing_freq]  ; mixing_freq / (BPM*2/5)

                     fnstcw [FPU_cw]             ; store control word (CW)
                     fnstcw [FPU_cw+2]           ; "                  (CW2)
                     and word [FPU_cw+2],0F3FFh  ; clear RC flag
                     or word [FPU_cw+2],1024     ; set RC to DOWN
                     fldcw [FPU_cw+2]            ; load CW2

                     fist dword [buffer_LGT]    ; BUFFER LENGTH
                     fldcw [FPU_cw]             ; restore control word (CW)

                     fisub dword [buffer_LGT]
                     fmul dword [tmp3]              ; 2^31 - you can't multiply with 2^32
                     fistp dword [buffer_fractstp]  ; fractional STEP
                     shl dword [buffer_fractstp],1
                     mov dword [buffer_fractdat],0  ; fractional DATA
                     ret
;----------------------------------------------------------------------------
; init BUFFER length
; DESTROYS: EAX,EBX

init_bufferLGT:
                     mov eax,[buffer_LGT]
                     mov [buffer_LGT_cntr],eax
                     mov eax,[buffer_fractstp]
                     mov ebx,eax
                     add ebx,eax
                     adc ebx,0
                     mov [buffer_fractdat],ebx
                     ret
;----------------------------------------------------------------------------
; get channel marker
; internal USE: DI for channel

get_channel_marker:
                     cmp word [row_counter],0  ; is the end of the pattern? (row counter is null)
                     jnz .nonext_row
.next_order:
                     inc byte [ordpos]         ; orderpos++ = 1
.first_order:
                     movzx esi,byte [ordpos]
                     add esi,[module_OFS]
                     add esi,0C0h
                     mov al,[esi]
                     cmp al,254                ; +++ remark
                     jz .next_order
                     cmp al,255                ; --- end
                     jnz .noendof_order
                     mov byte [ordpos],0
                     jmp short .first_order
.noendof_order:
                     call process_patterndatas ; calculate DATAs (from ordpos)
.nonext_row:
                     mov esi,[patternpos]      ; we get DATA from patternpos
;----------------------------------------------------------------------------
; ESI: position of pattern
; internal USE: DI for channel

get_next_channel_marker:

                     lodsb
                     cmp al,0
                     jz near end_of_row        ; end of row (in width)

                     movzx di,al
                     dec di
                     and di,63
                     test al,128
                     mov al,[CHN_maskvar+di]
                     jz .sk1
                     lodsb
.sk1:
                     mov [CHN_maskvar+di],al
;----------------------------------------------------------------------------
; GET NOTE,INSTR
                     test byte [CHN_maskvar+di],1
                     jz .nonewnote
                     lodsb
                     mov [CHN_note+di],al
.nonewnote:
                     test byte [CHN_maskvar+di],2
                     jz .nonewinstr
                     lodsb
                     mov [CHN_instr+di],al
.nonewinstr:
;----------------------------------------------------------------------------
; PROCESS NOTE+INSTR, NOTE, INSTR
                     mov al,[CHN_maskvar+di]   ; if we have both we have to call them together
                     and al,3
                     cmp al,3
                     jnz .nonew_both_noteinstr
                     call rowprocess_newboth_noteinstr
                     jmp short .newboth_noteinstr
.nonew_both_noteinstr:
                     test byte [CHN_maskvar+di],2
                     jz .nonewinstr_calc
                     call rowprocess_newinstr  ; instrument first
.nonewinstr_calc:
                     test byte [CHN_maskvar+di],1
                     jz .nonewnote_calc
                     call rowprocess_newnote   ; then note
.nonewnote_calc:
.newboth_noteinstr:
;----------------------------------------------------------------------------
; PROCESS NOTE,INSTR for SECOND
; IT optimalization, you don't have to load again the previous data!
                     mov al,[CHN_maskvar+di]   ; if we have both we have to call them together
                     shr al,4
                     and al,3
                     cmp al,3
                     jnz .noprev_both_noteinstr
                     call rowprocess_newboth_noteinstr
                     jmp short .prevboth_noteinstr
.noprev_both_noteinstr:
                     test byte [CHN_maskvar+di],32
                     jz .noprevinstr
                     test byte [CHN_maskvar+di],1
                     jz .previnstr
                     call rowprocess_newinstr
                     jmp short .prevboth_noteinstr
.previnstr:
                     call rowprocess_previnstr
.noprevinstr:
                     test byte [CHN_maskvar+di],16
                     jz .noprevnote
                     call rowprocess_newnote
.noprevnote:
.prevboth_noteinstr:
;----------------------------------------------------------------------------
; GET SMALLCMD,CMD+value
                     test byte [CHN_maskvar+di],4
                     jz .nonewsmallCMD
                     lodsb
                     mov [CHN_smallCMD+di],al
.nonewsmallCMD:
                     test byte [CHN_maskvar+di],8
                     jz .nonewCMD_value
                     lodsw                         ; opt!
                     mov [CHN_CMD+di],al
                     mov [CHN_CMDvalue+di],ah
.nonewCMD_value:
;----------------------------------------------------------------------------
; PROCESS SMALLCMD,CMD+value
                     test byte [CHN_maskvar+di],4
                     jz .nonewsmallCMD_calc
                     call rowprocess_newsmallCMD
.nonewsmallCMD_calc:
                     test byte [CHN_maskvar+di],8
                     jz .nonewCMD_value_calc
                     call rowprocess_newCMD_value
.nonewCMD_value_calc:
;----------------------------------------------------------------------------
; PROCESS SMALLCMD,CMD+value for SECOND
; IT optimalization, you don't have to load again the previous data!
                     test byte [CHN_maskvar+di],64
                     jz .noprevsmallCMD
                     call rowprocess_newsmallCMD
.noprevsmallCMD:
                     test byte [CHN_maskvar+di],128
                     jz .noprevCMD_value
                     call rowprocess_newCMD_value
.noprevCMD_value:
;----------------------------------------------------------------------------
                     jmp get_next_channel_marker
end_of_row:
                     mov [patternpos],esi        ; update patternpos
                     dec word [row_counter]      ; decrease row counter
                     ret
;----------------------------------------------------------------------------
; process both new note & instrument
; DESTROYS: EBX,EAX
; USE: DI

rowprocess_newboth_noteinstr:
                     push ESI  ; because of SMALLCMD, CMD and CMDvalue

                     movzx esi,byte [CHN_instr+di]
                     dec esi   ; sample number must not be 0, so we can decrease it
                     shl esi,2
                     add esi,[sample_OFS]
                     mov esi,[esi]
                     add esi,[module_OFS]
                     shl di,2

                     mov eax,[esi+3Ch] ; sampling_freq - we have to get this before we call the NEW_NOTE proc
                     mov [CHN_sampling_freq+di],eax
                     shr di,2

                     pop ESI

                     call rowprocess_newnote
                     jmp rowprocess_newinstr
;----------------------------------------------------------------------------
; process new note
; DESTROYS: EBX
; USE: DI

rowprocess_newnote:
                     movzx bx,byte [CHN_note+di]
                     shl di,2
                     cmp bl,254    ; stop sampling
                     jnz .sk1
                     and dword [CHN_sampling_flags+di],0FFFFFFFEh ; not 1
                     shr di,2
                     ret
.sk1:
                     cmp bl,255    ; stop sustain loop
                     jnz .sk3
                     and dword [CHN_sampling_flags+di],0FFFFFFBFh ; not 6
                     shr di,2
                     ret
.sk3:
                     shl bx,2
                     mov eax,[CHN_freq_quote+di]
                     mov [CHN_freq_quote_prev+di],eax
                     mov ebx,[freq_table+bx]
                     mov [CHN_freq_quote+di],ebx
rowprocess_newfreq:                                      ; this is needed for other procedures
                     fild dword [CHN_freq_quote+di]      ; freq_quote / 2^16 * sampling_freq / mixing_freq * 2^31
                     fidiv dword [tmp4] ; 2^16
                     fimul dword [CHN_sampling_freq+di]
                     fidiv dword [mixing_freq]

                     fnstcw [FPU_cw]             ; store control word (CW)
                     fnstcw [FPU_cw+2]           ; "                  (CW2)
                     and word [FPU_cw+2],0F3FFh  ; clear RC flag
                     or word [FPU_cw+2],1024     ; set RC to DOWN
                     fldcw [FPU_cw+2]            ; load CW2

                     fist dword [CHN_freq_cntr_int+di]    ; integer STEP
                     fldcw [FPU_cw]              ; restore control word (CW)

                     fisub dword [CHN_freq_cntr_int+di]
                     fmul dword [tmp3]           ; 2^31 - you can't multiply by 2^32
                     fistp dword [CHN_freq_cntr_fract+di] ; fractional STEP
                     shl dword [CHN_freq_cntr_fract+di],1

                     shr di,2
                     ret
;----------------------------------------------------------------------------
; process new instrument
; DESTROYS: EAX
; USE: DI

rowprocess_newinstr:
                     push ESI ; store ESI of SMALLCMD, CMD and CMDvalue

                     movzx esi,byte [CHN_instr+di]
                     dec esi  ; sample number must not be 0, so we can decrease it
                     shl esi,2
                     add esi,[sample_OFS]
                     mov esi,[esi]
                     add esi,[module_OFS]
                     shl di,2

                     or dword [CHN_sampling_flags+di],1           ; enable sampling
                     and dword [CHN_sampling_flags+di],0FFFFCF03h ; xx001xx1-00000011

                     test byte [esi+12h],2 ; FLG 16bit/8bit
                     jz .sk1
                     or dword [CHN_sampling_flags+di],4 ; set 16bit
.sk1:
                     test byte [esi+12h],16 ; FLG loop on/loop off
                     jz .sk2
                     or dword [CHN_sampling_flags+di],16 ; set loop
.sk2:
                     test byte [esi+12h],32 ; FLG sloop on/sloop off
                     jz .sk3
                     or dword [CHN_sampling_flags+di],64 ; set sloop
.sk3:
                     test byte [esi+12h],64 ; FLG loop pp/loop fw
                     jz .sk4
                     or dword [CHN_sampling_flags+di],32 ; set loop pp
.sk4:
                     test byte [esi+12h],128 ; FLG sloop pp/sloop fw
                     jz .sk5
                     or dword [CHN_sampling_flags+di],128 ; set sloop pp
.sk5:
                     test byte [esi+2eh],1 ; signed/unsigned
                     jz .sk6
                     or dword [CHN_sampling_flags+di],8192 ; set signed
.sk6:
                     mov eax,[esi+48h] ; begin
                     mov [CHN_sampling_start+di],eax
                     mov [CHN_sampling_pos+di],eax
                     add eax,[esi+30h] ; end (start+length)
                     mov [CHN_sampling_end+di],eax
                     mov eax,[esi+34h] ; loopB
                     mov [CHN_sampling_loopB+di],eax
                     mov eax,[esi+38h] ; loopE
                     mov [CHN_sampling_loopE+di],eax
                     mov eax,[esi+40h] ; susloopB
                     mov [CHN_sampling_susloopB+di],eax
                     mov eax,[esi+44h] ; susloopE
                     mov [CHN_sampling_susloopE+di],eax
                     mov eax,[esi+3Ch] ; sampling_freq
                     mov [CHN_sampling_freq+di],eax

                     shr di,2
.forprev:
                     mov al,[esi+13h] ; sample vol        (vol)
                     mov [CHN_sample_vol+di],al
                     mov al,[esi+11h] ; sample global vol (Gvl)
                     mov [CHN_sample_Gvl+di],al

                     push esi
                     movzx esi,di
                     add esi,[module_OFS]
                     add esi,40h

                     mov al,[esi]     ; channel pan       (pan)
                     pop esi
                     mov ah,[esi+2Fh] ; DfP
                     test ah,128      ; use DfP? (bit 7 on to use)
                     jz .sk7
                     mov al,ah        ; we use DfP
                     and al,7Fh       ;

                     movzx esi,di     ; store DfP to channel pan (pan table)
                     add esi,40h
                     add esi,[module_OFS]
                     mov [esi],al
.sk7:
                     mov [CHN_sample_pan+di],al ; store to sample pan

                     pop ESI ; reload ESI
                     ret
;----------------------------------------------------------------------------
; process previous instrument
; DESTROYS: EAX
; USE: DI

rowprocess_previnstr:
                     push ESI ; store ESI of SMALLCMD, CMD and CMDvalue

                     movzx esi,byte [CHN_instr+di]
                     dec esi  ; sample number must not be 0, so we can decrease it
                     shl esi,2
                     add esi,[sample_OFS]
                     mov esi,[esi]
                     add esi,[module_OFS]
                     jmp rowprocess_newinstr.forprev
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
; IT's volume column effects
;----------------------------------------------------------------------------
; process new small command
; USE: DI = channel

rowprocess_newsmallCMD:
                     mov al,[CHN_smallCMD+di]
;----------------------------------------------------------------------------
                     cmp al,65
                     jae .no_volume
                     mov [CHN_sample_vol+di],al ; to sample vol
                     ret
;----------------------------------------------------------------------------
.no_volume:
                     cmp al,75
                     jae .no_finevolup
                     ret
;----------------------------------------------------------------------------
.no_finevolup:
                     cmp al,85
                     jae .no_finevoldown
                     ret
;----------------------------------------------------------------------------
.no_finevoldown:
                     cmp al,95
                     jae .no_volslideup
                     ret
;----------------------------------------------------------------------------
.no_volslideup:
                     cmp al,105
                     jae .no_volslidedown
                     ret
;----------------------------------------------------------------------------
.no_volslidedown:
                     cmp al,115
                     jae .no_pitchslidedown
                     ret
;----------------------------------------------------------------------------
.no_pitchslidedown:
                     cmp al,125
                     jae .no_pitchslideup
                     ret
;----------------------------------------------------------------------------
.no_pitchslideup:
                     cmp al,193
                     jae .no_panning
                     sub al,128
.panning:
                     mov [CHN_sample_pan+di],al ; store to sample pan
                     movzx ebx,di
                     add ebx,[module_OFS]
                     add ebx,40h
                     mov [ebx],al               ; store to channel pan (pan table)
                     ret
;----------------------------------------------------------------------------
.no_panning:
                     cmp al,203
                     jae .no_portamentoto
                     ret
;----------------------------------------------------------------------------
.no_portamentoto:
                     cmp al,213
                     jae .no_vibrato
                     ret
;----------------------------------------------------------------------------
.no_vibrato:
                     ret
;----------------------------------------------------------------------------
; END of IT's volume culomn effects
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
; IT's general effects
;----------------------------------------------------------------------------
; process new command+value
; USE: DI = channel

rowprocess_newCMD_value:
                     mov al,[CHN_CMD+di]
                     mov ah,[CHN_CMDvalue+di]
;----------------------------------------------------------------------------
                     cmp al,0
                     jnz .END
                     ret
.END:
                     cmp al,1 ; A
                     jnz .noA
                     mov al,ah
                     cmp al,0
                     jz .A_end
                     mov [tempo],al
                     mov [tempo_counter],al
.A_end:
                     ret
;----------------------------------------------------------------------------
.noA:
                     cmp al,14h ; T
                     jnz .noT
                     mov al,ah
                     shr al,4
                     cmp al,0
                     jz .T_end
                     cmp al,1
                     jz .T_end
                     mov [BPM],ah
                     call process_BPM ; destroys AX
.T_end:
                     ret
;----------------------------------------------------------------------------
.noT:
                     cmp al,0Fh ; O
                     jnz .noO
                     test byte [CHN_maskvar+di],1 ; new note
                     jnz .O_ok
                     test byte [CHN_maskvar+di],2 ; new instr
                     jnz .O_ok
                     test byte [CHN_maskvar+di],16 ; prev note
                     jnz .O_ok
                     test byte [CHN_maskvar+di],32 ; prev instr
                     jz .O_end
.O_ok:
                     movzx bx,byte [CHN_SAy+di]
                     shl ebx,16
                     mov bl,[CHN_CMDvalue+di]
                     shl bx,8
                     shl di,2
                     test dword [CHN_sampling_flags+di],4 ; 16bit
                     jz .O_skip
                     shl bx,1
.O_skip:
                     add ebx,[CHN_sampling_start+di]
                     mov [CHN_sampling_pos+di],ebx
                     shr di,2
.O_end:
                     ret
;----------------------------------------------------------------------------
.noO:
                     cmp al,16h ; V
                     jnz .noV
                     mov [GV],ah
                     ret
;----------------------------------------------------------------------------
.noV:
                     cmp al,3 ; C
                     jnz .noC
                     mov word [row_counter],1 ; end of row
                     ret
;----------------------------------------------------------------------------
.noC:
                     cmp al,0Ah ; J
                     jnz .noJ
                     cmp ah,0
                     jnz .J_skip
                     mov ah,[CHN_Jxy+di]
.J_skip:
                     mov [CHN_Jxy+di],ah
                     mov al,6  ; begin with 6
                     mov [CHN_J+di],al
                     and ah,15 ; and add max to ofcoz
                     add [CHN_note+di],ah
                     ret
;----------------------------------------------------------------------------
.noJ:
                     cmp al,18h ; X
                     jnz .noX
                     mov al,ah
                     shr al,2
                     jmp rowprocess_newsmallCMD.panning
;----------------------------------------------------------------------------
.noX:
                     cmp al,0Dh ; M
                     jnz .noM
                     cmp ah,65
                     jb .M_sk0
                     mov ah,64
.M_sk0:
                     mov [CHN_sample_CHNvol+di],ah
                     ret
;----------------------------------------------------------------------------
.noM:
                     cmp al,4 ; D
                     jnz .noD
                     cmp ah,0
                     jnz .D_sk0
                     mov ah,[CHN_Dxx+di]
.D_sk0:
                     mov [CHN_Dxx+di],ah
                     mov al,ah
                     shr al,4
                     cmp al,0
                     jnz .noD0x
                     mov byte [CHN_D+di],1
                     ret
.noD0x:
                     mov al,ah
                     and al,15
                     jnz .noDx0
                     mov byte [CHN_D+di],2
                     ret
.noDx0:
                     mov al,ah
                     shr al,4
                     cmp al,15
                     jnz .noDFx
                     mov al,[CHN_sample_vol+di]
                     and ah,15
                     sub al,ah
                     jnc .DFx_skip
                     xor al,al
.DFx_skip:
                     mov [CHN_sample_vol+di],al
                     ret
.noDFx:
                     mov ah,[CHN_sample_vol+di]
                     add ah,al
                     cmp ah,65
                     jb .DxF_skip
                     mov ah,64
.DxF_skip:
                     mov [CHN_sample_vol+di],ah
                     ret
;----------------------------------------------------------------------------
.noD:
                     cmp al,5 ; E
                     jnz .noE
                     movzx bx,ah
                     and bl,15
                     shl bl,1
                     mov al,ah
                     shr al,4
                     cmp al,15
                     jnz .E_noEFx
                     movzx eax,word [finelinearslidedown_table+bx]
                     mov [tmp5],eax
                     fild dword [tmp5]
                     jmp process_GE_EFGxx.E_sk1
.E_noEFx:
                     cmp al,14
                     jnz .E_noEEx
                     movzx eax,word [extrafinelinearslidedown_table+bx]
                     mov [tmp5],eax
                     fild dword [tmp5]
                     jmp process_GE_EFGxx.E_sk1
.E_noEEx:
                     mov byte [CHN_EFG+di],1
                     cmp ah,0
                     jnz .E_sk0
                     mov ah,[CHN_EFGxx+di]
.E_sk0:
                     mov [CHN_EFGxx+di],ah
                     ret
;----------------------------------------------------------------------------
.noE:
                     cmp al,6 ; F
                     jnz .noF
                     movzx bx,ah
                     and bl,15
                     shl bl,1
                     mov al,ah
                     shr al,4
                     cmp al,15
                     jnz .F_noFFx
                     shl bx,1
                     fild dword [finelinearslideup_table+bx]
                     jmp process_GE_EFGxx.E_sk1
.F_noFFx:
                     cmp al,14
                     jnz .F_noFEx
                     shl bx,1
                     fild dword [extrafinelinearslideup_table+bx]
                     jmp process_GE_EFGxx.E_sk1
.F_noFEx:
                     mov byte [CHN_EFG+di],2
                     cmp ah,0
                     jnz .F_sk0
                     mov ah,[CHN_EFGxx+di]
.F_sk0:
                     mov [CHN_EFGxx+di],ah
                     ret
;----------------------------------------------------------------------------
.noF:
                     cmp al,7 ; G
                     jnz .noG
                     cmp ah,0
                     jnz .G_sk0
                     mov ah,[CHN_EFGxx+di]
.G_sk0:
                     mov [CHN_EFGxx+di],ah

                     test byte [CHN_maskvar+di],1 ; if no freq, disable G
                     jnz .G_ok
                     test byte [CHN_maskvar+di],2
                     jnz .G_ok
.G_nook:
                     mov byte [CHN_EFG+di],0
                     jmp short .G_end
.G_ok:
                     shl di,2
                     mov eax,[CHN_freq_quote_prev+di] ; old
                     mov ebx,[CHN_freq_quote+di]      ; new
                     shr di,2

                     cmp eax,ebx ; CURRENT  with NEW
                     jz .G_nook

                     shl di,2
                     mov [CHN_freq_quote_prev+di],ebx ; PREV is NEW
                     mov [CHN_freq_quote+di],eax      ; NOW is OLD
                     shr di,2

                     cmp eax,ebx ; CURRENT  with NEW
                     jb .G_currentissmaller
                     mov byte [CHN_EFG+di],1+4 ; E 2.bit is enabled
                     jmp short .G_currentisbigger
.G_currentissmaller:
                     mov byte [CHN_EFG+di],2+4 ; F 2.bit is enabled
.G_currentisbigger:
                     shl di,2
                     call rowprocess_newfreq ; no destroy! DI = chn<<2
.G_end:
                     ret
;----------------------------------------------------------------------------
.noG:
                     ret
;----------------------------------------------------------------------------
; END OF PROCESS NEW COMMAND+VALUE
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
; MEMORY FOR COMMANDS/VALUES
  align ALIGNsize_1,db 0
;----------------------------------------------------------------------------

CHN_SAy times CHN_nmb db 0 ; sample high offset
CHN_J   times CHN_nmb db 0 ; it is needed to identify ARPEGGIO
                           ; 0-1.bits - ARPEGGIO counter
                           ; 2.bit    - set if ARPEGGIO enabled

CHN_Jxy times CHN_nmb db 0 ; ARPEGGIO data
CHN_D   times CHN_nmb db 0 ; it is needed to identify VOLUME slide
                           ; 0 - nothing
                           ; 1 - D0x
                           ; 2 - Dx0

CHN_Dxx times CHN_nmb db 0 ; VOLUME slide data

CHN_EFG times CHN_nmb db 0 ; it is needed to identify PITCH slide
                           ; 0 - nothing
                           ; 1 - Exx (xx = 0-DF)
                           ; 2 - Fxx (xx = 0-DF)
                           ; 2.bit set if G is enabled (5 - Gxx with E) - sorry, no xx above DF suppoorted
                           ;                           (6 - Gxx with F) - "

CHN_EFGxx times CHN_nmb db 0           ; PITCH slide data
CHN_freq_quote_prev times CHN_nmb dd 0 ; previous freq quote for Gxx
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
; new code, new alignment
  align ALIGNsize_1,db 0
;----------------------------------------------------------------------------
; process general effects (CMD & CMDvalue)
; DESTROYS: ?
; internal USE: DI = channel

process_general_effects:
                     mov di,63
.loop:
                     call process_GE_Jxy
                     mov al,[tempo]
                     dec al                      ; < skip the first frame
                     cmp byte [tempo_counter],al ; some effects are needed to skip out
                     jz .skip_SE
                     call process_GE_EFGxx
.skip_SE:
                     call process_GE_Dxx
                     dec di
                     jns .loop
                     ret
;----------------------------------------------------------------------------
process_GE_EFGxx:
                     mov al,[CHN_EFG+di]
                     movzx bx,byte [CHN_EFGxx+di]
                     shl bx,1
                     cmp al,0
                     jz near .end
                     cmp al,1
                     jnz .noE
.E_sk0:
                     movzx eax,word [linearslidedown_table+bx]
                     mov [tmp5],eax
                     fild dword [tmp5]
.E_sk1:
                     fidiv dword [tmp4] ; 2^16
                     shl di,2
                     fimul dword [CHN_freq_quote+di]
                     fistp dword [CHN_freq_quote+di]
                     call rowprocess_newfreq ; no destroy! DI = chn<<2
                     ret
.noE:
                     cmp al,2
                     jnz .noF
                     shl bx,1
                     fild dword [linearslideup_table+bx]
                     jmp short .E_sk1
.noF:
                     cmp al,5
                     jnz .noGxxE

                     call .E_sk0
                     shl di,2
                     mov eax,[CHN_freq_quote+di]      ; CURRENT
                     mov ebx,[CHN_freq_quote_prev+di] ; NEW
                     shr di,2
                     cmp eax,ebx ; current - new
                     jae .end
                     shl di,2
                     mov [CHN_freq_quote+di],ebx
                     call rowprocess_newfreq ; no destroy! DI = chn<<2
                     ret
.noGxxE:
                     cmp al,6
                     jnz .end

                     shl bx,1
                     fild dword [linearslideup_table+bx]
                     call .E_sk1
                     shl di,2
                     mov eax,[CHN_freq_quote+di]      ; CURRENT
                     mov ebx,[CHN_freq_quote_prev+di] ; NEW
                     shr di,2
                     cmp eax,ebx ; current - new
                     jb .end
                     shl di,2
                     mov [CHN_freq_quote+di],ebx
                     call rowprocess_newfreq ; no destroy! DI = chn<<2
                     ret
.end:
                     ret
;----------------------------------------------------------------------------
process_GE_Dxx:
                     mov ah,[CHN_Dxx+di]         ; this is for S3M compat
                     cmp ah,0Fh
                     jz .D0F_DF0
                     cmp ah,0F0h
                     jz .D0F_DF0
                     mov al,[tempo]
                     dec al
                     cmp byte [tempo_counter],al
                     jz .end
.D0F_DF0:
                     mov al,[CHN_D+di]
                     cmp al,0
                     jz .end
                     cmp al,1
                     jnz .noD0x
                     mov al,[CHN_sample_vol+di]
                     sub al,ah
                     jnc .D0x_sk0
                     xor al,al
.D0x_sk0:
                     mov [CHN_sample_vol+di],al
                     ret
.noD0x:
                     cmp al,2
                     jnz .noDx0
                     shr ah,4
                     mov al,[CHN_sample_vol+di]
                     add al,ah
                     cmp al,65
                     jb .Dx0_sk0
                     mov al,64
.Dx0_sk0:
                     mov [CHN_sample_vol+di],al
                     ret
.noDx0:

.end:
                     ret
;----------------------------------------------------------------------------
process_GE_Jxy:
                     mov al,[CHN_J+di]
                     test al,4 ; 3.bit
                     jz .end
                     inc al
                     cmp al,7
                     jnz .sk0
                     mov al,4
.sk0:
                     mov [CHN_J+di],al
                     cmp al,5
                     jz .sk1
                     cmp al,6
                     jz .sk2

                     mov al,[CHN_Jxy+di]
                     and al,15
                     sub [CHN_note+di],al
.sk3:
                     call rowprocess_newnote ; DESTROYS: EAX,EBX / USE: DI
                     ret
.sk1:
                     mov al,[CHN_Jxy+di]
                     shr al,4
                     add [CHN_note+di],al
                     jmp short .sk3
.sk2:
                     mov al,[CHN_Jxy+di]
                     and al,15
                     mov ah,[CHN_Jxy+di]
                     shr ah,4
                     sub al,ah
                     add [CHN_note+di],al
                     jmp short .sk3
.end:
                     ret
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
; reset general effects
; DESTROYS: ?
; internal use: DI = channel

reset_general_effects:
                     mov di,63
.loop:
                     call reset_GE_Jxy
                     call reset_GE_Dxx
                     call reset_GE_EFGxx
                     dec di
                     jns .loop
                     ret
;----------------------------------------------------------------------------
reset_GE_EFGxx:
                     mov byte [CHN_EFG+di],0
                     ret
;----------------------------------------------------------------------------
reset_GE_Dxx:
                     mov byte [CHN_D+di],0
                     ret
;----------------------------------------------------------------------------
reset_GE_Jxy:
                     mov al,[CHN_J+di]
                     mov byte [CHN_J+di],0
                     mov ah,[CHN_Jxy+di]
                     cmp al,0
                     jz .realend
                     cmp al,4
                     jz .realend
                     cmp al,5
                     jz .sk0
                     and ah,15
                     sub [CHN_note+di],ah
                     jmp short .end
.sk0:
                     shr ah,4
                     sub [CHN_note+di],ah
.end:
                     call rowprocess_newnote ; DESTROYS: EAX,EBX / USE: DI
.realend:
                     ret
;----------------------------------------------------------------------------








;----------------------------------------------------------------------------
; this is the MAIN mixing procedure, mixes channels to each other

mixing_procedure:
                     jmp mix_STEREO_8b16b
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
; STEREO 8-bit/16-bit mixing routine
; it includes loop, sustain loop, forward, ping-pong directions.
; code has been tested
; no good optimizations
;----------------------------------------------------------------------------
mix_STEREO_8b16b:
                     mov eax,[buffer_LGT_cntr]    ; calculate mixing LENGTH
                     cmp eax,[final_buffer_CNTR]
                     jb .skip1
                     mov eax,[final_buffer_CNTR]
.skip1:
                     mov [.memo0+1],eax           ; store LGT
                     mov [.memo1+1],eax           ; "
                     mov [.memo10+1],eax          ; for loop
                     mov [.memo12+1],eax          ; for pingpong loop

                     mov [.memo2+1],ebp           ; save  EBP
                     mov [.memo3+1],esp           ;       ESP
                     mov eax,[mixing_buffer_curADDR]
                     mov [.memo4+1],eax           ; mixing buffer cur ADDR
                     mov [.memo9+1],eax           ; for loop
                     mov [.memo11+1],eax          ; for pingpong loop

                     mov di,63
.loop1:
                     shl di,2
;----------------------------------------------------------------------------
                     mov word [.NL_16BF1],9090h      ; 2 * nop
                     mov byte [.NL_16BF2+1],0BEh     ; byte
                     mov byte [.NL_16BF22+1],0BEh    ; byte
                     mov word [.NL_16BF3],9046h      ; 2 * nop
                     mov byte [.NL_16BF5+2],8        ; shl eax,8
                     mov byte [.NL_16BF55+2],8       ; shl eax,8

                     mov word [.FL_16BF1],9090h      ; 2 * nop
                     mov byte [.FL_16BF2+1],0BEh     ; byte
                     mov byte [.FL_16BF22+1],0BEh    ; byte
                     mov word [.FL_16BF3],9046h      ; 2 * nop
                     mov byte [.FL_16BF5+2],8        ; shl eax,8
                     mov byte [.FL_16BF55+2],8       ; shl eax,8

                     mov word [.PPL_16BF1],9090h     ; 2 * nop
                     mov word [.PPL_16BF11],9090h    ; 2 * nop
                     mov byte [.PPL_16BF2+1],0BEh    ; byte
                     mov byte [.PPL_16BF22+1],0BEh   ; byte
                     mov word [.PPL_16BF3],9046h     ; nop, inc esi
                     mov byte [.PPL_16BF5+2],8       ; shl eax,8
                     mov byte [.PPL_16BF55+2],8      ; shl eax,8
                     mov byte [.PPL2_16BF2+1],0BEh   ; byte
                     mov byte [.PPL2_16BF22+1],0BEh  ; byte
                     mov word [.PPL2_16BF3],904Eh    ; nop, dec esi
                     mov byte [.PPL2_16BF5+2],8      ; shl eax,8
                     mov byte [.PPL2_16BF55+2],8     ; shl eax,8

                     mov word [.PPL_correct],904Eh   ; nop, dec esi

                     test dword [CHN_sampling_flags+di],4 ; 16bit
                     jz near .NL_no16bit
;----------------------------------------------------------------------------
                     mov word [.NL_16BF1],0E0D1h     ; shl eax,1
                     mov byte [.NL_16BF2+1],0BFh     ; word
                     mov byte [.NL_16BF22+1],0BFh    ; word
                     mov word [.NL_16BF3],4646h      ; 2 * inc esi
                     mov byte [.NL_16BF5+2],0        ; shl eax,0
                     mov byte [.NL_16BF55+2],0       ; shl eax,0

                     mov word [.FL_16BF1],0E0D1h     ; shl eax,1
                     mov byte [.FL_16BF2+1],0BFh     ; word
                     mov byte [.FL_16BF22+1],0BFh    ; word
                     mov word [.FL_16BF3],4646h      ; 2 * inc esi
                     mov byte [.FL_16BF5+2],0        ; shl eax,0
                     mov byte [.FL_16BF55+2],0       ; shl eax,0

                     mov word [.PPL_16BF1],0E0D1h    ; shl eax,1
                     mov word [.PPL_16BF11],0E0D1h   ; shl eax,1
                     mov byte [.PPL_16BF2+1],0BFh    ; word
                     mov byte [.PPL_16BF22+1],0BFh   ; word
                     mov word [.PPL_16BF3],4646h     ; 2 * inc esi
                     mov byte [.PPL_16BF5+2],0       ; shl eax,0
                     mov byte [.PPL_16BF55+2],0      ; shl eax,0
                     mov byte [.PPL2_16BF2+1],0BFh   ; word
                     mov byte [.PPL2_16BF22+1],0BFh  ; word
                     mov word [.PPL2_16BF3],4E4Eh    ; 2 * dec esi
                     mov byte [.PPL2_16BF5+2],0      ; shl eax,0
                     mov byte [.PPL2_16BF55+2],0     ; shl eax,0

                     mov word [.PPL_correct],4E4Eh   ; 2* dec esi

.NL_no16bit:
;----------------------------------------------------------------------------
                     test dword [CHN_sampling_flags+di],2 ; inactive
                     jz near .no
                     test dword [CHN_sampling_flags+di],1 ; no sampling
                     jz near .no
                     test dword [CHN_sampling_flags+di],16 ; loop
                     jnz near .withloop
                     test dword [CHN_sampling_flags+di],64 ; susloop (we can use there sustainloop too, ofcoz)
                     jnz near .withloop

                     mov eax,[CHN_sampling_end+di]    ; sample END
                     sub eax,[CHN_sampling_start+di]
.NL_16BF1:           nop                              ; for 16bit
                     nop
                     add eax,[CHN_sampling_start+di]
                     add eax,[module_OFS]
                     mov [.memo5+2],eax               ; store END (the length of "cmp esi" is 2!)
                     mov [.memo6+2],di                ; store DI

                     mov edx,[CHN_freq_cntr_data+di]  ; edx = data
                     mov ebp,[CHN_freq_cntr_fract+di] ; ebp = fract
                     mov esp,[CHN_freq_cntr_int+di]   ; esp = int

                     test dword [CHN_sampling_flags+di],4 ; 16bit
                     jz .NL_no16bit2
                     shl esp,1
.NL_no16bit2:
                     mov esi,[CHN_sampling_pos+di]    ; current pos
                     add esi,[module_OFS]
                     shr di,2

                     movzx eax,byte [CHN_sample_vol+di]     ; AL  = vol
                     mov bl,[CHN_sample_Gvl+di]             ; BL  = Gvl
                     mul bl                                 ; AX  = vol*Gvl (AL*BL)
                     movzx ebx,byte [CHN_sample_CHNvol+di]  ; BL  = CHNvol
                     imul eax,ebx                           ; EAX = (vol*Gvl)*CHNvol (EAX*EBX)
                     mov bl,[GV]                            ; BL  = GV
                     imul eax,ebx                           ; EAX = ((vol*Gvl)*CHNvol)*GV (EAX*EBX)
                     shr eax,18                             ; EAX = (0-128) from max 33554432
                     adc al,0                               ; EAX = rounded volume (0-128)

                     mov bh,al                              ; EAX,EBX = rvol
                     mov bl,[CHN_sample_pan+di]             ; BL    = RIGHT pan
                     mul bl                                 ; AX    = rvol*Rpan (AL*BL)
                     shr ax,6                               ; AX    = (0-128) from max 8192
                     adc al,0                               ; AX    = RIGHT rounded volume
                     mov bl,al                              ; BL    = RIGHT rounded volume
                     mov al,bh                              ; AL    = rvol
                     xor bh,bh                              ; EBX   = RIGHT rounded volume
                     mov [.NL_pan1+2],ebx                   ; store RIGHT

                     mov bl,64                              ; BL  = 64
                     sub bl,[CHN_sample_pan+di]             ; BL  = LEFT pan
                     mul bl                                 ; AX  = rvol*Lpan (AL*BL)
                     shr ax,6                               ; AX  = (0-128) from max 8192
                     adc al,0                               ; AX  = LEFT rounded volume
                     mov bl,al                              ; EBX = LEFT VOLUME

.memo4:              mov edi,12345678h ; 4.        address
.memo0:              mov ecx,12345678h ; 0.        length
;----------------------------------------------------------------------------
; MAIN mixing routine
;----------------------------------------------------------------------------
.loop2:

.NL_16BF2:           movsx eax,byte [esi] ; left volume calculation (EBX)

.NL_16BF5:           shl eax,8
                     imul eax,ebx
                     sar eax,7
                     add [edi],eax

.NL_16BF22:          movsx eax,byte [esi] ; right volume calculation (INTEGRATED)

.NL_16BF55:          shl eax,8
.NL_pan1:            imul eax,eax,12345678h
                     sar eax,7
                     add [edi+4],eax

                     add edx,ebp
                     jnc .NL_16BF4
.NL_16BF3:           nop
                     nop
.NL_16BF4:           add esi,esp

                     add edi,8
.memo5:              cmp esi,12345678h ; 5.
                     jae .skip2
                     dec ecx
                     jnz .loop2
.skip2:
;----------------------------------------------------------------------------
.memo6:              mov di,1234h ; 6.
                     cmp ecx,0
                     jz .skip3
                     and dword [CHN_sampling_flags+di],0FFFFFFFEh ; not 1 no sampling
.skip3:
                     sub esi,[module_OFS]
                     mov [CHN_sampling_pos+di],esi   ; restore pos
                     mov [CHN_freq_cntr_data+di],edx ; restore freq data
.no:
                     shr di,2
                     dec di
                     jns near .loop1

.memo1:              mov eax,12345678h ; 1.
                     sub dword [buffer_LGT_cntr],eax
                     sub dword [final_buffer_CNTR],eax

                     shl eax,3
                     add [mixing_buffer_curADDR],eax

.memo2:              mov ebp,12345678h ; 2.
.memo3:              mov esp,12345678h ; 3.

                     ret
;----------------------------------------------------------------------------
; mixing with FORWARD LOOP
.withloop:
                     test dword [CHN_sampling_flags+di],64
                     jnz .FL_susLenable
                     test dword [CHN_sampling_flags+di],32 ; loop direction
                     jnz near .withpingpongloop
                     jz .FL_susLdisable
.FL_susLenable:
                     test dword [CHN_sampling_flags+di],128 ; susloop pp
                     jnz near .withpingpongloop
.FL_susLdisable:
                     mov eax,[CHN_sampling_loopE+di]  ; calc loopE

                     test dword [CHN_sampling_flags+di],64 ; sustain loop
                     jz .FL_nosusL1
                     mov eax,[CHN_sampling_susloopE+di]
.FL_nosusL1:

.FL_16BF1:           nop
                     nop
                     add eax,[CHN_sampling_start+di]
                     add eax,[module_OFS]
                     mov [.memo7+2],eax

                     mov edx,[CHN_freq_cntr_data+di]  ; freq counters
                     mov ebp,[CHN_freq_cntr_fract+di]
                     mov esp,[CHN_freq_cntr_int+di]

                     test dword [CHN_sampling_flags+di],4 ; 16bit
                     jz .FL_no16bit2
                     shl esp,1
.FL_no16bit2:
                     mov esi,[CHN_sampling_pos+di]    ; calc pos
                     add esi,[module_OFS]

                     mov [.memo8+2],di                ; store DI
                     shr di,2

                     movzx eax,byte [CHN_sample_vol+di]     ; AL  = vol
                     mov bl,[CHN_sample_Gvl+di]             ; BL  = Gvl
                     mul bl                                 ; AX  = vol*Gvl (AL*BL)
                     movzx ebx,byte [CHN_sample_CHNvol+di]  ; BL  = CHNvol
                     imul eax,ebx                           ; EAX = (vol*Gvl)*CHNvol (EAX*EBX)
                     mov bl,[GV]                            ; BL  = GV
                     imul eax,ebx                           ; EAX = ((vol*Gvl)*CHNvol)*GV (EAX*EBX)
                     shr eax,18                             ; EAX = (0-128) from max 33554432
                     adc al,0                               ; EAX = rounded volume (0-128)

                     mov bh,al                              ; EAX,EBX = rvol
                     mov bl,[CHN_sample_pan+di]             ; BL    = RIGTH pan
                     mul bl                                 ; AX    = rvol*Rpan (AL*BL)
                     shr ax,6                               ; AX    = (0-128) from max 8192
                     adc al,0                               ; AX    = RIGHT rounded volume
                     mov bl,al                              ; BL    = RIGHT rounded volume
                     mov al,bh                              ; AL    = rvol
                     xor bh,bh                              ; EBX   = RIGHT rounded volume
                     mov [.FL_pan1+2],ebx                   ; store RIGHT

                     mov bl,64                              ; BL  = 64
                     sub bl,[CHN_sample_pan+di]             ; BL  = LEFT pan
                     mul bl                                 ; AX  = rvol*Lpan (AL*BL)
                     shr ax,6                               ; AX  = (0-128) from max 8192
                     adc al,0                               ; AX  = LEFT rounded volume
                     mov bl,al                              ; EBX = LEFT VOLUME

.memo9:              mov edi,12345678h ; 9.
.memo10:             mov ecx,12345678h ; 10.
;----------------------------------------------------------------------------
; MAIN mixing routine
;----------------------------------------------------------------------------
.loop3:

.FL_16BF2:           movsx eax,byte [esi] ; left volume calculation (EBX)

.FL_16BF5:           shl eax,8
                     imul eax,ebx
                     sar eax,7
                     add [edi],eax

.FL_16BF22:          movsx eax,byte [esi] ; right volume calculatios (INTEGRATED)

.FL_16BF55:          shl eax,8
.FL_pan1:            imul eax,eax,12345678h
                     sar eax,7
                     add [edi+4],eax

                     add edx,ebp
                     jnc .FL_16BF4
.FL_16BF3:           nop
                     nop
.FL_16BF4:           add esi,esp

                     add edi,8
.memo7:              cmp esi,12345678h ; 7.
                     jae .skip4
.skip6:
                     dec ecx
                     jnz .loop3
;----------------------------------------------------------------------------
.skip4:
                     mov eax,edi       ; eax isn't in use
.memo8:              mov di,1234h
                     cmp ecx,0
                     jz .skip5

                     mov esi,[CHN_sampling_loopB+di] ; loop BEGIN (must be!)

                     test dword [CHN_sampling_flags+di],64 ; sustain loop
                     jz .FL_nosusL2
                     mov esi,[CHN_sampling_susloopB+di]
.FL_nosusL2:
                     test dword [CHN_sampling_flags+di],4 ; 16bit
                     jz .FL_no16bit3
                     shl esi,1
.FL_no16bit3:
                     add esi,[CHN_sampling_start+di]
                     add esi,[module_OFS]
                     mov edi,eax
                     jmp short .skip6      ; ecx is still in its data
;----------------------------------------------------------------------------
.skip5:
                     jmp .skip3
;----------------------------------------------------------------------------
; mixing with PINGPING LOOP
.withpingpongloop:
                     mov eax,[CHN_sampling_loopE+di]  ; calc loopE

                     test dword [CHN_sampling_flags+di],64 ; sustain loop
                     jz .PPL_nosusL1
                     mov eax,[CHN_sampling_susloopE+di]
.PPL_nosusL1:

.PPL_16BF1:          nop
                     nop
                     add eax,[CHN_sampling_start+di]
                     add eax,[module_OFS]
                     mov [.memo13+2],eax

                     mov eax,[CHN_sampling_loopB+di]  ; calc loopB

                     test dword [CHN_sampling_flags+di],64 ; sustain loop
                     jz .PPL_nosusL2
                     mov eax,[CHN_sampling_susloopB+di]
.PPL_nosusL2:

.PPL_16BF11:         nop
                     nop
                     add eax,[CHN_sampling_start+di]
                     add eax,[module_OFS]
                     mov [.memo14+2],eax

                     mov edx,[CHN_freq_cntr_data+di]  ; freq counters
                     mov ebp,[CHN_freq_cntr_fract+di]
                     mov esp,[CHN_freq_cntr_int+di]

                     test dword [CHN_sampling_flags+di],4 ; 16bit
                     jz .PPL_no16bit
                     shl esp,1
.PPL_no16bit:
                     mov esi,[CHN_sampling_pos+di]    ; calc pos
                     add esi,[module_OFS]

                     mov [.memo15+2],di               ; store DI
                     mov [.memo16+2],di               ; store DI

                     mov al,[CHN_sampling_flags+di]   ; later
                     mov [.memo17+1],al
                     shr di,2

                     movzx eax,byte [CHN_sample_vol+di]     ; AL  = vol
                     mov bl,[CHN_sample_Gvl+di]             ; BL  = Gvl
                     mul bl                                 ; AX  = vol*Gvl (AL*BL)
                     movzx ebx,byte [CHN_sample_CHNvol+di]  ; BL  = CHNvol
                     imul eax,ebx                           ; EAX = (vol*Gvl)*CHNvol (EAX*EBX)
                     mov bl,[GV]                            ; BL  = GV
                     imul eax,ebx                           ; EAX = ((vol*Gvl)*CHNvol)*GV (EAX*EBX)
                     shr eax,18                             ; EAX = (0-128) from max 33554432
                     adc al,0                               ; EAX = rounded volume (0-128)

                     mov bh,al                              ; EAX,EBX = rvol
                     mov bl,[CHN_sample_pan+di]             ; BL    = RIGHT pan
                     mul bl                                 ; AX    = rvol*Rpan (AL*BL)
                     shr ax,6                               ; AX    = (0-128) from max 8192
                     adc al,0                               ; AX    = RIGHT rounded volume
                     mov bl,al                              ; BL    = RIGHT rounded volume
                     mov al,bh                              ; AL    = rvol
                     xor bh,bh                              ; EBX   = RIGHT rounded volume
                     mov [.PPL_pan1+2],ebx                  ; store RIGHT
                     mov [.PPL2_pan1+2],ebx                 ; store RIGHT

                     mov bl,64                              ; BL  = 64
                     sub bl,[CHN_sample_pan+di]             ; BL  = LEFT pan
                     mul bl                                 ; AX  = rvol*Lpan (AL*BL)
                     shr ax,6                               ; AX  = (0-128) from max 8192
                     adc al,0                               ; AX  = LEFT rounded volume
                     mov bl,al                              ; EBX = LEFT VOLUME

.memo11:             mov edi,12345678h ; 11.
.memo12:             mov ecx,12345678h ; 12.

.memo17:             mov al,12h               ; here, current direction
                     test al,8
                     jnz .loop5               ; backward if set
;----------------------------------------------------------------------------
; MAIN mixing routine
;----------------------------------------------------------------------------
.loop4:

.PPL_16BF2:          movsx eax,byte [esi] ; left volume calculation (EBX)

.PPL_16BF5:          shl eax,8
                     imul eax,ebx
                     sar eax,7
                     add [edi],eax
.PPL_16BF22:
                     movsx eax,byte [esi] ; right volume calculation (INTEGRATED)
.PPL_16BF55:
                     shl eax,8
.PPL_pan1:           imul eax,eax,12345678h
                     sar eax,7
                     add [edi+4],eax

                     add edx,ebp
                     jnc .PPL_16BF4
.PPL_16BF3:          nop
                     nop
.PPL_16BF4:          add esi,esp

                     add edi,8
.memo13:             cmp esi,12345678h ; 13.
                     jae .skip7
.skip8:
                     dec ecx
                     jnz .loop4
;----------------------------------------------------------------------------
.skip7:
                     mov eax,edi
.memo15:             mov di,1234h ; 15.
                     cmp ecx,0
                     jz near .skip11

                     sub edx,ebp      ; this is the correction for pinpong l.
                     jnc .PPL_correct_
.PPL_correct:
                     dec esi
                     dec esi
.PPL_correct_:
                     sub esi,esp

                     xor dword [CHN_sampling_flags+di],8 ; xor direction
                     mov edi,eax
                     jmp short .skip10
;----------------------------------------------------------------------------
.loop5:

.PPL2_16BF2:
                     movsx eax,byte [esi] ; left volume calculation (EBX)
.PPL2_16BF5:
                     shl eax,8
                     imul eax,ebx
                     sar eax,7
                     add [edi],eax
.PPL2_16BF22:
                     movsx eax,byte [esi] ; right volume calculation (INTEGRATED)
.PPL2_16BF55:
                     shl eax,8
.PPL2_pan1:          imul eax,eax,12345678h
                     sar eax,7
                     add [edi+4],eax

                     add edx,ebp
                     jnc .PPL2_16BF4
.PPL2_16BF3:
                     nop
                     nop
.PPL2_16BF4:
                     sub esi,esp

                     add edi,8
.memo14:             cmp esi,12345678h ; 14.
                     jb .skip9
.skip10:
                     dec ecx
                     jnz .loop5
;----------------------------------------------------------------------------
.skip9:
                     mov eax,edi
.memo16:             mov di,1234h ; 16
                     cmp ecx,0
                     jz .skip11

                     mov esi,[CHN_sampling_loopB+di]  ; this is needed!

                     test dword [CHN_sampling_flags+di],64 ; sustain loop
                     jz .PPL_nosusL3
                     mov esi,[CHN_sampling_susloopB+di]
.PPL_nosusL3:
                     test dword [CHN_sampling_flags+di],4  ; 16bit
                     jz .PPL_no16bit2
                     shl esi,1
.PPL_no16bit2:
                     add esi,[CHN_sampling_start+di]
                     add esi,[module_OFS]
                     xor dword [CHN_sampling_flags+di],8   ; xor direction
                     mov edi,eax
                     jmp .skip8
;----------------------------------------------------------------------------
.skip11:
                     jmp .skip3
;----------------------------------------------------------------------------
; END OF MIXING ROUTINES
;----------------------------------------------------------------------------








;----------------------------------------------------------------------------
; HERE is ITplayer's DATA area
  align ALIGNsize_1,db 0
;----------------------------------------------------------------------------
mixing_freq            dd 44100 ; - you can modify this
tempo                  db 0 ; (1-255)
tempo_counter          db 0 ; ?
BPM                    db 0 ; (31-255) but why just 31/32?
;----------------------------------------------------------------------------
buffer_LGT             dd 0 ; length of BUFFER
buffer_LGT_cntr        dd 0 ; BUFFER counter
buffer_fractstp        dd 0 ; 2^31 fractional step for BUFFER
buffer_fractdat        dd 0 ; 2^31 fractional data for BUFFER (null at start)
;----------------------------------------------------------------------------
tmp1                   dw 0 ; used for calculating BPM
tmp2                   dw 5 ; "
tmp3                   dd 2147483648.0 ; 2^31 (32-bit float) - you can't multiply by 2^32!
tmp4                   dd 65536        ; 2^16
tmp5                   dd 0 ; used for anything
;----------------------------------------------------------------------------
instr_OFS              dd 0
sample_OFS             dd 0
pattern_OFS            dd 0
;----------------------------------------------------------------------------
active_channels        db 0 ; number of active channels (how many channels are enabled)
;----------------------------------------------------------------------------
module_OFS             dd 0 ; module offset

mixing_buffer_ADDR     dd 0 ; address of MIXING buffer
mixing_buffer_curADDR  dd 0 ; current "
mixing_buffer_LGT      dd 0 ; length of MIXING buffer

final_buffer_ADDR      dd 0 ; address of FINAL buffer (final buffer hasn't got current address)
final_buffer_LGT       dd 0 ; length of FINAL buffer
final_buffer_CNTR      dd 0 ; counter

HALF_counter           db 0 ; this is made for the DMA/other HALF-moving routine

GV                     db 0 ; global volume for all channel
MV                     db 0 ; mixing volume for mixing
;----------------------------------------------------------------------------
FPU_cw                 dd 0 ; two FPU control word (this is needed because the FPU's rounding to the nearest value - you can correct this)
;----------------------------------------------------------------------------
  align ALIGNsize_1,db 0
freq_table: ; values are 16.16 bit
   DW      2048, 0,   2170, 0,   2299, 0,   2435, 0,   2580, 0,   2734, 0 ; C-0
   DW      2896, 0,   3069, 0,   3251, 0,   3444, 0,   3649, 0,   3866, 0 ;>B-0

   DW      4096, 0,   4340, 0,   4598, 0,   4871, 0,   5161, 0,   5468, 0 ; C-1
   DW      5793, 0,   6137, 0,   6502, 0,   6889, 0,   7298, 0,   7732, 0 ;>B-1

   DW      8192, 0,   8679, 0,   9195, 0,   9742, 0,   10321, 0,  10935, 0
   DW      11585, 0,  12274, 0,  13004, 0,  13777, 0,  14596, 0,  15464, 0

   DW      16384, 0,  17358, 0,  18390, 0,  19484, 0,  20643, 0,  21870, 0
   DW      23170, 0,  24548, 0,  26008, 0,  27554, 0,  29193, 0,  30929, 0

   DW      32768, 0,  34716, 0,  36781, 0,  38968, 0,  41285, 0,  43740, 0
   DW      46341, 0,  49097, 0,  52016, 0,  55109, 0,  58386, 0,  61858, 0

   DW      0, 1,      3897, 1,   8026, 1,   12400, 1,  17034, 1,  21944, 1
   DW      27146, 1,  32657, 1,  38496, 1,  44682, 1,  51236, 1,  58179, 1

   DW      0, 2,      7794, 2,   16051, 2,  24800, 2,  34068, 2,  43888, 2
   DW      54292, 2,  65314, 2,  11456, 3,  23828, 3,  36936, 3,  50823, 3

   DW      0, 4,      15588, 4,  32103, 4,  49600, 4,  2601, 5,   22240, 5
   DW      43048, 5,  65092, 5,  22912, 6,  47656, 6,  8336, 7,   36110, 7

   DW      0, 8,      31176, 8,  64205, 8,  33663, 9,  5201, 10,  44481, 10
   DW      20559, 11, 64648, 11, 45823, 12, 29776, 13, 16671, 14, 6684, 15

   DW      0, 16,     62352, 16, 62875, 17, 1790,  19, 10403, 20, 23425, 21
   DW      41118, 22, 63761, 23, 26111, 25, 59552, 26, 33342, 28, 13368, 30
;----------------------------------------------------------------------------
  align ALIGNsize_1,db 0
linearslideup_table: ; values are 16.16 bit
        DW      0,     1, 237,   1, 475,   1, 714,   1, 953,  1  ; 0->4
        DW      1194,  1, 1435,  1, 1677,  1, 1920,  1, 2164, 1  ; 5->9
        DW      2409,  1, 2655,  1, 2902,  1, 3149,  1, 3397, 1  ; 10->14
        DW      3647,  1, 3897,  1, 4148,  1, 4400,  1, 4653, 1  ; 15->19
        DW      4907,  1, 5157,  1, 5417,  1, 5674,  1, 5932, 1  ; 20->24
        DW      6190,  1, 6449,  1, 6710,  1, 6971,  1, 7233, 1  ; 25->29
        DW      7496,  1, 7761,  1, 8026,  1, 8292,  1, 8559, 1  ; 30->34
        DW      8027,  1, 9096,  1, 9366,  1, 9636,  1, 9908, 1  ; 35->39
        DW      10181, 1, 10455, 1, 10730, 1, 11006, 1, 11283,1  ; 40->44
        DW      11560, 1, 11839, 1, 12119, 1, 12400, 1, 12682,1  ; 45->49
        DW      12965, 1, 13249, 1, 13533, 1, 13819, 1, 14106,1  ; 50->54
        DW      14394, 1, 14684, 1, 14974, 1, 15265, 1, 15557,1  ; 55->59
        DW      15850, 1, 16145, 1, 16440, 1, 16737, 1, 17034,1  ; 60->64
        DW      17333, 1, 17633, 1, 17933, 1, 18235, 1, 18538,1  ; 65->69
        DW      18842, 1, 19147, 1, 19454, 1, 19761, 1, 20070,1  ; 70->74
        DW      20379, 1, 20690, 1, 21002, 1, 21315, 1, 21629,1  ; 75->79
        DW      21944, 1, 22260, 1, 22578, 1, 22897, 1, 23216,1  ; 80->84
        DW      23537, 1, 23860, 1, 24183, 1, 24507, 1, 24833,1  ; 85->89
        DW      25160, 1, 25488, 1, 25817, 1, 26148, 1, 26479,1  ; 90->94
        DW      26812, 1, 27146, 1, 27481, 1, 27818, 1, 28155,1  ; 95->99
        DW      28494, 1, 28834, 1, 29175, 1, 29518, 1, 29862,1  ; 100->104
        DW      30207, 1, 30553, 1, 30900, 1, 31248, 1, 31599,1  ; 105->109
        DW      31951, 1, 32303, 1, 32657, 1, 33012, 1, 33369,1  ; 110->114
        DW      33726, 1, 34085, 1, 34446, 1, 34807, 1, 35170,1  ; 115->119
        DW      35534, 1, 35900, 1, 36267, 1, 36635, 1, 37004,1  ; 120->124
        DW      37375, 1, 37747, 1, 38121, 1, 38496, 1, 38872,1  ; 125->129
        DW      39250, 1, 39629, 1, 40009, 1, 40391, 1, 40774,1  ; 130->134
        DW      41158, 1, 41544, 1, 41932, 1, 42320, 1, 42710,1  ; 135->139
        DW      43102, 1, 43495, 1, 43889, 1, 44285, 1, 44682,1  ; 140->144
        DW      45081, 1, 45481, 1, 45882, 1, 46285, 1, 46690,1  ; 145->149
        DW      47095, 1, 47503, 1, 47917, 1, 48322, 1, 48734,1  ; 150->154
        DW      49147, 1, 49562, 1, 49978, 1, 50396, 1, 50815,1  ; 155->159
        DW      51236, 1, 51658, 1, 52082, 1, 52507, 1, 52934,1  ; 160->164
        DW      53363, 1, 53793, 1, 54224, 1, 54658, 1, 55092,1  ; 165->169
        DW      55529, 1, 55966, 1, 56406, 1, 56847, 1, 57289,1  ; 170->174
        DW      57734, 1, 58179, 1, 58627, 1, 59076, 1, 59527,1  ; 175->179
        DW      59979, 1, 60433, 1, 60889, 1, 61346, 1, 61805,1  ; 180->184
        DW      62265, 1, 62727, 1, 63191, 1, 63657, 1, 64124,1  ; 185->189
        DW      64593, 1, 65064, 1, 0,     2, 474,   2, 950,  2  ; 190->194
        DW      1427,  2, 1906,  2, 2387,  2, 2870,  2, 3355, 2  ; 195->199
        DW      3841,  2, 4327,  2, 4818,  2, 5310,  2, 5803, 2  ; 200->204
        DW      6298,  2, 6795,  2, 7294,  2, 7794,  2, 8296, 2  ; 205->209
        DW      8800,  2, 9306,  2, 9814,  2, 10323, 2, 10835,2  ; 210->214
        DW      11348, 2, 11863, 2, 12380, 2, 12899, 2, 13419,2  ; 215->219
        DW      13942, 2, 14467, 2, 14993, 2, 15521, 2, 16051,2  ; 220->224
        DW      16583, 2, 17117, 2, 17653, 2, 18191, 2, 18731,2  ; 225->229
        DW      19273, 2, 19817, 2, 20362, 2, 20910, 2, 21460,2  ; 230->234
        DW      22011, 2, 22565, 2, 23121, 2, 23678, 2, 24238,2  ; 235->239
        DW      24800, 2, 25363, 2, 25929, 2, 25497, 2, 27067,2  ; 240->244
        DW      27639, 2, 28213, 2, 28789, 2, 29367, 2, 29947,2  ; 245->249
        DW      30530, 2, 31114, 2, 31701, 2, 32289, 2, 32880, 2 ; 250->254
        DW      33473, 2, 34068, 2                               ; 255->256
;----------------------------------------------------------------------------
  align ALIGNsize_1,db 0
linearslidedown_table: ; values are 0.16 bit
        DW      65535, 65300, 65065, 64830, 64596, 64364, 64132, 63901 ; 0->7
        DW      63670, 63441, 63212, 62984, 62757, 62531, 62306, 62081 ; 8->15
        DW      61858, 61635, 61413, 61191, 60971, 60751, 60532, 60314 ; 16->23
        DW      60097, 59880, 59664, 59449, 59235, 59022, 58809, 58597 ; 24->31
        DW      58386, 58176, 57966, 57757, 57549, 57341, 57135, 56929 ; 32->39
        DW      56724, 56519, 56316, 56113, 55911, 55709, 55508, 55308 ; 40->47
        DW      55109, 54910, 54713, 54515, 54319, 54123, 53928, 53734 ; 48->55
        DW      53540, 53347, 53155, 52963, 52773, 52582, 52393, 52204 ; 56->63
        DW      52016, 51829, 51642, 51456, 51270, 51085, 50901, 50718 ; 64->71
        DW      50535, 50353, 50172, 49991, 49811, 49631, 49452, 49274 ; 72->79
        DW      49097, 48920, 48743, 48568, 48393, 48128, 48044, 47871 ; 80->87
        DW      47699, 47527, 47356, 47185, 47015, 46846, 46677, 46509 ; 88->95
        DW      46341, 46174, 46008, 45842, 45677, 45512, 45348, 45185 ; 96->103
        DW      45022, 44859, 44698, 44537, 44376, 44216, 44057, 43898 ;104->111
        DW      43740, 43582, 43425, 43269, 43113, 42958, 42803, 42649 ;112->119
        DW      42495, 42342, 42189, 42037, 41886, 41735, 41584, 41434 ;120->127
        DW      41285, 41136, 40988, 40840, 40639, 40566, 40400, 40253 ;128->135
        DW      40110, 39965, 39821, 39678, 39535, 39392, 39250, 39109 ;136->143
        DW      38968, 38828, 38688, 38548, 38409, 38271, 38133, 37996 ;144->151
        DW      37859, 37722, 37586, 37451, 37316, 37181, 37047, 36914 ;152->159
        DW      36781, 36648, 36516, 36385, 36254, 36123, 35993, 35863 ;160->167
        DW      35734, 35605, 35477, 35349, 35221, 35095, 34968, 34842 ;168->175
        DW      34716, 34591, 34467, 34343, 34219, 34095, 33973, 33850 ;176->183
        DW      33728, 33607, 33486, 33365, 33245, 33125, 33005, 32887 ;184->191
        DW      32768, 32650, 32532, 32415, 32298, 32182, 32066, 31950 ;192->199
        DW      31835, 31720, 31606, 31492, 31379, 31266, 31153, 31041 ;200->207
        DW      30929, 30817, 30706, 30596, 30485, 30376, 30226, 30157 ;208->215
        DW      30048, 29940, 29832, 29725, 29618, 29511, 29405, 29299 ;216->223
        DW      29193, 29088, 28983, 28879, 28774, 28671, 28567, 28464 ;224->231
        DW      28362, 28260, 28158, 28056, 27955, 27855, 27754, 27654 ;232->239
        DW      27554, 27455, 27356, 27258, 27159, 27062, 26964, 26867 ;240->247
        DW      26770, 26674, 26577, 26482, 26386, 26291, 26196, 26102 ;248->255
        DW      26008                                                  ;256
;----------------------------------------------------------------------------
  align ALIGNsize_1,db 0
finelinearslideup_table: ; values are 16.16 bit
        DW      0, 1,     59, 1,    118, 1,   178, 1,   237, 1    ; 0->4
        DW      296, 1,   356, 1,   415, 1,   475, 1,   535, 1    ; 5->9
        DW      594, 1,   654, 1,   714, 1,   773, 1,   833, 1    ; 10->14
        DW      893, 1                                            ; 15
;----------------------------------------------------------------------------
finelinearslidedown_table: ; values are 0.16 bit
        DW      65535, 65477, 65418, 65359, 65300, 65241, 65182, 65359 ; 0->7
        DW      65065, 65006, 64947, 64888, 64830, 64772, 64713, 64645 ; 8->15
;----------------------------------------------------------------------------
extrafinelinearslidedown_table: ; values are 0.16 bit
        DW      65535, 65521, 65506, 65492, 65477, 65462, 65447, 65433 ; 0->7
        DW      65418, 65403, 65388, 65374, 65359, 65344, 65329, 65315 ; 8->15
;----------------------------------------------------------------------------
extrafinelinearslideup_table: ; values are 16.16 bit
        DW      0, 1,     15, 1,    30, 1,    44, 1,    59, 1     ; 0->4
        DW      74, 1,    89, 1,    104, 1,   118, 1,   133, 1    ; 5->9
        DW      148, 1,   163, 1,   178, 1,   193, 1,   207, 1    ; 10->14
        DW      222, 1,                                           ; 15
;----------------------------------------------------------------------------
  align ALIGNsize_1,db 0
;----------------------------------------------------------------------------
CHN_freq_quote         times CHN_nmb dd 0 ; 16.16 bit value from freq table
CHN_sampling_freq      times CHN_nmb dd 0 ; C-5 freq
;----------------------------------------------------------------------------
CHN_freq_cntr_data     times CHN_nmb dd 0 ; 2^31 fractional data for freq
CHN_freq_cntr_fract    times CHN_nmb dd 0 ; 2^31 fractional step for freq
CHN_freq_cntr_int      times CHN_nmb dd 0 ;      integer    step for freq
;----------------------------------------------------------------------------
CHN_sampling_pos       times CHN_nmb dd 0 ; current position
CHN_sampling_start     times CHN_nmb dd 0 ; Start of sample
CHN_sampling_end       times CHN_nmb dd 0 ; End   of sample
CHN_sampling_loopB     times CHN_nmb dd 0 ; loop Start
CHN_sampling_loopE     times CHN_nmb dd 0 ; loop End
CHN_sampling_susloopB  times CHN_nmb dd 0 ; Sloop Start
CHN_sampling_susloopE  times CHN_nmb dd 0 ; Sloop End
;----------------------------------------------------------------------------
CHN_sampling_flags     times CHN_nmb dd 0 ; channel_sampling_flags
;----------------------------------------------------------------------------
CHN_sample_CHNvol      times CHN_nmb db 0 ; channel volume (0-64)
CHN_sample_vol         times CHN_nmb db 0 ; default volume (0-64)
CHN_sample_Gvl         times CHN_nmb db 0 ; global  volume (0-128)
CHN_sample_pan         times CHN_nmb db 0 ; panning (0-64) 100 is surround
;----------------------------------------------------------------------------
CHN_maskvar            times CHN_nmb db 0
CHN_note               times CHN_nmb db 0 ; freq
CHN_instr              times CHN_nmb db 0 ; instrument number
CHN_smallCMD           times CHN_nmb db 0 ; small command (volume column effects)
CHN_CMD                times CHN_nmb db 0 ; command (general effects)
CHN_CMDvalue           times CHN_nmb db 0 ; command value
;----------------------------------------------------------------------------
row_number    dw 0 ; number of rows (32-200)
row_counter   dw 0 ; row counter
pattern_LGT   dw 0 ; length of compressed pattern
patternpos    dd 0 ; current position in pattern
ordpos        db 0 ; current position in order
;----------------------------------------------------------------------------








;----------------------------------------------------------------------------
; here is the END of the ITplayer - you can find here some useful description
;----------------------------------------------------------------------------
; channel sampling flags:
; (dword value) bits are:
;
; 0. sampling / no sampling
; 1. channel active / inactive
; 2. sampling is 16bit / 8bit
; 3. current direction is forward / backward
; 4. loop is on / off
; 5. loop direction is forward / ping-pong
; 6. susloop is on / off
; 7. susloop direction is forward / ping-pong
;
; 8. filter is on / off
; 9. -
; 10. -
; 11. interpolation is on / off
; 12. surround is on / off
; 13. sample is signed / unsigned
; 14. -
; 15. -
;
; bits 16-31 are unused.
;----------------------------------------------------------------------------
; Some mixing rutines:
;
;                   BPM*2      mixing frequency
; HZ = ticks/sec = -------     ---------------- = length of buffer
;                     5               HZ
;
;----------------------------------------------------------------------------
; Linear slide : 2^(val/192) - multiply, or divide with this
;                2^(val/768) - in fine linear slide
;                2^(val/3072) - in extra fine linear slide
;
;----------------------------------------------------------------------------
; Calculate current frequency: freq*(2^(1/12*val)) - value is the note (12 halftones)
;
;----------------------------------------------------------------------------
; Interpolation: Hermite Curve (Yehar's 2nd):
;
; Known samples: y(-1), y(0), y(1), y(2)
; Interpolated between 0..1
;
; Interpolated Sample:
;
;          f(x) = ax^3 + bx^2 + cx + y(0)   (x=0..1)
;
;              3 ( y(0) - y(1) ) - y(-1) + y(2)
;          a = --------------------------------
;                             2
;
;                               5 y(0) + y(2)
;          b = 2 y(1) + y(-1) - -------------
;                                     2
;
;              y(1) - y(-1)
;          c = ------------
;                   2
;
;----------------------------------------------------------------------------
; IT's filter
;
; freq = filter frequency (0 <= x <= 1)
; reso = filter resonance (0 <= x < 1)
;
; in   = input sample
; b    = bandpass out
; l    = lowpass out
;
; b=reso*b+freq*(in-l)
; l+=freq*b
;
; algorithm for each sample:
;                              fld dword [input]  ; (in)
;                              fsub dword [l]     ; (in-l)
;                              fmul dword [freq]  ; (freq*(in-l))
;                              fld dword [b]      ; (b) (freq*(in-l))
;                              fmul dword [reso]  ; (b*reso) (freq*(in-l))
;                              faddp st1,st0      ; (b*reso)+(freq*(in-l))
;                              fst dword [b]      ; ->Bandpass
;                              fmul dword [freq]  ; (b*reso)+(freq*(in-l))*freq
;                              fadd dword [l]     ; (b*reso)+(freq*(in-l))*freq+l
;                              fstp dword [l]     ; ->Lowpass
;
;----------------------------------------------------------------------------









