; File/Disk procedures by mogyi

segment code32 use32

%define FILES 0
%include "raw32.inc"
%include "files.inc"

;----------------------------------------------------------------------------
; convert EDX to DX:AX

bit32to16:
               add edx,[code32a]
               mov al,dl
               and ax,0fh
               shr edx,4
               ret
;----------------------------------------------------------------------------
; OPEN EXISTING FILE
; AL  = access mode
; EDX = ASCIZ filename
; CL  = attribute mask

; RETURN:
; CF clear if successful
;    AX = file handle
; CF set on error
;    AX = error code

Fopen:
               mov byte [v86r_ah],3dh
               mov byte [v86r_al],al
               mov byte [v86r_cl],cl
               mov byte [v86r_ch],0
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_dx],ax
               mov al,21h
               int RMCALL_VECT
               mov ax,word [v86r_ax]
               test word [v86r_flags],1
               jnz Fopen_error
               clc
               ret
Fopen_error:
               stc
               ret
;----------------------------------------------------------------------------
; CLOSE FILE
; BX  = file handle

; RETURN:
; CF clear if successful
;    AX destroyed
; CF set on error
;    AX = error code

Fclose:
               mov byte [v86r_ah],3eh
               mov word [v86r_bx],bx
               mov al,21h
               int RMCALL_VECT
               mov ax,word [v86r_ax]
               test word [v86r_flags],1
               jnz Fclose_error
               clc
               ret
Fclose_error:
               stc
               ret
;----------------------------------------------------------------------------
; READ FROM FILE OR DEVICE
; BX  = handle
; CX  = number of bytes to read
; EDX = buffer to data

; RETURN
; CF clear if successful
;    AX = number of bytes actually read (0 if at EOF before call)
; CF set on error
;    AX = error code

Fread:
               mov byte [v86r_ah],3fh
               mov word [v86r_bx],bx
               mov word [v86r_cx],cx
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_dx],ax
               mov al,21h
               int RMCALL_VECT
               mov ax,word [v86r_ax]
               test word [v86r_flags],1
               jnz Fread_error
               clc
               ret
Fread_error:
               stc
               ret
;----------------------------------------------------------------------------
; CREATE OR TRUNCATE FILE
; CX  = file attributes
; EDX = ASCIZ filename

; RETURN:
; CF clear if successful
;    AX = file handle
; CF set on error
;    AX = error code

Fcreate:
               mov byte [v86r_ah],3ch
               mov byte [v86r_ch],0
               mov byte [v86r_cl],cl
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_dx],ax
               mov al,21h
               int RMCALL_VECT
               mov ax,word [v86r_ax]
               test word [v86r_flags],1
               jnz Fcreate_error
               clc
               ret
Fcreate_error:
               stc
               ret
;----------------------------------------------------------------------------
; WRITE TO FILE OR DEVICE
; BX  = file handle
; CX  = number of bytes to write
; EDX = data to write

; RETURN
; CF clear if successful
;    AX = number of bytes actually written
; CF set on error
;    AX = error code

Fwrite:
               mov byte [v86r_ah],40h
               mov word [v86r_bx],bx
               mov word [v86r_cx],cx
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_dx],ax
               mov al,21h
               int RMCALL_VECT
               mov ax,word [v86r_ax]
               test word [v86r_flags],1
               jnz Fwrite_error
               clc
               ret
Fwrite_error:
               stc
               ret
;----------------------------------------------------------------------------
; SET CURRENT FILE POSITION
; AL  = origin of move
;       00 start of file
;       01 current file position
;       02 end of file
; BX  = file handle
; ECX = offset from origin of new file position

; RETURN
; CF clear if successful
;    ECX = new file position in bytes from start of file
; CF set on error
;    AX = error code

Fseek:
               mov byte [v86r_ah],42h
               mov byte [v86r_al],al
               mov word [v86r_bx],bx
               mov word [v86r_dx],cx
               shr ecx,16
               mov word [v86r_cx],cx
               mov al,21h
               int RMCALL_VECT

               test word [v86r_flags],1
               jnz Fseek_error
               mov cx,word [v86r_dx]
               shl ecx,16
               mov cx,word [v86r_ax]
               clc
               ret
Fseek_error:
               mov ax,word [v86r_ax]
               stc
               ret
;----------------------------------------------------------------------------
; CREATE SUBDIRECTORY
; EDX = ASCIZ pathname

; RETURN
; CF clear if successful
;    AX = destroyed
; CF set on error
;    AX = error code

Fmkdir:
               mov byte [v86r_ah],39h
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_dx],ax
               mov al,21h
               int RMCALL_VECT
               mov ax,[v86r_ax]
               test word [v86r_flags],1
               jnz Fmkdir_error
               clc
               ret
Fmkdir_error:
               stc
               ret
;----------------------------------------------------------------------------
; REMOVE SUBDIRECTORY
; EDX = ASCIZ pathname of directory to be removed

; RETURN
; CF clear if successful
;    AX = destroyed
; CF set on error
;    AX = error code

Frmdir:
               mov byte [v86r_ah],3ah
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_dx],ax
               mov al,21h
               int RMCALL_VECT
               mov ax,[v86r_ax]
               test word [v86r_flags],1
               jnz Frmdir_error
               clc
               ret
Frmdir_error:
               stc
               ret
;----------------------------------------------------------------------------
; SET CURRENT DIRECTORY
; EDX = ASCIZ pathname to become current directory (max 64 bytes)

; RETURN
; CF clear if successful
;    AX = destroyed
; CF set on error
;    AX = error code

Fchdir:
               mov byte [v86r_ah],3bh
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_dx],ax
               mov al,21h
               int RMCALL_VECT
               mov ax,[v86r_ax]
               test word [v86r_flags],1
               jnz Fchdir_error
               clc
               ret
Fchdir_error:
               stc
               ret
;----------------------------------------------------------------------------
; DELETE FILE
; CL  = attribute mask for deletion
; EDX = ASCIZfilename

; RETURN
; CF clear if successful
;    AX = destroyed
; CF set on error
;    AX = error code

Fdel:
               mov byte [v86r_cl],cl
               mov byte [v86r_ah],41h
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_dx],ax
               mov al,21h
               int RMCALL_VECT
               mov ax,[v86r_ax]
               test word [v86r_flags],1
               jnz Fdel_error
               clc
               ret
Fdel_error:
               stc
               ret
;----------------------------------------------------------------------------
; GET FILE ATTRIBUTES
; EDX = ASCIZfilename

; RETURN
; CF clear if successful
;    CX = file attributes
;    AX = CX
; CF set on error
;    AX = error code

Fget_attrib:
               mov word [v86r_ax],4300h
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_dx],ax
               mov al,21h
               int RMCALL_VECT
               mov cx,[v86r_cx]
               mov ax,[v86r_ax]
               test word [v86r_flags],1
               jnz Fget_attrib_error
               clc
               ret
Fget_attrib_error:
               stc
               ret
;----------------------------------------------------------------------------
; SET FILE ATTRIBUTES
; CX  = new attributes
; EDX = ASCIZfilename

; RETURN
; CF clear if successful
;    AX = destroyed
; CF set on error
;    AX = error code

Fchmod:
               mov word [v86r_cx],cx
               mov word [v86r_ax],4301h
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_dx],ax
               mov al,21h
               int RMCALL_VECT
               mov ax,[v86r_ax]
               test word [v86r_flags],1
               jnz Fchmod_error
               clc
               ret
Fchmod_error:
               stc
               ret
;----------------------------------------------------------------------------
; READ FROM FILE OR DEVICE (32bit)
; AL  = read mode 00 - read with ECX
;                 01 - read the whole file (no ECX need)
; BX  = handle
; ECX = number of bytes to read
; EDX = buffer to data (it can be lomem or himem too)

; RETURN
; CF clear if successful
;    ECX = number of bytes actually read (0 if at EOF before call)
;    EDI = new address
;    EDX = original address
;     AX = mode 00 - no error
;               01 - EOF detected (file length is 0, or unknown error.)
; CF set on error
;    AX = error code

Flongread:
               pusha
               cmp dword [copymem],0         ; is there the COPYMEM buffer ?
               jnz Flongread_noalloccopymem
               movzx eax,word [copymem_lgt]
               call getlomem
               mov [copymem],eax
Flongread_noalloccopymem:
               popa

               mov word [Flongread_hndl],bx  ; handle
               mov dword [Flongread_ecx],ecx ; original ECX
               mov dword [Flongread_edx],edx ; original READ ADDRESS
               mov dword [Flongread_orgedx],edx ; -""-

               cmp al,1
               jnz Flongread_nomode1
               mov word [Flongread_rmndr],0
               mov word [Flongread_counter],-1
               mov dword [Flongread_ecx],0
               jmp short Flongread_mode1
Flongread_nomode1:
               mov eax,ecx
               xor edx,edx
               movzx ebx,word [copymem_lgt]
               div ebx
               mov word [Flongread_rmndr],dx
               mov word [Flongread_counter],ax
               mov dword [Flongread_ecx],0       ; clear ECX
Flongread_mode1:
               cmp word [Flongread_counter],0
               jz Flongread_remainder
Flongread_highloop:
               mov bx,[Flongread_hndl]       ; HIGHLOAD
               mov edx,[copymem]
               mov cx,[copymem_lgt]
               call Fread
               jc Flongread_error
               cmp ax,0
               jz Flongread_EOF

               call Flongread_copy
               cmp ax,[copymem_lgt]
               jnz Flongread_endread

               mov al,1
               mov bx,[Flongread_hndl]
               mov ecx,0
               call Fseek

               dec word [Flongread_counter]
               jnz Flongread_highloop

Flongread_remainder:
               mov bx,[Flongread_hndl]
               mov edx,[copymem]
               mov cx,[Flongread_rmndr]
               jcxz Flongread_noremainder

               call Fread
               jc Flongread_error
               cmp ax,0
               jz Flongread_EOF

               call Flongread_copy

Flongread_noremainder:
Flongread_endread:
               clc
               mov ax,0
               mov ecx,[Flongread_ecx]
               mov edi,[Flongread_edx]
               ret
;----------------------------------------------------------------------------
Flongread_error:
               stc
               mov ax,[v86r_ax]
               ret
Flongread_EOF:
               clc
               mov ax,1
               mov ecx,[Flongread_ecx]
               mov edi,[Flongread_edx]
               ret
;----------------------------------------------------------------------------
Flongread_copy:
               push es
               push ds
               pop es

               pushf
               cld
               push ax
               mov esi,[copymem]
               mov edi,[Flongread_edx]
               movzx ecx,ax
               shr cx,1
               jnc Flongread_nomovsb
               movsb
Flongread_nomovsb:
               shr cx,1
               jnc Flongread_nomovsw
               movsw
Flongread_nomovsw:
               jcxz Flongread_nomovsd
               rep movsd
Flongread_nomovsd:
               pop ax
               movzx eax,ax
               add dword [Flongread_edx],eax
               add dword [Flongread_ecx],eax
               popf

               pop es
               ret
;----------------------------------------------------------------------------
Flongread_hndl dw 0
Flongread_ecx dd 0
Flongread_edx dd 0
Flongread_orgedx dd 0
Flongread_rmndr dw 0
Flongread_counter dw 0
copymem dd 0
copymem_lgt dw 65535 ; length of copymem buffer (it depends from the file length)
;----------------------------------------------------------------------------
; WRITE TO FILE OR DEVICE (32bit)
; BX  = file handle
; ECX = number of bytes to write
; EDX = data to write (it can be lomem or himem too)

; RETURN
; CF clear if successful
;    ECX = number of bytes actually written
;    EDI = new address
;    EDX = original address
; CF set on error
;    AX = error code

Flongwrite:
               pusha
               cmp dword [copymem],0         ; is there the COPYMEM buffer ?
               jnz Flongwrite_noalloccopymem
               movzx eax,word [copymem_lgt]
               call getlomem
               mov [copymem],eax
Flongwrite_noalloccopymem:
               popa

               mov word [Flongwrite_hndl],bx  ; handle
               mov dword [Flongwrite_ecx],ecx ; original ECX
               mov dword [Flongwrite_edx],edx ; original WRITE ADDRESS
               mov dword [Flongwrite_orgedx],edx ; -""-

               xor edx,edx
               mov eax,ecx
               movzx ebx,word [copymem_lgt]
               div ebx
               mov word [Flongwrite_rmndr],dx
               mov word [Flongwrite_counter],ax
               mov dword [Flongwrite_ecx],0      ; now ECX is 0

               cmp word [Flongwrite_counter],0
               jz Flongwrite_remainder
Flongwrite_highloop:
               mov cx,[copymem_lgt]

               call Flongwrite_copy

               mov bx,[Flongwrite_hndl]
               mov edx,[copymem]
               call Fwrite
               jc Flongwrite_error
               cmp ax,0
               jz Flongwrite_EOF

               cmp ax,[copymem_lgt]
               jnz Flongwrite_endread

               mov al,1
               mov bx,[Flongwrite_hndl]
               mov ecx,0
               call Fseek

               dec word [Flongwrite_counter]
               jnz Flongwrite_highloop
Flongwrite_remainder:
               mov cx,[Flongwrite_rmndr]
               jcxz Flongwrite_noremainder

               call Flongwrite_copy

               mov bx,[Flongwrite_hndl]
               mov edx,[copymem]
               call Fwrite
               jc Flongwrite_error
               cmp ax,0
               jz Flongwrite_EOF

Flongwrite_noremainder:
Flongwrite_endread:
               clc
               mov ecx,[Flongwrite_ecx]
               mov edi,[Flongwrite_edx]
               mov edx,[Flongwrite_orgedx]
               ret
;----------------------------------------------------------------------------
Flongwrite_error:
               stc
               mov ax,[v86r_ax]
               ret
Flongwrite_EOF:
               clc
               mov ecx,[Flongwrite_ecx]
               mov edi,[Flongwrite_edx]
               mov edx,[Flongwrite_orgedx]
               ret
;----------------------------------------------------------------------------
Flongwrite_copy:
               push es
               push ds
               pop es

               pushf
               cld
               push cx
               mov esi,[Flongwrite_edx]
               mov edi,[copymem]
               movzx ecx,cx
               shr cx,1
               jnc Flongwrite_nomovsb
               movsb
Flongwrite_nomovsb:
               shr cx,1
               jnc Flongwrite_nomovsw
               movsw
Flongwrite_nomovsw:
               jcxz Flongwrite_nomovsd
               rep movsd
Flongwrite_nomovsd:
               pop cx
               movzx eax,cx
               add dword [Flongwrite_edx],eax
               add dword [Flongwrite_ecx],eax
               popf

               pop es
               ret
;----------------------------------------------------------------------------
Flongwrite_hndl dw 0
Flongwrite_ecx dd 0
Flongwrite_edx dd 0
Flongwrite_orgedx dd 0
Flongwrite_rmndr dw 0
Flongwrite_counter dw 0
;----------------------------------------------------------------------------
; GET FILE SIZE
; BX  = handle

; RETURN
; CF clear if successful
;    EAX = filesize
; CF set on error
;    AX = error code

Fget_size:
               mov [v86r_bx],bx

               mov word [v86r_ax],4201h
               mov word [v86r_cx],0
               mov word [v86r_dx],0
               mov al,21h
               int RMCALL_VECT
               push word [v86r_dx]
               push word [v86r_ax]

               mov word [v86r_ax],4202h
               mov word [v86r_cx],0
               mov word [v86r_dx],0
               mov al,21h
               int RMCALL_VECT
               mov ax,[v86r_dx]
               shl eax,16
               mov ax,[v86r_ax]

               pop word [v86r_dx]
               pop word [v86r_cx]
               mov word [v86r_ax],4200h
               push eax
               mov al,21h
               int RMCALL_VECT
               pop eax

               test word [v86r_flags],1
               jnz Fget_size_error
               clc
               ret
Fget_size_error:
               stc
               ret
;----------------------------------------------------------------------------
; COPY SOME BYTES FROM SOURCE FILE TO DESTINATION FILE
; SI  = source file handle
; DI  = destination file handle
; ECX = number of bytes, if 0 then will be full copy

; RETURN
; CF clear if successful
;    EAX = number of copied bytes
; CF set on error
;    EAX = destroyed

Fcopy:
               cmp ecx,0
               jz near Fcopy_end

               mov [Fcopy_hndl1],si
               mov [Fcopy_hndl2],di
               pusha
               cmp dword [copymem],0         ; is there the COPYMEM buffer ?
               jnz Fcopy_noalloccopymem
               movzx eax,word [copymem_lgt]
               call getlomem
               mov [copymem],eax
Fcopy_noalloccopymem:
               popa

               mov dword [Fcopy_ecx],0
               cmp ecx,-1
               jnz Fcopy_nomode1
               mov word [Fcopy_rmndr],0
               mov word [Fcopy_counter],0FFFFh
               jmp short Fcopy_mode1
Fcopy_nomode1:
               xor edx,edx
               mov eax,ecx
               movzx ebx,word [copymem_lgt]
               div ebx
               mov word [Fcopy_rmndr],dx
               mov word [Fcopy_counter],ax
Fcopy_mode1:
               cmp word [Fcopy_counter],0
               jz Fcopy_remainder
Fcopy_highloop:
               mov bx,[Fcopy_hndl1]
               mov cx,[copymem_lgt]
               mov edx,[copymem]
               call Fread
               jc near Fcopy_error
               cmp ax,0
               jz near Fcopy_EOF

               mov bx,[Fcopy_hndl2]
               mov cx,ax
               mov edx,[copymem]
               call Fwrite
               jc Fcopy_error
               movzx eax,ax
               add dword [Fcopy_ecx],eax
               cmp ax,[copymem_lgt]
               jnz Fcopy_end

               dec word [Fcopy_counter]
               jnz Fcopy_highloop
Fcopy_remainder:
               cmp word [Fcopy_rmndr],0
               jz Fcopy_end

               mov bx,[Fcopy_hndl1]
               mov cx,[Fcopy_rmndr]
               mov edx,[copymem]
               call Fread
               jc Fcopy_error
               cmp ax,0
               jz Fcopy_EOF

               mov bx,[Fcopy_hndl2]
               mov cx,ax
               mov edx,[copymem]
               call Fwrite
               jc Fcopy_error
               movzx eax,ax
               add dword [Fcopy_ecx],eax
Fcopy_end:
               clc
               mov eax,[Fcopy_ecx]
               ret
;----------------------------------------------------------------------------
Fcopy_EOF:
               clc
               mov eax,[Fcopy_ecx]
               ret
;----------------------------------------------------------------------------
Fcopy_error:
               stc
               ret
;----------------------------------------------------------------------------
Fcopy_rmndr dw 0
Fcopy_counter dw 0
Fcopy_hndl1 dw 0
Fcopy_hndl2 dw 0
Fcopy_ecx dd 0
;----------------------------------------------------------------------------
; FIND FIRST/NEXT MATCHING FILE
; AH  = 4E find first matching file
; AH  = 4F find next  "
; AL  = special flag for use by append
; CX  = file attributes
; EDX = ASCIZ file specification

; RETURN
; CF clear if successful
;    DTA filled with FIND data block (at PSP:0080h is the DTA)
; CF set on error
;    AX = error code

Ffind:
               mov word [v86r_ax],ax
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_dx],ax
               mov word [v86r_cx],cx
               mov al,21h
               int RMCALL_VECT
               test word [v86r_flags],1
               jnz Ffind_error
               clc
               ret
Ffind_error:
               stc
               ret
;----------------------------------------------------------------------------
; GET FREE/TOTAL DISK SPACE
; DL  = drive number 00 = actual
;                    01 = A...

; RETURN
; AX  = 0FFFFh invalid drive
; else  v86_ax = sectors per cluster
;       v86_bx = number of free clusters
;       v86_cx = bytes per sector
;       v86_dx = total clusters on drive
; ax * bx * cx = free space
; ax * cx * dx = total space

Fget_diskspace:
               mov byte [v86r_ah],36h
               mov byte [v86r_dl],dl
               mov al,21h
               int RMCALL_VECT
               mov ax,[v86r_ax]
               mov bx,[v86r_bx]
               mul bx
               shl edx,16
               mov dx,ax
               mov eax,edx
               movzx ecx,word [v86r_cx]
               mul ecx
               mov [Ffree_space],eax

               mov ax,[v86r_ax]
               mov cx,[v86r_cx]
               mul cx
               shl edx,16
               mov dx,ax
               mov eax,edx
               movzx ecx,word [v86r_dx]
               mul ecx
               mov [Ftotal_space],eax

               mov eax,[Ffree_space]
               mov ebx,[Ftotal_space]
               ret
Ffree_space dd 0
Ftotal_space dd 0
;----------------------------------------------------------------------------
; DISK RESET
Freset_disk:
               mov byte [v86r_ah],0dh
               mov al,21h
               int RMCALL_VECT
               ret
;----------------------------------------------------------------------------
; SELECT DEFAULT DRIVE
; DL  = new default drive 00 = A..

; RETURN
; AL  = number of potentially valid drive letters

Fselect_drive:
               mov byte [v86r_ah],0eh
               mov byte [v86r_dl],dl
               mov al,21h
               int RMCALL_VECT
               mov al,[v86r_al]
               ret
;----------------------------------------------------------------------------
; GET DEFAULT DRIVE

; RETURN
; AL  = default drive 00 = A..

Fget_drive:
               mov byte [v86r_ah],19h
               mov al,21h
               int RMCALL_VECT
               mov al,[v86r_al]
               ret
;----------------------------------------------------------------------------
; GET DRIVE PARAMETER FOR DEFAULT DRIVE

; RETURN
; AL  = status
;       00h if successful
;              DS:BX -> DPB (drive parameter block)
;       FFh invalid or network drive

Fget_driveparam:
               mov byte [v86r_ah],1fh
               mov al,21h
               int RMCALL_VECT
               mov al,byte [v86r_al]
               ret
;----------------------------------------------------------------------------
; GET SYSTEM DATE

; RETURN
; CX  = year (1980-2099)
; DH  = month
; DL  = day
; AL  = day of week (00 = sunday)  (?)

Fget_date:
               mov byte [v86r_ah],2ah
               mov al,21h
               int RMCALL_VECT
               mov cx,[v86r_cx]
               mov dx,[v86r_dx]
               mov ax,[v86r_ax]
               ret
;----------------------------------------------------------------------------
; SET SYSTEM DATE
; CX  = year
; DH  = month
; DL  = day

; RETURN
; AL  = status
;       00h if successful
;       FFh invalid date, system date unchanged

Fset_date:
               mov byte [v86r_ah],2bh
               mov word [v86r_cx],cx
               mov word [v86r_dx],dx
               mov al,21h
               int RMCALL_VECT
               mov al,[v86r_al]
               ret
;----------------------------------------------------------------------------
; GET SYSTEM TIME

; RETURN
; CH  = hour
; CL  = minute
; DH  = second
; DL  = 1/100 seconds

Fget_time:
               mov byte [v86r_ah],2ch
               mov al,21h
               int RMCALL_VECT
               mov cx,[v86r_cx]
               mov dx,[v86r_dx]
               ret
;----------------------------------------------------------------------------
; SET SYSTEM TIME
; CH  = hour
; CL  = minute
; DH  = second
; DL  = 1/100 seconds

; RETURN
; AL  = result
;       00h if successful
;       FFh invalid time, system time unchanged

Fset_time:
               mov byte [v86r_ah],2dh
               mov word [v86r_cx],cx
               mov word [v86r_dx],dx
               mov al,21h
               int RMCALL_VECT
               mov al,[v86r_al]
               ret
;----------------------------------------------------------------------------
; GET CURRENT DIRECTORY
; AL  = drive number 00 = def, 01 = A..
; EDX = 64 byte buffer for ASCIZ pathname

; RETURN
; CF set on error
;    AX = error code
; CF clear if successful
;    AX = 0100h - undocumented

Fget_cwd:
               mov ah,47h
               mov word [v86r_ax],ax
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_si],ax
               mov al,21
               int RMCALL_VECT
               mov ax,[v86r_ax]
               test word [v86r_flags],1
               jnz Fget_cwd_error
               clc
               ret
Fget_cwd_error:
               stc
               ret
;----------------------------------------------------------------------------
; RENAME FILE
; EDX = ASCIZ existing filename
; EDI = ASCIZ new filename
; CL  = attribute mask

; RETURN
; CF clear if successful
; CF set on error
;    AX = error code

Frename:
               mov byte [v86r_ah],56h
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_dx],ax
               mov edx,edi
               call bit32to16
               mov word [v86r_es],dx
               mov word [v86r_di],ax
               mov byte [v86r_cl],cl
               mov al,21h
               int RMCALL_VECT
               mov ax,[v86r_ax]
               test word [v86r_flags],1
               jnz Frename_error
               clc
               ret
Frename_error:
               stc
               ret
;----------------------------------------------------------------------------
; GET FILE'S LAST WRITTEN DATE AND TIME
; BX  = handle

; RETURN
; CF clear if successful
;    CX = time
;    DX = date
; CF set on error
;    AX = error code

Fget_lastwdt:
               mov word [v86r_ax],5700h
               mov word [v86r_bx],bx
               mov al,21h
               int RMCALL_VECT
               mov ax,word [v86r_ax]
               test word [v86r_flags],1
               jnz Fget_lastwdt_error
               mov cx,[v86r_cx]
               mov dx,[v86r_dx]
               clc
               ret
Fget_lastwdt_error:
               stc
               ret
;----------------------------------------------------------------------------
; SET FILE'S LAST WRITTEN DATE AND TIME
; BX  = handle
; CX  = new time
; DX  = new date

; RETURN
; CF clear if successful
; CF set on error
;    AX = error code

Fset_lastwdt:
               mov word [v86r_ax],5701h
               mov word [v86r_bx],bx
               mov word [v86r_cx],cx
               mov word [v86r_dx],dx
               mov al,21h
               int RMCALL_VECT
               test word [v86r_flags],1
               jnz Fset_lastwdt_error
               mov ax,word [v86r_ax]
               clc
               ret
Fset_lastwdt_error:
               stc
               ret
;----------------------------------------------------------------------------
; GET/SET DISK SERIAL NUMBER
; AL  = mode 00 get ser number
;            01 set ser number
; BL  = drive 00 = def.  01 = A..
; BH  = info level 00 for dos, 01 for other (?)
; EDX = disk info

; RETURN
; CF clear if successful
;    AL = 00 buffer filled
;         01 buffer set
; CF set on error
;    AX = error code

Fdisk_serialnmb:
               mov ah,69h
               mov word [v86r_ax],ax
               mov word [v86r_bx],bx
               call bit32to16
               mov word [v86r_ds],dx
               mov word [v86r_dx],ax
               mov al,21h
               int RMCALL_VECT
               mov ax,word [v86r_ax]
               test word [v86r_flags],1
               jnz Fdisk_serialnmb_error
               clc
               ret
Fdisk_serialnmb_error:
               stc
               ret
; 00h dw info level
; 02h dd disk serial number (binary)
; 06h 11 volume label
; 11h  8 filesystem time (only if AL=00)
;----------------------------------------------------------------------------






;----------------------------------------------------------------------------
; Bit(s)      ACCESS MODE
; 2-0         000 read only
;             001 write only
;             010 read/write
;             011 passed to redirector on EXEC to allow case-sensitive filenames
; 3           (reserved)
; 6-4         SHARING MODE
;             000 compatibility mode
;             001 "DENYALL" prohibit both read and write access by others
;             010 "DENYWRITE" prohibit write access by others
;             011 "DENYREAD" prohibit read access by others
;             100 "DENYNONE" allow full access by others
;             111 network FCB
; 7           inheritance
;----------------------------------------------------------------------------
; Bit(s)      ATTRIBUTES
; 0           read-only
; 1           hidden
; 2           system
; 3           volume label (ignored)
; 4           reserved, must be zero (directory)
; 5           archive
; 7           if set, file is shareable under Novell NetWare
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
;Values for DOS extended error code:
; 00h (0)   no error
; 01h (1)   function number invalid
; 02h (2)   file not found
; 03h (3)   path not found
; 04h (4)   too many open files (no handles available)
; 05h (5)   access denied
; 06h (6)   invalid handle
; 07h (7)   memory control block destroyed
; 08h (8)   insufficient memory
; 09h (9)   memory block address invalid
; 0Ah (10)  environment invalid (usually >32K in length)
; 0Bh (11)  format invalid
; 0Ch (12)  access code invalid
; 0Dh (13)  data invalid
; 0Eh (14)  reserved
; 0Fh (15)  invalid drive
; 10h (16)  attempted to remove current directory
; 11h (17)  not same device
; 12h (18)  no more files
;---DOS 3.0+ ---
; 13h (19)  disk write-protected
; 14h (20)  unknown unit
; 15h (21)  drive not ready
; 16h (22)  unknown command
; 17h (23)  data error (CRC)
; 18h (24)  bad request structure length
; 19h (25)  seek error
; 1Ah (26)  unknown media type (non-DOS disk)
; 1Bh (27)  sector not found
; 1Ch (28)  printer out of paper
; 1Dh (29)  write fault
; 1Eh (30)  read fault
; 1Fh (31)  general failure
; 20h (32)  sharing violation
; 21h (33)  lock violation
; 22h (34)  disk change invalid (ES:DI -> media ID structure)(see #01658)
; 23h (35)  FCB unavailable
; 24h (36)  sharing buffer overflow
; 25h (37)  (DOS 4.0+) code page mismatch
; 26h (38)  (DOS 4.0+) cannot complete file operation (out of input)
; 27h (39)  (DOS 4.0+) insufficient disk space
; 28h-31h   reserved
; 32h (50)  network request not supported
; 33h (51)  remote computer not listening
; 34h (52)  duplicate name on network
; 35h (53)  network name not found
; 36h (54)  network busy
; 37h (55)  network device no longer exists
; 38h (56)  network BIOS command limit exceeded
; 39h (57)  network adapter hardware error
; 3Ah (58)  incorrect response from network
; 3Bh (59)  unexpected network error
; 3Ch (60)  incompatible remote adapter
; 3Dh (61)  print queue full
; 3Eh (62)  queue not full
; 3Fh (63)  not enough space to print file
; 40h (64)  network name was deleted
; 41h (65)  network: Access denied
; 42h (66)  network device type incorrect
; 43h (67)  network name not found
; 44h (68)  network name limit exceeded
; 45h (69)  network BIOS session limit exceeded
; 46h (70)  temporarily paused
; 47h (71)  network request not accepted
; 48h (72)  network print/disk redirection paused
; 49h (73)  network software not installed
;            (LANtastic) invalid network version
; 4Ah (74)  unexpected adapter close
;            (LANtastic) account expired
; 4Bh (75)  (LANtastic) password expired
; 4Ch (76)  (LANtastic) login attempt invalid at this time
; 4Dh (77)  (LANtastic v3+) disk limit exceeded on network node
; 4Eh (78)  (LANtastic v3+) not logged in to network node
; 4Fh (79)  reserved
; 50h (80)  file exists
; 51h (81)  reserved
; 52h (82)  cannot make directory
; 53h (83)  fail on INT 24h
; 54h (84)  (DOS 3.3+) too many redirections
; 55h (85)  (DOS 3.3+) duplicate redirection
; 56h (86)  (DOS 3.3+) invalid password
; 57h (87)  (DOS 3.3+) invalid parameter
; 58h (88)  (DOS 3.3+) network write fault
; 59h (89)  (DOS 4.0+) function not supported on network
; 5Ah (90)  (DOS 4.0+) required system component not installed
; 5Bh (91)  (NetWare4) timer server table overflowed
; 5Ch (92)  (NetWare4) duplicate in timer service table
; 5Dh (93)  (NetWare4) no items to work on
; 5Fh (95)  (NetWare4) invalid interrupt
; 64h (100) (MSCDEX) unknown error
; 64h (100) (NetWare4) open semaphore limit exceeded
; 65h (101) (MSCDEX) not ready
; 65h (101) (NetWare4) exclusive semaphore is already owned
; 66h (102) (MSCDEX) EMS memory no longer valid
; 66h (102) (NetWare4) semaphore was set when close attempted
; 67h (103) (MSCDEX) not High Sierra or ISO-9660 format
; 67h (103) (NetWare4) too many exclusive semaphore requests
; 68h (104) (MSCDEX) door open
; 68h (104) (NetWare4) operation invalid from interrupt handler
; 69h (105) (NetWare4) semaphore owner died
; 6Ah (106) (NetWare4) semaphore limit exceeded
; 6Bh (107) (NetWare4) insert drive B: disk into drive A:
; 6Ch (108) (NetWare4) drive locked by another process
; 6Dh (109) (NetWare4) broken pipe
; 6Eh (110) (NetWare4) pipe open/create failed
; 6Fh (111) (NetWare4) pipe buffer overflowed
; 70h (112) (NetWare4) disk full
; 71h (113) (NetWare4) no more search handles
; 72h (114) (NetWare4) invalid target handle for dup2
; 73h (115) (NetWare4) bad user virtual address
; 74h (116) (NetWare4) error on console I/O
; 75h (117) (NetWare4) unknown category code for IOCTL
; 76h (118) (NetWare4) invalid value for verify flag
; 77h (119) (NetWare4) level four driver not found
; 78h (120) (NetWare4) invalid function number
; 79h (121) (NetWare4) semaphore timeout
; 7Ah (122) (NetWare4) buffer too small
; 7Bh (123) (NetWare4) invalid character or bad file-system name
; 7Ch (124) (NetWare4) unimplemented information level
; 7Dh (125) (NetWare4) no volume label found
; 7Eh (126) (NetWare4) module handle not found
; 7Fh (127) (NetWare4) procedure address not found
; 80h (128) (NetWare4) CWait found no children
; 81h (129) (NetWare4) CWait children still running
; 82h (130) (NetWare4) invalid operation for direct disk-access handle
; 83h (131) (NetWare4) attempted seek to negative offset
; 84h (132) (NetWare4) attempted to seek on device or pipe
; 85h (133) (NetWare4) drive already has JOINed drives
; 86h (134) (NetWare4) drive is already JOINed
; 87h (135) (NetWare4) drive is already SUBSTed
; 88h (136) (NetWare4) can not delete drive which is not JOINed
; 89h (137) (NetWare4) can not delete drive which is not SUBSTed
; 8Ah (138) (NetWare4) can not JOIN to a JOINed drive
; 8Bh (139) (NetWare4) can not SUBST to a SUBSTed drive
; 8Ch (140) (NetWare4) can not JOIN to a SUBSTed drive
; 8Dh (141) (NetWare4) can not SUBST to a JOINed drive
; 8Eh (142) (NetWare4) drive is busy
; 8Fh (143) (NetWare4) can not JOIN/SUBST to same drive
; 90h (144) (NetWare4) directory must not be root directory
; 91h (145) (NetWare4) can only JOIN to empty directory
; 92h (146) (NetWare4) path is already in use for SUBST
; 93h (147) (NetWare4) path is already in use for JOIN
; 94h (148) (NetWare4) path is in use by another process
; 95h (149) (NetWare4) directory previously SUBSTituted
; 96h (150) (NetWare4) system trace error
; 97h (151) (NetWare4) invalid event count for DosMuxSemWait
; 98h (152) (NetWare4) too many waiting on mutex
; 99h (153) (NetWare4) invalid list format
; 9Ah (154) (NetWare4) volume label too large
; 9Bh (155) (NetWare4) unable to create another TCB
; 9Ch (156) (NetWare4) signal refused
; 9Dh (157) (NetWare4) segment discarded
; 9Eh (158) (NetWare4) segment not locked
; 9Fh (159) (NetWare4) invalid thread-ID address
; A0h (160) (NetWare4) bad environment pointer
; A1h (161) (NetWare4) invalid name passed to EXEC
; A2h (162) (NetWare4) signal already pending
; A3h (163) (NetWare4) ERROR_124 mapping
; A4h (164) (NetWare4) no more process slots
; A5h (165) (NetWare4) ERROR_124 mapping
; B0h (176) (MS-DOS 7.0) volume is not locked
; B1h (177) (MS-DOS 7.0) volume is locked in drive
; B2h (178) (MS-DOS 7.0) volume is not removable
; B4h (180) (MS-DOS 7.0) lock count has been exceeded
; B4h (180) (NetWare4) invalid segment number
; B5h (181) (MS-DOS 7.0) a valid eject request failed
; B5h (181) (NetWare4) invalid call gate
; B6h (182) (NetWare4) invalid ordinal
; B7h (183) (NetWare4) shared segment already exists
; B8h (184) (NetWare4) no child process to wait for
; B9h (185) (NetWare4) NoWait specified and child still running
; BAh (186) (NetWare4) invalid flag number
; BBh (187) (NetWare4) semaphore does not exist
; BCh (188) (NetWare4) invalid starting code segment
; BDh (189) (NetWare4) invalid stack segment
; BEh (190) (NetWare4) invalid module type (DLL can not be used as application)
; BFh (191) (NetWare4) invalid EXE signature
; C0h (192) (NetWare4) EXE marked invalid
; C1h (193) (NetWare4) bad EXE format (e.g. DOS-mode program)
; C2h (194) (NetWare4) iterated data exceeds 64K
; C3h (195) (NetWare4) invalid minimum allocation size
; C4h (196) (NetWare4) dynamic link from invalid Ring
; C5h (197) (NetWare4) IOPL not enabled
; C6h (198) (NetWare4) invalid segment descriptor privilege level
; C7h (199) (NetWare4) automatic data segment exceeds 64K
; C8h (200) (NetWare4) Ring2 segment must be moveable
; C9h (201) (NetWare4) relocation chain exceeds segment limit
; CAh (202) (NetWare4) infinite loop in relocation chain
; CBh (203) (NetWare4) environment variable not found
; CCh (204) (NetWare4) not current country
; CDh (205) (NetWare4) no signal sent
; CEh (206) (NetWare4) file name not 8.3
; CFh (207) (NetWare4) Ring2 stack in use
; D0h (208) (NetWare4) meta expansion is too long
; D1h (209) (NetWare4) invalid signal number
; D2h (210) (NetWare4) inactive thread
; D3h (211) (NetWare4) file system information not available
; D4h (212) (NetWare4) locked error
; D5h (213) (NetWare4) attempted to execute non-family API call in DOS mode
; D6h (214) (NetWare4) too many modules
; D7h (215) (NetWare4) nesting not allowed
; E6h (230) (NetWare4) non-existent pipe, or bad operation
; E7h (231) (NetWare4) pipe is busy
; E8h (232) (NetWare4) no data available for nonblocking read
; E9h (233) (NetWare4) pipe disconnected by server
; EAh (234) (NetWare4) more data available
; FFh (255) (NetWare4) invalid drive
;----------------------------------------------------------------------------
