; 3D engine, all 3D functions except mappers, + screen functions, etc..

segment code32 use32

%define ENGINE3D

%include "3Dengine.inc"
%include "3Drotate.inc"
%include "raw32.inc"
%include "files.inc"
%include "procs.inc"
%include "nasmmacr.inc"

%include "truemap.inc"
;----------------------------------------------------------------------------
; VESA functions
;----------------------------------------------------------------------------
VESA.setmode:
                     mov   bx,[screen.mode]

                     mov   W [v86r_ax],4F02h
                     mov   [v86r_bx],bx
                     mov   al,10h
                     int   RMCALL_VECT
                     ret
;----------------------------------------------------------------------------
VESA.setpage:
                     mov   bx,0
                     mov   dx,[screen.page]

                     mov   W [v86r_ax],4F05h
                     mov   [v86r_bx],bx    ; window num 0=A, 1=B
                     mov   [v86r_dx],dx    ; page
                     mov   al,10h
                     int   RMCALL_VECT
                     ret
;----------------------------------------------------------------------------
VESA.setaddress:
                     mov   bx,0
                     mov   cx,0
                     mov   dx,[screen.Yaddress]

                     mov   W [v86r_ax],4F07h
                     mov   [v86r_bx],bx
                     mov   [v86r_cx],cx
                     mov   [v86r_dx],dx
                     mov   al,10h
                     int   RMCALL_VECT
                     ret
;----------------------------------------------------------------------------
VESA.getinfo:
                     mov   edx,VESA.infoblock
                     call  bit32to16
                     mov   [v86r_es],dx
                     mov   [v86r_di],ax
                     mov   W [v86r_ax],4F00h
                     mov   al,10h
                     int   RMCALL_VECT
                     mov   ax,[v86r_ax]
                     cmp   ah,0
                     jz    .ok
                     dosprint .msg1
                     stc
                     ret
.ok:
                     dosprint .msg2
                     xor   eax,eax
                     mov   al,[VESA.infoblock+4+1]
                     call  decwrite
                     dosprint .msg3
                     xor   eax,eax
                     mov   al,[VESA.infoblock+4]
                     call  decwrite
                     clc
                     mov   ax,[VESA.infoblock+4]
                     ret
.msg1 db "VESA not found.$"
.msg2 db "VESA version $"
.msg3 db ".$"
;----------------------------------------------------------------------------
VESA.infoblock times 256 db 0
;----------------------------------------------------------------------------
; END of VESA functions
;----------------------------------------------------------------------------








;----------------------------------------------------------------------------
; fill videomemory
videomem.fill:
                     mov   edi,0A0000h
                     mov   eax,[videomem.filldata]
                     mov   ecx,[screen.length]
                     and   ecx,0FFFFh
                     shr   ecx,4
.loop:
                     mov   [gs:edi],eax
                     mov   [gs:edi+4],eax
                     mov   [gs:edi+8],eax
                     mov   [gs:edi+12],eax
                     add   edi,16
                     dec   ecx
                     jnz   .loop
                     ret
;----------------------------------------------------------------------------
; set videomode
videomode.set:
                     mov   ax,[screen.mode]
                     mov   [v86r_ax],ax
                     mov   al,10h
                     int   RMCALL_VECT
                     ret
;----------------------------------------------------------------------------
; get virtual videomem
V.videomem.get:
                     mov   eax,[screen.length]
                     call  gethimem
                     mov   [V_videomem],eax
                     ret
;----------------------------------------------------------------------------
; fill virtual video memory
V.videomem.fill:
                     mov   esi,[V_videomem]
                     mov   eax,[videomem.filldata]
                     mov   ecx,[screen.length]
                     shr   ecx,4
.loop:
                     mov   [esi],eax
                     mov   [esi+4],eax
                     mov   [esi+8],eax
                     mov   [esi+12],eax
                     add   esi,16
                     dec   ecx
                     jnz   .loop
                     ret
;----------------------------------------------------------------------------
videomem.filldata    dd 0
;----------------------------------------------------------------------------
; copy virtual video memory
V.videomem.copy:
                     mov   W [screen.page],0

                     mov   dx,[screen.maxpages]
                     cmp   dx,0
                     jnz   .another

                     mov   esi,[V_videomem]
                     mov   edi,0A0000h
                     mov   ecx,[screen.length]
                     shr   ecx,3
.loop:
                     mov   eax,[esi]
                     mov   ebx,[esi+4]
                     mov   [gs:edi],eax
                     mov   [gs:edi+4],ebx
                     add   esi,8
                     add   edi,8
                     dec   ecx
                     jnz   .loop
                     ret
;----------------------------------------------------------------------------
.another:
                     mov   esi,[V_videomem]
.loop3:
                     mov   edi,0A0000h
                     mov   ecx,65536/8
.loop2:
                     mov   eax,[esi]
                     mov   ebx,[esi+4]
                     mov   [gs:edi],eax
                     mov   [gs:edi+4],ebx
                     add   esi,8
                     add   edi,8
                     dec   ecx
                     jnz   .loop2

                     inc   word [screen.page]
                     push  dx
                     call  VESA.setpage
                     pop   dx

                     dec   dx
                     jnz   .loop3

                     mov   edi,0A0000h
                     mov   ecx,[screen.remlength]
                     shr   ecx,3
.loop4:
                     mov   eax,[esi]
                     mov   ebx,[esi+4]
                     mov   [gs:edi],eax
                     mov   [gs:edi+4],ebx
                     add   esi,8
                     add   edi,8
                     dec   ecx
                     jnz   .loop4
                     ret
;----------------------------------------------------------------------------
vert.retr:
                     mov   dx,3DAh
.w1:
                     in    al,dx
                     test  al,8
                     jnz   .w1
.w2:
                     in    al,dx
                     test  al,8
                     jz    .w2
                     ret
;----------------------------------------------------------------------------
rand.gen:
                     mov   eax,[seed]
                     rol   eax,16
                     mov   edx,eax
                     rol   edx,3
                     xor   edx,eax
                     mov   ax,dx
                     mov   [seed],eax
                     movzx eax,ax
                     ret
seed dd "aabacada"
;----------------------------------------------------------------------------








;----------------------------------------------------------------------------
init_3D_engine:
                     call  gen.sintable

                     mov   eax,256*256
                     call  gethimem
                     mov   [texture_map],eax
                     mov   eax,256*64
                     call  gethimem
                     mov   [shade_table],eax

                     call  load_texture
                     call  load_shadetable
                     call  load_palette
                     call  set_palette
;----------------------------------------------------------------------------
                     mov   eax,[texture_map]
                     mov   ebx,[shade_table]
                     mov   ecx,[V_videomem]
                     mov   edx,put_true_gshaded_arbitrary_tiled_tmap
                     mov   esi,texture_shadetable_setup

                     mov   [mapper.map],eax
                     mov   [mapper.shadetable],ebx
                     mov   [mapper.screen],ecx
                     mov   [mapper.drawpoly],edx
                     mov   [mapper.setup],esi
;----------------------------------------------------------------------------
                     mov   ax,[screen.Xreso]
                     mov   [mapper.Xreso],ax

                     mov   ax,[screen.Xreso]
                     mov   bx,[screen.Yreso]
                     mov   [Clip.XR],ax
                     mov   [Clip.YD],bx
                     ret
;----------------------------------------------------------------------------
set_palette:
                     mov   esi,palette
                     xor   cl,cl
.loop:
                     mov   dx,3C8h
                     mov   al,cl
                     out   dx,al
                     inc   dl
                     mov   al,[esi]
                     shr   al,2
                     out   dx,al
                     mov   al,[esi+1]
                     shr   al,2
                     out   dx,al
                     mov   al,[esi+2]
                     shr   al,2
                     out   dx,al

                     add   esi,4
                     inc   cl
                     jnz   .loop
                     ret
;----------------------------------------------------------------------------
load_texture:
                     Fopen texture_name,0,0,[handle]
                     jnc .noloaderror
                     dosprint texture_loaderr
                     jmp exit
.noloaderror:
                     Flongread 1,[handle],[texture_map]
                     Fclose [handle]
                     ret
;----------------------------------------------------------------------------
load_shadetable:
                     Fopen shadetable_name,0,0,[handle]
                     jnc .noloaderror
                     dosprint shadetable_loaderr
                     jmp exit
.noloaderror:
                     Flongread 1,[handle],[shade_table]
                     Fclose [handle]
                     ret
;----------------------------------------------------------------------------
load_palette:
                     Fopen palette_name,0,0,[handle]
                     jnc .noloaderror
                     dosprint palette_loaderr
                     jmp exit
.noloaderror:
                     Flongread 1,[handle],palette
                     Fclose [handle]
                     ret
;----------------------------------------------------------------------------
handle               dw 0
V_videomem           dd 0
texture_map          dd 0
shade_table          dd 0
palette times 1024   db 0
;----------------------------------------------------------------------------
texture_name    db "texture",0
shadetable_name db "shadetab",0
palette_name    db "palette",0
;----------------------------------------------------------------------------
texture_loaderr    db "texture not found.$"
shadetable_loaderr db "shadetable not found.$"
palette_loaderr    db "palette not found.$"
;----------------------------------------------------------------------------


;----------------------------------------------------------------------------
screen.Xreso     dw 320      ; xreso
screen.Yreso     dw 200      ; yreso
screen.mode      dw 13h      ; videomode
screen.length    dd 320*200  ; xreso*yreso
screen.page      dw 0        ; reserved (nem h)
screen.maxpages  dw 0        ; hany db page,
screen.remlength dw 45056    ; mennyi marad a pagebol: (pl 640*480-65536*4=45056)
screen.Yaddress  dw 0        ; ez most mi?
;----------------------------------------------------------------------------












;----------------------------------------------------------------------------
; ENGINE for rotations
;----------------------------------------------------------------------------
; gen sin+cos table for rotation
gen.sintable:
                     finit
                     mov   edi,sintable
.loop:
                     fild  W [.cntr]
                     fdiv  D [.diver]
                     fsin
                     fimul W [.muler]
                     fistp D [edi]
                     add   edi,4
                     inc   W [.cntr]
                     cmp   W [.cntr],512+128
                     jnz   .loop
                     ret
.diver  dd 81.4873308630504119
.cntr   dw 0
.muler  dw 32767
;----------------------------------------------------------------------------
alpha   dd 0  ; angle around Z
beta    dd 0  ; angle around X
gamma   dd 0  ; angle around Y
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
; coordinate area rotation
rotate.area:
                     mov   esi,oldpoints
                     mov   ecx,[oldpoints.number]
                     mov   edi,newpoints
                     mov   ebp,points.zdata
.loop:
                     mov   ax,[esi]
                     mov   bx,[esi+2]
                     mov   dx,[esi+4]
                     mov   [x],ax
                     mov   [y],bx
                     mov   [z],dx

                     push  ecx
                     push  edi
                     push  esi
                     push  ebp
                     call  rotate.dot
                     pop   ebp
                     pop   esi
                     mov   ax,[z2]
                     pop   edi
                     mov   [ds:ebp],ax

                     call  fix.dot
                     pop   ecx

                     add   esi,6
                     add   edi,6
                     add   ebp,2

                     dec   ecx
                     jnz   .loop
                     ret
;----------------------------------------------------------------------------
; fix dot's X,Y, and Z coordinate + calculate perspective Z
fix.dot:
                     xor   ebx,ebx
                     movsx eax,W [z2]
                     mov   bx,[Zmul1]
                     imul  eax,ebx
                     sar   eax,Zsar1

                     mov   [edi+4],ax
                     add   ax,[Zmid]
                     and   eax,65535

                     movsx ebx,W [x2]
                     movsx ecx,W [y2]
                     imul  ebx,eax
                     imul  ecx,eax

                     mov   eax,ebx
                     cdq
                     xor   ebx,ebx
                     mov   bx,[Zdiv]
                     idiv  ebx
                     add   ax,[Xmid]
                     mov   [edi],ax

                     mov   eax,ecx
                     cdq
                     idiv  ebx
                     add   ax,[Ymid]
                     mov   [edi+2],ax


                     xor   ebx,ebx
                     movsx eax,W [edi+4]
                     mov   bx,[Zmul2]
                     imul  eax,ebx
                     sar   eax,8
                     neg   ax
                     add   ax,[Zmid]
                     mov   [edi+4],ax

                     ret
;----------------------------------------------------------------------------
; coordination datas
Xmid    dw 160       ; middle X
Ymid    dw 100       ; middle Y
Zmid    dw 0x2000    ; middle Z - best for Z perspective

Zdiv    dw 0x2000    ; near/far - distance? (nagysag)
Zsar1   equ 7        ; 7 instead of 8 for better perspective
Zmul1   dw 5800      ; a divider
Zmul2   dw 256       ; but why?
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
; calculate colors (Z gouraud mode) for all vertex in points.z/s/t data
calc.zgouraud:
                     mov   esi,points.zdata
                     mov   edi,points.sdata
                     mov   ebp,points.tdata
                     mov   ecx,[polygon.number]
.loop:
                     add   ebp,6
                     call  calc.zgouraud.col
                     add   ebp,2
                     add   esi,2
                     add   edi,2
                     call  calc.zgouraud.col
                     add   ebp,2
                     add   esi,2
                     add   edi,2
                     call  calc.zgouraud.col
                     add   ebp,2
                     add   esi,2
                     add   edi,2

                     dec   ecx
                     jnz   .loop
                     ret
;----------------------------------------------------------------------------
;  for that
calc.zgouraud.col:
                     mov   ax,[esi]
                     xor   ebx,ebx
                     shl   eax,16
                     mov   bx,[zg.diver]
                     cdq
                     idiv  ebx
                     sar   eax,16
                     add   ax,[ds:ebp]

                     cmp   ax,[zg.min]
                     jge   .nomin
                     mov   ax,[zg.min]
.nomin:
                     cmp   ax,[zg.max]
                     jle   .nomax
                     mov   ax,[zg.max]
.nomax:
                     mov   [edi],ax
                     ret
;----------------------------------------------------------------------------
zg.diver  dw 12      ; divider for shading
zg.min    dw 0       ; minimal shade
zg.max    dw 63      ; maximal shade
;----------------------------------------------------------------------------

;----------------------------------------------------------------------------
; put polygons from area
area.putpoly_1:
                     mov   ecx,[polygon.number]
                     mov   esi,points.tdata
                     mov   edi,newpoints
                     mov   ebp,points.sdata
.loop:
                     mov   ax,[edi]
                     mov   bx,[edi+2]
                     mov   dx,[edi+4]

                     mov   [vertex1.X],ax
                     mov   [vertex1.Y],bx
                     mov   [vertex1.Z],dx
                     mov   ax,[ds:ebp]
                     mov   [vertex1.S],ax

                     mov   ax,[edi+6]
                     mov   bx,[edi+8]
                     mov   dx,[edi+10]

                     mov   [vertex2.X],ax
                     mov   [vertex2.Y],bx
                     mov   [vertex2.Z],dx
                     mov   ax,[ds:ebp+2]
                     mov   [vertex2.S],ax

                     mov   ax,[edi+12]
                     mov   bx,[edi+14]
                     mov   dx,[edi+16]

                     mov   [vertex3.X],ax
                     mov   [vertex3.Y],bx
                     mov   [vertex3.Z],dx
                     mov   ax,[ds:ebp+4]
                     mov   [vertex3.S],ax

                     mov   ax,[esi]
                     mov   bx,[esi+2]
                     mov   dx,[esi+4]
                     mov   [vertex1.Xtile],al
                     mov   [vertex1.Ytile],ah
                     mov   [vertex2.Xtile],bl
                     mov   [vertex2.Ytile],bh
                     mov   [vertex3.Xtile],dl
                     mov   [vertex3.Ytile],dh

                     pusha
                     call  dword [mapper.setup]
                     call  dword [mapper.drawpoly]
                     popa

                     add   esi,12
                     add   ebp,6
                     add   edi,18
                     dec   ecx
                     jnz   near .loop
                     ret
;----------------------------------------------------------------------------




;----------------------------------------------------------------------------
POLY equ 2        ; we have two polygons
polygon.number    dd 1*POLY
oldpoints.number  dd 3*POLY
; old points
oldpoints:
             dw +80 ,  -80,   0  ; x, y, z coordinates
             dw -80 ,  -80,   0
             dw -80 ,  +80,   0

             dw +80 ,  -80,   0
             dw +80 ,  +80,   0
             dw -80 ,  +80,   0
;----------------------------------------------------------------------------
points.tdata db 66,00,00,00,00,66  ; tmap Xtile,Ytile    for 3 vertex
             dw 32,32,32           ; shade number (0-63) for 3 vertex
             db 66,00,66,66,00,66
             dw 32,32,32
;----------------------------------------------------------------------------
points.zdata  times 3*POLY   dw 0
points.sdata  times 3*POLY   dw 0
;----------------------------------------------------------------------------
newpoints     times 3*3*POLY dw 0
;----------------------------------------------------------------------------











