
/**************************************************************************
 *                                                                        *
 *               Copyright (C) 1995, Silicon Graphics, Inc.               *
 *                                                                        *
 *  These coded instructions, statements, and computer programs  contain  *
 *  unpublished  proprietary  information of Silicon Graphics, Inc., and  *
 *  are protected by Federal copyright  law.  They  may not be disclosed  *
 *  to  third  parties  or copied or duplicated in any form, in whole or  *
 *  in part, without the prior written consent of Silicon Graphics, Inc.  *
 *                                                                        *
 *************************************************************************/

#include <ultra64.h>
#include <ramrom.h>	/* needed for argument passing into the app */

#include "pack.h"
#include "n64.ci"


/*
 * Symbol genererated by "makerom" to indicate the end of the code segment
 * in virtual (and physical) memory
 */
extern char _codeSegmentEnd[];

/*
 * Symbols generated by "makerom" to tell us where the static segment is
 * in ROM.
 */
extern char _staticSegmentRomStart[], _staticSegmentRomEnd[];
extern char _verticeSegmentRomStart[], _verticeSegmentRomEnd[];
extern char _backgroundSegmentRomStart[], _backgroundSegmentRomEnd[];

/*
 * Stacks for the threads as well as message queues for synchronization
 */
u64	bootStack[STACKSIZE/sizeof(u64)];

static void	idle(void *);
static void	mainproc(void *);

static OSThread	idleThread;
static u64	idleThreadStack[STACKSIZE/sizeof(u64)];

static OSThread	mainThread;
static u64	mainThreadStack[STACKSIZE/sizeof(u64)];

/* this number (the depth of the message queue) needs to be equal
 * to the maximum number of possible overlapping PI requests.
 * For this app, 1 or 2 is probably plenty, other apps might
 * require a lot more.
 */
#define NUM_PI_MSGS     8

static OSMesg PiMessages[NUM_PI_MSGS];
static OSMesgQueue PiMessageQ;

OSMesgQueue	dmaMessageQ, rdpMessageQ, retraceMessageQ;
OSMesg		dmaMessageBuf, rdpMessageBuf, retraceMessageBuf;
OSMesg		dummyMessage;
OSIoMesg	dmaIOMessageBuf;


/*
 * Dynamic segment in code space. Needs OS_K0_TO_PHYSICAL()...
 */
Dynamic dynamic;

/*
 * must be in BSS, not on the stack for this to work:
 */
OSTask	tlist =
{
    M_GFXTASK,			/* task type */
    OS_TASK_DP_WAIT,		   /* task flags */
    NULL,			   /* boot ucode pointer (fill in later) */
    0,				   /* boot ucode size (fill in later) */
    NULL,			   /* task ucode pointer (fill in later) */
    SP_UCODE_SIZE,		   /* task ucode size */
    NULL,			   /* task ucode data pointer (fill in later) */
    SP_UCODE_DATA_SIZE,		   /* task ucode data size */
    &dram_stack[0],		   /* task dram stack pointer */
    SP_DRAM_STACK_SIZE8,	   /* task dram stack size */
    &rdp_output[0],		   /* task fifo buffer start ptr */
    &rdp_output[0]+RDP_OUTPUT_LEN, /* task fifo buffer end ptr */
    NULL,			   /* task data pointer (fill in later) */
    0,				   /* task data size (fill in later) */
    NULL,			   /* task yield buffer ptr (not used here) */
    0				   /* task yield buffer size (not used here) */
};

Gfx		*glistp;	/* global for test case procs */

/*
 * global variables for arguments, to control test cases
 */
static int	rdp_flag = 0;	/* 0:xbus , 1:fifo */
static int      draw_buffer = 0;
static void	*cfb_ptrs[2];
static float	theta = 0.0;
static u64	ramrombuf[RAMROM_MSG_SIZE/sizeof(u64)];
char		*verticeSegment;
char		*backgroundSegment;
char		*staticSegment;
    

static void	draw_teapot(Dynamic *);
static void	convert_bg(void);
static void	upd_light(Dynamic *dynamicp, char x, char y, char z);

float   fov;
int	controllerSlot, oldbut=0;
float	eyex,eyey,eyez;
float	atx,aty,atz;
float	upx,upy,upz;
float	roll, pitch, yaw, speed;
float	movex, movey;
float	r,v,s;
int	offset;

Mtx	Temp1, Temp2;

OSPiHandle	*handler;
OSContPad	**pad;


boot(void)
{


    /* notice that you can't call osSyncPrintf() until you set
     * up an idle thread.
     */
    
    osInitialize();

    handler = osCartRomInit();

    
    osCreateThread(&idleThread, 1, idle, NULL,
		   idleThreadStack+STACKSIZE/sizeof(u64), 10);
    osStartThread(&idleThread);

    /* never reached */
}

static void
idle(void *arg)
{
    /* Initialize video */
    osCreateViManager(OS_PRIORITY_VIMGR);
    osViSetMode(&osViModeTable[OS_VI_PAL_LAN1]);
    osViSetSpecialFeatures(OS_VI_GAMMA_ON|OS_VI_GAMMA_DITHER_ON|OS_VI_DIVOT_ON|OS_VI_DITHER_FILTER_ON);
    osViBlack(TRUE);    


    /*
     * Start PI Mgr for access to cartridge
     */
    osCreatePiManager((OSPri)OS_PRIORITY_PIMGR, &PiMessageQ, PiMessages, 
		      NUM_PI_MSGS);
    
    /*
     * Create main thread
     */
    osCreateThread(&mainThread, 3, mainproc, NULL ,
		   mainThreadStack+STACKSIZE/sizeof(u64), 10);
    osStartThread(&mainThread);

    /*
     * Become the idle thread
     */
    osSetThreadPri( 0, 0 );
    for (;;);
}

/*
 * This is the main routine of the app.
 */
static void
mainproc(void *arg)
{
    int		i, j;

    OSTask	*tlistp;
    Dynamic	*dynamicp;
    u32		clearcolor;
    u16		perspNorm;
    
    cfb_ptrs[0] = &(cfb_16_a[0]);
    cfb_ptrs[1] = &(cfb_16_b[0]);

    eyex = 0;
    eyey = 0;
    eyez = 225;
    atx = 0;
    aty = 0;
    atz = 0;
    upx = 0;
    upy = 1;
    upz = 0;
    roll = 0.0;
    pitch = 0.0;
    yaw = 90*PI/180;
    speed = -0.0;
    r=v=0.0;
    s=PI2/50000.0;
    oldbut = 0;
    fov = 45.5;
    offset = 0;

    /*
     * Setup the message queues
     */
    osCreateMesgQueue(&dmaMessageQ, &dmaMessageBuf, 1);
    
    osCreateMesgQueue(&rdpMessageQ, &rdpMessageBuf, 1);
    osSetEventMesg(OS_EVENT_DP, &rdpMessageQ, dummyMessage);
    
    osCreateMesgQueue(&retraceMessageQ, &retraceMessageBuf, 1);
    osViSetEvent(&retraceMessageQ, dummyMessage, 1);
    
    /*
     * Stick the static segment right after the code/data segment
     */
    staticSegment = _codeSegmentEnd;

    dmaIOMessageBuf.hdr.pri      = OS_MESG_PRI_NORMAL;
    dmaIOMessageBuf.hdr.retQueue = &dmaMessageQ;
    dmaIOMessageBuf.dramAddr     = staticSegment;
    dmaIOMessageBuf.devAddr      = (u32)_staticSegmentRomStart;
    dmaIOMessageBuf.size         = _staticSegmentRomEnd-_staticSegmentRomStart;

    osEPiStartDma(handler, &dmaIOMessageBuf, OS_READ);
    
    /*
     * Wait for DMA to finish
     */
    (void)osRecvMesg(&dmaMessageQ, &dummyMessage, OS_MESG_BLOCK);

    /*
     * Stick the static segment right after the code/data segment
     */
    verticeSegment = staticSegment + 
      (u32) _staticSegmentRomEnd - (u32) _staticSegmentRomStart;


    dmaIOMessageBuf.hdr.pri      = OS_MESG_PRI_NORMAL;
    dmaIOMessageBuf.hdr.retQueue = &dmaMessageQ;
    dmaIOMessageBuf.dramAddr     = verticeSegment;
    dmaIOMessageBuf.devAddr      = (u32)_verticeSegmentRomStart;
    dmaIOMessageBuf.size         = _verticeSegmentRomEnd-_verticeSegmentRomStart;

    osEPiStartDma(handler, &dmaIOMessageBuf, OS_READ);
    
    /*
     * Wait for DMA to finish
     */
    (void)osRecvMesg(&dmaMessageQ, &dummyMessage, OS_MESG_BLOCK);

    /*
     * Stick the static segment right after the code/data segment
     */
    backgroundSegment = verticeSegment + 
      (u32) _verticeSegmentRomEnd - (u32) _verticeSegmentRomStart;

    dmaIOMessageBuf.hdr.pri      = OS_MESG_PRI_NORMAL;
    dmaIOMessageBuf.hdr.retQueue = &dmaMessageQ;
    dmaIOMessageBuf.dramAddr     = backgroundSegment;
    dmaIOMessageBuf.devAddr      = (u32)_backgroundSegmentRomStart;
    dmaIOMessageBuf.size         = _backgroundSegmentRomEnd-_backgroundSegmentRomStart;

    osEPiStartDma(handler, &dmaIOMessageBuf, OS_READ);
    
    /*
     * Wait for DMA to finish
     */
    (void)osRecvMesg(&dmaMessageQ, &dummyMessage, OS_MESG_BLOCK);


    convert_bg();  

    
    /*
     * Main game loop
     */
    while (1) {
        v += s;
        r += v;
        if(ABS(v)>PI2/100.0) s=-s;

	/*
	 * pointers to build the display list.
	 */
	tlistp = &tlist;
	dynamicp = &dynamic;
	glistp = &(dynamicp->glist[0]);
	
	/*
	 * Tell RCP where each segment is
	 */
	gSPSegment(glistp++, 0, 0x0);	/* K0 (physical) address segment */
	gSPSegment(glistp++, STATIC_SEGMENT,
		   osVirtualToPhysical(staticSegment));
	gSPSegment(glistp++, VERTICE_SEGMENT,
		   osVirtualToPhysical(verticeSegment));

	gSPDisplayList(glistp++, rdpinit_dl);
	gSPDisplayList(glistp++, rspinit_dl);
	gDPSetDepthImage(glistp++, OS_K0_TO_PHYSICAL(zbuffer));
	
	/*
	 * clear z, z = max z, dz = 0
	 */
	gDPSetCycleType(glistp++, G_CYC_FILL);
	gDPSetColorImage(glistp++, G_IM_FMT_RGBA, G_IM_SIZ_16b, SCREEN_WD,
			 OS_K0_TO_PHYSICAL(zbuffer));
	gDPSetFillColor(glistp++, 
			GPACK_ZDZ(G_MAXFBZ,0) << 16 | GPACK_ZDZ(G_MAXFBZ,0));
	gDPFillRectangle(glistp++, 0, 0, SCREEN_WD-1, SCREEN_HT-1);
		
	/*
	 * Clear framebuffer
	 * doing this as a static display list is a little messier, due
	 * to cfb pointer conversion...
	 */
	gDPPipeSync(glistp++);
	gDPSetCycleType(glistp++, G_CYC_FILL);
	/*
	 * clear color, cvg = FULL or 1
	 */
	gDPSetColorImage(glistp++, G_IM_FMT_RGBA, G_IM_SIZ_16b, SCREEN_WD, 
			 OS_K0_TO_PHYSICAL(cfb_ptrs[draw_buffer]));
	clearcolor = ((GPACK_RGBA5551(0, 0, 0, 1) << 16) |
		      (GPACK_RGBA5551(0, 0, 0, 1)));
	gDPSetFillColor(glistp++, clearcolor);
	gDPFillRectangle(glistp++, 0, 0, 64, 64);
	gDPFillRectangle(glistp++, 30, 30, 290, 240);
	gDPFillRectangle(glistp++, 0, 170, 320, 240);

	gDPPipeSync(glistp++);
	gDPSetCycleType(glistp++, G_CYC_1CYCLE);
	
	/* end of standard display list part. */

	draw_teapot(dynamicp);
	/* all done with this frame. */
	gDPFullSync(glistp++);
	gSPEndDisplayList(glistp++);
	
	/* 
	 * Build graphics task:
	 *
	 */
	tlistp->t.ucode_boot = (u64 *) rspbootTextStart;
	tlistp->t.ucode_boot_size = ((int)rspbootTextEnd - 
				     (int)rspbootTextStart);


	tlistp->t.ucode = (u64 *) gspF3DEX2_NoN_fifoTextStart;
	tlistp->t.ucode_data = (u64 *) gspF3DEX2_NoN_fifoDataStart; 
	
	/* initial display list: */
	tlistp->t.data_ptr = (u64 *) dynamicp->glist;
	tlistp->t.data_size = ((int)(glistp - dynamicp->glist) *
			       sizeof (Gfx));

	/*
	 * Can just flush 16KB and forget about each individual pieces
	 * of data to flush.
	 */
	osWritebackDCacheAll();
	
	osSpTaskStart(tlistp);
	
	(void)osRecvMesg(&rdpMessageQ, &dummyMessage, OS_MESG_BLOCK);

	/* setup to swap buffers */
	osViSwapBuffer(cfb_ptrs[draw_buffer]);

	/* Make sure there isn't an old retrace in queue 
	 * (assumes queue has a depth of 1) 
	 */
	if (MQ_IS_FULL(&retraceMessageQ))
	    (void)osRecvMesg(&retraceMessageQ, &dummyMessage, OS_MESG_BLOCK);
	
	/* Wait for Vertical retrace to finish swap buffers */
	(void)osRecvMesg(&retraceMessageQ, &dummyMessage, OS_MESG_BLOCK);
	draw_buffer ^= 1;
        osViBlack(FALSE);    

	theta += 2.0;
	offset += 256;
	if (offset >= 2048*256) offset = 0;

    }
}


static void
draw_teapot(Dynamic *dynamicp)
{
  int xc, yc;
  int i, j, k, uls, ult, lrs, lrt;
  float xp, yp, zp;
    u16		perspNorm;

  gSPViewport(glistp++, &vp);


  guPerspective(&dynamicp->projection, &perspNorm,
		      45, 320.0/240.0, 50, 5000, 1.0);

  guLookAt(&dynamicp->viewing, 
		 sinf(r)*230, cosf(r)*230, 210,
		 0, 0, 0,
		 0, 1, 0);
	
  gSPMatrix(glistp++, OS_K0_TO_PHYSICAL(&(dynamicp->projection)),
		  G_MTX_PROJECTION|G_MTX_LOAD|G_MTX_NOPUSH);
  gSPMatrix(glistp++, OS_K0_TO_PHYSICAL(&(dynamicp->viewing)),
		  G_MTX_PROJECTION|G_MTX_MUL|G_MTX_NOPUSH);
  gSPPerspNormalize(glistp++, perspNorm);

  gSPClearGeometryMode(glistp++, G_CULL_BACK);
  gSPSetGeometryMode(glistp++, G_LIGHTING | G_ZBUFFER | G_SHADE | G_SHADING_SMOOTH);
  gDPSetAlphaCompare(glistp++, G_AC_THRESHOLD);
  gDPSetAlphaDither(glistp++, G_AD_NOISE);

  gDPSetCombineMode(glistp++, G_CC_MODULATERGBDECALA, G_CC_MODULATERGBDECALA);

  gDPSetCycleType(glistp++, G_CYC_1CYCLE);
  gDPSetRenderMode(glistp++, G_RM_ZB_OPA_SURF, G_RM_ZB_OPA_SURF2);
  
  gSPTexture(glistp++, 0x8000, 0x8000, 0, G_TX_RENDERTILE, G_ON);
  gDPSetTexturePersp(glistp++, G_TP_PERSP);
  gDPSetTextureFilter(glistp++, G_TF_BILERP);
  gDPSetTextureLOD (glistp++, G_TL_TILE);
  gDPSetTextureConvert(glistp++, G_TC_FILT);
  gDPSetTextureLUT (glistp++, G_TT_NONE);

  
  upd_light(dynamicp, 0, 0, cosf(r)*80); 
  gSPLight(glistp++, &(dynamicp->light.l[0]), 1);
  gSPLight(glistp++, &(dynamicp->light.a), 2);
  gSPNumLights(glistp++, NUMLIGHTS_1);
  
  gDPSetPrimColor(glistp++, 0, 0, 255, 255, 255, 255);
  


  xc = 0;
  yc = 0;
  uls = 0;
  lrs = 31;  
  ult = 0;
  lrt = 31;
  xp = -75.0;
  yp = 40.0;
  zp = 0.0;


/*****
 FRONT AND BACKSIDE!!!
******/

	 for (j = 1; j < 4; j++)
	  { 

		  for (i = 1; i < 9; i++)
		    {

    			  guTranslate(&(dynamicp->Boxes[xc][yc]), xp, yp, zp);
			  gSPMatrix(glistp++, OS_K0_TO_PHYSICAL(&(dynamicp->Boxes[xc][yc])),
				      G_MTX_MODELVIEW|G_MTX_LOAD|G_MTX_NOPUSH);				      
			  gDPLoadTextureTile (glistp++, radwar, G_IM_FMT_RGBA, G_IM_SIZ_16b, 256, 100, 
			    uls, ult, lrs, lrt, 0, G_TX_WRAP | G_TX_NOMIRROR, G_TX_WRAP | G_TX_NOMIRROR,
			    5, 5, G_TX_NOLOD, G_TX_NOLOD);

			  gSPVertex(glistp++, &VERTS_Box1[0], 16, 0);

			  gSP2Triangles(glistp++, 1, 3, 2, 0, 0, 3, 1, 0);

			  guTranslate(&(dynamicp->Boxes1[xc][yc]), xp, yp, zp);
			  gSPMatrix(glistp++, OS_K0_TO_PHYSICAL(&(dynamicp->Boxes1[xc][yc])),
				      G_MTX_MODELVIEW|G_MTX_MUL|G_MTX_NOPUSH);
			  gSP2Triangles(glistp++, 4, 6, 7, 0, 4, 5, 6, 0);

			uls = lrs + 1;
			lrs = (32 * (i+1)) - 1;

			xc++;
			xp += 20;
		   }

	   uls = 0;
	   lrs = 31;
	   yc++;
	   xc = 0;
	   ult = lrt + 1;
	   lrt = (32 * (j+1)) - 1;
	   xp  = -75.0;
	   yp -=  20.0;
	  }

  gDPPipeSync(glistp++);


/*****
 UP AND BOTTOMSIDE!!!
******/

  xc = 0;
  yc = 0;
  uls = 0;
  lrs = 31;  
  ult = 0;
  lrt = 31;
  xp = -75.0;
  yp = 40.0;
  zp = 0.0;


	 for (j = 1; j < 4; j++)
	  { 

		  for (i = 1; i < 9; i++)
		    {

			  guTranslate(&(dynamicp->Boxes2[xc][yc]), xp, yp, zp);
			  gSPMatrix(glistp++, OS_K0_TO_PHYSICAL(&(dynamicp->Boxes2[xc][yc])),
				      G_MTX_MODELVIEW|G_MTX_LOAD|G_MTX_NOPUSH);

			  gDPLoadTextureTile (glistp++, trsi, G_IM_FMT_RGBA, G_IM_SIZ_16b, 256, 100, 
			    uls, ult, lrs, lrt, 0, G_TX_WRAP | G_TX_NOMIRROR, G_TX_WRAP | G_TX_NOMIRROR,
			    5, 5, G_TX_NOLOD, G_TX_NOLOD);
			  gSPVertex(glistp++, &VERTS_Box1[0], 16, 0);
			  gSP2Triangles(glistp++,  8,  9, 13, 0,  8, 13, 12, 0);

			  guTranslate(&(dynamicp->Boxes3[xc][yc]), xp, yp, zp);
			  gSPMatrix(glistp++, OS_K0_TO_PHYSICAL(&(dynamicp->Boxes3[xc][yc])),
				      G_MTX_MODELVIEW|G_MTX_MUL|G_MTX_NOPUSH);
			  gSP2Triangles(glistp++, 15, 14, 10, 0, 15, 10, 11, 0);



			uls = lrs + 1;
			lrs = (32 * (i+1)) - 1;

			xc++;
			xp += 20;
		   }

	   uls = 0;
	   lrs = 31;
	   yc++;
	   xc = 0;
	   ult = lrt + 1;
	   lrt = (32 * (j+1)) - 1;
	   xp  = -75.0;
	   yp  = 40.0;
	   zp -=  20.0;
	  }


	


  xc = 0;
  yc = 0;
  uls = 0;
  lrs = 31;  
  ult = 0;
  lrt = 31;
  xp = -75.0;
  yp = -50.0;
  zp = 0.0;

	guPerspective(&dynamicp->projectiondown, &perspNorm,
		      fov, 320.0/240.0, 5, 10000, 1.0);

	guLookAt(&dynamicp->viewingdown, 
		 0, 0, 180,
		 0, -40, -100,
		 0, 1, 0);
	
	gSPMatrix(glistp++, OS_K0_TO_PHYSICAL(&(dynamicp->projectiondown)),
		  G_MTX_PROJECTION|G_MTX_LOAD|G_MTX_NOPUSH);
	gSPMatrix(glistp++, OS_K0_TO_PHYSICAL(&(dynamicp->viewingdown)),
		  G_MTX_PROJECTION|G_MTX_MUL|G_MTX_NOPUSH);

	gSPPerspNormalize(glistp++, perspNorm);

	 for (j = 1; j < 9; j++)
	  { 

		  for (i = 1; i < 9; i++)
		    {

			  guTranslate(&(dynamicp->Boxes4[xc][yc]), xp, yp, zp);
			  gSPMatrix(glistp++, OS_K0_TO_PHYSICAL(&(dynamicp->Boxes4[xc][yc])),
				      G_MTX_MODELVIEW|G_MTX_LOAD|G_MTX_NOPUSH);

			  gDPLoadTextureTile (glistp++, fire-(256*256)+offset, G_IM_FMT_RGBA, G_IM_SIZ_16b, 256, 256, 
			    uls, ult, lrs, lrt, 0, G_TX_WRAP | G_TX_NOMIRROR, G_TX_WRAP | G_TX_NOMIRROR,
			    5, 5, G_TX_NOLOD, G_TX_NOLOD);
			  gSPVertex(glistp++, &VERTS_Box1[0], 16, 0);
			  gSP2Triangles(glistp++,  8,  9, 13, 0,  8, 13, 12, 0);


			uls = lrs + 1;
			lrs = (32 * (i+1)) - 1;

			xc++;
			xp += 20;
		   }

	   uls = 0;
	   lrs = 31;
	   yc++;
	   xc = 0;
	   ult = lrt + 1;
	   lrt = (32 * (j+1)) - 1;
	   xp  = -75.0;
	   zp -=  20.0;
	  }


   xc=yc=0;

	 for (j = 1; j < 4; j++)
	  { 

		  for (i = 1; i < 9; i++)
		    {
			guRotate(&Temp1, theta, 1.0, 0.0, 0.0);
			guMtxCatL(&(dynamicp->Boxes[xc][yc]), &Temp1, &(dynamicp->Boxes[xc][yc]));
			guMtxCatL(&(dynamicp->Boxes1[xc][yc]), &Temp1, &(dynamicp->Boxes1[xc][yc]));
			guMtxCatL(&(dynamicp->Boxes2[xc][yc]), &Temp1, &(dynamicp->Boxes2[xc][yc]));
			guMtxCatL(&(dynamicp->Boxes3[xc][yc]), &Temp1, &(dynamicp->Boxes3[xc][yc]));
			xc++;

		    }
	    xc = 0;
	    yc++;
	   }

  gSPViewport(glistp++, &vp1);

  guPerspective(&dynamicp->projectionsmall, &perspNorm,
		      40, 320.0/240.0, 5, 10000, 1.0);

  guLookAt(&dynamicp->viewingsmall, 
		 -20, 150, 250,
		 0, 50, 0,
		 0, 1, 0);
	
  gSPMatrix(glistp++, OS_K0_TO_PHYSICAL(&(dynamicp->projectionsmall)),
		  G_MTX_PROJECTION|G_MTX_LOAD|G_MTX_NOPUSH);
  gSPMatrix(glistp++, OS_K0_TO_PHYSICAL(&(dynamicp->viewingsmall)),
		  G_MTX_PROJECTION|G_MTX_MUL|G_MTX_NOPUSH);

  gSPPerspNormalize(glistp++, perspNorm);

  gSPSetGeometryMode(glistp++, G_CULL_BACK);
  gDPSetCombineMode(glistp++, G_CC_ENVSHADE, G_CC_ENVSHADE);
  gDPSetRenderMode(glistp++, G_RM_AA_ZB_OPA_SURF, G_RM_AA_ZB_OPA_SURF2);
  guPosition(&(dynamicp->Logo), 0.0, theta, 0.0, 0.1, 0.0, 50.0, 0.0);
  gSPMatrix(glistp++, &(dynamicp->Logo), G_MTX_MODELVIEW | G_MTX_LOAD | G_MTX_NOPUSH);
  gSPDisplayList(glistp++, &n64_model0[0]);
  gDPPipeSync(glistp++);

  
  gDPPipeSync(glistp++);


}


static void
convert_bg(void)
{
int	index, i=0;
int	x, y;
int	r, g, b;

     for (index=0; index<SCREEN_WD*SCREEN_HT; index++)
       {
         r = backgroundSegment[i];
         g = backgroundSegment[i+1];
         b = backgroundSegment[i+2];

         cfb_16_a[index] = GPACK_RGBA5551(r,g,b,0xff);
	 cfb_16_b[index] = GPACK_RGBA5551(r,g,b,0xff);
	 i += 3;
       }

}

static void
upd_light(Dynamic *dynamicp, char x, char y, char z)
{
	dynamicp->light.a.l.col [0] = 45;
	dynamicp->light.a.l.col [1] = 45;
	dynamicp->light.a.l.col [2] = 45;

	dynamicp->light.a.l.colc [0] = 45;
	dynamicp->light.a.l.colc [1] = 45;
	dynamicp->light.a.l.colc [2] = 45;

	dynamicp->light.l[0].l.col [0] = 196;
	dynamicp->light.l[0].l.col [1] = 196;
	dynamicp->light.l[0].l.col [2] = 196;

	dynamicp->light.l[0].l.colc [0] = 196;
	dynamicp->light.l[0].l.colc [1] = 196;
	dynamicp->light.l[0].l.colc [2] = 196;

	dynamicp->light.l[0].l.dir [0] = x;
	dynamicp->light.l[0].l.dir [1] = y;
	dynamicp->light.l[0].l.dir [2] = 0;

	dynamicp->light.l[1].l.col [0] = 196;
	dynamicp->light.l[1].l.col [1] = 196;
	dynamicp->light.l[1].l.col [2] = 196;

	dynamicp->light.l[1].l.colc [0] = 196;
	dynamicp->light.l[1].l.colc [1] = 196;
	dynamicp->light.l[1].l.colc [2] = 196;

	dynamicp->light.l[1].l.dir [0] = -x;
	dynamicp->light.l[1].l.dir [1] = y;
	dynamicp->light.l[1].l.dir [2] = 0;


}

