BITS 32

EXTERN _screen
EXTERN _dosds
EXTERN _scrsize

GLOBAL _vga_flip_screen

SECTION .text

_vga_flip_screen:
        mov     ax,[_dosds]
        mov     es,ax
        mov     esi,[_screen]
        mov     edi,0xa0000
        mov     ecx,[_scrsize]
        shr     ecx,2
vgaflip0:
        mov     ah,[esi+12]   ; 1, red
        and     ah,11100000b
        mov     bl,[esi+13]   ; green
        shr     bl,3
        and     bl,00011100b
        or      ah,bl
        mov     bl,[esi+14]   ; blue
        shr     bl,6
        add     ah,bl

        mov     al,[esi+8]   ; 2, red
        and     al,11100000b
        mov     bl,[esi+9]   ; green
        shr     bl,3
        and     bl,00011100b
        or      al,bl
        mov     bl,[esi+10]   ; blue
        shr     bl,6
        add     al,bl

        shl     eax,16

        mov     ah,[esi+4]   ; 3, red
        and     ah,11100000b
        mov     bl,[esi+5]   ; green
        shr     bl,3
        and     bl,00011100b
        or      ah,bl
        mov     bl,[esi+6]   ; blue
        shr     bl,6
        add     ah,bl

        mov     al,[esi]   ; 4, red
        and     al,11100000b
        mov     bl,[esi+1]   ; green
        shr     bl,3
        and     bl,00011100b
        or      al,bl
        mov     bl,[esi+2]   ; blue
        shr     bl,6
        add     al,bl

        stosd

        add     esi,16
        loop    vgaflip1
	ret
vgaflip1:
        jmp     vgaflip0
