#include "init.h"

#define MAX_ALLOCS 6000

void **alloc_list=0;

void init_memory() {
    int i;
    alloc_list=malloc(sizeof(void *)*MAX_ALLOCS);
    if(!alloc_list) error(MEMORY_ERROR,"Not enough memory to alloclist");
    for(i=0;i<MAX_ALLOCS;i++) alloc_list[i]=0;
}

void deinit_memory() {
    if(alloc_list) {
        hfree_all();
        free(alloc_list);
        alloc_list=0;
    }
}

void *halloc(int size) {
    int i;
    if(size<=0) error(MEMORY_ERROR,"Can't alloc < 1 bytes!\n");
    if(!alloc_list) init_memory();
    for(i=0;i<MAX_ALLOCS;i++) {
        if(!alloc_list[i]) {
            alloc_list[i]=malloc(size);
            if(!alloc_list[i]) error(MEMORY_ERROR,"Not enough memory");
            return alloc_list[i];
        }
    }
    error(MEMORY_ERROR,"Alloclist is too small");
    return 0;
}

void hfree(void *ptr) {
    int i;
    for(i=0;i<MAX_ALLOCS;i++) {
        if(alloc_list[i]) {
            free(alloc_list[i]);
            alloc_list[i]=0;
            break;
        }
    }
}

void hfree_all() {
    int i;
    for(i=0;i<MAX_ALLOCS;i++) {
        if(alloc_list[i]) {
            free(alloc_list[i]);
            alloc_list[i]=0;
        }
    }
}
