#include "init.h"

// 3D icasta :)

inline void swap(int *a,int *b) {
    int temp=*a;
    *a=*b;
    *b=temp;
}

inline void hline(int x1,int x2,int y,int color) {
    int x;
    if(x1==x2) return;
    if(x1>x2) swap(&x1,&x2);
    for(x=x1;x<x2;x++) screen[(y<<8)+(y<<6)+x]=color;
}

void draw_flat_triangle(int x1,int y1,int x2,int y2,int x3,int y3,int c) {
    int ly, dx1, dx2, ix1, ix2;

    if(y2>y3) { swap(&y2,&y3); swap(&x2,&x3); }
    if(y1>y3) { swap(&y1,&y3); swap(&x1,&x3); }
    if(y1>y2) { swap(&y1,&y2); swap(&x1,&x2); }
    if(y3==y1) return;

    ix1 = ((x3-x1)<<16) / (y3-y1);
    if(y2!=y1) {
        ix2 = ((x2-x1)<<16) / (y2-y1);
        dx1 = x1<<16;
        dx2 = x1<<16;
        for (ly = y1; ly < y2; ly++) {
            hline(dx1>>16, dx2>>16, ly, c);
            dx1 += ix1;
            dx2 += ix2;
        }
    }
    if (y3 != y2) {
        ix2 = ((x3-x2)<<16) / (y3-y2);
        dx1 = (x1<<16) + ((y2 - y1) * ix1);
        dx2 = x2<<16;
        for (ly = y2; ly <= y3; ly++) {
            hline(dx1>>16, dx2>>16, ly, c);
            dx1 += ix1;
            dx2 += ix2;
        }
    }
}

object *load_3d_object(short *vertices,short *faces) {
    int i,j;
    object *o;
    o=halloc(sizeof(object));
    o->vertices=vertices[0];
    o->faces=faces[0];
    o->vertex=halloc(sizeof(t_vertex)*o->vertices);
    o->transx=halloc(sizeof(int)*o->vertices);
    o->transy=halloc(sizeof(int)*o->vertices);
    o->transz=halloc(sizeof(int)*o->vertices);
    o->transd=halloc(sizeof(int)*o->vertices);
    o->face=halloc(sizeof(void *)*o->faces);
    j=1;
    for(i=0;i<o->vertices;i++) {
        o->vertex[i].x=vertices[j++];
        o->vertex[i].y=vertices[j++];
        o->vertex[i].z=vertices[j++];
    }
    j=1;
    for(i=0;i<o->faces;i++) {
        o->face[i]=halloc(sizeof(t_face));
        o->face[i]->a=faces[j++];
        o->face[i]->b=faces[j++];
        o->face[i]->c=faces[j++];
    }
    return o;
}

void show_object(object *o,int x,int y,int z,int angle) {
    int i;
    short xx,yy,zz,yt,xt, xc,xs,yc,ys,zc,zs;
    float cosu,sinu;
    cosu=cos(3.1415*2*angle/256);
    sinu=sin(3.1415*2*angle/256);
    for(i=0;i<o->vertices;i++) {
        xx=o->vertex[i].x;
        yy=o->vertex[i].y;
        zz=o->vertex[i].z;
        xc=cosu*xx;xs=sinu*xx;
        yc=cosu*yy;ys=sinu*yy;
        zc=cosu*zz;zs=sinu*zz;
        yt = yc - zs;
        zz = ys + zc;
        xt = xc - zs;
        zz = xs + zc;
        xt = xc - yt*sinu;
        yy = xs + yt*cosu;
        xx = xt;

        o->transx[i]=(int)(xx)+x;
        if(o->transx[i]>318 || o->transx[i]<1) { o->transd[i]=1; continue; }
        o->transd[i]=0;

        o->transy[i]=(int)(yy)+y;
        if(o->transy[i]>198 || o->transy[i]<1) { o->transd[i]=1; continue; }
 
        //o->transz[i]=(int)(zz)+z;
        //if(o->transz[i]<0) { o->transd[i]=1; continue; }
    }
    for(i=0;i<o->faces;i++) {
        if(o->transd[o->face[i]->a]) continue;
        if(o->transd[o->face[i]->b]) continue;
        if(o->transd[o->face[i]->c]) continue;

        draw_flat_triangle(o->transx[o->face[i]->a],o->transy[o->face[i]->a],
                           o->transx[o->face[i]->b],o->transy[o->face[i]->b],
                           o->transx[o->face[i]->c],o->transy[o->face[i]->c],
                           255+(128<<8)+(128<<16));
    }
}
